/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.TimeZone;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEDiagnosticsLogger {
    private static final int MAX_PENDING = 8192;
    private String name;
    private int max_size;
    private File debug_dir;
    private boolean timestamp_enable = true;
    private boolean force;
    private boolean first_file = true;
    private boolean first_write = true;
    private PrintWriter current_writer;
    private LinkedList<StringBuilder> pending;
    private int pending_size;
    private boolean direct_writes;
    private boolean close_pws = false;
    private static final String start_date;
    private static final long timezone_offset;

    protected AEDiagnosticsLogger(File _debug_dir, String _name, int _max_size, boolean _direct_writes) {
        this.debug_dir = _debug_dir;
        this.name = _name;
        this.max_size = _max_size;
        this.direct_writes = _direct_writes;
        try {
            File f1 = this.getLogFile();
            this.first_file = false;
            File f2 = this.getLogFile();
            this.first_file = true;
            if (f1.exists() && f2.exists() && f1.lastModified() < f2.lastModified()) {
                this.first_file = false;
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
    }

    public void setForced(boolean _force) {
        this.force = _force;
    }

    public boolean isForced() {
        return this.force;
    }

    protected String getName() {
        return this.name;
    }

    public void setMaxFileSize(int _max_size) {
        this.max_size = _max_size;
    }

    public void enableTimeStamp(boolean enable) {
        this.timestamp_enable = enable;
    }

    public void log(Throwable e) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
            e.printStackTrace(pw);
            pw.close();
            this.log(baos.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void logAndOut(String str) {
        this.logAndOut(str, false);
    }

    public void logAndOut(String str, boolean stderr) {
        if (stderr) {
            System.err.println(str);
            if (Logger.getOldStdErr() == null) {
                this.log(str);
            }
        } else {
            System.out.println(str);
            this.log(str);
        }
    }

    public void logAndOut(Throwable e) {
        e.printStackTrace();
        this.log(e);
    }

    public static String getTimestamp() {
        long time = SystemTime.getCurrentTime();
        time += timezone_offset;
        int secs = (int)(time /= 1000L) % 60;
        int mins = (int)(time / 60L) % 60;
        int hours = (int)(time / 3600L) % 24;
        char[] chars = new char[11];
        chars[0] = 91;
        AEDiagnosticsLogger.format(hours, chars, 1);
        chars[3] = 58;
        AEDiagnosticsLogger.format(mins, chars, 4);
        chars[6] = 58;
        AEDiagnosticsLogger.format(secs, chars, 7);
        chars[9] = 93;
        chars[10] = 32;
        return new String(chars);
    }

    private static final void format(int num, char[] chars, int pos) {
        if (num < 10) {
            chars[pos] = 48;
            chars[pos + 1] = (char)(48 + num);
        } else {
            chars[pos] = (char)(48 + num / 10);
            chars[pos + 1] = (char)(48 + num % 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String _str) {
        if (!AEDiagnostics.loggers_enabled && !this.force) {
            return;
        }
        StringBuilder str = new StringBuilder(_str.length() + 20);
        String timeStamp = this.timestamp_enable ? AEDiagnosticsLogger.getTimestamp() : null;
        AEDiagnosticsLogger aEDiagnosticsLogger = this;
        synchronized (aEDiagnosticsLogger) {
            if (this.first_write) {
                this.first_write = false;
                Calendar now = GregorianCalendar.getInstance();
                str.append("\r\n[");
                str.append(start_date);
                str.append("] Log File Opened for ");
                str.append(Constants.APP_NAME);
                str.append(" ");
                str.append("5.5.0.1_B37");
                str.append("\r\n");
            }
            if (timeStamp != null) {
                str.append(timeStamp);
            }
            str.append(_str);
            if (!this.direct_writes) {
                if (this.pending == null) {
                    this.pending = new LinkedList();
                }
                this.pending.add(str);
                this.pending_size += str.length();
                if (this.pending_size > 8192) {
                    this.writePending();
                }
                return;
            }
            this.write(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(StringBuilder str) {
        try {
            File log_file = this.getLogFile();
            if (log_file.length() >= (long)this.max_size) {
                if (this.current_writer != null) {
                    this.current_writer.close();
                    this.current_writer = null;
                }
                this.first_file = !this.first_file;
                log_file = this.getLogFile();
                log_file.delete();
            }
            if (this.current_writer == null) {
                this.current_writer = new PrintWriter(new FileWriter(log_file, true));
            }
            this.current_writer.println(str);
            this.current_writer.flush();
        }
        catch (Throwable throwable) {
        }
        finally {
            if (this.current_writer != null && this.close_pws) {
                this.current_writer.close();
                this.current_writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePending() {
        AEDiagnosticsLogger aEDiagnosticsLogger = this;
        synchronized (aEDiagnosticsLogger) {
            if (this.pending == null) {
                return;
            }
            try {
                File log_file = this.getLogFile();
                if (log_file.length() >= (long)this.max_size) {
                    if (this.current_writer != null) {
                        this.current_writer.close();
                        this.current_writer = null;
                    }
                    this.first_file = !this.first_file;
                    log_file = this.getLogFile();
                    log_file.delete();
                }
                if (this.current_writer == null) {
                    this.current_writer = new PrintWriter(new FileWriter(log_file, true));
                }
                for (StringBuilder str : this.pending) {
                    this.current_writer.println(str);
                }
                this.current_writer.flush();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.direct_writes = true;
                this.pending = null;
                if (this.current_writer != null && this.close_pws) {
                    this.current_writer.close();
                    this.current_writer = null;
                }
            }
        }
    }

    private File getLogFile() {
        return new File(this.debug_dir, this.getName() + "_" + (this.first_file ? "1" : "2") + ".log");
    }

    private static String format(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    static {
        long now = System.currentTimeMillis();
        start_date = new SimpleDateFormat().format(new Date(now));
        timezone_offset = TimeZone.getDefault().getOffset(now);
    }
}

