/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.ReferenceCountedDirectByteBuffer;

public class DirectByteBuffer {
    public static final byte AL_NONE = 0;
    public static final byte AL_EXTERNAL = 1;
    public static final byte AL_OTHER = 2;
    public static final byte AL_PT_READ = 3;
    public static final byte AL_PT_LENGTH = 4;
    public static final byte AL_CACHE_READ = 5;
    public static final byte AL_DM_READ = 6;
    public static final byte AL_DM_ZERO = 7;
    public static final byte AL_DM_CHECK = 8;
    public static final byte AL_BT_PIECE = 9;
    public static final byte AL_CACHE_WRITE = 10;
    public static final byte AL_PROXY_RELAY = 11;
    public static final byte AL_MSG = 12;
    public static final byte AL_MSG_AZ_HAND = 13;
    public static final byte AL_MSG_AZ_PEX = 14;
    public static final byte AL_MSG_BT_CANCEL = 15;
    public static final byte AL_MSG_BT_HAND = 16;
    public static final byte AL_MSG_BT_HAVE = 17;
    public static final byte AL_MSG_BT_PIECE = 18;
    public static final byte AL_MSG_BT_REQUEST = 19;
    public static final byte AL_MSG_BT_KEEPALIVE = 20;
    public static final byte AL_MSG_BT_HEADER = 21;
    public static final byte AL_MSG_AZ_HEADER = 22;
    public static final byte AL_MSG_BT_PAYLOAD = 23;
    public static final byte AL_MSG_AZ_PAYLOAD = 24;
    public static final byte AL_FILE = 25;
    public static final byte AL_NET_CRYPT = 26;
    public static final byte AL_MSG_LT_EXT_MESSAGE = 27;
    public static final byte AL_MSG_LT_HANDSHAKE = 28;
    public static final byte AL_MSG_UT_PEX = 29;
    public static final byte AL_MSG_BT_DHT_PORT = 30;
    public static final byte AL_MSG_BT_REJECT_REQUEST = 31;
    public static final byte AL_MSG_BT_SUGGEST_PIECE = 32;
    public static final byte AL_MSG_BT_ALLOWED_FAST = 33;
    public static final byte AL_MSG_UT_METADATA = 34;
    public static final byte AL_MSG_AZ_METADATA = 35;
    public static final byte AL_MSG_UT_UPLOAD_ONLY = 36;
    public static final String[] AL_DESCS = new String[]{"None", "Ext", "Other", "PeerRead", "PeerLen", "CacheRead", "DiskRead", "DiskZero", "DiskCheck", "BTPiece", "CacheWrite", "ProxyRelay", "Messaging", "AZHandshake", "AZPEX", "BTCancel", "BTHandshake", "BTHave", "BTPiece", "BTRequest", "BTKeepAlive", "BTHeader", "AZHeader", "BTPayload", "AZPayload", "File", "MsgCrypt", "LTExtMsg", "LTExtHandshake", "UTPEX", "BTDHTPort", "BTRejectRequest", "BTSuggestPiece", "BTAllowedFast", "UTMetaData", "AZMetaData", "UTUploadOnly"};
    public static final byte SS_NONE = 0;
    public static final byte SS_EXTERNAL = 1;
    public static final byte SS_OTHER = 2;
    public static final byte SS_CACHE = 3;
    public static final byte SS_FILE = 4;
    public static final byte SS_NET = 5;
    public static final byte SS_BT = 6;
    public static final byte SS_DR = 7;
    public static final byte SS_DW = 8;
    public static final byte SS_PEER = 9;
    public static final byte SS_PROXY = 10;
    public static final byte SS_MSG = 11;
    public static final String[] SS_DESCS = new String[]{"None", "Ext", "Other", "Cache", "File", "Net", "BT", "DiskRead", "DiskWrite", "Peer", "Proxy", "Messaging"};
    public static final byte OP_LIMIT = 0;
    public static final byte OP_LIMIT_INT = 1;
    public static final byte OP_POSITION = 2;
    public static final byte OP_POSITION_INT = 3;
    public static final byte OP_CLEAR = 4;
    public static final byte OP_FLIP = 5;
    public static final byte OP_REMANING = 6;
    public static final byte OP_CAPACITY = 7;
    public static final byte OP_PUT_BYTEARRAY = 8;
    public static final byte OP_PUT_DBB = 9;
    public static final byte OP_PUT_BB = 10;
    public static final byte OP_PUTINT = 11;
    public static final byte OP_PUT_BYTE = 12;
    public static final byte OP_GET = 13;
    public static final byte OP_GET_INT = 14;
    public static final byte OP_GET_BYTEARRAY = 15;
    public static final byte OP_GETINT = 16;
    public static final byte OP_GETINT_INT = 17;
    public static final byte OP_HASREMAINING = 18;
    public static final byte OP_READ_FC = 19;
    public static final byte OP_WRITE_FC = 20;
    public static final byte OP_READ_SC = 21;
    public static final byte OP_WRITE_SC = 22;
    public static final byte OP_GETBUFFER = 23;
    public static final byte OP_GETSHORT = 24;
    public static final byte OP_PUTSHORT = 25;
    public static final String[] OP_DESCS = new String[]{"limit", "limit(int)", "position", "position(int)", "clear", "flip", "remaining", "capacity", "put(byte[])", "put(dbb)", "put(bbb)", "putInt", "put(byte)", "get", "get(int)", "get(byte[])", "getInt", "getInt(int", "hasRemaining", "read(fc)", "write(fc)", "read(sc)", "write(sc)", "getBuffer", "getShort", "putShort"};
    public static final byte FL_NONE = 0;
    public static final byte FL_CONTAINS_TRANSIENT_DATA = 1;
    protected static final boolean TRACE = false;
    protected static final int TRACE_BUFFER_SIZE = 64;
    private ByteBuffer buffer;
    private DirectByteBufferPool pool;
    private byte allocator;
    private byte flags;

    public DirectByteBuffer(ByteBuffer _buffer) {
        this(0, _buffer, null);
    }

    public DirectByteBuffer(byte _allocator, ByteBuffer _buffer, DirectByteBufferPool _pool) {
        if (_buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        this.allocator = _allocator;
        this.buffer = _buffer;
        this.pool = _pool;
    }

    protected DirectByteBuffer(DirectByteBuffer basis) {
        this.allocator = basis.allocator;
        this.buffer = basis.buffer;
        this.pool = null;
        if (this.buffer == null) {
            throw new NullPointerException("basis.buffer is null");
        }
    }

    public ReferenceCountedDirectByteBuffer getReferenceCountedBuffer() {
        ReferenceCountedDirectByteBuffer res = new ReferenceCountedDirectByteBuffer(this);
        return res;
    }

    public void setFlag(byte flag) {
        this.flags = (byte)(this.flags | flag);
    }

    public boolean getFlag(byte flag) {
        return (this.flags & flag) != 0;
    }

    protected void traceUsage(byte subsystem, byte operation) {
    }

    protected String getTraceString() {
        return null;
    }

    protected void dumpTrace(Throwable e) {
    }

    protected ByteBuffer getBufferInternal() {
        return this.buffer;
    }

    protected byte getAllocator() {
        return this.allocator;
    }

    public int limit(byte subsystem) {
        return this.buffer.limit();
    }

    public void limit(byte subsystem, int l) {
        this.buffer.limit(l);
    }

    public int position(byte subsystem) {
        return this.buffer.position();
    }

    public void position(byte subsystem, int l) {
        this.buffer.position(l);
    }

    public void clear(byte subsystem) {
        this.buffer.clear();
    }

    public void flip(byte subsystem) {
        this.buffer.flip();
    }

    public int remaining(byte subsystem) {
        return this.buffer.remaining();
    }

    public int capacity(byte subsystem) {
        return this.buffer.capacity();
    }

    public void put(byte subsystem, byte[] data) {
        this.buffer.put(data);
    }

    public void put(byte subsystem, byte[] data, int offset, int length) {
        this.buffer.put(data, offset, length);
    }

    public void put(byte subsystem, DirectByteBuffer data) {
        this.buffer.put(data.buffer);
    }

    public void put(byte subsystem, ByteBuffer data) {
        this.buffer.put(data);
    }

    public void put(byte subsystem, byte data) {
        this.buffer.put(data);
    }

    public void putShort(byte subsystem, short x) {
        this.buffer.putShort(x);
    }

    public void putInt(byte subsystem, int data) {
        this.buffer.putInt(data);
    }

    public byte get(byte subsystem) {
        return this.buffer.get();
    }

    public byte get(byte subsystem, int x) {
        return this.buffer.get(x);
    }

    public void get(byte subsystem, byte[] data) {
        this.buffer.get(data);
    }

    public short getShort(byte subsystem) {
        return this.buffer.getShort();
    }

    public int getInt(byte subsystem) {
        return this.buffer.getInt();
    }

    public int getInt(byte subsystem, int x) {
        return this.buffer.getInt(x);
    }

    public boolean hasRemaining(byte subsystem) {
        return this.buffer.hasRemaining();
    }

    public int read(byte subsystem, FileChannel chan) throws IOException {
        try {
            return chan.read(this.buffer);
        }
        catch (IllegalArgumentException e) {
            this.dumpTrace(e);
            throw e;
        }
    }

    public int write(byte subsystem, FileChannel chan) throws IOException {
        try {
            return chan.write(this.buffer);
        }
        catch (IllegalArgumentException e) {
            this.dumpTrace(e);
            throw e;
        }
    }

    public int read(byte subsystem, SocketChannel chan) throws IOException {
        try {
            return chan.read(this.buffer);
        }
        catch (IllegalArgumentException e) {
            this.dumpTrace(e);
            throw e;
        }
    }

    public int write(byte subsystem, SocketChannel chan) throws IOException {
        try {
            return chan.write(this.buffer);
        }
        catch (IllegalArgumentException e) {
            this.dumpTrace(e);
            throw e;
        }
    }

    public ByteBuffer getBuffer(byte subsystem) {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPool() {
        if (this.pool != null) {
            DirectByteBuffer directByteBuffer = this;
            synchronized (directByteBuffer) {
                if (this.buffer == null) {
                    Debug.out("Buffer already returned to pool");
                } else {
                    this.pool.returnBufferSupport(this);
                    this.buffer = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPoolIfNotFree() {
        if (this.pool != null) {
            DirectByteBuffer directByteBuffer = this;
            synchronized (directByteBuffer) {
                if (this.buffer != null) {
                    this.pool.returnBufferSupport(this);
                    this.buffer = null;
                }
            }
        }
    }
}

