/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.multiuser.commands;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.UserProfile;
import org.gudy.azureus2.ui.console.commands.CommandCollection;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;
import org.gudy.azureus2.ui.console.commands.OptionsConsoleCommand;
import org.gudy.azureus2.ui.console.multiuser.UserManager;

public class UserCommand
extends IConsoleCommand {
    private final CommandCollection subCommands = new CommandCollection();
    private final UserManager userManager;

    public UserCommand(UserManager userManager) {
        super("user");
        this.userManager = userManager;
        this.subCommands.add(new AddUserCommand());
        this.subCommands.add(new DeleteUserCommand());
        this.subCommands.add(new ModifyUserCommand());
        this.subCommands.add(new ListUsersCommand());
    }

    private UserManager getUserManager() {
        return this.userManager;
    }

    private void saveUserManagerConfig(PrintStream out) {
        try {
            this.userManager.save();
            out.println("> User Manager config saved");
        }
        catch (FileNotFoundException e) {
            out.println("> Error saving User Manager config: " + e);
            e.printStackTrace(out);
        }
    }

    public String getCommandDescriptions() {
        return "user add|delete|list|modify <options>\tmanage users able to log in via telnet ui";
    }

    public void execute(String commandName, ConsoleInput ci, List args) {
        if (args.isEmpty()) {
            this.printHelp(ci.out, args);
        } else {
            commandName = (String)args.remove(0);
            this.subCommands.execute(commandName, ci, args);
        }
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> -----");
        out.println("'user' syntax:");
        if (args.size() > 0) {
            String command = (String)args.remove(0);
            IConsoleCommand cmd = this.subCommands.get(command);
            if (cmd != null) {
                cmd.printHelp(out, args);
            }
            return;
        }
        out.println("user <command> <command options>");
        out.println();
        out.println("Available <command>s:");
        Iterator iter = this.subCommands.iterator();
        while (iter.hasNext()) {
            IConsoleCommand cmd = (IConsoleCommand)iter.next();
            out.println(cmd.getCommandDescriptions());
        }
        out.println("try 'help user <command>' for more information about a particular user command");
        out.println("> -----");
    }

    private final class AddUserCommand
    extends OptionsConsoleCommand {
        public AddUserCommand() {
            super("add", "a");
            this.getOptions().addOption(new Option("u", "username", true, "name of new user"));
            this.getOptions().addOption(new Option("p", "password", true, "password for new user"));
            this.getOptions().addOption(new Option("t", "type", true, "user type (Admin / User / Guest)"));
            this.getOptions().addOption(new Option("d", "savedirectory", true, "default torrent save directory for this user"));
        }

        public void execute(String commandName, ConsoleInput ci, CommandLine commandLine) {
            String userName = commandLine.getOptionValue('u');
            if (userName == null) {
                ci.out.println("> AddUser: (u)sername option not specified");
                return;
            }
            String password = commandLine.getOptionValue('p');
            if (password == null) {
                ci.out.println("> AddUser: (p)assword option not specified");
                return;
            }
            String userType = commandLine.getOptionValue('t', "admin");
            if (!UserProfile.isValidUserType(userType.toLowerCase())) {
                ci.out.println("> AddUser: invalid profile type '" + userType + "'. Valid values are: " + "admin" + "," + "user" + "," + "guest");
                return;
            }
            if (UserCommand.this.getUserManager().getUser(userName) != null) {
                ci.out.println("> AddUser error: user '" + userName + "' already exists");
                return;
            }
            UserProfile profile = new UserProfile(userName, userType);
            profile.setPassword(password);
            String defaultSaveDirectory = commandLine.getOptionValue('d', null);
            profile.setDefaultSaveDirectory(defaultSaveDirectory);
            UserCommand.this.getUserManager().addUser(profile);
            ci.out.println("> AddUser: user '" + userName + "' added");
            UserCommand.this.saveUserManagerConfig(ci.out);
        }

        public String getCommandDescriptions() {
            return "add [-u user] <options>\t\ta\tadds a new user";
        }
    }

    private final class DeleteUserCommand
    extends OptionsConsoleCommand {
        public DeleteUserCommand() {
            super("delete", "d");
            this.getOptions().addOption(new Option("u", "username", true, "name of user to delete"));
        }

        public void execute(String commandName, ConsoleInput ci, CommandLine commandLine) {
            String userName = commandLine.getOptionValue('u');
            if (userName == null) {
                ci.out.println("> DeleteUser: (u)sername option not specified");
                return;
            }
            if (UserCommand.this.getUserManager().getUser(userName) == null) {
                ci.out.println("> DeleteUser: error - user '" + userName + "' not found");
                return;
            }
            UserCommand.this.getUserManager().deleteUser(userName);
            ci.out.println("> DeleteUser: user '" + userName + "' deleted");
            UserCommand.this.saveUserManagerConfig(ci.out);
        }

        public String getCommandDescriptions() {
            return "delete [-u user]\t\td\tdeletes a user";
        }
    }

    private final class ListUsersCommand
    extends IConsoleCommand {
        public ListUsersCommand() {
            super("list", "l");
        }

        public void execute(String commandName, ConsoleInput ci, List args) {
            ci.out.println("> -----");
            ci.out.println("> Username\tProfile\t\tSave Directory");
            for (UserProfile profile : UserCommand.this.getUserManager().getUsers()) {
                String saveDir = profile.getDefaultSaveDirectory();
                if (saveDir == null) {
                    saveDir = "(default)";
                }
                ci.out.println("> " + profile.getUsername() + "\t\t" + profile.getUserType() + "\t\t" + saveDir);
            }
            ci.out.println("> -----");
        }

        public String getCommandDescriptions() {
            return "list \t\t\t\tl\tlists all users";
        }
    }

    private final class ModifyUserCommand
    extends OptionsConsoleCommand {
        public ModifyUserCommand() {
            super("modify", "m");
            this.getOptions().addOption(new Option("u", "username", true, "name of user to modify"));
            this.getOptions().addOption(new Option("p", "password", true, "password for new user"));
            this.getOptions().addOption(new Option("t", "type", true, "user type (Admin / User / Guest)"));
            this.getOptions().addOption(new Option("d", "savedirectory", true, "default torrent save directory for this user"));
        }

        public void execute(String commandName, ConsoleInput ci, CommandLine commandLine) {
            String defaultSaveDirectory;
            String password;
            String userName = commandLine.getOptionValue('u');
            if (userName == null) {
                ci.out.println("> ModifyUser: (u)sername option not specified");
                return;
            }
            UserProfile profile = UserCommand.this.getUserManager().getUser(userName);
            if (profile == null) {
                ci.out.println("> ModifyUser: error - user '" + userName + "' not found");
                return;
            }
            boolean modified = false;
            String userType = commandLine.getOptionValue('t');
            if (userType != null) {
                if (UserProfile.isValidUserType(userType.toLowerCase())) {
                    profile.setUserType(userType.toLowerCase());
                    modified = true;
                } else {
                    ci.out.println("> ModifyUser: invalid profile type '" + userType + "'. Valid values are: " + "admin" + "," + "user" + "," + "guest");
                    return;
                }
            }
            if ((password = commandLine.getOptionValue('p')) != null) {
                profile.setPassword(password);
                modified = true;
            }
            if ((defaultSaveDirectory = commandLine.getOptionValue('d')) != null) {
                modified = true;
                if (defaultSaveDirectory.length() > 0) {
                    profile.setDefaultSaveDirectory(defaultSaveDirectory);
                } else {
                    profile.setDefaultSaveDirectory(null);
                }
            }
            if (modified) {
                ci.out.println("> ModifyUser: user '" + userName + "' modified");
                UserCommand.this.saveUserManagerConfig(ci.out);
            } else {
                this.printHelp(ci.out, commandLine.getArgList());
            }
        }

        public String getCommandDescriptions() {
            return "modify [-u user] <options>\tm\tmodifies a user";
        }
    }
}

