/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class PieUtils {
    public static void drawPie(GC gc, int x, int y, int width, int height, int percent) {
        Color background = gc.getBackground();
        gc.setForeground(Colors.blue);
        int angle = percent * 360 / 100;
        if (angle < 4) {
            angle = 0;
        }
        gc.setBackground(Colors.white);
        gc.fillArc(x, y, width, height, 0, 360);
        gc.setBackground(background);
        gc.fillArc(x, y, width, height, 90, angle * -1);
        gc.drawOval(x, y, width - 1, height - 1);
    }

    public static void drawPie(GC gc, Image image, int x, int y, int width, int height, int percent, boolean draw_border) {
        Rectangle image_size = image.getBounds();
        int width_pad = (width - image_size.width) / 2;
        int height_pad = (height - image_size.height) / 2;
        int angle = percent * 360 / 100;
        if (angle < 4) {
            angle = 0;
        }
        Region old_clipping = new Region();
        gc.getClipping(old_clipping);
        Path path_done = new Path(gc.getDevice());
        path_done.addArc((float)x, (float)y, (float)width, (float)height, 90.0f, (float)(-angle));
        path_done.lineTo((float)(x + width / 2), (float)(y + height / 2));
        path_done.close();
        gc.setClipping(path_done);
        gc.drawImage(image, x + width_pad, y + height_pad + 1);
        Path path_undone = new Path(gc.getDevice());
        path_undone.addArc((float)x, (float)y, (float)width, (float)height, (float)(90 - angle), (float)(angle - 360));
        path_undone.lineTo((float)(x + width / 2), (float)(y + height / 2));
        path_undone.close();
        gc.setClipping(path_undone);
        gc.setAlpha(75);
        gc.drawImage(image, x + width_pad, y + height_pad + 1);
        gc.setAlpha(255);
        gc.setClipping(old_clipping);
        if (draw_border) {
            gc.setForeground(Colors.blue);
            if (percent == 100) {
                gc.drawOval(x, y, width - 1, height - 1);
            } else if (angle > 0) {
                gc.drawPath(path_done);
            }
        }
        path_done.dispose();
        path_undone.dispose();
        old_clipping.dispose();
    }
}

