/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.donations;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class DonationWindow {
    public static boolean DEBUG = System.getProperty("donations.debug", "0").equals("1");
    private static int reAskEveryHours = 96;
    private static int initialAskHours = 48;
    private static boolean pageLoadedOk = false;
    private static Shell shell = null;
    private static Browser browser;
    private static BrowserFunction browserFunction;

    public static void checkForDonationPopup() {
        FeatureManager.FeatureDetails[] fds;
        if (shell != null) {
            if (DEBUG) {
                new MessageBoxShell(32, "Donations Test", "Already Open").open(null);
            }
            return;
        }
        FeatureManager fm = PluginInitializer.getDefaultInterface().getUtilities().getFeatureManager();
        for (FeatureManager.FeatureDetails fd : fds = fm.getFeatureDetails("core")) {
            if (fd.hasExpired()) continue;
            return;
        }
        long maxDate = COConfigurationManager.getLongParameter("donations.maxDate", 0L);
        boolean force = maxDate > 0L && SystemTime.getCurrentTime() > maxDate;
        boolean alreadyDonated = COConfigurationManager.getBooleanParameter("donations.donated", false);
        if (alreadyDonated && !force) {
            if (DEBUG) {
                new MessageBoxShell(32, "Donations Test", "Already Donated! I like you.").open(null);
            }
            return;
        }
        OverallStats stats2 = StatsFactory.getStats();
        if (stats2 == null) {
            return;
        }
        long upTime = stats2.getTotalUpTime();
        int hours = (int)(upTime / 3600L);
        int nextAsk = COConfigurationManager.getIntParameter("donations.nextAskHours", 0);
        if (nextAsk == 0) {
            COConfigurationManager.setParameter("donations.nextAskHours", hours + initialAskHours);
            COConfigurationManager.save();
            if (DEBUG) {
                new MessageBoxShell(32, "Donations Test", "Newbie. You're active for " + hours + ".").open(null);
            }
            return;
        }
        if (hours < nextAsk && !force) {
            if (DEBUG) {
                new MessageBoxShell(32, "Donations Test", "Wait " + (nextAsk - hours) + ".").open(null);
            }
            return;
        }
        long minDate = COConfigurationManager.getLongParameter("donations.minDate", 0L);
        if (minDate > 0L && minDate > SystemTime.getCurrentTime()) {
            if (DEBUG) {
                new MessageBoxShell(32, "Donation Test", "Wait " + (SystemTime.getCurrentTime() - minDate) / 1000L / 3600L / 24L + " days").open(null);
            }
            return;
        }
        COConfigurationManager.setParameter("donations.nextAskHours", hours + reAskEveryHours);
        COConfigurationManager.save();
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                DonationWindow.open(false, "check");
            }
        });
    }

    public static void open(final boolean showNoLoad, final String sourceRef) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                DonationWindow._open(showNoLoad, sourceRef);
            }
        });
    }

    public static void _open(final boolean showNoLoad, String sourceRef) {
        if (shell != null && !shell.isDisposed()) {
            return;
        }
        final Shell parentShell = Utils.findAnyShell();
        shell = ShellFactory.createShell(parentShell, 67616);
        shell.setLayout((Layout)new FillLayout());
        if (parentShell != null) {
            parentShell.setCursor(shell.getDisplay().getSystemCursor(1));
        }
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.widget.dispose();
                    e.doit = false;
                }
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (parentShell != null) {
                    parentShell.setCursor(e.display.getSystemCursor(0));
                }
                if (browserFunction != null && !browserFunction.isDisposed()) {
                    browserFunction.dispose();
                }
                shell = null;
            }
        });
        browser = Utils.createSafeBrowser((Composite)shell, 0);
        if (browser == null) {
            shell.dispose();
            return;
        }
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event2) {
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                shell.setText(event2.title);
            }
        });
        browserFunction = new BrowserFunction(browser, "sendDonationEvent"){

            public Object function(Object[] arguments) {
                String[] strings;
                if (shell == null || shell.isDisposed()) {
                    return null;
                }
                if (arguments == null) {
                    Debug.out("Invalid sendDonationEvent null ");
                    return null;
                }
                if (arguments.length < 1) {
                    Debug.out("Invalid sendDonationEvent length " + arguments.length + " not 1");
                    return null;
                }
                if (!(arguments[0] instanceof String)) {
                    Debug.out("Invalid sendDonationEvent " + (arguments[0] == null ? "NULL" : arguments.getClass().getSimpleName()) + " not String");
                    return null;
                }
                String text = (String)arguments[0];
                if (text.contains("page-loaded")) {
                    pageLoadedOk = true;
                    COConfigurationManager.setParameter("donations.count", COConfigurationManager.getLongParameter("donations.count", 1L) + 1L);
                    Utils.centreWindow(shell);
                    if (parentShell != null) {
                        parentShell.setCursor(shell.getDisplay().getSystemCursor(0));
                    }
                    shell.open();
                } else if (text.contains("reset-ask-time")) {
                    int time = reAskEveryHours;
                    String[] strings2 = text.split(" ");
                    if (strings2.length > 1) {
                        try {
                            time = Integer.parseInt(strings2[1]);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DonationWindow.resetAskTime(time);
                } else if (text.contains("never-ask-again")) {
                    DonationWindow.neverAskAgain();
                } else if (text.contains("close")) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            if (shell != null && !shell.isDisposed()) {
                                shell.dispose();
                            }
                        }
                    });
                } else if (text.startsWith("open-url")) {
                    String url = text.substring(9);
                    Utils.launch(url);
                } else if (text.startsWith("set-size") && (strings = text.split(" ")).length > 2) {
                    try {
                        int w = Integer.parseInt(strings[1]);
                        int h = Integer.parseInt(strings[2]);
                        Rectangle computeTrim = shell.computeTrim(0, 0, w, h);
                        shell.setSize(computeTrim.width, computeTrim.height);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
        browser.addStatusTextListener(new StatusTextListener(){
            String last = null;

            public void changed(StatusTextEvent event2) {
                String text = event2.text.toLowerCase();
                if (this.last != null && this.last.equals(text)) {
                    return;
                }
                this.last = text;
                browserFunction.function(new Object[]{text});
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event2) {
            }

            public void changed(LocationEvent event2) {
            }
        });
        long upTime = StatsFactory.getStats().getTotalUpTime();
        int upHours = (int)(upTime / 3600L);
        String azid = Base32.encode(CryptoManagerFactory.getSingleton().getSecureID());
        final String url = "http://" + System.getProperty("platform_address", "www.vuze.com") + ":" + System.getProperty("platform_port", "80") + "/" + "donate.start?locale=" + MessageText.getCurrentLocale().toString() + "&azv=" + "5.5.0.1_B37" + "&count=" + COConfigurationManager.getLongParameter("donations.count", 1L) + "&uphours=" + upHours + "&azid=" + azid + "&sourceref=" + UrlUtils.encode(sourceRef);
        SimpleTimer.addEvent("donation.pageload", SystemTime.getOffsetTime(6000L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (!pageLoadedOk) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            Debug.out("Page Didn't Load:" + url);
                            shell.dispose();
                            if (showNoLoad) {
                                new MessageBoxShell(32, MessageText.getString("DonationWindow.noload.title"), MessageText.getString("DonationWindow.noload.text", new String[]{url})).open(null);
                            }
                        }
                    });
                }
            }
        });
        browser.setUrl(url);
    }

    protected static void neverAskAgain() {
        COConfigurationManager.setParameter("donations.donated", true);
        DonationWindow.updateMinDate();
        COConfigurationManager.save();
    }

    public static void resetAskTime() {
        DonationWindow.resetAskTime(reAskEveryHours);
    }

    public static void resetAskTime(int askEveryHours) {
        long upTime = StatsFactory.getStats().getTotalUpTime();
        int hours = (int)(upTime / 3600L);
        int nextAsk = hours + askEveryHours;
        COConfigurationManager.setParameter("donations.nextAskHours", nextAsk);
        COConfigurationManager.setParameter("donations.lastVersion", "5.5.0.1_B37");
        DonationWindow.updateMinDate();
        COConfigurationManager.save();
    }

    public static void updateMinDate() {
        COConfigurationManager.setParameter("donations.minDate", SystemTime.getOffsetTime(2592000000L));
        COConfigurationManager.setParameter("donations.maxDate", SystemTime.getOffsetTime(10368000000L));
    }

    public static int getInitialAskHours() {
        return initialAskHours;
    }

    public static void setInitialAskHours(int i) {
        initialAskHours = i;
    }

    public static void main(String[] args) {
        try {
            AzureusCoreFactory.create().start();
            DonationWindow.open(true, "test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Display d = Display.getDefault();
        while (true) {
            if (d.readAndDispatch()) {
                continue;
            }
            d.sleep();
        }
    }
}

