/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketRequestFindNode
extends DHTUDPPacketRequest {
    private byte[] id;
    private int node_status;
    private int estimated_dht_size;

    public DHTUDPPacketRequestFindNode(DHTTransportUDPImpl _transport, long _connection_id, DHTTransportUDPContactImpl _local_contact, DHTTransportUDPContactImpl _remote_contact) {
        super(_transport, 1028, _connection_id, _local_contact, _remote_contact);
    }

    protected DHTUDPPacketRequestFindNode(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, long con_id, int trans_id) throws IOException {
        super(network_handler, is, 1028, con_id, trans_id);
        this.id = DHTUDPUtils.deserialiseByteArray(is, 64);
        if (this.getProtocolVersion() >= 22) {
            this.node_status = is.readInt();
            this.estimated_dht_size = is.readInt();
        }
        super.postDeserialise(is);
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        DHTUDPUtils.serialiseByteArray(os, this.id, 64);
        if (this.getProtocolVersion() >= 22) {
            os.writeInt(this.node_status);
            os.writeInt(this.estimated_dht_size);
        }
        super.postSerialise(os);
    }

    protected void setID(byte[] _id) {
        this.id = _id;
    }

    protected byte[] getID() {
        return this.id;
    }

    protected void setNodeStatus(int ns) {
        this.node_status = ns;
    }

    protected int getNodeStatus() {
        return this.node_status;
    }

    protected void setEstimatedDHTSize(int s) {
        this.estimated_dht_size = s;
    }

    protected int getEstimatedDHTSize() {
        return this.estimated_dht_size;
    }

    public String getString() {
        return super.getString();
    }
}

