/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManager;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheEntry;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerStatsImpl;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithCache;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCache;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManager;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.util.LinkFileMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class CacheFileManagerImpl
implements CacheFileManager,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CACHE;
    public static final boolean DEBUG = false;
    public static final int CACHE_CLEANER_TICKS = 60;
    public static final int STATS_UPDATE_FREQUENCY = 1000;
    public static final long DIRTY_CACHE_WRITE_MAX_AGE = 120000L;
    protected boolean cache_enabled;
    protected boolean cache_read_enabled;
    protected boolean cache_write_enabled;
    protected long cache_size;
    protected long cache_files_not_smaller_than;
    protected long cache_minimum_free_size;
    protected long cache_space_free;
    private long cache_file_id_next = 0L;
    protected FMFileManager file_manager;
    protected WeakHashMap cache_files = new WeakHashMap();
    protected WeakHashMap updated_cache_files = null;
    protected LinkedHashMap cache_entries = new LinkedHashMap(1024, 0.75f, true);
    protected CacheFileManagerStatsImpl stats;
    protected Map torrent_to_cache_file_map = new LightHashMap();
    protected long cache_bytes_written;
    protected long cache_bytes_read;
    protected long file_bytes_written;
    protected long file_bytes_read;
    protected long cache_read_count;
    protected long cache_write_count;
    protected long file_read_count;
    protected long file_write_count;
    protected AEMonitor this_mon = new AEMonitor("CacheFileManager");
    private long cleaner_ticks = 60L;

    protected static int convertCacheToFileType(int cache_type) {
        if (cache_type == 1) {
            return 1;
        }
        if (cache_type == 2) {
            return 2;
        }
        if (cache_type == 3) {
            return 3;
        }
        return 4;
    }

    protected static int convertFileToCacheType(int file_type) {
        if (file_type == 1) {
            return 1;
        }
        if (file_type == 2) {
            return 2;
        }
        if (file_type == 3) {
            return 3;
        }
        return 4;
    }

    public CacheFileManagerImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
        this.file_manager = FMFileManagerFactory.getSingleton();
        boolean enabled = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.enable");
        boolean enable_read = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.enable.read");
        boolean enable_write = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.enable.write");
        long size = 0x100000L * (long)COConfigurationManager.getIntParameter("diskmanager.perf.cache.size");
        int not_smaller_than = 1024 * COConfigurationManager.getIntParameter("notsmallerthan");
        if (size <= 0L) {
            Debug.out("Invalid cache size parameter (" + size + "), caching disabled");
            enabled = false;
        }
        this.initialise(enabled, enable_read, enable_write, size, not_smaller_than);
    }

    protected void initialise(boolean enabled, boolean enable_read, boolean enable_write, long size, long not_smaller_than) {
        this.cache_enabled = enabled && (enable_read || enable_write);
        this.cache_read_enabled = enabled && enable_read;
        this.cache_write_enabled = enabled && enable_write;
        this.cache_size = size;
        this.cache_files_not_smaller_than = not_smaller_than;
        this.cache_minimum_free_size = this.cache_size / 4L;
        this.cache_space_free = this.cache_size;
        this.stats = new CacheFileManagerStatsImpl(this);
        this.cacheStatsAndCleaner();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "DiskCache: enabled = " + this.cache_enabled + ", read = " + this.cache_read_enabled + ", write = " + this.cache_write_enabled + ", size = " + this.cache_size + " B"));
        }
    }

    protected boolean isWriteCacheEnabled() {
        return this.cache_write_enabled;
    }

    protected boolean isReadCacheEnabled() {
        return this.cache_read_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheFile createFile(final CacheFileOwner owner, File file, int type) throws CacheFileManagerException {
        long my_id;
        try {
            this.this_mon.enter();
            my_id = this.cache_file_id_next++;
        }
        finally {
            this.this_mon.exit();
        }
        int fm_type = CacheFileManagerImpl.convertCacheToFileType(type);
        try {
            CacheFile cf;
            FMFile fm_file = this.file_manager.createFile(new FMFileOwner(){

                public String getName() {
                    return owner.getCacheFileOwnerName() + "[" + my_id + "]";
                }

                public TOTorrentFile getTorrentFile() {
                    return owner.getCacheFileTorrentFile();
                }

                public File getControlFileDir() {
                    return owner.getCacheFileControlFileDir();
                }
            }, file, fm_type);
            TOTorrentFile tf = owner.getCacheFileTorrentFile();
            int cache_mode = owner.getCacheMode();
            if (cache_mode == 3) {
                cf = new CacheFileWithoutCacheMT(this, fm_file, tf);
            } else if (tf != null && tf.getLength() < this.cache_files_not_smaller_than || !this.cache_enabled || cache_mode == 2) {
                cf = new CacheFileWithoutCache(this, fm_file, tf);
            } else {
                cf = new CacheFileWithCache(this, fm_file, tf);
                try {
                    this.this_mon.enter();
                    if (this.updated_cache_files == null) {
                        this.updated_cache_files = new WeakHashMap(this.cache_files);
                    }
                    this.updated_cache_files.put(cf, null);
                    if (tf != null) {
                        this.torrent_to_cache_file_map.put(tf, cf);
                    }
                }
                finally {
                    this.this_mon.exit();
                }
            }
            return cf;
        }
        catch (FMFileManagerException e) {
            this.rethrow(null, e);
            return null;
        }
    }

    public CacheFileManagerStats getStats() {
        return this.stats;
    }

    protected boolean isCacheEnabled() {
        return this.cache_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry allocateCacheSpace(int entry_type, CacheFileWithCache file, DirectByteBuffer buffer, long file_position, int length) throws CacheFileManagerException {
        boolean ok = false;
        boolean log = false;
        while (!ok) {
            CacheEntry oldest_entry = null;
            try {
                this.this_mon.enter();
                if ((long)length < this.cache_space_free || this.cache_space_free == this.cache_size) {
                    ok = true;
                } else {
                    oldest_entry = (CacheEntry)this.cache_entries.keySet().iterator().next();
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (ok) continue;
            log = true;
            long old_free = this.cache_space_free;
            CacheFileWithCache oldest_file = oldest_entry.getFile();
            try {
                oldest_file.flushCache(oldest_entry.getFilePosition(), true, this.cache_minimum_free_size);
            }
            catch (CacheFileManagerException e) {
                if (oldest_file != file) {
                    oldest_file.setPendingException(e);
                }
                throw e;
            }
            long flushed = this.cache_space_free - old_free;
            if (Logger.isEnabled()) {
                TOTorrentFile tf = file.getTorrentFile();
                TOTorrent torrent = tf == null ? null : tf.getTorrent();
                Logger.log(new LogEvent(torrent, LOGID, "DiskCache: cache full, flushed " + flushed + " from " + oldest_file.getName()));
            }
            if (flushed != 0L) continue;
            try {
                this.this_mon.enter();
                if (this.cache_entries.size() <= 0 || (CacheEntry)this.cache_entries.keySet().iterator().next() != oldest_entry) continue;
                throw new CacheFileManagerException(null, "Cache inconsistent: 0 flushed");
            }
            finally {
                this.this_mon.exit();
            }
        }
        CacheEntry entry = new CacheEntry(entry_type, file, buffer, file_position, length);
        if (log && Logger.isEnabled()) {
            TOTorrentFile tf = file.getTorrentFile();
            TOTorrent torrent = tf == null ? null : tf.getTorrent();
            Logger.log(new LogEvent(torrent, LOGID, "DiskCache: cr=" + this.cache_bytes_read + ",cw=" + this.cache_bytes_written + ",fr=" + this.file_bytes_read + ",fw=" + this.file_bytes_written));
        }
        return entry;
    }

    protected void cacheStatsAndCleaner() {
        SimpleTimer.addPeriodicEvent("CacheFile:stats+cleaner", 1000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent ev) {
                CacheFileManagerImpl.this.stats.update();
                Iterator cf_it = CacheFileManagerImpl.this.cache_files.keySet().iterator();
                while (cf_it.hasNext()) {
                    ((CacheFileWithCache)cf_it.next()).updateStats();
                }
                if (--CacheFileManagerImpl.this.cleaner_ticks == 0L) {
                    CacheFileManagerImpl.this.cleaner_ticks = 60L;
                    HashSet<CacheFileWithCache> dirty_files = new HashSet<CacheFileWithCache>();
                    long oldest = SystemTime.getCurrentTime() - 120000L;
                    try {
                        CacheFileManagerImpl.this.this_mon.enter();
                        if (CacheFileManagerImpl.this.updated_cache_files != null) {
                            CacheFileManagerImpl.this.cache_files = CacheFileManagerImpl.this.updated_cache_files;
                            CacheFileManagerImpl.this.updated_cache_files = null;
                        }
                        if (CacheFileManagerImpl.this.cache_entries.size() > 0) {
                            for (CacheEntry entry : CacheFileManagerImpl.this.cache_entries.keySet()) {
                                if (!entry.isDirty()) continue;
                                dirty_files.add(entry.getFile());
                            }
                        }
                    }
                    finally {
                        CacheFileManagerImpl.this.this_mon.exit();
                    }
                    for (CacheFileWithCache file : dirty_files) {
                        try {
                            TOTorrentFile tf = file.getTorrentFile();
                            long min_flush_size = -1L;
                            if (tf != null) {
                                min_flush_size = tf.getTorrent().getPieceLength();
                            }
                            file.flushOldDirtyData(oldest, min_flush_size);
                        }
                        catch (CacheFileManagerException e) {
                            file.setPendingException(e);
                            Debug.printStackTrace(e);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCacheSpace(CacheEntry new_entry) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            this.cache_space_free -= (long)new_entry.getLength();
            this.cache_entries.put(new_entry, new_entry);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheEntryUsed(CacheEntry entry) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.cache_entries.get(entry) == null) {
                Debug.out("Cache inconsistency: entry missing on usage");
                throw new CacheFileManagerException(null, "Cache inconsistency: entry missing on usage");
            }
            entry.used();
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCacheSpace(CacheEntry entry) throws CacheFileManagerException {
        entry.getBuffer().returnToPool();
        try {
            this.this_mon.enter();
            this.cache_space_free += (long)entry.getLength();
            if (this.cache_entries.remove(entry) == null) {
                Debug.out("Cache inconsistency: entry missing on removal");
                throw new CacheFileManagerException(null, "Cache inconsistency: entry missing on removal");
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getCacheSize() {
        return this.cache_size;
    }

    protected long getCacheUsed() {
        long free = this.cache_space_free;
        if (free < 0L) {
            free = 0L;
        }
        return this.cache_size - free;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheBytesWritten(long num) {
        try {
            this.this_mon.enter();
            this.cache_bytes_written += num;
            ++this.cache_write_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheBytesRead(int num) {
        try {
            this.this_mon.enter();
            this.cache_bytes_read += (long)num;
            ++this.cache_read_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileBytesWritten(long num) {
        try {
            this.this_mon.enter();
            this.file_bytes_written += num;
            ++this.file_write_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileBytesRead(int num) {
        try {
            this.this_mon.enter();
            this.file_bytes_read += (long)num;
            ++this.file_read_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getBytesWrittenToCache() {
        return this.cache_bytes_written;
    }

    protected long getBytesWrittenToFile() {
        return this.file_bytes_written;
    }

    protected long getBytesReadFromCache() {
        return this.cache_bytes_read;
    }

    protected long getBytesReadFromFile() {
        return this.file_bytes_read;
    }

    public long getCacheReadCount() {
        return this.cache_read_count;
    }

    public long getCacheWriteCount() {
        return this.cache_write_count;
    }

    public long getFileReadCount() {
        return this.file_read_count;
    }

    public long getFileWriteCount() {
        return this.file_write_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFile(CacheFileWithCache file) {
        TOTorrentFile tf = file.getTorrentFile();
        if (tf != null && this.torrent_to_cache_file_map.get(tf) != null) {
            try {
                this.this_mon.enter();
                this.torrent_to_cache_file_map.remove(tf);
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean[] getBytesInCache(TOTorrent torrent, long[] absoluteOffsets, long[] lengths) {
        TOTorrentFile tf;
        int i;
        if (absoluteOffsets.length != lengths.length) {
            throw new IllegalArgumentException("Offsets/Lengths mismatch");
        }
        long prevEnding = 0L;
        for (int i2 = 0; i2 < lengths.length; ++i2) {
            if (absoluteOffsets[i2] < prevEnding || lengths[i2] <= 0L) {
                throw new IllegalArgumentException("Offsets/Lengths are not in ascending order");
            }
            prevEnding = absoluteOffsets[i2] + lengths[i2];
        }
        TOTorrentFile[] files = torrent.getFiles();
        long[] fileOffsets = new long[files.length];
        boolean[] results = new boolean[absoluteOffsets.length];
        Arrays.fill(results, true);
        long first = absoluteOffsets[0];
        long last = absoluteOffsets[absoluteOffsets.length - 1] + lengths[lengths.length - 1];
        long fileOffset = 0L;
        int firstFile = -1;
        boolean lockAcquired = false;
        LightHashMap localCacheMap = new LightHashMap();
        try {
            for (i = 0; i < files.length; ++i) {
                tf = files[i];
                long length = tf.getLength();
                fileOffsets[i] = fileOffset;
                if (firstFile == -1 && fileOffset <= first && first < fileOffset + length) {
                    firstFile = i;
                    this.this_mon.enter();
                    lockAcquired = true;
                }
                if (fileOffset > last) {
                    break;
                }
                if (lockAcquired) {
                    CacheFileWithCache cache_file = (CacheFileWithCache)this.torrent_to_cache_file_map.get(tf);
                    localCacheMap.put(tf, cache_file);
                }
                fileOffset += length;
            }
        }
        finally {
            if (lockAcquired) {
                this.this_mon.exit();
            }
        }
        for (i = firstFile; -1 < i && i < files.length; ++i) {
            tf = files[i];
            CacheFileWithCache cache_file = (CacheFileWithCache)localCacheMap.get(tf);
            long length = tf.getLength();
            fileOffset = fileOffsets[i];
            if (fileOffset > last) break;
            if (cache_file != null) {
                cache_file.getBytesInCache(results, absoluteOffsets, lengths);
                continue;
            }
            for (int j = 0; j < results.length; ++j) {
                if ((absoluteOffsets[j] >= fileOffset + length || absoluteOffsets[j] <= fileOffset) && (absoluteOffsets[j] + lengths[j] >= fileOffset + length || absoluteOffsets[j] + lengths[j] <= fileOffset)) continue;
                results[j] = false;
            }
        }
        if (!lockAcquired) {
            Arrays.fill(results, false);
        }
        return results;
    }

    protected void rethrow(CacheFile file, FMFileManagerException e) throws CacheFileManagerException {
        Throwable cause = e.getCause();
        if (cause != null) {
            throw new CacheFileManagerException(file, e.getMessage(), cause);
        }
        throw new CacheFileManagerException(file, e.getMessage(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Cache Manager");
        try {
            Iterator it;
            writer.indent();
            try {
                this.this_mon.enter();
                it = new ArrayList(this.cache_entries.keySet()).iterator();
            }
            finally {
                this.this_mon.exit();
            }
            writer.println("Entries = " + this.cache_entries.size());
            HashSet<CacheFileWithCache> files = new HashSet<CacheFileWithCache>();
            while (it.hasNext()) {
                String fileLength;
                TOTorrentFile torrentFile;
                CacheFileWithCache file;
                block13: {
                    CacheEntry entry = (CacheEntry)it.next();
                    file = entry.getFile();
                    if (files.contains(file)) continue;
                    files.add(file);
                    torrentFile = file.getTorrentFile();
                    fileLength = "";
                    try {
                        fileLength = "" + file.getLength();
                    }
                    catch (Exception e) {
                        if (torrentFile == null) break block13;
                        fileLength = "" + torrentFile.getLength();
                    }
                }
                String hash = "<unknown>";
                try {
                    if (torrentFile != null) {
                        hash = ByteFormatter.encodeString(torrentFile.getTorrent().getHash());
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                String name = file.getName();
                writer.println("File: " + Debug.secretFileName(name) + ", size " + fileLength + ", torrent " + hash + ", access = " + file.getAccessMode());
            }
        }
        finally {
            writer.exdent();
        }
    }

    public void setFileLinks(TOTorrent torrent, LinkFileMap links) {
        this.file_manager.setFileLinks(torrent, links);
    }
}

