/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FileUtil;

public class HTTPUtils {
    public static final String NL = "\r\n";
    private static final String default_type = "application/octet-stream";
    private static final Map file_types = new HashMap();
    private static final Set compression = new HashSet();

    public static String guessContentTypeFromFileType(String file_type) {
        String type;
        if (file_type != null && (type = (String)file_types.get(file_type.toLowerCase(Constants.LOCALE_ENGLISH))) != null) {
            return type;
        }
        return default_type;
    }

    public static boolean canGZIP(String accept_encoding) {
        int gzip_index;
        boolean gzip_reply = false;
        if (accept_encoding != null && (gzip_index = (accept_encoding = accept_encoding.toLowerCase(Constants.LOCALE_ENGLISH)).indexOf("gzip")) != -1) {
            gzip_reply = true;
            if (accept_encoding.length() - gzip_index >= 8) {
                char c;
                char[] chars = accept_encoding.toCharArray();
                boolean q_value = false;
                for (int i = gzip_index + 4; i < chars.length && (c = chars[i]) != ','; ++i) {
                    if (c == '=') {
                        q_value = true;
                        gzip_reply = false;
                        continue;
                    }
                    if (!q_value || c == ' ' || c == '0' || c == '.') continue;
                    gzip_reply = true;
                    break;
                }
            }
        }
        return gzip_reply;
    }

    public static boolean useCompressionForFileType(String file_type) {
        return compression.contains(file_type);
    }

    public static InputStream decodeChunkedEncoding(Socket socket) throws IOException {
        return HTTPUtils.decodeChunkedEncoding(socket, false);
    }

    public static InputStream decodeChunkedEncoding(Socket socket, boolean ignoreStatusCode) throws IOException {
        byte[] buffer;
        InputStream is = socket.getInputStream();
        String reply_header = "";
        do {
            if (is.read(buffer = new byte[1]) > 0) continue;
            throw new IOException("Premature end of input stream");
        } while (!(reply_header = reply_header + (char)buffer[0]).endsWith("\r\n\r\n"));
        int p1 = reply_header.indexOf(NL);
        String first_line = reply_header.substring(0, p1).trim();
        if (!ignoreStatusCode && first_line.indexOf("200") == -1) {
            String info = null;
            try {
                int timeout = socket.getSoTimeout();
                socket.setSoTimeout(500);
                info = FileUtil.readInputStreamAsStringWithTruncation(is, 512);
                socket.setSoTimeout(timeout);
            }
            catch (Throwable e) {
                // empty catch block
            }
            String error = "HTTP request failed: " + first_line;
            if (info != null) {
                error = error + " - " + info;
            }
            throw new IOException(error);
        }
        String lc_reply_header = reply_header.toLowerCase(Constants.LOCALE_ENGLISH);
        int te_pos = lc_reply_header.indexOf("transfer-encoding");
        if (te_pos != -1) {
            String property = lc_reply_header.substring(te_pos);
            if ((property = property.substring(property.indexOf(58) + 1, property.indexOf(NL)).trim()).equals("chunked")) {
                int x;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                String chunk = "";
                int total_length = 0;
                while ((x = is.read()) != -1) {
                    int len;
                    int chunk_length;
                    if (!(chunk = chunk + (char)x).endsWith(NL) || chunk.length() <= 2) continue;
                    int semi_pos = chunk.indexOf(59);
                    if (semi_pos != -1) {
                        chunk = chunk.substring(0, semi_pos);
                    }
                    if ((chunk_length = Integer.parseInt(chunk = chunk.trim(), 16)) <= 0) break;
                    if ((total_length += chunk_length) > 0x100000) {
                        throw new IOException("Chunk size " + chunk_length + " too large");
                    }
                    byte[] buffer2 = new byte[chunk_length];
                    int buffer_pos = 0;
                    for (int rem = chunk_length; rem > 0; rem -= len) {
                        len = is.read(buffer2, buffer_pos, rem);
                        if (len <= 0) {
                            throw new IOException("Premature end of stream");
                        }
                        buffer_pos += len;
                    }
                    baos.write(buffer2);
                    chunk = "";
                }
                return new ByteArrayInputStream(baos.toByteArray());
            }
        }
        return is;
    }

    static {
        file_types.put("html", "text/html");
        file_types.put("htm", "text/html");
        file_types.put("css", "text/css");
        file_types.put("js", "text/javascript");
        file_types.put("xml", "text/xml");
        file_types.put("xsl", "text/xml");
        file_types.put("jpg", "image/jpeg");
        file_types.put("jpeg", "image/jpeg");
        file_types.put("gif", "image/gif");
        file_types.put("tiff", "image/tiff");
        file_types.put("bmp", "image/bmp");
        file_types.put("png", "image/png");
        file_types.put("torrent", "application/x-bittorrent");
        file_types.put("tor", "application/x-bittorrent");
        file_types.put("vuze", "application/x-vuze");
        file_types.put("vuz", "application/x-vuze");
        file_types.put("zip", "application/zip");
        file_types.put("txt", "text/plain");
        file_types.put("jar", "application/java-archive");
        file_types.put("jnlp", "application/x-java-jnlp-file");
        file_types.put("mp3", "audio/x-mpeg");
        file_types.put("flv", "video/x-flv");
        file_types.put("swf", "application/x-shockwave-flash");
        file_types.put("mkv", "video/x-matroska");
        file_types.put("mp4", "video/mp4");
        file_types.put("mov", "video/quicktime");
        file_types.put("avi", "video/avi");
        file_types.put("xap", "application/x-silverlight-app");
        compression.add("text/html");
        compression.add("text/css");
        compression.add("text/xml");
        compression.add("text/plain");
        compression.add("text/javascript");
    }
}

