/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.jman;

import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.core.util.average.MovingAverage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEJavaManagement;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEThreadMonitor
implements AEJavaManagement.ThreadStuff {
    private boolean disable_getThreadCpuTime = false;
    private ThreadMXBean thread_bean;

    public long getThreadCPUTime() {
        if (this.thread_bean == null) {
            return 0L;
        }
        return this.thread_bean.getCurrentThreadCpuTime();
    }

    public AEThreadMonitor() {
        try {
            this.thread_bean = ManagementFactory.getThreadMXBean();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String java_version = System.getProperty("java.runtime.version");
        this.disable_getThreadCpuTime = Constants.isOSX && java_version.startsWith("1.5.0_06");
        AEDiagnostics.addEvidenceGenerator(new EvidenceGenerateor());
        if (!this.disable_getThreadCpuTime) {
            AEThread thread = new AEThread("AEThreadMonitor"){

                public void runSupport() {
                    try {
                        try {
                            Class.forName("java.lang.management.ManagementFactory");
                            AEThreadMonitor.monitor15();
                        }
                        catch (Throwable e) {}
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            thread.setPriority(10);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static void monitor15() {
        AEDiagnosticsLogger log = AEDiagnostics.getLogger("thread");
        int num_processors = Runtime.getRuntime().availableProcessors();
        if (num_processors < 1) {
            num_processors = 1;
        }
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        log.log("Monitoring starts (processors =" + num_processors + ")");
        if (!bean.isThreadCpuTimeSupported()) {
            log.log("ThreadCpuTime not supported");
            return;
        }
        if (!bean.isThreadCpuTimeEnabled()) {
            log.log("Enabling ThreadCpuTime");
            bean.setThreadCpuTimeEnabled(true);
        }
        HashMap last_times = new HashMap();
        int time_available = 10000;
        long start_mono = SystemTime.getMonotonousTime();
        MovingAverage high_usage_history = AverageFactory.MovingAverage(12);
        boolean huh_mon_active = false;
        while (true) {
            long start = System.currentTimeMillis();
            try {
                Thread.sleep(10000L);
            }
            catch (Throwable e) {
                log.log(e);
            }
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            long[] ids = bean.getAllThreadIds();
            long[] diffs = new long[ids.length];
            long total_diffs = 0L;
            long biggest_diff = 0L;
            int biggest_index = 0;
            HashMap<Long, Long> new_times = new HashMap<Long, Long>();
            for (int i = 0; i < ids.length; ++i) {
                long id = ids[i];
                long time = bean.getThreadCpuTime(id) / 1000000L;
                Long old_time = (Long)last_times.get(id);
                if (old_time != null) {
                    long diff = time - old_time;
                    if (diff > biggest_diff) {
                        biggest_diff = diff;
                        biggest_index = i;
                    }
                    diffs[i] = diff;
                    total_diffs += diff;
                }
                new_times.put(id, time);
            }
            ThreadInfo info = bean.getThreadInfo(ids[biggest_index]);
            String thread_name = info == null ? "<dead>" : info.getThreadName();
            int percent = (int)(100L * biggest_diff / 10000L);
            Runtime rt = Runtime.getRuntime();
            log.log("Thread state: elapsed=" + elapsed + ",cpu=" + total_diffs + ",max=" + thread_name + "(" + biggest_diff + "/" + percent + "%),mem:max=" + rt.maxMemory() / 1024L + ",tot=" + rt.totalMemory() / 1024L + ",free=" + rt.freeMemory() / 1024L);
            if (huh_mon_active) {
                boolean interesting = percent > 5 && thread_name.equals("PRUDPPacketHandler:sender");
                double temp = high_usage_history.update(interesting ? 1.0 : 0.0);
                if (temp >= 0.5) {
                    Logger.log(new LogAlert(false, 1, "High CPU usage detected in networking code - see <a href=\"http://wiki.vuze.com/w/High_CPU_Usage\">The Wiki</a> for possible solutions"));
                }
            } else {
                boolean bl = huh_mon_active = SystemTime.getMonotonousTime() - start_mono > 120000L;
            }
            if (biggest_diff > 2500L) {
                info = bean.getThreadInfo(ids[biggest_index], 255);
                if (info == null) {
                    log.log("    no info for max thread");
                } else {
                    StackTraceElement[] elts = info.getStackTrace();
                    StringBuilder str = new StringBuilder(elts.length * 20);
                    str.append("    ");
                    for (int i = 0; i < elts.length; ++i) {
                        if (i != 0) {
                            str.append(", ");
                        }
                        str.append(elts[i]);
                    }
                    log.log(str.toString());
                }
            }
            last_times = new_times;
        }
    }

    public void dumpThreads() {
        StringWriter sw = new StringWriter();
        IndentWriter iw = new IndentWriter(new PrintWriter(sw));
        this.dumpThreads(iw);
        iw.close();
        Debug.out(sw.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpThreads(IndentWriter writer) {
        int i;
        final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] allThreadIds = threadBean.getAllThreadIds();
        writer.println("Threads " + allThreadIds.length);
        writer.indent();
        ArrayList<ThreadInfo> threadInfos = new ArrayList<ThreadInfo>(allThreadIds.length);
        for (i = 0; i < allThreadIds.length; ++i) {
            ThreadInfo info = threadBean.getThreadInfo(allThreadIds[i], 32);
            if (info == null) continue;
            threadInfos.add(info);
        }
        if (!this.disable_getThreadCpuTime) {
            Collections.sort(threadInfos, new Comparator<ThreadInfo>(){

                @Override
                public int compare(ThreadInfo o1, ThreadInfo o2) {
                    long diff = threadBean.getThreadCpuTime(o2.getThreadId()) - threadBean.getThreadCpuTime(o1.getThreadId());
                    if (diff == 0L) {
                        return o1.getThreadName().compareToIgnoreCase(o2.getThreadName());
                    }
                    return diff > 0L ? 1 : -1;
                }
            });
        }
        for (i = 0; i < threadInfos.size(); ++i) {
            try {
                Object var15_14;
                String sState;
                long lCpuTime;
                ThreadInfo threadInfo = (ThreadInfo)threadInfos.get(i);
                long l = lCpuTime = this.disable_getThreadCpuTime ? -1L : threadBean.getThreadCpuTime(threadInfo.getThreadId());
                if (lCpuTime == 0L) break;
                switch (threadInfo.getThreadState()) {
                    case BLOCKED: {
                        sState = "Blocked";
                        break;
                    }
                    case RUNNABLE: {
                        sState = "Runnable";
                        break;
                    }
                    case NEW: {
                        sState = "New";
                        break;
                    }
                    case TERMINATED: {
                        sState = "Terminated";
                        break;
                    }
                    case TIMED_WAITING: {
                        sState = "Timed Waiting";
                        break;
                    }
                    case WAITING: {
                        sState = "Waiting";
                        break;
                    }
                    default: {
                        sState = "" + (Object)((Object)threadInfo.getThreadState());
                    }
                }
                String sName = threadInfo.getThreadName();
                String sLockName = threadInfo.getLockName();
                writer.println(sName + ": " + sState + ", " + lCpuTime / 1000000L + "ms CPU, " + "B/W: " + threadInfo.getBlockedCount() + "/" + threadInfo.getWaitedCount() + (sLockName == null ? "" : "; Locked by " + sLockName + "/" + threadInfo.getLockOwnerName()));
                writer.indent();
                try {
                    StackTraceElement[] stackTrace = threadInfo.getStackTrace();
                    for (int j = 0; j < stackTrace.length; ++j) {
                        writer.println(stackTrace[j].toString());
                    }
                    var15_14 = null;
                    writer.exdent();
                    continue;
                }
                catch (Throwable throwable) {
                    var15_14 = null;
                    writer.exdent();
                    throw throwable;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        writer.exdent();
    }

    private class EvidenceGenerateor
    implements AEDiagnosticsEvidenceGenerator {
        private EvidenceGenerateor() {
        }

        public void generate(IndentWriter writer) {
            AEThreadMonitor.this.dumpThreads(writer);
        }
    }
}

