/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportStartpoint;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.proxy.AEProxySelector;
import com.aelitis.azureus.core.proxy.AEProxySelectorFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingZone;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerRateController;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.components.graphics.PingGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.Plot3D;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class TransferStatsView
implements UISWTViewCoreEventListener {
    public static final String MSGID_PREFIX = "TransferStatsView";
    private static final int MAX_DISPLAYED_PING_MILLIS = 1199;
    private static final int MAX_DISPLAYED_PING_MILLIS_DISP = 1200;
    private AzureusCore azureus_core;
    private GlobalManager global_manager;
    private GlobalManagerStats stats;
    private SpeedManager speedManager;
    private OverallStats totalStats;
    private Composite mainPanel;
    private Composite blahPanel;
    private BufferedLabel asn;
    private BufferedLabel estUpCap;
    private BufferedLabel estDownCap;
    private BufferedLabel uploadBiaser;
    private BufferedLabel currentIP;
    private Composite connectionPanel;
    private BufferedLabel upload_label;
    private BufferedLabel connection_label;
    private SpeedGraphic upload_graphic;
    private SpeedGraphic connection_graphic;
    private TabFolder con_folder;
    private long last_route_update;
    private Composite route_comp;
    private BufferedLabel[][] route_labels = new BufferedLabel[0][0];
    private Map<String, Long> route_last_seen = new HashMap<String, Long>();
    private Composite generalPanel;
    private BufferedLabel totalLabel;
    private BufferedLabel nowUp;
    private BufferedLabel nowDown;
    private BufferedLabel sessionDown;
    private BufferedLabel sessionUp;
    private BufferedLabel session_ratio;
    private BufferedLabel sessionTime;
    private BufferedLabel totalDown;
    private BufferedLabel totalUp;
    private BufferedLabel total_ratio;
    private BufferedLabel totalTime;
    private Label socksState;
    private BufferedLabel socksCurrent;
    private BufferedLabel socksFails;
    private Label socksMore;
    private Group autoSpeedPanel;
    private StackLayout autoSpeedPanelLayout;
    private Composite autoSpeedInfoPanel;
    private Composite autoSpeedDisabledPanel;
    private PingGraphic pingGraph;
    private plotView[] plot_views;
    private zoneView[] zone_views;
    private limitToTextHelper limit_to_text = new limitToTextHelper();
    private final DecimalFormat formatter = new DecimalFormat("##.#");
    private boolean initialised;
    private UISWTView swtView;

    public TransferStatsView() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                TransferStatsView.this.azureus_core = core;
                TransferStatsView.this.global_manager = core.getGlobalManager();
                TransferStatsView.this.stats = TransferStatsView.this.global_manager.getStats();
                TransferStatsView.this.speedManager = core.getSpeedManager();
                TransferStatsView.this.totalStats = StatsFactory.getStats();
            }
        });
        this.pingGraph = PingGraphic.getInstance();
    }

    private void initialize(Composite composite) {
        this.mainPanel = new Composite(composite, 0);
        GridLayout mainLayout = new GridLayout();
        this.mainPanel.setLayout((Layout)mainLayout);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (TransferStatsView.this.mainPanel == null || TransferStatsView.this.mainPanel.isDisposed()) {
                            return;
                        }
                        TransferStatsView.this.createGeneralPanel();
                        TransferStatsView.this.createConnectionPanel();
                        TransferStatsView.this.createCapacityPanel();
                        TransferStatsView.this.createAutoSpeedPanel();
                        TransferStatsView.this.initialised = true;
                    }
                });
            }
        });
    }

    private void createGeneralPanel() {
        this.generalPanel = new Composite(this.mainPanel, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 2;
        this.generalPanel.setLayout((Layout)outerLayout);
        GridData gridData = new GridData(768);
        this.generalPanel.setLayoutData((Object)gridData);
        Composite generalStatsPanel = new Composite(this.generalPanel, 2048);
        GridData generalStatsPanelGridData = new GridData(768);
        generalStatsPanelGridData.grabExcessHorizontalSpace = true;
        generalStatsPanel.setLayoutData((Object)generalStatsPanelGridData);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 5;
        panelLayout.makeColumnsEqualWidth = true;
        generalStatsPanel.setLayout((Layout)panelLayout);
        Label lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.downloaded");
        lbl = new Label(generalStatsPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uploaded");
        lbl = new Label(generalStatsPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.ratio");
        lbl = new Label(generalStatsPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uptime");
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        Label nowLabel = new Label(generalStatsPanel, 0);
        gridData = new GridData(768);
        nowLabel.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)nowLabel, "SpeedView.stats.now");
        this.nowDown = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.nowDown.setLayoutData(gridData);
        this.nowUp = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.nowUp.setLayoutData(gridData);
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        Label sessionLabel = new Label(generalStatsPanel, 0);
        gridData = new GridData(768);
        sessionLabel.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)sessionLabel, "SpeedView.stats.session");
        this.sessionDown = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.sessionDown.setLayoutData(gridData);
        this.sessionUp = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.sessionUp.setLayoutData(gridData);
        this.session_ratio = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.session_ratio.setLayoutData(gridData);
        this.sessionTime = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.sessionTime.setLayoutData(gridData);
        this.totalLabel = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.totalLabel.setLayoutData(gridData);
        Messages.setLanguageText(this.totalLabel.getWidget(), "SpeedView.stats.total");
        this.totalDown = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.totalDown.setLayoutData(gridData);
        this.totalUp = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.totalUp.setLayoutData(gridData);
        this.total_ratio = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.total_ratio.setLayoutData(gridData);
        this.totalTime = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.totalTime.setLayoutData(gridData);
        for (Object obj : new Object[]{nowLabel, sessionLabel, this.totalLabel}) {
            Object control = obj instanceof BufferedLabel ? ((BufferedLabel)obj).getControl() : (Label)obj;
            Menu menu = new Menu((Decorations)control.getShell(), 8);
            control.setMenu(menu);
            MenuItem item = new MenuItem(menu, 0);
            Messages.setLanguageText((Widget)item, "MainWindow.menu.view.configuration");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        uif.openView(4, "Stats");
                    }
                }
            });
        }
        Composite generalSocksPanel = new Composite(this.generalPanel, 2048);
        GridData generalSocksData = new GridData();
        generalSocksPanel.setLayoutData((Object)generalSocksData);
        GridLayout socksLayout = new GridLayout();
        socksLayout.numColumns = 2;
        generalSocksPanel.setLayout((Layout)socksLayout);
        lbl = new Label(generalSocksPanel, 0);
        Messages.setLanguageText((Widget)lbl, "label.socks");
        lbl = new Label(generalSocksPanel, 0);
        lbl = new Label(generalSocksPanel, 0);
        lbl.setText(MessageText.getString("label.proxy") + ":");
        this.socksState = new Label(generalSocksPanel, 0);
        gridData = new GridData(768);
        gridData.widthHint = 120;
        this.socksState.setLayoutData((Object)gridData);
        lbl = new Label(generalSocksPanel, 0);
        lbl.setText(MessageText.getString("PeersView.state") + ":");
        this.socksCurrent = new BufferedLabel(generalSocksPanel, 0x20000000);
        gridData = new GridData(768);
        this.socksCurrent.setLayoutData(gridData);
        lbl = new Label(generalSocksPanel, 0);
        lbl.setText(MessageText.getString("label.fails") + ":");
        this.socksFails = new BufferedLabel(generalSocksPanel, 0x20000000);
        gridData = new GridData(768);
        this.socksFails.setLayoutData(gridData);
        lbl = new Label(generalSocksPanel, 0);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 3;
        this.socksMore = new Label(generalSocksPanel, 0);
        this.socksMore.setText(MessageText.getString("label.more") + "...");
        this.socksMore.setLayoutData((Object)gridData);
        this.socksMore.setCursor(this.socksMore.getDisplay().getSystemCursor(21));
        this.socksMore.setForeground(Colors.blue);
        this.socksMore.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TransferStatsView.this.showSOCKSInfo();
            }

            public void mouseUp(MouseEvent arg0) {
                TransferStatsView.this.showSOCKSInfo();
            }
        });
        Point socks_size = generalSocksPanel.computeSize(-1, -1);
        Rectangle trim = generalSocksPanel.computeTrim(0, 0, socks_size.x, socks_size.y);
        generalStatsPanelGridData.heightHint = socks_size.y - (trim.height - socks_size.y);
    }

    private void showSOCKSInfo() {
        AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
        String info = proxy_selector.getInfo();
        TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("proxy.info.title"), null, info, false);
    }

    private void createCapacityPanel() {
        this.blahPanel = new Composite(this.mainPanel, 0);
        GridData blahPanelData = new GridData(768);
        this.blahPanel.setLayoutData((Object)blahPanelData);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 8;
        this.blahPanel.setLayout((Layout)panelLayout);
        Label label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.asn");
        this.asn = new BufferedLabel(this.blahPanel, 0);
        GridData gridData = new GridData(768);
        this.asn.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "label.current_ip");
        this.currentIP = new BufferedLabel(this.blahPanel, 0);
        gridData = new GridData(768);
        this.currentIP.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.estupcap");
        this.estUpCap = new BufferedLabel(this.blahPanel, 0);
        gridData = new GridData(768);
        this.estUpCap.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.estdowncap");
        this.estDownCap = new BufferedLabel(this.blahPanel, 0);
        gridData = new GridData(768);
        this.estDownCap.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.upbias");
        this.uploadBiaser = new BufferedLabel(this.blahPanel, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 7;
        this.uploadBiaser.setLayoutData(gridData);
    }

    private void createConnectionPanel() {
        this.connectionPanel = new Composite(this.mainPanel, 0);
        GridData gridData = new GridData(768);
        this.connectionPanel.setLayoutData((Object)gridData);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 2;
        panelLayout.makeColumnsEqualWidth = true;
        this.connectionPanel.setLayout((Layout)panelLayout);
        Composite conn_area = new Composite(this.connectionPanel, 0);
        gridData = new GridData(768);
        conn_area.setLayoutData((Object)gridData);
        panelLayout = new GridLayout();
        panelLayout.numColumns = 2;
        conn_area.setLayout((Layout)panelLayout);
        Label label = new Label(conn_area, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.con");
        this.connection_label = new BufferedLabel(conn_area, 0x20000000);
        gridData = new GridData(768);
        this.connection_label.setLayoutData(gridData);
        Composite upload_area = new Composite(this.connectionPanel, 0);
        gridData = new GridData(768);
        upload_area.setLayoutData((Object)gridData);
        panelLayout = new GridLayout();
        panelLayout.numColumns = 2;
        upload_area.setLayout((Layout)panelLayout);
        label = new Label(upload_area, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.upload");
        this.upload_label = new BufferedLabel(upload_area, 0x20000000);
        gridData = new GridData(768);
        this.upload_label.setLayoutData(gridData);
        this.con_folder = new TabFolder(this.connectionPanel, 16384);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.con_folder.setLayoutData((Object)gridData);
        this.con_folder.setBackground(Colors.background);
        TabItem conn_item = new TabItem(this.con_folder, 0);
        conn_item.setText(MessageText.getString("label.connections"));
        Canvas connection_canvas = new Canvas((Composite)this.con_folder, 262144);
        conn_item.setControl((Control)connection_canvas);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        connection_canvas.setLayoutData((Object)gridData);
        this.connection_graphic = SpeedGraphic.getInstance(new ValueFormater(){

            public String format(int value) {
                return String.valueOf(value);
            }
        });
        this.connection_graphic.initialize(connection_canvas);
        Color[] colors = this.connection_graphic.colors;
        this.connection_graphic.setLineColors(colors);
        TabItem route_info_tab = new TabItem(this.con_folder, 0);
        route_info_tab.setText(MessageText.getString("label.routing"));
        Composite route_tab_comp = new Composite((Composite)this.con_folder, 0);
        route_tab_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout routeTabLayout = new GridLayout();
        routeTabLayout.numColumns = 1;
        route_tab_comp.setLayout((Layout)routeTabLayout);
        route_info_tab.setControl((Control)route_tab_comp);
        ScrolledComposite sc = new ScrolledComposite(route_tab_comp, 512);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.route_comp = new Composite((Composite)sc, 0);
        this.route_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout routeLayout = new GridLayout();
        routeLayout.numColumns = 3;
        this.route_comp.setLayout((Layout)routeLayout);
        sc.setContent((Control)this.route_comp);
        this.buildRouteComponent(5);
        Canvas upload_canvas = new Canvas(this.connectionPanel, 262144);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        upload_canvas.setLayoutData((Object)gridData);
        this.upload_graphic = SpeedGraphic.getInstance(new ValueFormater(){

            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtc(value);
            }
        });
        this.upload_graphic.initialize(upload_canvas);
    }

    private void buildRouteComponent(int rows) {
        boolean changed = false;
        if (rows <= this.route_labels.length) {
            for (int i = rows; i < this.route_labels.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.route_labels[i][j].setText("");
                }
            }
        } else {
            Control[] labels = this.route_comp.getChildren();
            for (int i = 0; i < labels.length; ++i) {
                labels[i].dispose();
            }
            Label h1 = new Label(this.route_comp, 0);
            h1.setLayoutData((Object)new GridData(768));
            h1.setText(MessageText.getString("label.route"));
            Label h2 = new Label(this.route_comp, 0);
            h2.setLayoutData((Object)new GridData(768));
            h2.setText(MessageText.getString("tps.type.incoming"));
            Label h3 = new Label(this.route_comp, 0);
            h3.setLayoutData((Object)new GridData(768));
            h3.setText(MessageText.getString("label.outgoing"));
            new Label(this.route_comp, 0);
            new Label(this.route_comp, 0);
            new Label(this.route_comp, 0);
            this.route_labels = new BufferedLabel[rows][3];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < 3; ++j) {
                    BufferedLabel l = new BufferedLabel(this.route_comp, 0x20000000);
                    GridData gridData = new GridData(768);
                    l.setLayoutData(gridData);
                    this.route_labels[i][j] = l;
                }
            }
            changed = true;
        }
        Point size = this.route_comp.computeSize(this.route_comp.getParent().getSize().x, -1);
        changed = changed || !this.route_comp.getSize().equals((Object)size);
        this.route_comp.setSize(size);
        if (!changed) {
            for (int i = 0; i < this.route_labels.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    BufferedLabel lab = this.route_labels[i][j];
                    if (lab.getControl().getSize().y != 0 || lab.getText().length() <= 0) continue;
                    changed = true;
                }
            }
        }
        if (changed) {
            this.route_comp.getParent().layout(true, true);
        }
        this.route_comp.update();
    }

    private void createAutoSpeedPanel() {
        this.autoSpeedPanel = new Group(this.mainPanel, 0);
        GridData generalPanelData = new GridData(1808);
        this.autoSpeedPanel.setLayoutData((Object)generalPanelData);
        Messages.setLanguageText((Widget)this.autoSpeedPanel, "SpeedView.stats.autospeed", new String[]{String.valueOf(1200)});
        this.autoSpeedPanelLayout = new StackLayout();
        this.autoSpeedPanel.setLayout((Layout)this.autoSpeedPanelLayout);
        this.autoSpeedInfoPanel = new Composite((Composite)this.autoSpeedPanel, 0);
        this.autoSpeedInfoPanel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 8;
        layout.makeColumnsEqualWidth = true;
        this.autoSpeedInfoPanel.setLayout((Layout)layout);
        Canvas pingCanvas = new Canvas(this.autoSpeedInfoPanel, 262144);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        pingCanvas.setLayoutData((Object)gridData);
        this.pingGraph.initialize(pingCanvas);
        TabFolder folder = new TabFolder(this.autoSpeedInfoPanel, 16384);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        folder.setLayoutData((Object)gridData);
        folder.setBackground(Colors.background);
        ValueFormater speed_formatter = new ValueFormater(){

            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtc(value);
            }
        };
        ValueFormater time_formatter = new ValueFormater(){

            public String format(int value) {
                return value + " ms";
            }
        };
        ValueFormater[] formatters = new ValueFormater[]{speed_formatter, speed_formatter, time_formatter};
        String[] labels = new String[]{"up", "down", "ping"};
        SpeedManagerPingMapper[] mappers = this.speedManager.getMappers();
        this.plot_views = new plotView[mappers.length];
        this.zone_views = new zoneView[mappers.length];
        for (int i = 0; i < mappers.length; ++i) {
            SpeedManagerPingMapper mapper = mappers[i];
            TabItem plot_item = new TabItem(folder, 0);
            plot_item.setText("Plot " + mapper.getName());
            Canvas plotCanvas = new Canvas((Composite)folder, 262144);
            gridData = new GridData(1808);
            plotCanvas.setLayoutData((Object)gridData);
            this.plot_views[i] = new plotView(mapper, plotCanvas, labels, formatters);
            plot_item.setControl((Control)plotCanvas);
            TabItem zones_item = new TabItem(folder, 0);
            zones_item.setText("Zones " + mapper.getName());
            Canvas zoneCanvas = new Canvas((Composite)folder, 262144);
            gridData = new GridData(1808);
            zoneCanvas.setLayoutData((Object)gridData);
            this.zone_views[i] = new zoneView(mapper, zoneCanvas, labels, formatters);
            zones_item.setControl((Control)zoneCanvas);
        }
        this.autoSpeedDisabledPanel = new Composite((Composite)this.autoSpeedPanel, 0);
        this.autoSpeedDisabledPanel.setLayout((Layout)new GridLayout());
        Label disabled = new Label(this.autoSpeedDisabledPanel, 0);
        disabled.setEnabled(false);
        Messages.setLanguageText((Widget)disabled, "SpeedView.stats.autospeed.disabled");
        disabled.setLayoutData((Object)new GridData(832));
        this.autoSpeedPanelLayout.topControl = this.speedManager.isAvailable() ? this.autoSpeedInfoPanel : this.autoSpeedDisabledPanel;
        gridData = new GridData(768);
        gridData.horizontalSpan = 8;
        Legend.createLegendComposite(this.autoSpeedInfoPanel, PingGraphic.colors, new String[]{"TransferStatsView.legend.pingaverage", "TransferStatsView.legend.ping1", "TransferStatsView.legend.ping2", "TransferStatsView.legend.ping3"}, gridData);
    }

    private void delete() {
        int i;
        Utils.disposeComposite(this.generalPanel);
        Utils.disposeComposite(this.blahPanel);
        if (this.upload_graphic != null) {
            this.upload_graphic.dispose();
        }
        if (this.connection_graphic != null) {
            this.connection_graphic.dispose();
        }
        if (this.pingGraph != null) {
            this.pingGraph.dispose();
        }
        if (this.plot_views != null) {
            for (i = 0; i < this.plot_views.length; ++i) {
                this.plot_views[i].dispose();
            }
        }
        if (this.zone_views != null) {
            for (i = 0; i < this.zone_views.length; ++i) {
                this.zone_views[i].dispose();
            }
        }
    }

    private Composite getComposite() {
        return this.mainPanel;
    }

    private void refresh() {
        if (!this.initialised) {
            return;
        }
        this.refreshGeneral();
        this.refreshCapacityPanel();
        this.refreshConnectionPanel();
        this.refreshPingPanel();
    }

    private void refreshGeneral() {
        AEProxySelector proxy_selector;
        Proxy proxy;
        if (this.stats == null) {
            return;
        }
        int now_prot_down_rate = this.stats.getProtocolReceiveRate();
        int now_prot_up_rate = this.stats.getProtocolSendRate();
        int now_total_down_rate = this.stats.getDataReceiveRate() + now_prot_down_rate;
        int now_total_up_rate = this.stats.getDataSendRate() + now_prot_up_rate;
        float now_perc_down = (float)(now_prot_down_rate * 100) / (float)(now_total_down_rate == 0 ? 1 : now_total_down_rate);
        float now_perc_up = (float)(now_prot_up_rate * 100) / (float)(now_total_up_rate == 0 ? 1 : now_total_up_rate);
        this.nowDown.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_down_rate) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_down_rate) + ", " + this.formatter.format(now_perc_down) + "%)");
        this.nowUp.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_up_rate) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_up_rate) + ", " + this.formatter.format(now_perc_up) + "%)");
        long session_prot_received = this.stats.getTotalProtocolBytesReceived();
        long session_prot_sent = this.stats.getTotalProtocolBytesSent();
        long session_total_received = this.stats.getTotalDataBytesReceived() + session_prot_received;
        long session_total_sent = this.stats.getTotalDataBytesSent() + session_prot_sent;
        float session_perc_received = (float)(session_prot_received * 100L) / (float)(session_total_received == 0L ? 1L : session_total_received);
        float session_perc_sent = (float)(session_prot_sent * 100L) / (float)(session_total_sent == 0L ? 1L : session_total_sent);
        this.sessionDown.setText(DisplayFormatters.formatByteCountToKiBEtc(session_total_received) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_received) + ", " + this.formatter.format(session_perc_received) + "%)");
        this.sessionUp.setText(DisplayFormatters.formatByteCountToKiBEtc(session_total_sent) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_sent) + ", " + this.formatter.format(session_perc_sent) + "%)");
        if (this.totalStats != null) {
            long mark = this.totalStats.getMarkTime();
            if (mark > 0L) {
                Messages.setLanguageText(this.totalLabel.getWidget(), "SpeedView.stats.total.since", new String[]{new SimpleDateFormat().format(new Date(mark))});
            } else {
                Messages.setLanguageText(this.totalLabel.getWidget(), "SpeedView.stats.total");
            }
            long dl_bytes = this.totalStats.getDownloadedBytes(true);
            long ul_bytes = this.totalStats.getUploadedBytes(true);
            this.totalDown.setText(DisplayFormatters.formatByteCountToKiBEtc(dl_bytes));
            this.totalUp.setText(DisplayFormatters.formatByteCountToKiBEtc(ul_bytes));
            long session_up_time = this.totalStats.getSessionUpTime();
            long total_up_time = this.totalStats.getTotalUpTime(true);
            this.sessionTime.setText(session_up_time == 0L ? "" : DisplayFormatters.formatETA(session_up_time));
            this.totalTime.setText(total_up_time == 0L ? "" : DisplayFormatters.formatETA(total_up_time));
            long t_ratio_raw = 1000L * ul_bytes / (dl_bytes == 0L ? 1L : dl_bytes);
            long s_ratio_raw = 1000L * session_total_sent / (session_total_received == 0L ? 1L : session_total_received);
            String t_ratio = "";
            String s_ratio = "";
            String partial = String.valueOf(t_ratio_raw % 1000L);
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            t_ratio = t_ratio_raw / 1000L + "." + partial;
            partial = String.valueOf(s_ratio_raw % 1000L);
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            s_ratio = s_ratio_raw / 1000L + "." + partial;
            this.total_ratio.setText(t_ratio);
            this.session_ratio.setText(s_ratio);
        }
        this.socksMore.setEnabled((proxy = (proxy_selector = AEProxySelectorFactory.getSelector()).getActiveProxy()) != null);
        if (Constants.isOSX) {
            this.socksMore.setForeground(proxy == null ? Colors.light_grey : Colors.blue);
        }
        this.socksState.setText(proxy == null ? MessageText.getString("label.inactive") : ((InetSocketAddress)proxy.address()).getHostName());
        if (proxy == null) {
            this.socksCurrent.setText("");
            this.socksFails.setText("");
        } else {
            long last_con = proxy_selector.getLastConnectionTime();
            long last_fail = proxy_selector.getLastFailTime();
            int total_cons = proxy_selector.getConnectionCount();
            int total_fails = proxy_selector.getFailCount();
            long now = SystemTime.getMonotonousTime();
            long con_ago = now - last_con;
            long fail_ago = now - last_fail;
            String state_str = last_fail < 0L ? "PeerManager.status.ok" : (fail_ago > 60000L ? (con_ago < fail_ago ? "PeerManager.status.ok" : "SpeedView.stats.unknown") : "ManagerItem.error");
            this.socksCurrent.setText(MessageText.getString(state_str) + ", con=" + total_cons);
            long fail_ago_secs = fail_ago / 1000L;
            if (fail_ago_secs == 0L) {
                fail_ago_secs = 1L;
            }
            this.socksFails.setText(last_fail < 0L ? "" : DisplayFormatters.formatETA(fail_ago_secs, false) + " " + MessageText.getString("label.ago") + ", tot=" + total_fails);
        }
    }

    private void refreshCapacityPanel() {
        if (this.speedManager == null) {
            return;
        }
        this.asn.setText(this.speedManager.getASN());
        this.estUpCap.setText(this.limit_to_text.getLimitText(this.speedManager.getEstimatedUploadCapacityBytesPerSec()));
        this.estDownCap.setText(this.limit_to_text.getLimitText(this.speedManager.getEstimatedDownloadCapacityBytesPerSec()));
        this.uploadBiaser.setText(DownloadManagerRateController.getString());
        InetAddress current_ip = NetworkAdmin.getSingleton().getDefaultPublicAddress();
        this.currentIP.setText(current_ip == null ? "" : current_ip.getHostAddress());
    }

    private void refreshConnectionPanel() {
        long now;
        if (this.global_manager == null) {
            return;
        }
        int total_connections = 0;
        int total_con_queued = 0;
        int total_con_blocked = 0;
        int total_con_unchoked = 0;
        int total_data_queued = 0;
        int total_in = 0;
        List<DownloadManager> dms = this.global_manager.getDownloadManagers();
        for (DownloadManager dm : dms) {
            PEPeerManager pm = dm.getPeerManager();
            if (pm == null) continue;
            total_data_queued += pm.getBytesQueuedForUpload();
            total_connections += pm.getNbPeers() + pm.getNbSeeds();
            total_con_queued += pm.getNbPeersWithUploadQueued();
            total_con_blocked += pm.getNbPeersWithUploadBlocked();
            total_con_unchoked += pm.getNbPeersUnchoked();
            total_in += pm.getNbRemoteTCPConnections() + pm.getNbRemoteUDPConnections() + pm.getNbRemoteUTPConnections();
        }
        this.connection_label.setText(MessageText.getString("SpeedView.stats.con_details", new String[]{String.valueOf(total_connections) + "[" + MessageText.getString("label.in").toLowerCase() + ":" + total_in + "]", String.valueOf(total_con_unchoked), String.valueOf(total_con_queued), String.valueOf(total_con_blocked)}));
        this.connection_graphic.addIntsValue(new int[]{total_connections, total_con_unchoked, total_con_queued, total_con_blocked});
        this.upload_label.setText(MessageText.getString("SpeedView.stats.upload_details", new String[]{DisplayFormatters.formatByteCountToKiBEtc(total_data_queued)}));
        this.upload_graphic.addIntValue(total_data_queued);
        this.upload_graphic.refresh(false);
        this.connection_graphic.refresh(false);
        if (this.con_folder.getSelectionIndex() == 1 && (now = SystemTime.getMonotonousTime()) - this.last_route_update >= 2000L) {
            this.last_route_update = now;
            NetworkAdmin na = NetworkAdmin.getSingleton();
            HashMap<InetAddress, String> ip_to_name_map = new HashMap<InetAddress, String>();
            HashMap<String, RouteInfo> name_to_route_map = new HashMap<String, RouteInfo>();
            RouteInfo udp_info = null;
            RouteInfo unknown_info = null;
            List<PRUDPPacketHandler> udp_handlers = PRUDPPacketHandlerFactory.getHandlers();
            InetAddress udp_bind_ip = null;
            for (PRUDPPacketHandler handler : udp_handlers) {
                if (!handler.hasPrimordialHandler() || (udp_bind_ip = handler.getBindIP()) == null || !udp_bind_ip.isAnyLocalAddress()) continue;
                udp_bind_ip = null;
            }
            for (DownloadManager dm : dms) {
                PEPeerManager pm = dm.getPeerManager();
                if (pm == null) continue;
                List<PEPeer> peers = pm.getPeers();
                for (PEPeer p : peers) {
                    Transport transport;
                    NetworkConnection nc = PluginCoreUtils.unwrap(p.getPluginConnection());
                    boolean done = false;
                    if (nc != null && (transport = nc.getTransport()) != null) {
                        if (transport.isTCP()) {
                            InetSocketAddress socket_address;
                            TransportStartpoint start = transport.getTransportStartpoint();
                            if (start != null && (socket_address = start.getProtocolStartpoint().getAddress()) != null) {
                                RouteInfo info;
                                InetAddress address = socket_address.getAddress();
                                String name = address.isAnyLocalAddress() ? "* (TCP)" : (String)ip_to_name_map.get(address);
                                if (name == null) {
                                    name = na.classifyRoute(address);
                                    ip_to_name_map.put(address, name);
                                }
                                if (transport.isSOCKS()) {
                                    name = name + " (SOCKS)";
                                }
                                if ((info = (RouteInfo)name_to_route_map.get(name)) == null) {
                                    info = new RouteInfo(name);
                                    name_to_route_map.put(name, info);
                                    this.route_last_seen.put(name, now);
                                }
                                info.update(p);
                                done = true;
                            }
                        } else if (udp_bind_ip != null) {
                            RouteInfo info;
                            String name = (String)ip_to_name_map.get(udp_bind_ip);
                            if (name == null) {
                                name = na.classifyRoute(udp_bind_ip);
                                ip_to_name_map.put(udp_bind_ip, name);
                                info = (RouteInfo)name_to_route_map.get(name);
                                this.route_last_seen.put(name, now);
                                if (info == null) {
                                    info = new RouteInfo(name);
                                    name_to_route_map.put(name, info);
                                }
                            } else {
                                info = (RouteInfo)name_to_route_map.get(name);
                            }
                            info.update(p);
                            done = true;
                        } else {
                            if (udp_info == null) {
                                udp_info = new RouteInfo("* (UDP)");
                                name_to_route_map.put(udp_info.getName(), udp_info);
                                this.route_last_seen.put(udp_info.getName(), now);
                            }
                            udp_info.update(p);
                            done = true;
                        }
                    }
                    if (done) continue;
                    if (unknown_info == null) {
                        unknown_info = new RouteInfo("Pending");
                        name_to_route_map.put(unknown_info.getName(), unknown_info);
                        this.route_last_seen.put(unknown_info.getName(), now);
                    }
                    unknown_info.update(p);
                }
            }
            ArrayList<RouteInfo> rows = new ArrayList<RouteInfo>();
            Iterator<Map.Entry<String, Long>> it = this.route_last_seen.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Long> entry = it.next();
                long when = entry.getValue();
                if (now - when > 60000L) {
                    it.remove();
                    continue;
                }
                if (when == now) continue;
                rows.add(new RouteInfo(entry.getKey()));
            }
            rows.addAll(name_to_route_map.values());
            Collections.sort(rows, new Comparator<RouteInfo>(){

                @Override
                public int compare(RouteInfo o1, RouteInfo o2) {
                    String n1 = o1.getName();
                    String n2 = o2.getName();
                    if (n1.startsWith("*") || n1.equals("Pending")) {
                        n1 = "zzzz" + n1;
                    }
                    if (n2.startsWith("*") || n2.equals("Pending")) {
                        n2 = "zzzz" + n2;
                    }
                    return n1.compareTo(n2);
                }
            });
            this.buildRouteComponent(rows.size());
            for (int i = 0; i < rows.size(); ++i) {
                RouteInfo info = (RouteInfo)rows.get(i);
                this.route_labels[i][0].setText(info.getName());
                this.route_labels[i][1].setText(info.getIncomingString());
                this.route_labels[i][2].setText(info.getOutgoingString());
            }
            this.buildRouteComponent(rows.size());
        }
    }

    private void refreshPingPanel() {
        if (this.speedManager == null) {
            return;
        }
        if (this.speedManager.isAvailable()) {
            int i;
            this.autoSpeedPanelLayout.topControl = this.autoSpeedInfoPanel;
            this.autoSpeedPanel.layout();
            this.pingGraph.refresh();
            for (i = 0; i < this.plot_views.length; ++i) {
                this.plot_views[i].refresh();
            }
            for (i = 0; i < this.zone_views.length; ++i) {
                this.zone_views[i].refresh();
            }
        } else {
            this.autoSpeedPanelLayout.topControl = this.autoSpeedDisabledPanel;
            this.autoSpeedPanel.layout();
        }
    }

    public void periodicUpdate() {
        SpeedManagerPingSource[] sources;
        if (this.speedManager == null) {
            return;
        }
        if (this.speedManager.isAvailable() && (sources = this.speedManager.getPingSources()).length > 0) {
            int[] pings = new int[sources.length];
            for (int i = 0; i < sources.length; ++i) {
                SpeedManagerPingSource source = sources[i];
                if (source == null) continue;
                int ping = source.getPingTime();
                pings[i] = ping = Math.min(ping, 1199);
            }
            this.pingGraph.addIntsValue(pings);
            if (this.plot_views != null) {
                plotView[] arr$ = this.plot_views;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    plotView plotView2 = arr$[i$];
                    if (plotView2 == null) continue;
                    plotView2.update();
                }
            }
            if (this.zone_views != null) {
                for (zoneView zoneView2 : this.zone_views) {
                    if (zoneView2 == null) continue;
                    zoneView2.update();
                }
            }
        }
    }

    protected String getMapperTitle(SpeedManagerPingMapper mapper) {
        if (mapper.isActive()) {
            SpeedManagerLimitEstimate up_1 = mapper.getEstimatedUploadLimit(false);
            SpeedManagerLimitEstimate up_2 = mapper.getEstimatedUploadLimit(true);
            SpeedManagerLimitEstimate down_1 = mapper.getEstimatedDownloadLimit(false);
            SpeedManagerLimitEstimate down_2 = mapper.getEstimatedDownloadLimit(true);
            return "ul=" + DisplayFormatters.formatByteCountToKiBEtc(up_1.getBytesPerSec()) + ":" + DisplayFormatters.formatByteCountToKiBEtc(up_2.getBytesPerSec()) + ",dl=" + DisplayFormatters.formatByteCountToKiBEtc(down_1.getBytesPerSec()) + ":" + DisplayFormatters.formatByteCountToKiBEtc(down_2.getBytesPerSec()) + ",mr=" + DisplayFormatters.formatDecimal(mapper.getCurrentMetricRating(), 2);
        }
        return "";
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(MessageText.getString("TransferStatsView.title.full"));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                if (this.generalPanel == null) break;
                this.generalPanel.layout(true, true);
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }

    private static class RouteInfo {
        private String name;
        private RouteInfoRecord incoming = new RouteInfoRecord();
        private RouteInfoRecord outgoing = new RouteInfoRecord();

        private RouteInfo(String _name) {
            this.name = _name;
        }

        private String getName() {
            return this.name;
        }

        private String getIncomingString() {
            return this.incoming.getString();
        }

        private String getOutgoingString() {
            return this.outgoing.getString();
        }

        private void update(PEPeer peer) {
            RouteInfoRecord record = peer.isIncoming() ? this.incoming : this.outgoing;
            record.update(peer);
        }
    }

    private static class RouteInfoRecord {
        private int peer_count;
        private int up_rate;
        private int down_rate;

        private RouteInfoRecord() {
        }

        private void update(PEPeer peer) {
            ++this.peer_count;
            PEPeerStats stats2 = peer.getStats();
            this.up_rate = (int)((long)this.up_rate + (stats2.getDataSendRate() + stats2.getProtocolSendRate()));
            this.down_rate = (int)((long)this.down_rate + (stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate()));
        }

        private String getString() {
            if (this.peer_count == 0) {
                return "0";
            }
            return this.peer_count + ": up=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.up_rate) + ", down=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.down_rate);
        }
    }

    public static class limitToTextHelper {
        String msg_text_unknown = MessageText.getString("SpeedView.stats.unknown");
        String msg_text_estimate = MessageText.getString("SpeedView.stats.estimate");
        String msg_text_choke_estimate = MessageText.getString("SpeedView.stats.estimatechoke");
        String msg_text_measured_min;
        String msg_text_measured = MessageText.getString("SpeedView.stats.measured");
        String msg_text_manual;
        String msg_unlimited;
        String[] setable_types;

        public limitToTextHelper() {
            this.msg_text_measured_min = MessageText.getString("SpeedView.stats.measuredmin");
            this.msg_text_manual = MessageText.getString("SpeedView.stats.manual");
            this.msg_unlimited = MessageText.getString("ConfigView.unlimited");
            this.setable_types = new String[]{"", this.msg_text_estimate, this.msg_text_measured, this.msg_text_manual};
        }

        public String[] getSettableTypes() {
            return this.setable_types;
        }

        public String getSettableType(SpeedManagerLimitEstimate limit) {
            float type = limit.getEstimateType();
            String text = type == -0.1f ? "" : (type == 1.0f ? this.msg_text_manual : (type == 0.9f ? this.msg_text_measured : (type == 0.8f ? this.msg_text_measured : (type == 0.5f ? this.msg_text_estimate : this.msg_text_estimate))));
            return text;
        }

        public String typeToText(float type) {
            String text = type == -0.1f ? this.msg_text_unknown : (type == 1.0f ? this.msg_text_manual : (type == 0.9f ? this.msg_text_measured : (type == 0.8f ? this.msg_text_measured_min : (type == 0.5f ? this.msg_text_choke_estimate : this.msg_text_estimate))));
            return text;
        }

        public float textToType(String text) {
            if (text.equals(this.msg_text_estimate)) {
                return 0.0f;
            }
            if (text.equals(this.msg_text_choke_estimate)) {
                return 0.5f;
            }
            if (text.equals(this.msg_text_measured)) {
                return 0.9f;
            }
            if (text.equals(this.msg_text_manual)) {
                return 1.0f;
            }
            return -0.1f;
        }

        public String getLimitText(SpeedManagerLimitEstimate limit) {
            float type = limit.getEstimateType();
            String text = this.typeToText(type);
            int l = limit.getBytesPerSec();
            if (l == 0) {
                return this.msg_unlimited + " (" + text + ")";
            }
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(l) + " (" + text + ")";
        }

        public String getUnlimited() {
            return this.msg_unlimited;
        }
    }

    class plotView {
        private SpeedManagerPingMapper mapper;
        private Plot3D plotGraph;

        protected plotView(SpeedManagerPingMapper _mapper, Canvas _canvas, String[] _labels, ValueFormater[] _formatters) {
            this.mapper = _mapper;
            this.plotGraph = new Plot3D(_labels, _formatters);
            this.plotGraph.setMaxZ(1199);
            this.plotGraph.initialize(_canvas);
        }

        protected void update() {
            int[][] history = this.mapper.getHistory();
            this.plotGraph.update(history);
            this.plotGraph.setTitle(TransferStatsView.this.getMapperTitle(this.mapper));
        }

        protected void refresh() {
            this.plotGraph.refresh(false);
        }

        protected void dispose() {
            this.plotGraph.dispose();
        }
    }

    class zoneView
    implements ParameterListener {
        private SpeedManagerPingMapper mapper;
        private SpeedManagerPingZone[] zones = new SpeedManagerPingZone[0];
        private Canvas canvas;
        private ValueFormater[] formatters;
        private String[] labels;
        private String title = "";
        private int refresh_count;
        private int graphicsUpdate;
        private Point old_size;
        protected Image buffer_image;

        protected zoneView(SpeedManagerPingMapper _mapper, Canvas _canvas, String[] _labels, ValueFormater[] _formatters) {
            this.mapper = _mapper;
            this.canvas = _canvas;
            this.labels = _labels;
            this.formatters = _formatters;
            COConfigurationManager.addAndFireParameterListener("Graphics Update", this);
        }

        public void parameterChanged(String name) {
            this.graphicsUpdate = COConfigurationManager.getIntParameter(name);
        }

        protected void update() {
            this.zones = this.mapper.getZones();
            this.title = TransferStatsView.this.getMapperTitle(this.mapper);
        }

        private void refresh() {
            if (this.canvas.isDisposed()) {
                return;
            }
            Rectangle bounds = this.canvas.getClientArea();
            if (bounds.height < 30 || bounds.width < 100 || bounds.width > 2000 || bounds.height > 2000) {
                return;
            }
            boolean size_changed = this.old_size == null || this.old_size.x != bounds.width || this.old_size.y != bounds.height;
            this.old_size = new Point(bounds.width, bounds.height);
            ++this.refresh_count;
            if (this.refresh_count > this.graphicsUpdate) {
                this.refresh_count = 0;
            }
            if (this.refresh_count == 0 || size_changed) {
                if (this.buffer_image != null && !this.buffer_image.isDisposed()) {
                    this.buffer_image.dispose();
                }
                this.buffer_image = this.draw(bounds);
            }
            if (this.buffer_image != null) {
                GC gc = new GC((Drawable)this.canvas);
                gc.drawImage(this.buffer_image, bounds.x, bounds.y);
                gc.dispose();
            }
        }

        private Image draw(Rectangle bounds) {
            SpeedManagerLimitEstimate[] bad_down;
            SpeedManagerLimitEstimate[] bad_up;
            int i;
            int i2;
            int PAD_TOP = 10;
            int PAD_BOTTOM = 10;
            int PAD_RIGHT = 10;
            int PAD_LEFT = 10;
            int usable_width = bounds.width - 10 - 10;
            int usable_height = bounds.height - 10 - 10;
            Image image = new Image((Device)this.canvas.getDisplay(), bounds);
            GC gc = new GC((Drawable)image);
            try {
                gc.setAntialias(1);
            }
            catch (Exception e) {
                // empty catch block
            }
            int font_height = gc.getFontMetrics().getHeight();
            int char_width = gc.getFontMetrics().getAverageCharWidth();
            Color[] colours = TransferStatsView.this.plot_views[0].plotGraph.getColours();
            int max_x = 0;
            int max_y = 0;
            if (this.zones.length > 0) {
                int max_metric = 0;
                for (int i3 = 0; i3 < this.zones.length; ++i3) {
                    SpeedManagerPingZone zone = this.zones[i3];
                    int metric = zone.getMetric();
                    if (metric <= 0) continue;
                    max_metric = Math.max(max_metric, metric);
                    max_x = Math.max(max_x, zone.getUploadEndBytesPerSec());
                    max_y = Math.max(max_y, zone.getDownloadEndBytesPerSec());
                }
                if (max_x > 0 && max_y > 0) {
                    int i4;
                    double x_ratio = (double)usable_width / (double)max_x;
                    double y_ratio = (double)usable_height / (double)max_y;
                    ArrayList<Object[]> texts = new ArrayList<Object[]>();
                    for (i2 = 0; i2 < this.zones.length; ++i2) {
                        SpeedManagerPingZone zone = this.zones[i2];
                        int metric = zone.getMetric();
                        int x1 = zone.getUploadStartBytesPerSec();
                        int y1 = zone.getDownloadStartBytesPerSec();
                        int x2 = zone.getUploadEndBytesPerSec();
                        int y2 = zone.getDownloadEndBytesPerSec();
                        if (metric <= 0) continue;
                        int colour_index = (int)((float)metric * (float)colours.length / (float)max_metric);
                        if (colour_index >= colours.length) {
                            colour_index = colours.length - 1;
                        }
                        gc.setBackground(colours[colour_index]);
                        int x = 10 + (int)((double)x1 * x_ratio);
                        int y = 10 + (int)((double)y1 * y_ratio);
                        int width = (int)Math.ceil((double)(x2 - x1 + 1) * x_ratio);
                        int height = (int)Math.ceil((double)(y2 - y1 + 1) * y_ratio);
                        int y_draw = usable_height + 10 + 10 - y - height;
                        gc.fillRectangle(x, y_draw, width, height);
                        int text_metric = zone.getMetric();
                        String text = String.valueOf(metric);
                        int text_width = text.length() * char_width + 4;
                        if (width < text_width || height < font_height) continue;
                        Rectangle text_rect = new Rectangle(x + (width - text_width) / 2, y_draw + (height - font_height) / 2, text_width, font_height);
                        Iterator it = texts.iterator();
                        while (it.hasNext()) {
                            Object[] old = (Object[])it.next();
                            Rectangle old_coords = (Rectangle)old[1];
                            if (!old_coords.intersects(text_rect)) continue;
                            it.remove();
                        }
                        texts.add(new Object[]{new Integer(text_metric), text_rect});
                    }
                    int text_num = texts.size();
                    int n = i4 = text_num > 100 ? text_num - 100 : 0;
                    while (i4 < text_num) {
                        Object[] entry = (Object[])texts.get(i4);
                        String str = String.valueOf(entry[0]);
                        Rectangle rect = (Rectangle)entry[1];
                        gc.drawText(str, rect.x, rect.y, 1);
                        ++i4;
                    }
                }
            }
            int x_axis_left_x = 10;
            int x_axis_left_y = usable_height + 10;
            int x_axis_right_x = 10 + usable_width;
            int x_axis_right_y = x_axis_left_y;
            gc.drawLine(x_axis_left_x, x_axis_left_y, x_axis_right_x, x_axis_right_y);
            gc.drawLine(usable_width, x_axis_right_y - 4, x_axis_right_x, x_axis_right_y);
            gc.drawLine(usable_width, x_axis_right_y + 4, x_axis_right_x, x_axis_right_y);
            for (int i5 = 1; i5 < 10; ++i5) {
                int x = x_axis_left_x + (x_axis_right_x - x_axis_left_x) * i5 / 10;
                gc.drawLine(x, x_axis_left_y, x, x_axis_left_y + 4);
            }
            SpeedManagerLimitEstimate le = this.mapper.getEstimatedUploadLimit(false);
            if (le != null) {
                gc.setForeground(Colors.grey);
                int[][] segs = le.getSegments();
                if (segs.length > 0) {
                    int max_metric = 0;
                    int max_pos = 0;
                    for (int i6 = 0; i6 < segs.length; ++i6) {
                        int[] seg = segs[i6];
                        max_metric = Math.max(max_metric, seg[0]);
                        max_pos = Math.max(max_pos, seg[2]);
                    }
                    double metric_ratio = max_metric == 0 ? 1.0 : (double)(50.0f / (float)max_metric);
                    double pos_ratio = max_pos == 0 ? 1.0 : (double)((float)usable_width / (float)max_pos);
                    int prev_x = 1;
                    int prev_y = 1;
                    for (i = 0; i < segs.length; ++i) {
                        int[] seg = segs[i];
                        int next_x = (int)((double)(seg[1] + (seg[2] - seg[1]) / 2) * pos_ratio) + 1;
                        int next_y = (int)((double)seg[0] * metric_ratio) + 1;
                        gc.drawLine(x_axis_left_x + prev_x, x_axis_left_y - prev_y, x_axis_left_x + next_x, x_axis_left_y - next_y);
                        prev_x = next_x;
                        prev_y = next_y;
                    }
                }
                gc.setForeground(Colors.black);
            }
            if ((bad_up = this.mapper.getBadUploadHistory()).length > 0) {
                gc.setLineWidth(3);
                gc.setForeground(Colors.red);
                for (i2 = 0; i2 < bad_up.length; ++i2) {
                    int speed = bad_up[i2].getBytesPerSec();
                    int x = max_x == 0 ? 0 : speed * usable_width / max_x;
                    gc.drawLine(x_axis_left_x + x, x_axis_left_y - 0, x_axis_left_x + x, x_axis_left_y - 10);
                }
                gc.setForeground(Colors.black);
                gc.setLineWidth(1);
            }
            String x_text = this.labels[0] + " - " + this.formatters[0].format(max_x + 1);
            gc.drawText(x_text, x_axis_right_x - 20 - x_text.length() * char_width, x_axis_right_y - font_height - 2, 1);
            int y_axis_bottom_x = 10;
            int y_axis_bottom_y = usable_height + 10;
            int y_axis_top_x = 10;
            int y_axis_top_y = 10;
            gc.drawLine(y_axis_bottom_x, y_axis_bottom_y, y_axis_top_x, y_axis_top_y);
            gc.drawLine(y_axis_top_x - 4, y_axis_top_y + 10, y_axis_top_x, y_axis_top_y);
            gc.drawLine(y_axis_top_x + 4, y_axis_top_y + 10, y_axis_top_x, y_axis_top_y);
            for (int i7 = 1; i7 < 10; ++i7) {
                int y = y_axis_bottom_y + (y_axis_top_y - y_axis_bottom_y) * i7 / 10;
                gc.drawLine(y_axis_bottom_x, y, y_axis_bottom_x - 4, y);
            }
            le = this.mapper.getEstimatedDownloadLimit(false);
            if (le != null) {
                gc.setForeground(Colors.grey);
                int[][] segs = le.getSegments();
                if (segs.length > 0) {
                    int max_metric = 0;
                    int max_pos = 0;
                    for (i = 0; i < segs.length; ++i) {
                        int[] seg = segs[i];
                        max_metric = Math.max(max_metric, seg[0]);
                        max_pos = Math.max(max_pos, seg[2]);
                    }
                    double metric_ratio = max_metric == 0 ? 1.0 : (double)(50.0f / (float)max_metric);
                    double pos_ratio = max_pos == 0 ? 1.0 : (double)((float)usable_height / (float)max_pos);
                    int prev_x = 1;
                    int prev_y = 1;
                    for (int i8 = 0; i8 < segs.length; ++i8) {
                        int[] seg = segs[i8];
                        int next_x = (int)((double)seg[0] * metric_ratio) + 1;
                        int next_y = (int)((double)(seg[1] + (seg[2] - seg[1]) / 2) * pos_ratio) + 1;
                        gc.drawLine(y_axis_bottom_x + prev_x, y_axis_bottom_y - prev_y, y_axis_bottom_x + next_x, y_axis_bottom_y - next_y);
                        prev_x = next_x;
                        prev_y = next_y;
                    }
                }
                gc.setForeground(Colors.black);
            }
            if ((bad_down = this.mapper.getBadDownloadHistory()).length > 0) {
                gc.setForeground(Colors.red);
                gc.setLineWidth(3);
                for (int i9 = 0; i9 < bad_down.length; ++i9) {
                    int speed = bad_down[i9].getBytesPerSec();
                    int y = max_y == 0 ? 0 : speed * usable_height / max_y;
                    gc.drawLine(y_axis_bottom_x + 0, y_axis_bottom_y - y, y_axis_bottom_x + 10, y_axis_bottom_y - y);
                }
                gc.setForeground(Colors.black);
                gc.setLineWidth(1);
            }
            String y_text = this.labels[1] + " - " + this.formatters[1].format(max_y + 1);
            gc.drawText(y_text, y_axis_top_x + 4, y_axis_top_y + 2, 1);
            gc.drawText(this.title, (bounds.width - this.title.length() * char_width) / 2, 1, 1);
            gc.dispose();
            return image;
        }

        protected void dispose() {
            if (this.buffer_image != null && !this.buffer_image.isDisposed()) {
                this.buffer_image.dispose();
            }
            COConfigurationManager.removeParameterListener("Graphics Update", this);
        }
    }
}

