/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellSWTBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableRowSWTBase
implements TableRowSWT {
    public static boolean DEBUG_ROW_PAINT = false;
    private static final boolean expand_enabled = COConfigurationManager.getBooleanParameter("Table.useTree");
    protected Object lock;
    private final TableViewSWT tv;
    private final TableRowCore parentRow;
    private final Object coreDataSource;
    private int lastIndex = -1;
    protected Map<String, TableCellCore> mTableCells;
    private boolean bDisposed;
    private Object pluginDataSource;
    protected boolean wasShown = false;
    private boolean bSetNotUpToDateLastRefresh;
    private ArrayList<TableRowMouseListener> mouseListeners;
    private Map<String, Object> dataList;
    private int alpha = 255;
    private int fontStyle;
    private boolean expanded;

    public TableRowSWTBase(Object lock, TableRowCore parentRow, TableViewSWT tv, Object dataSource) {
        this.lock = lock;
        this.parentRow = parentRow;
        this.tv = tv;
        this.coreDataSource = dataSource;
    }

    @Override
    public void invalidate() {
        this.invalidate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(boolean mustRefersh) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return;
            }
            for (TableCellCore cell : this.mTableCells.values()) {
                if (cell == null) continue;
                cell.invalidate(mustRefersh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesAnyCellHaveFlag(int flag) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return false;
            }
            for (TableCellCore cell : this.mTableCells.values()) {
                if (!(cell instanceof TableCellSWTBase) || !((TableCellSWTBase)cell).hasFlag(flag)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCellFlag(int flag) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return;
            }
            for (TableCellCore cell : this.mTableCells.values()) {
                if (cell == null) continue;
                ((TableCellSWTBase)cell).setFlag(flag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCellFlag(int flag, boolean subRows) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return;
            }
            for (TableCellCore cell : this.mTableCells.values()) {
                if (cell == null) continue;
                ((TableCellSWTBase)cell).clearFlag(flag);
            }
            if (subRows) {
                TableRowCore[] subRowsWithNull;
                for (TableRowCore row : subRowsWithNull = this.getSubRowsWithNull()) {
                    ((TableRowSWTBase)row).clearCellFlag(flag, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed) {
                return;
            }
            if (this.mTableCells != null) {
                for (TableCellCore cell : this.mTableCells.values()) {
                    try {
                        if (cell == null || cell.isDisposed()) continue;
                        cell.dispose();
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
            }
            this.setHeight(0);
            this.bDisposed = true;
        }
    }

    @Override
    public List refresh(boolean bDoGraphics) {
        if (this.bDisposed) {
            return Collections.EMPTY_LIST;
        }
        boolean bVisible = this.isVisible();
        return this.refresh(bDoGraphics, bVisible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locationChanged(int iStartColumn) {
        if (this.bDisposed || !this.isVisible()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells == null) {
                return;
            }
            for (TableCellCore cell : this.mTableCells.values()) {
                if (cell == null || cell.getTableColumn().getPosition() <= iStartColumn) continue;
                cell.locationChanged();
            }
        }
    }

    @Override
    public Object getDataSource(boolean bCoreObject) {
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        this.pluginDataSource = PluginCoreUtils.convert(this.coreDataSource, bCoreObject);
        return this.pluginDataSource;
    }

    @Override
    public int getIndex() {
        if (this.bDisposed) {
            return -1;
        }
        if (this.lastIndex >= 0) {
            if (this.parentRow != null) {
                return this.lastIndex;
            }
            TableRowCore row = this.tv.getRowQuick(this.lastIndex);
            if (row == this) {
                return this.lastIndex;
            }
        }
        return this.tv.indexOf(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellCore getTableCellCore(String name) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return null;
            }
            return this.mTableCells.get(name);
        }
    }

    @Override
    public boolean isVisible() {
        return this.tv.isRowVisible(this);
    }

    @Override
    public boolean setTableItem(int newIndex) {
        return this.setTableItem(newIndex, true);
    }

    @Override
    public boolean setTableItem(int newIndex, boolean isVisible) {
        boolean changedIndex;
        if (this.bDisposed) {
            System.out.println("XXX setTI: bDisposed from " + Debug.getCompressedStackTrace());
            return false;
        }
        boolean bl = changedIndex = this.lastIndex != newIndex;
        if (changedIndex) {
            this.lastIndex = newIndex;
        }
        return changedIndex;
    }

    @Override
    public void setSelected(boolean selected) {
        TableView tableView = this.getView();
        if (tableView instanceof TableViewSWT) {
            ((TableViewSWT)tableView).setRowSelected(this, selected, true);
        }
    }

    @Override
    public boolean isRowDisposed() {
        return this.bDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUpToDate(boolean upToDate) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return;
            }
            for (TableCellCore cell : this.mTableCells.values()) {
                if (cell == null) continue;
                cell.setUpToDate(upToDate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableCellCore> refresh(boolean bDoGraphics, boolean bVisible) {
        ArrayList<TableCellCore> list = Collections.EMPTY_LIST;
        if (this.bDisposed) {
            return list;
        }
        if (!bVisible) {
            if (!this.bSetNotUpToDateLastRefresh) {
                this.setUpToDate(false);
                this.bSetNotUpToDateLastRefresh = true;
            }
            return list;
        }
        this.bSetNotUpToDateLastRefresh = false;
        this.tv.invokeRefreshListeners(this);
        ArrayList<TableCellCore> lTableCells = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells != null) {
                lTableCells = new ArrayList<TableCellCore>(this.mTableCells.values());
            }
        }
        if (lTableCells != null) {
            for (TableCellCore cell : lTableCells) {
                boolean cellVisible;
                boolean changed;
                TableColumn column;
                if (cell == null || cell.isDisposed() || (column = cell.getTableColumn()) != this.tv.getSortColumn() && !this.tv.isColumnVisible(column) || !(changed = cell.refresh(bDoGraphics, bVisible, cellVisible = bVisible && cell.isShown()))) continue;
                if (list == Collections.EMPTY_LIST) {
                    list = new ArrayList<TableCellCore>(lTableCells.size());
                }
                list.add(cell);
            }
        }
        return list;
    }

    @Override
    public TableView getView() {
        return this.tv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMouseListener(TableRowMouseListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mouseListeners == null) {
                this.mouseListeners = new ArrayList(1);
            }
            this.mouseListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMouseListener(TableRowMouseListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mouseListeners == null) {
                return;
            }
            this.mouseListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeMouseListeners(TableRowMouseEvent event2) {
        ArrayList<TableRowMouseListener> listeners;
        Object object = this.lock;
        synchronized (object) {
            listeners = this.mouseListeners == null ? null : new ArrayList<TableRowMouseListener>(this.mouseListeners);
        }
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableRowMouseListener l = listeners.get(i);
                l.rowMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public boolean isMouseOver() {
        return this.tv.getTableRowWithCursor() == this;
    }

    public boolean canExpand() {
        return expand_enabled;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean b) {
        if (this.canExpand() && this.expanded != b) {
            this.expanded = b;
            this.tv.invokeExpansionChangeListeners(this, b);
        }
    }

    @Override
    public TableRowCore getParentRowCore() {
        return this.parentRow;
    }

    @Override
    public boolean isInPaintItem() {
        return false;
    }

    @Override
    public Object getDataSource() {
        return this.getDataSource(false);
    }

    @Override
    public String getTableID() {
        return this.tv.getTableID();
    }

    @Override
    public abstract boolean setForeground(Color var1);

    @Override
    public void setForeground(int red, int green, int blue) {
        this.setForeground2(red, green, blue);
    }

    public boolean setForeground2(int red, int green, int blue) {
        if (red < 0 || green < 0 || blue < 0) {
            return this.setForeground((Color)null);
        }
        return this.setForeground(new RGB(red, green, blue));
    }

    private boolean setForeground(final RGB rgb) {
        boolean changed;
        Color colorFG = this.getForeground();
        boolean bl = changed = colorFG == null || colorFG.isDisposed() || !colorFG.getRGB().equals((Object)rgb);
        if (changed) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    TableRowSWTBase.this.setForeground(ColorCache.getColor((Device)Display.getCurrent(), rgb));
                }
            });
        }
        return changed;
    }

    @Override
    public void setForeground(int[] rgb) {
        this.setForeground2(rgb);
    }

    public boolean setForeground2(int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            return this.setForeground((Color)null);
        }
        return this.setForeground2(rgb[0], rgb[1], rgb[2]);
    }

    @Override
    public void setForegroundToErrorColor() {
        this.setForeground(Colors.colorError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return true;
            }
            boolean valid = true;
            for (TableCellCore cell : this.mTableCells.values()) {
                if (cell == null || !cell.isValid()) continue;
                return false;
            }
            return valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCell getTableCell(String field) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return null;
            }
            return this.mTableCells.get(field);
        }
    }

    @Override
    public boolean isSelected() {
        return this.getView().isSelected(this);
    }

    public boolean isFocused() {
        return this.getView().getFocusedRow() == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String id) {
        TableRowSWTBase tableRowSWTBase = this;
        synchronized (tableRowSWTBase) {
            return this.dataList == null ? null : this.dataList.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String id, Object data) {
        TableRowSWTBase tableRowSWTBase = this;
        synchronized (tableRowSWTBase) {
            if (this.dataList == null) {
                this.dataList = new HashMap<String, Object>(1);
            }
            if (data == null) {
                this.dataList.remove(id);
            } else {
                this.dataList.put(id, data);
            }
        }
    }

    @Override
    public abstract boolean setIconSize(Point var1);

    @Override
    public abstract Color getForeground();

    @Override
    public abstract Color getBackground();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellSWT getTableCellSWT(String name) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return null;
            }
            TableCellCore cell = this.mTableCells.get(name);
            if (cell instanceof TableCellSWT) {
                return (TableCellSWT)cell;
            }
            return null;
        }
    }

    @Override
    public abstract Rectangle getBounds();

    @Override
    public abstract void setBackgroundImage(Image var1);

    @Override
    public int getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public boolean setFontStyle(int style) {
        if (this.fontStyle == style) {
            return false;
        }
        this.fontStyle = style;
        this.invalidate();
        return true;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public boolean setAlpha(int alpha) {
        if (alpha == this.alpha) {
            return false;
        }
        this.alpha = alpha;
        return true;
    }

    @Override
    public abstract void setWidgetSelected(boolean var1);

    @Override
    public boolean isShown() {
        return this.wasShown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setShown(boolean b, boolean force) {
        if (this.bDisposed) {
            return false;
        }
        if (b == this.wasShown && !force) {
            return false;
        }
        this.wasShown = b;
        ArrayList<TableCellCore> lTableCells = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells != null) {
                lTableCells = new ArrayList<TableCellCore>(this.mTableCells.values());
            }
        }
        if (lTableCells != null) {
            for (TableCellCore cell : lTableCells) {
                if (cell == null) continue;
                cell.invokeVisibilityListeners(b ? 0 : 1, true);
            }
        }
        return true;
    }

    @Override
    public void redraw() {
        this.redraw(false);
    }
}

