/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.rss;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSChannel;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSItem;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.json.simple.JSONObject;

public class RSSEngine
extends WebEngine {
    private Pattern seed_leecher_pat = Pattern.compile("([0-9]+)\\s+(seed|leecher)s", 2);

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new RSSEngine(meta_search, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        return new RSSEngine(meta_search, id, last_updated, rank_bias, name, map);
    }

    public RSSEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, String searchURLFormat, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, 4, id, last_updated, rank_bias, name, searchURLFormat, "GMT", false, "EEE, d MMM yyyy HH:mm:ss Z", new FieldMapping[0], needs_auth, auth_method, login_url, required_cookies);
    }

    protected RSSEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
    }

    protected RSSEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        super(meta_search, 1, id, last_updated, rank_bias, name, map);
    }

    public Map exportToBencodedMap() throws IOException {
        return this.exportToBencodedMap(false);
    }

    public Map exportToBencodedMap(boolean generic) throws IOException {
        HashMap res = new HashMap();
        super.exportToBencodedMap(res, generic);
        return res;
    }

    public boolean supportsField(int field_id) {
        switch (field_id) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 102: 
            case 103: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    public int getAutoDownloadSupported() {
        return (int)this.getLocalLong("auto_dl_supported", 0L);
    }

    protected Result[] searchSupport(SearchParameter[] searchParameters, Map searchContext, int desired_max_matches, int absolute_max_matches, String headers, ResultListener listener) throws SearchException {
        this.debugStart();
        boolean only_if_mod = !searchContext.containsKey("force_full");
        WebEngine.pageDetails page_details = super.getWebPageContent(searchParameters, searchContext, headers, only_if_mod, new WebEngine.pageDetailsVerifier(){

            public void verify(WebEngine.pageDetails details) throws SearchException {
                try {
                    String page = details.getContent();
                    if (page != null && page.length() > 0) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(page.getBytes("UTF-8"));
                        RSSFeed rssFeed = StaticUtilities.getRSSFeed(details.getInitialURL(), bais);
                        details.setVerifiedState(rssFeed);
                    }
                }
                catch (Throwable e) {
                    RSSEngine.this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
                    if (e instanceof SearchException) {
                        throw (SearchException)e;
                    }
                    throw new SearchException("RSS matching failed", e);
                }
            }
        });
        String page = page_details.getContent();
        if (listener != null) {
            listener.contentReceived(this, page);
        }
        if (page == null || page.length() == 0) {
            return new Result[0];
        }
        try {
            RSSFeed rssFeed = (RSSFeed)page_details.getVerifiedState();
            RSSChannel[] channels = rssFeed.getChannels();
            ArrayList<WebResult> results = new ArrayList<WebResult>();
            block16: for (int i = 0; i < channels.length; ++i) {
                RSSChannel channel2 = channels[i];
                SimpleXMLParserDocumentNode[] channel_kids = channel2.getNode().getChildren();
                int auto_dl_state = 1;
                for (int j = 0; j < channel_kids.length; ++j) {
                    SimpleXMLParserDocumentNode child = channel_kids[j];
                    String lc_full_child_name = child.getFullName().toLowerCase();
                    if (!lc_full_child_name.equals("vuze:auto_dl_enabled") || child.getValue().equalsIgnoreCase("true")) continue;
                    auto_dl_state = 2;
                }
                this.setLocalLong("auto_dl_supported", auto_dl_state);
                RSSItem[] items = channel2.getItems();
                for (int j = 0; j < items.length; ++j) {
                    String magnet;
                    String name;
                    WebResult result;
                    block68: {
                        String uid;
                        String link_url;
                        String lc_url;
                        RSSItem item = items[j];
                        result = new WebResult(this, this.getRootPage(), this.getBasePage(), this.getDateParser(), "");
                        result.setPublishedDate(item.getPublicationDate());
                        result.setNameFromHTML(item.getTitle());
                        URL cdp_link = item.getLink();
                        boolean cdp_set = false;
                        if (cdp_link != null && ((lc_url = (link_url = cdp_link.toExternalForm()).toLowerCase(Locale.US)).startsWith("http") || lc_url.startsWith("tor:http"))) {
                            result.setCDPLink(link_url);
                            cdp_set = true;
                        }
                        if ((uid = item.getUID()) != null) {
                            result.setUID(uid);
                            if (!cdp_set) {
                                try {
                                    String test_url = new URL(uid).toExternalForm();
                                    if (test_url.toLowerCase().startsWith("http")) {
                                        result.setCDPLink(test_url);
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                        }
                        boolean got_seeds_peers = false;
                        SimpleXMLParserDocumentNode node = item.getNode();
                        if (node != null) {
                            SimpleXMLParserDocumentNode child;
                            int k;
                            SimpleXMLParserDocumentNode[] children = node.getChildren();
                            boolean vuze_feed = false;
                            for (k = 0; k < children.length; ++k) {
                                child = children[k];
                                String lc_full_child_name = child.getFullName().toLowerCase();
                                if (!lc_full_child_name.startsWith("vuze:")) continue;
                                vuze_feed = true;
                                break;
                            }
                            for (k = 0; k < children.length; ++k) {
                                child = children[k];
                                String lc_child_name = child.getName().toLowerCase();
                                String lc_full_child_name = child.getFullName().toLowerCase();
                                String value = child.getValue();
                                if (lc_child_name.equals("enclosure")) {
                                    SimpleXMLParserDocumentAttribute lengthAtt;
                                    SimpleXMLParserDocumentAttribute typeAtt = child.getAttribute("type");
                                    if (typeAtt == null || !typeAtt.getValue().equalsIgnoreCase("application/x-bittorrent")) continue;
                                    SimpleXMLParserDocumentAttribute urlAtt = child.getAttribute("url");
                                    if (urlAtt != null) {
                                        result.setTorrentLink(urlAtt.getValue());
                                    }
                                    if ((lengthAtt = child.getAttribute("length")) == null) continue;
                                    result.setSizeFromHTML(lengthAtt.getValue());
                                    continue;
                                }
                                if (lc_child_name.equals("category")) {
                                    result.setCategoryFromHTML(value);
                                    continue;
                                }
                                if (lc_child_name.equals("comments")) {
                                    result.setCommentsFromHTML(value);
                                    continue;
                                }
                                if (lc_child_name.equals("link") || lc_child_name.equals("guid")) {
                                    String lc_value = value.toLowerCase();
                                    try {
                                        URL url = new URL(value);
                                        if (lc_value.endsWith(".torrent") || lc_value.startsWith("magnet:") || lc_value.startsWith("bc:") || lc_value.startsWith("bctp:") || lc_value.startsWith("dht:")) {
                                            result.setTorrentLink(value);
                                            continue;
                                        }
                                        if (!lc_child_name.equals("link") || vuze_feed) continue;
                                        long test = this.getLocalLong("link_is_torrent", 0L);
                                        if (test == 1L) {
                                            result.setTorrentLink(value);
                                            continue;
                                        }
                                        if (test != 0L && SystemTime.getCurrentTime() - test <= 60000L) continue;
                                        if (this.linkIsToTorrent(url)) {
                                            result.setTorrentLink(value);
                                            this.setLocalLong("link_is_torrent", 1L);
                                            continue;
                                        }
                                        this.setLocalLong("link_is_torrent", SystemTime.getCurrentTime());
                                    }
                                    catch (Throwable e) {
                                        SimpleXMLParserDocumentAttribute hrefAtt;
                                        SimpleXMLParserDocumentAttribute typeAtt = child.getAttribute("type");
                                        if (typeAtt == null || !typeAtt.getValue().equalsIgnoreCase("application/x-bittorrent") || (hrefAtt = child.getAttribute("href")) == null) continue;
                                        String href = hrefAtt.getValue().trim();
                                        try {
                                            result.setTorrentLink(new URL(href).toExternalForm());
                                        }
                                        catch (Throwable f) {}
                                    }
                                    continue;
                                }
                                if (lc_child_name.equals("content") && rssFeed.isAtomFeed()) {
                                    String src;
                                    SimpleXMLParserDocumentAttribute srcAtt = child.getAttribute("src");
                                    String string = src = srcAtt == null ? null : srcAtt.getValue();
                                    if (src == null) continue;
                                    boolean is_dl_link = false;
                                    SimpleXMLParserDocumentAttribute typeAtt = child.getAttribute("type");
                                    if (typeAtt != null && typeAtt.getValue().equalsIgnoreCase("application/x-bittorrent")) {
                                        is_dl_link = true;
                                    }
                                    if (!is_dl_link) {
                                        boolean bl = is_dl_link = src.toLowerCase().indexOf(".torrent") != -1;
                                    }
                                    if (!is_dl_link) continue;
                                    try {
                                        new URL(src);
                                        result.setTorrentLink(src);
                                    }
                                    catch (Throwable e) {}
                                    continue;
                                }
                                if (lc_full_child_name.equals("vuze:size")) {
                                    result.setSizeFromHTML(value);
                                    continue;
                                }
                                if (lc_full_child_name.equals("vuze:seeds")) {
                                    got_seeds_peers = true;
                                    result.setNbSeedsFromHTML(value);
                                    continue;
                                }
                                if (lc_full_child_name.equals("vuze:superseeds")) {
                                    got_seeds_peers = true;
                                    result.setNbSuperSeedsFromHTML(value);
                                    continue;
                                }
                                if (lc_full_child_name.equals("vuze:peers")) {
                                    got_seeds_peers = true;
                                    result.setNbPeersFromHTML(value);
                                    continue;
                                }
                                if (lc_full_child_name.equals("vuze:rank")) {
                                    result.setRankFromHTML(value);
                                    continue;
                                }
                                if (lc_full_child_name.equals("vuze:contenttype")) {
                                    String type = value.toLowerCase();
                                    if (type.startsWith("video")) {
                                        type = "video";
                                    } else if (type.startsWith("audio")) {
                                        type = "audio";
                                    } else if (type.startsWith("games")) {
                                        type = "game";
                                    }
                                    result.setContentType(type);
                                    continue;
                                }
                                if (lc_full_child_name.equals("vuze:downloadurl")) {
                                    result.setTorrentLink(value);
                                    continue;
                                }
                                if (lc_full_child_name.equals("vuze:playurl")) {
                                    result.setPlayLink(value);
                                    continue;
                                }
                                if (lc_full_child_name.equals("vuze:drmkey")) {
                                    result.setDrmKey(value);
                                    continue;
                                }
                                if (!lc_full_child_name.equals("vuze:assethash")) continue;
                                result.setHash(value);
                            }
                        }
                        if (!got_seeds_peers) {
                            try {
                                SimpleXMLParserDocumentNode desc_node = node.getChild("description");
                                if (desc_node != null) {
                                    String desc = desc_node.getValue().trim();
                                    Matcher m = this.seed_leecher_pat.matcher(desc);
                                    while (m.find()) {
                                        String num = m.group(1);
                                        String type = m.group(2);
                                        if (type.toLowerCase().charAt(0) == 's') {
                                            result.setNbSeedsFromHTML(num);
                                            continue;
                                        }
                                        result.setNbPeersFromHTML(num);
                                    }
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                        try {
                            SimpleXMLParserDocumentNode trackers_node;
                            SimpleXMLParserDocumentNode n;
                            String hash;
                            SimpleXMLParserDocumentNode n2;
                            String dlink;
                            SimpleXMLParserDocumentNode n3;
                            SimpleXMLParserDocumentNode torrent_node = node.getChild("torrent");
                            if (torrent_node == null) break block68;
                            if (result.getSize() <= 0L && (n3 = torrent_node.getChild("contentLength")) != null) {
                                try {
                                    long l = Long.parseLong(n3.getValue().trim());
                                    result.setSizeFromHTML(l + " B");
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            if (((dlink = result.getDownloadLink()) == null || dlink.length() == 0) && (n2 = torrent_node.getChild("magnetURI")) != null) {
                                dlink = n2.getValue().trim();
                                result.setTorrentLink(dlink);
                            }
                            if (((hash = result.getHash()) == null || hash.length() == 0) && (n = torrent_node.getChild("infoHash")) != null) {
                                String uri;
                                String h = n.getValue().trim();
                                result.setHash(h);
                                if ((dlink == null || dlink.length() == 0) && (uri = UrlUtils.normaliseMagnetURI(h)) != null) {
                                    result.setTorrentLink(uri);
                                }
                            }
                            if ((trackers_node = torrent_node.getChild("trackers")) != null && !got_seeds_peers) {
                                SimpleXMLParserDocumentNode[] groups = trackers_node.getChildren();
                                int max_total = -1;
                                int best_seeds = 0;
                                int best_leechers = 0;
                                for (SimpleXMLParserDocumentNode group : groups) {
                                    SimpleXMLParserDocumentNode[] g_kids;
                                    for (SimpleXMLParserDocumentNode t : g_kids = group.getChildren()) {
                                        SimpleXMLParserDocumentAttribute a_leechers;
                                        int leechers;
                                        SimpleXMLParserDocumentAttribute a_seeds;
                                        int seeds;
                                        int total;
                                        if (!t.getName().equalsIgnoreCase("tracker") || (total = (seeds = (a_seeds = t.getAttribute("seeds")) == null ? -1 : Integer.parseInt(a_seeds.getValue().trim())) + (leechers = (a_leechers = t.getAttribute("peers")) == null ? -1 : Integer.parseInt(a_leechers.getValue().trim()))) <= max_total) continue;
                                        max_total = total;
                                        best_seeds = seeds;
                                        best_leechers = leechers;
                                    }
                                }
                                if (max_total >= 0) {
                                    result.setNbSeedsFromHTML(String.valueOf(Math.max(0, best_seeds)));
                                    result.setNbPeersFromHTML(String.valueOf(Math.max(0, best_leechers)));
                                }
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    String dlink = result.getDownloadLink();
                    if ((dlink == null || dlink.length() == 0) && (name = result.getName()) != null && (magnet = UrlUtils.parseTextForMagnets(name)) != null) {
                        result.setTorrentLink(magnet);
                    }
                    if ((dlink = result.getDownloadLink()) == null || dlink.length() == 0) {
                        result.setTorrentLink(result.getCDPLink());
                    }
                    results.add(result);
                    if (absolute_max_matches >= 0 && results.size() == absolute_max_matches) continue block16;
                }
            }
            Result[] res = results.toArray(new Result[results.size()]);
            this.debugLog("success: found " + res.length + " results");
            return res;
        }
        catch (Throwable e) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            throw new SearchException("RSS matching failed", e);
        }
    }

    protected boolean linkIsToTorrent(URL url) {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            String content_type = con.getContentType();
            if (content_type != null) {
                this.log("Testing link " + url + " to see if torrent link -> content type=" + content_type);
                if (content_type.equalsIgnoreCase("application/x-bittorrent")) {
                    return true;
                }
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

