/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

class GlobalManagerHostSupport
implements TRHostTorrentFinder {
    protected GlobalManager gm;
    protected TRHost host;

    protected GlobalManagerHostSupport(GlobalManager _gm) {
        this.gm = _gm;
        this.host = TRHostFactory.getSingleton();
        this.host.initialise(this);
    }

    public TOTorrent lookupTorrent(byte[] hash) {
        List<DownloadManager> managers = this.gm.getDownloadManagers();
        for (int i = 0; i < managers.size(); ++i) {
            DownloadManager dm = managers.get(i);
            TOTorrent t = dm.getTorrent();
            if (t == null) continue;
            try {
                if (!Arrays.equals(hash, t.getHash())) continue;
                return t;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    protected void torrentRemoved(String torrent_file_str, TOTorrent torrent) {
        File torrent_file;
        TRHostTorrent host_torrent = this.host.getHostTorrent(torrent);
        if (host_torrent != null && (torrent_file = new File(torrent_file_str)).exists()) {
            try {
                TorrentUtils.writeToFile(host_torrent.getTorrent(), torrent_file, false);
                host_torrent.setPassive(true);
            }
            catch (Throwable e) {
                Debug.out("Failed to make torrent '" + torrent_file_str + "' passive: " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    protected void destroy() {
        this.host.close();
    }
}

