/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class TextViewerWindow {
    private Shell shell;
    private Text txtInfo;
    private Button ok;
    private List<TextViewerWindowListener> listeners = new ArrayList<TextViewerWindowListener>();

    public TextViewerWindow(String sTitleID, String sMessageID, String sText) {
        this(sTitleID, sMessageID, sText, true);
    }

    public TextViewerWindow(String sTitleID, String sMessageID, String sText, boolean modal) {
        this(sTitleID, sMessageID, sText, modal, false);
    }

    public TextViewerWindow(String sTitleID, String sMessageID, String sText, boolean modal, boolean defer_modal) {
        this(null, sTitleID, sMessageID, sText, modal, defer_modal);
    }

    public TextViewerWindow(Shell parent_shell, String sTitleID, String sMessageID, String sText, boolean modal, boolean defer_modal) {
        this.shell = modal ? (parent_shell == null ? ShellFactory.createMainShell(68720) : ShellFactory.createShell(parent_shell, 68720)) : (parent_shell == null ? ShellFactory.createMainShell(3184) : ShellFactory.createShell(parent_shell, 3184));
        if (sTitleID != null) {
            this.shell.setText(MessageText.keyExists(sTitleID) ? MessageText.getString(sTitleID) : sTitleID);
        }
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        if (sMessageID != null) {
            label.setText(MessageText.keyExists(sMessageID) ? MessageText.getString(sMessageID) : sMessageID);
        }
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.txtInfo = new Text((Composite)this.shell, 2818);
        gridData = new GridData(1808);
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        gridData.horizontalSpan = 2;
        this.txtInfo.setLayoutData((Object)gridData);
        this.txtInfo.setText(sText);
        label = new Label((Composite)this.shell, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.ok = new Button((Composite)this.shell, 8);
        this.ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData();
        gridData.widthHint = 70;
        this.ok.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(this.ok);
        this.ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    TextViewerWindow.this.shell.dispose();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b' && TextViewerWindow.this.ok.isEnabled()) {
                    TextViewerWindow.this.shell.dispose();
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                for (TextViewerWindowListener l : TextViewerWindow.this.listeners) {
                    l.closed();
                }
            }
        });
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
        if (modal && !defer_modal) {
            this.goModal();
        }
    }

    public void goModal() {
        Display display = SWTThread.getInstance().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void append(String str) {
        this.txtInfo.setText(this.txtInfo.getText() + str);
        this.txtInfo.setSelection(this.txtInfo.getTextLimit());
    }

    public void append2(String str) {
        this.txtInfo.append(str);
        this.txtInfo.setSelection(this.txtInfo.getTextLimit());
    }

    public String getText() {
        return this.txtInfo.getText();
    }

    public void setText(String text) {
        this.txtInfo.setText(text);
        this.txtInfo.setSelection(this.txtInfo.getTextLimit());
    }

    public void setEditable(boolean editable) {
        this.txtInfo.setEditable(editable);
    }

    public void setOKEnabled(boolean enabled) {
        this.ok.setEnabled(enabled);
    }

    public void addListener(TextViewerWindowListener l) {
        this.listeners.add(l);
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public static interface TextViewerWindowListener {
        public void closed();
    }
}

