/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import com.aelitis.azureus.ui.common.updater.UIUpdatableAlways;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.AZProgressBar;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.BlockedIpsWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.IMainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.ListenerNeedingCoreRunning;
import org.gudy.azureus2.ui.swt.mainwindow.SelectableSpeedMenu;
import org.gudy.azureus2.ui.swt.mainwindow.SystemWarningWindow;
import org.gudy.azureus2.ui.swt.progress.IProgressReport;
import org.gudy.azureus2.ui.swt.progress.IProgressReporter;
import org.gudy.azureus2.ui.swt.progress.IProgressReportingListener;
import org.gudy.azureus2.ui.swt.progress.ProgressReporterWindow;
import org.gudy.azureus2.ui.swt.progress.ProgressReportingManager;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.update.UpdateWindow;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;

public class MainStatusBar
implements IMainStatusBar,
UIUpdatableAlways {
    private static final String STATUS_ICON_WARN = "sb_warning";
    private static final String ID = "MainStatusBar";
    private AEMonitor this_mon = new AEMonitor("MainStatusBar");
    private UpdateWindow updateWindow;
    private Composite statusBar;
    private CLabel statusText;
    private String statusTextKey = "";
    private String statusImageKey = null;
    private Image statusImage = null;
    private AZProgressBar progressBar;
    private CLabelPadding ipBlocked;
    private CLabelPadding srStatus;
    private CLabelPadding natStatus;
    private CLabelPadding dhtStatus;
    private CLabelPadding statusDown;
    private CLabelPadding statusUp;
    private Composite plugin_label_composite;
    private ArrayList<Runnable> listRunAfterInit = new ArrayList();
    private Display display;
    private long last_sr_ratio = -1L;
    private int last_sr_status = -1;
    private int lastNATstatus = -1;
    private String lastNATimageID = null;
    private int lastDHTstatus = -1;
    private long lastDHTcount = -1L;
    private NumberFormat numberFormat;
    private OverallStats overall_stats;
    private ConnectionManager connection_manager;
    private DHTPlugin dhtPlugin;
    private UIFunctions uiFunctions;
    private UIStatusTextClickListener clickListener;
    private static final int borderFlag = 32;
    private boolean isAZ3 = false;
    private ProgressReportingManager PRManager = ProgressReportingManager.getInstance();
    private GridData progressGridData = new GridData(131072, 0x1000000, false, false);
    private CLabelPadding progressViewerImageLabel;
    private String lastSRimageID = null;
    private int last_dl_limit;
    private long last_rec_data = -1L;
    private long last_rec_prot;
    private long[] max_rec = new long[]{0L};
    private long[] max_sent = new long[]{0L};
    private Image imgRec;
    private Image imgSent;
    private Image warningIcon;
    private Image warningGreyIcon;
    private Image infoIcon;
    private CLabelPadding statusWarnings;
    private TimerEventPeriodic alert_flasher_event;
    private long alert_flasher_event_start_time;
    private boolean alert_flash_activate;
    boolean was_hidden = false;

    public MainStatusBar() {
        this.numberFormat = NumberFormat.getInstance();
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                PluginManager pm = core.getPluginManager();
                MainStatusBar.this.connection_manager = PluginInitializer.getDefaultInterface().getConnectionManager();
                PluginInterface dht_pi = pm.getPluginInterfaceByClass(DHTPlugin.class);
                if (dht_pi != null) {
                    MainStatusBar.this.dhtPlugin = (DHTPlugin)dht_pi.getPlugin();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Composite initStatusBar(final Composite parent) {
        ArrayList<Runnable> list;
        this.display = parent.getDisplay();
        this.uiFunctions = UIFunctionsManager.getUIFunctions();
        ImageLoader imageLoader = ImageLoader.getInstance();
        Color fgColor = parent.getForeground();
        this.statusBar = new Composite(parent, 0);
        this.statusBar.setForeground(fgColor);
        this.isAZ3 = "az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"));
        this.statusBar.getShell().addListener(20, new Listener(){

            public void handleEvent(Event event2) {
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        if (!MainStatusBar.this.statusBar.isDisposed()) {
                            MainStatusBar.this.statusBar.layout();
                        }
                    }
                });
            }
        });
        GridLayout layout_status = new GridLayout();
        layout_status.numColumns = 20;
        layout_status.horizontalSpacing = 0;
        layout_status.verticalSpacing = 0;
        layout_status.marginHeight = 0;
        if (Constants.isOSX) {
            try {
                layout_status.marginRight = 15;
            }
            catch (NoSuchFieldError e) {
                layout_status.marginWidth = 15;
            }
        } else {
            layout_status.marginWidth = 0;
        }
        this.statusBar.setLayout((Layout)layout_status);
        this.statusText = new CLabel(this.statusBar, 32);
        this.statusText.setForeground(fgColor);
        this.statusText.setLayoutData((Object)new GridData(784));
        this.addStatusBarMenu((Composite)this.statusText);
        GC gc = new GC((Drawable)this.statusText);
        int height = Math.max(16, gc.getFontMetrics().getHeight()) + 6;
        gc.dispose();
        FormData formData = new FormData();
        formData.height = height;
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.statusBar.setLayoutData((Object)formData);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (MainStatusBar.this.clickListener == null) {
                    if (MainStatusBar.this.updateWindow != null) {
                        MainStatusBar.this.updateWindow.show();
                    }
                } else {
                    MainStatusBar.this.clickListener.UIStatusTextClicked();
                }
            }
        };
        this.statusText.addListener(4, listener);
        this.statusText.addListener(8, listener);
        this.progressBar = true == Constants.isOSX ? new AZProgressBar(this.statusBar, true) : new AZProgressBar(this.statusBar, false);
        this.progressBar.setVisible(false);
        this.progressGridData = new GridData(0x1000000, 0x1000000, false, false);
        this.progressGridData.widthHint = 5;
        this.progressBar.setLayoutData(this.progressGridData);
        this.progressViewerImageLabel = new CLabelPadding(this.statusBar, 0);
        this.progressViewerImageLabel.setToolTipText(MessageText.getString("Progress.reporting.statusbar.button.tooltip"));
        this.progressViewerImageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                block2: {
                    IProgressReporter[] reporters;
                    block1: {
                        reporters = MainStatusBar.this.PRManager.getReportersArray(false);
                        if (reporters.length != 0) break block1;
                        if (ProgressReporterWindow.isShowingEmpty()) break block2;
                        ProgressReporterWindow.open(reporters, 32);
                        break block2;
                    }
                    for (int i = 0; i < reporters.length; ++i) {
                        if (ProgressReporterWindow.isOpened(reporters[i])) continue;
                        ProgressReporterWindow.open(reporters, 32);
                        break;
                    }
                }
            }
        });
        this.progressViewerImageLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                imageLoader.releaseImage("progress_error");
                imageLoader.releaseImage("progress_info");
                imageLoader.releaseImage("progress_viewer");
            }
        });
        this.plugin_label_composite = new Composite(this.statusBar, 0);
        this.plugin_label_composite.setForeground(fgColor);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.numColumns = 20;
        GridData gridData = new GridData(1040);
        gridData.heightHint = height;
        gridData.minimumHeight = height;
        this.plugin_label_composite.setLayout((Layout)gridLayout);
        this.plugin_label_composite.setLayoutData((Object)gridData);
        this.srStatus = new CLabelPadding(this.statusBar, 32);
        this.srStatus.setText(MessageText.getString("SpeedView.stats.ratio"));
        COConfigurationManager.addAndFireParameterListener("Status Area Show SR", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.srStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.natStatus = new CLabelPadding(this.statusBar, 32);
        this.natStatus.setText("");
        COConfigurationManager.addAndFireParameterListener("Status Area Show NAT", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.natStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.dhtStatus = new CLabelPadding(this.statusBar, 32);
        this.dhtStatus.setText("");
        this.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.tooltip"));
        COConfigurationManager.addAndFireParameterListener("Status Area Show DDB", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.dhtStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.ipBlocked = new CLabelPadding(this.statusBar, 32);
        this.ipBlocked.setText("{} IPs:");
        Messages.setLanguageText((Widget)this.ipBlocked, "MainWindow.IPs.tooltip");
        this.ipBlocked.addListener(8, new ListenerNeedingCoreRunning(){

            public void handleEvent(AzureusCore core, Event event2) {
                BlockedIpsWindow.showBlockedIps(core, parent.getShell());
            }
        });
        final Menu menuIPFilter = new Menu((Decorations)this.statusBar.getShell(), 8);
        this.ipBlocked.setMenu(menuIPFilter);
        menuIPFilter.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                MenuItem[] oldItems = menuIPFilter.getItems();
                for (int i = 0; i < oldItems.length; ++i) {
                    oldItems[i].dispose();
                }
                if (!AzureusCoreFactory.isCoreRunning()) {
                    return;
                }
                AzureusCore azureusCore = AzureusCoreFactory.getSingleton();
                final IpFilter ip_filter = azureusCore.getIpFilterManager().getIPFilter();
                final MenuItem ipfEnable = new MenuItem(menuIPFilter, 32);
                ipfEnable.setSelection(ip_filter.isEnabled());
                Messages.setLanguageText((Widget)ipfEnable, "MyTorrentsView.menu.ipf_enable");
                ipfEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ip_filter.setEnabled(ipfEnable.getSelection());
                    }
                });
                MenuItem ipfOptions = new MenuItem(menuIPFilter, 8);
                Messages.setLanguageText((Widget)ipfOptions, "ipfilter.options");
                ipfOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        UIFunctions uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) {
                            uif.openView(4, "ipfilter");
                        }
                    }
                });
            }
        });
        COConfigurationManager.addAndFireParameterListener("Status Area Show IPF", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.ipBlocked.setVisible(COConfigurationManager.getBooleanParameter(parameterName));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.statusDown = new CLabelPadding(this.statusBar, 32);
        this.statusDown.setImage(imageLoader.getImage("down"));
        Messages.setLanguageText((Widget)this.statusDown, "MainWindow.status.updowndetails.tooltip");
        Listener lStats = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "TransferStatsView");
            }
        };
        this.statusUp = new CLabelPadding(this.statusBar, 32);
        this.statusUp.setImage(imageLoader.getImage("up"));
        Messages.setLanguageText((Widget)this.statusUp, "MainWindow.status.updowndetails.tooltip");
        this.statusDown.addListener(8, lStats);
        this.statusUp.addListener(8, lStats);
        Listener lDHT = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "DHTView");
            }
        };
        this.dhtStatus.addListener(8, lDHT);
        Listener lSR = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "SpeedView");
                OverallStats stats2 = StatsFactory.getStats();
                if (stats2 == null) {
                    return;
                }
                long ratio = 1000L * stats2.getUploadedBytes() / (stats2.getDownloadedBytes() + 1L);
                if (ratio < 900L) {
                    // empty if block
                }
            }
        };
        this.srStatus.addListener(8, lSR);
        ListenerNeedingCoreRunning lNAT = new ListenerNeedingCoreRunning(){

            public void handleEvent(AzureusCore core, Event e) {
                MainStatusBar.this.uiFunctions.openView(4, "server");
                if (PluginInitializer.getDefaultInterface().getConnectionManager().getNATStatus() != 1) {
                    Utils.launch("http://wiki.vuze.com/w/NAT_problem");
                }
            }
        };
        this.natStatus.addListener(8, lNAT);
        boolean bSpeedMenu = COConfigurationManager.getBooleanParameter("GUI_SWT_bOldSpeedMenu");
        if (bSpeedMenu) {
            final Menu menuUpSpeed = new Menu((Decorations)this.statusBar.getShell(), 8);
            menuUpSpeed.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    if (!AzureusCoreFactory.isCoreRunning()) {
                        return;
                    }
                    AzureusCore core = AzureusCoreFactory.getSingleton();
                    GlobalManager globalManager = core.getGlobalManager();
                    SelectableSpeedMenu.generateMenuItems(menuUpSpeed, core, globalManager, true);
                }
            });
            this.statusUp.setMenu(menuUpSpeed);
        } else {
            this.statusUp.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.button != 3 && (e.button != 1 || e.stateMask != 262144)) {
                        return;
                    }
                    Event event2 = new Event();
                    event2.type = 4;
                    event2.widget = e.widget;
                    event2.stateMask = e.stateMask;
                    event2.button = e.button;
                    e.widget.getDisplay().post(event2);
                    CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                        public void azureusCoreRunning(AzureusCore core) {
                            SelectableSpeedMenu.invokeSlider((Control)MainStatusBar.this.statusUp, core, true);
                        }
                    });
                }
            });
        }
        if (bSpeedMenu) {
            final Menu menuDownSpeed = new Menu((Decorations)this.statusBar.getShell(), 8);
            menuDownSpeed.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    if (!AzureusCoreFactory.isCoreRunning()) {
                        return;
                    }
                    AzureusCore core = AzureusCoreFactory.getSingleton();
                    GlobalManager globalManager = core.getGlobalManager();
                    SelectableSpeedMenu.generateMenuItems(menuDownSpeed, core, globalManager, false);
                }
            });
            this.statusDown.setMenu(menuDownSpeed);
        } else {
            this.statusDown.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.button != 3 && (e.button != 1 || e.stateMask != 262144)) {
                        return;
                    }
                    Event event2 = new Event();
                    event2.type = 4;
                    event2.widget = e.widget;
                    event2.stateMask = e.stateMask;
                    event2.button = e.button;
                    e.widget.getDisplay().post(event2);
                    CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                        public void azureusCoreRunning(AzureusCore core) {
                            SelectableSpeedMenu.invokeSlider((Control)MainStatusBar.this.statusDown, core, false);
                        }
                    });
                }
            });
        }
        this.statusWarnings = new CLabelPadding(this.statusBar, 32);
        this.warningIcon = imageLoader.getImage("image.sidebar.vitality.alert");
        this.warningGreyIcon = imageLoader.getImage("image.sidebar.vitality.alert-gray");
        this.infoIcon = imageLoader.getImage("image.sidebar.vitality.info");
        this.updateStatusWarnings(null, false);
        Messages.setLanguageText((Widget)this.statusWarnings, "MainWindow.status.warning.tooltip");
        Alerts.addMessageHistoryListener(new Alerts.AlertHistoryListener(){

            public void alertHistoryAdded(LogAlert alert) {
                MainStatusBar.this.updateStatusWarnings(alert, true);
            }

            public void alertHistoryRemoved(LogAlert alert) {
                MainStatusBar.this.updateStatusWarnings(alert, false);
            }
        });
        this.statusWarnings.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                if (SystemWarningWindow.numWarningWindowsOpen > 0) {
                    return;
                }
                ArrayList<LogAlert> alerts = Alerts.getUnviewedLogAlerts();
                if (alerts.size() == 0) {
                    return;
                }
                Shell shell = MainStatusBar.this.statusWarnings.getShell();
                Rectangle bounds = MainStatusBar.this.statusWarnings.getClientArea();
                Point ptBottomRight = MainStatusBar.this.statusWarnings.toDisplay(bounds.x + bounds.width, bounds.y);
                new SystemWarningWindow(alerts.get(0), ptBottomRight, shell, 0);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Menu menuStatusWarnings = new Menu((Decorations)this.statusBar.getShell(), 8);
        this.statusWarnings.setMenu(menuStatusWarnings);
        final MenuItem dismissAllItem = new MenuItem(menuStatusWarnings, 8);
        menuStatusWarnings.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                dismissAllItem.setEnabled(Alerts.getUnviewedLogAlerts().size() > 0);
            }
        });
        Messages.setLanguageText((Widget)dismissAllItem, "label.dismiss.all");
        dismissAllItem.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ArrayList<LogAlert> alerts = Alerts.getUnviewedLogAlerts();
                for (LogAlert a : alerts) {
                    Alerts.markAlertAsViewed(a);
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("status.rategraphs", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        boolean doRateGraphs = COConfigurationManager.getBooleanParameter("status.rategraphs");
                        if (doRateGraphs) {
                            GC gc;
                            if (MainStatusBar.this.imgRec == null || MainStatusBar.this.imgRec.isDisposed()) {
                                MainStatusBar.this.imgRec = new Image((Device)MainStatusBar.this.display, 100, 20);
                                gc = new GC((Drawable)MainStatusBar.this.imgRec);
                                gc.setBackground(MainStatusBar.this.statusDown.getBackground());
                                gc.fillRectangle(0, 0, 100, 20);
                                gc.dispose();
                                MainStatusBar.this.statusDown.setBackgroundImage(MainStatusBar.this.imgRec);
                            }
                            if (MainStatusBar.this.imgSent == null || MainStatusBar.this.imgSent.isDisposed()) {
                                MainStatusBar.this.imgSent = new Image((Device)MainStatusBar.this.display, 100, 20);
                                gc = new GC((Drawable)MainStatusBar.this.imgSent);
                                gc.setBackground(MainStatusBar.this.statusUp.getBackground());
                                gc.fillRectangle(0, 0, 100, 20);
                                gc.dispose();
                                MainStatusBar.this.statusUp.setBackgroundImage(MainStatusBar.this.imgSent);
                            }
                        } else {
                            MainStatusBar.this.statusUp.setBackgroundImage(null);
                            MainStatusBar.this.statusDown.setBackgroundImage(null);
                            Utils.disposeSWTObjects(new Object[]{MainStatusBar.this.imgRec, MainStatusBar.this.imgSent});
                            MainStatusBar.this.imgRec = (MainStatusBar.this.imgSent = null);
                        }
                    }
                });
            }
        });
        this.PRManager.addListener(new ProgressListener());
        this.uiFunctions.getUIUpdater().addUpdater(this);
        this.this_mon.enter();
        try {
            list = this.listRunAfterInit;
            this.listRunAfterInit = null;
            Object var21_21 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (Runnable runnable : list) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        this.statusBar.layout(true);
        return this.statusBar;
    }

    protected void updateStatusWarnings(final LogAlert current_alert, final boolean current_added) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MainStatusBar.this.statusWarnings == null || MainStatusBar.this.statusWarnings.isDisposed()) {
                    return;
                }
                ArrayList<LogAlert> alerts = Alerts.getUnviewedLogAlerts();
                int count = alerts.size();
                Image icon = MainStatusBar.this.infoIcon;
                for (LogAlert alert : alerts) {
                    int type = alert.getType();
                    if (type != 3 && type != 2) continue;
                    icon = MainStatusBar.this.warningIcon;
                    break;
                }
                if (MainStatusBar.this.statusWarnings.getImage() != icon) {
                    MainStatusBar.this.statusWarnings.setImage(icon);
                }
                MainStatusBar.this.statusWarnings.setVisible(count > 0);
                MainStatusBar.this.statusWarnings.setText("" + count);
                MainStatusBar.this.statusWarnings.layoutNow();
                if (current_added) {
                    MainStatusBar.this.alert_flash_activate = true;
                    if (current_alert.getType() != 1) {
                        MainStatusBar.this.alert_flasher_event_start_time = SystemTime.getMonotonousTime();
                        if (MainStatusBar.this.alert_flasher_event == null) {
                            MainStatusBar.this.alert_flasher_event = SimpleTimer.addPeriodicEvent("MSB:alertFlasher", 500L, new TimerEventPerformer(){
                                private long last_tick_time = -1L;

                                public void perform(TimerEvent event2) {
                                    Utils.execSWTThread(new AERunnable(){

                                        public void runSupport() {
                                            long now = SystemTime.getMonotonousTime();
                                            if (last_tick_time != -1L && now - last_tick_time < 400L) {
                                                return;
                                            }
                                            last_tick_time = now;
                                            if (MainStatusBar.this.statusWarnings == null || MainStatusBar.this.statusWarnings.isDisposed() || MainStatusBar.this.alert_flasher_event == null || !MainStatusBar.this.alert_flash_activate) {
                                                if (MainStatusBar.this.alert_flasher_event != null) {
                                                    MainStatusBar.this.alert_flasher_event.cancel();
                                                    MainStatusBar.this.alert_flasher_event = null;
                                                }
                                                return;
                                            }
                                            Image current_icon = MainStatusBar.this.statusWarnings.getImage();
                                            if (now > MainStatusBar.this.alert_flasher_event_start_time + 15000L && current_icon == MainStatusBar.this.warningIcon) {
                                                MainStatusBar.this.alert_flasher_event.cancel();
                                                MainStatusBar.this.alert_flasher_event = null;
                                                return;
                                            }
                                            Image target_icon = current_icon == MainStatusBar.this.warningIcon ? MainStatusBar.this.warningGreyIcon : MainStatusBar.this.warningIcon;
                                            MainStatusBar.this.statusWarnings.setImage(target_icon);
                                        }
                                    });
                                }
                            });
                        }
                    }
                } else {
                    MainStatusBar.this.alert_flash_activate = false;
                }
            }
        });
    }

    private void addFeedBack() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        MainStatusBar.this._addFeedBack();
                    }
                });
            }
        });
    }

    private void _addFeedBack() {
        OverallStats stats2 = StatsFactory.getStats();
        long secs_uptime = stats2.getTotalUpTime();
        long last_uptime = COConfigurationManager.getLongParameter("statusbar.feedback.uptime", 0L);
        if (last_uptime == 0L) {
            COConfigurationManager.setParameter("statusbar.feedback.uptime", secs_uptime);
        } else if (secs_uptime - last_uptime > 900L) {
            this.createStatusEntry(new IMainStatusBar.CLabelUpdater(){

                public boolean update(CLabelPadding label) {
                    return false;
                }

                public void created(CLabelPadding feedback) {
                    feedback.setText(MessageText.getString("statusbar.feedback"));
                    Listener feedback_listener = new Listener(){

                        public void handleEvent(Event e) {
                            String url = "feedback.start?" + Utils.getWidgetBGColorURLParam() + "&fromWeb=false&os.name=" + UrlUtils.encode(Constants.OSName) + "&os.version=" + UrlUtils.encode(System.getProperty("os.version")) + "&java.version=" + UrlUtils.encode(Constants.JAVA_VERSION);
                            UIFunctionsManagerSWT.getUIFunctionsSWT().viewURL(url, (String)null, 600, 520, true, false);
                        }
                    };
                    feedback.setToolTipText(MessageText.getString("statusbar.feedback.tooltip"));
                    feedback.setCursor(MainStatusBar.this.display.getSystemCursor(21));
                    feedback.setForeground(Colors.blue);
                    feedback.addListener(4, feedback_listener);
                    feedback.addListener(8, feedback_listener);
                    feedback.setVisible(true);
                }
            });
        }
    }

    private void addStatusBarMenu(Composite cSB) {
        if (!Constants.isCVSVersion()) {
            return;
        }
        Menu menu = new Menu((Control)cSB);
        cSB.setMenu(menu);
        MenuItem itemShow = new MenuItem(menu, 64);
        itemShow.setText("Show");
        Menu menuShow = new Menu(itemShow);
        itemShow.setMenu(menuShow);
        String[] statusAreaLangs = new String[]{"ConfigView.section.style.status.show_sr", "ConfigView.section.style.status.show_nat", "ConfigView.section.style.status.show_ddb", "ConfigView.section.style.status.show_ipf"};
        String[] statusAreaConfig = new String[]{"Status Area Show SR", "Status Area Show NAT", "Status Area Show DDB", "Status Area Show IPF"};
        for (int i = 0; i < statusAreaConfig.length; ++i) {
            final String configID = statusAreaConfig[i];
            String langID = statusAreaLangs[i];
            final MenuItem item = new MenuItem(menuShow, 32);
            Messages.setLanguageText((Widget)item, langID);
            item.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    COConfigurationManager.setParameter(configID, !COConfigurationManager.getBooleanParameter(configID));
                }
            });
            menuShow.addListener(22, new Listener(){

                public void handleEvent(Event event2) {
                    item.setSelection(COConfigurationManager.getBooleanParameter(configID));
                }
            });
        }
    }

    public void setStatusText(String keyedSentence) {
        this.statusTextKey = keyedSentence == null ? "" : keyedSentence;
        this.setStatusImageKey(null);
        this.clickListener = null;
        if (this.statusTextKey.length() == 0) {
            this.resetStatus();
        }
        this.updateStatusText();
    }

    private void setStatusImageKey(String newStatusImageKey) {
        if (("" + this.statusImageKey).equals("" + newStatusImageKey)) {
            return;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        if (this.statusImageKey != null) {
            imageLoader.releaseImage(this.statusImageKey);
        }
        this.statusImageKey = newStatusImageKey;
        this.statusImage = this.statusImageKey != null ? imageLoader.getImage(this.statusImageKey) : null;
    }

    private void resetStatus() {
        if (Constants.isCVSVersion()) {
            this.statusTextKey = "MainWindow.status.unofficialversion (5.5.0.1_B39)";
            this.setStatusImageKey(STATUS_ICON_WARN);
        } else if (!Constants.isOSX && COConfigurationManager.getStringParameter("ui").equals("az2")) {
            this.statusTextKey = Constants.APP_NAME + " " + "5.5.0.1_B39";
            this.setStatusImageKey(null);
        }
    }

    public void setStatusText(int statustype, String string, UIStatusTextClickListener l) {
        String string2 = this.statusTextKey = string == null ? "" : string;
        if (this.statusTextKey.length() == 0) {
            this.resetStatus();
        }
        this.clickListener = l;
        if (statustype == 1) {
            this.setStatusImageKey(STATUS_ICON_WARN);
        }
        if (statustype == 1) {
            this.setStatusImageKey(STATUS_ICON_WARN);
        } else {
            this.setStatusImageKey(null);
        }
        this.updateStatusText();
    }

    public void updateStatusText() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        final String text = this.updateWindow != null ? "MainWindow.updateavail" : this.statusTextKey;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MainStatusBar.this.statusText != null && !MainStatusBar.this.statusText.isDisposed()) {
                    MainStatusBar.this.statusText.setText(MessageText.getStringForSentence(text));
                    MainStatusBar.this.statusText.setImage(MainStatusBar.this.statusImage);
                }
            }
        });
    }

    public void refreshStatusText() {
        if (this.statusText != null && !this.statusText.isDisposed()) {
            this.statusText.update();
        }
    }

    public void setUpdateNeeded(UpdateWindow updateWindow) {
        this.updateWindow = updateWindow;
        if (updateWindow != null) {
            this.statusText.setCursor(this.display.getSystemCursor(21));
            this.statusText.setForeground(Colors.colorWarning);
            this.updateStatusText();
        } else {
            this.statusText.setCursor(null);
            this.statusText.setForeground(null);
            this.updateStatusText();
        }
    }

    public void updateUI() {
        this.updateUI(true);
    }

    public void updateUI(boolean is_visible) {
        boolean is_hidden;
        if (this.statusBar.isDisposed()) {
            this.uiFunctions.getUIUpdater().removeUpdater(this);
            return;
        }
        boolean bl = is_hidden = !is_visible || this.statusBar.getDisplay().getFocusControl() == null;
        if (is_hidden) {
            this.was_hidden = true;
        } else if (this.was_hidden) {
            this.statusBar.layout(true, true);
            this.was_hidden = false;
        }
        if (!is_visible) {
            return;
        }
        Control[] plugin_elements = this.plugin_label_composite.getChildren();
        for (int i = 0; i < plugin_elements.length; ++i) {
            if (!(plugin_elements[i] instanceof UpdateableCLabel)) continue;
            ((UpdateableCLabel)plugin_elements[i]).checkForRefresh();
        }
        if (this.ipBlocked.isVisible()) {
            this.updateIPBlocked();
        }
        if (this.srStatus.isVisible()) {
            this.updateShareRatioStatus();
        }
        if (this.natStatus.isVisible()) {
            this.updateNatStatus();
        }
        if (this.dhtStatus.isVisible()) {
            this.updateDHTStatus();
        }
        if (AzureusCoreFactory.isCoreRunning()) {
            String seeding_only;
            AzureusCore core = AzureusCoreFactory.getSingleton();
            GlobalManager gm = core.getGlobalManager();
            GlobalManagerStats stats2 = gm.getStats();
            int dl_limit = NetworkManager.getMaxDownloadRateBPS() / 1024;
            long rec_data = stats2.getDataReceiveRate();
            long rec_prot = stats2.getProtocolReceiveRate();
            if (this.last_dl_limit != dl_limit || this.last_rec_data != rec_data || this.last_rec_prot != rec_prot) {
                this.last_dl_limit = dl_limit;
                this.last_rec_data = rec_data;
                this.last_rec_prot = rec_prot;
                this.statusDown.setText((dl_limit == 0 ? "" : "[" + dl_limit + "K] ") + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(rec_data, rec_prot));
            }
            boolean auto_up = TransferSpeedValidator.isAutoSpeedActive(gm) && TransferSpeedValidator.isAutoUploadAvailable(core);
            int ul_limit_norm = NetworkManager.getMaxUploadRateBPSNormal() / 1024;
            if (NetworkManager.isSeedingOnlyUploadRate()) {
                int ul_limit_seed = NetworkManager.getMaxUploadRateBPSSeedingOnly() / 1024;
                if (ul_limit_seed == 0) {
                    seeding_only = "+\u221eK";
                } else {
                    int diff = ul_limit_seed - ul_limit_norm;
                    seeding_only = (diff >= 0 ? "+" : "") + diff + "K";
                }
            } else {
                seeding_only = "";
            }
            int sent_data = stats2.getDataSendRate();
            if (this.imgRec != null && !this.imgRec.isDisposed()) {
                this.updateGraph(this.statusDown, this.imgRec, rec_data, this.max_rec);
                this.updateGraph(this.statusUp, this.imgSent, sent_data, this.max_sent);
            }
            this.statusUp.setText((ul_limit_norm == 0 ? "" : "[" + ul_limit_norm + "K" + seeding_only + "]") + (auto_up ? "* " : " ") + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(sent_data, stats2.getProtocolSendRate()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGraph(CLabelPadding label, Image img, long newVal, long[] max) {
        GC gc = new GC((Drawable)img);
        try {
            long val = newVal;
            Rectangle bounds = img.getBounds();
            int padding = 2;
            int x = bounds.width - 2 - 2;
            if (val > max[0]) {
                int y = 20 - (int)(max[0] * 20L / val);
                gc.setBackground(label.getBackground());
                gc.fillRectangle(2, 0, x, y);
                gc.copyArea(3, 0, x, 20, 2, y);
                max[0] = val;
            } else {
                gc.copyArea(3, 0, x, 20, 2, 0);
            }
            gc.setForeground(label.getBackground());
            int breakPoint = 20 - (max[0] == 0L ? 0 : (int)(val * 20L / max[0]));
            gc.drawLine(x, 0, x, breakPoint);
            gc.setForeground(Colors.blues[5]);
            gc.drawLine(x, breakPoint, x, 20);
            Object var14_11 = null;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        label.redraw();
    }

    private void updateDHTStatus() {
        if (this.dhtPlugin == null) {
            return;
        }
        int dht_status = this.dhtPlugin.getStatus();
        long dht_count = -1L;
        if (dht_status == 3) {
            DHT[] dhts = this.dhtPlugin.getDHTs();
            dht_count = dhts[0].getControl().getStats().getEstimatedDHTSize();
        }
        if (this.lastDHTstatus != dht_status || this.lastDHTcount != dht_count) {
            boolean hasImage = this.dhtStatus.getImage() != null;
            boolean needImage = true;
            switch (dht_status) {
                case 3: {
                    this.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.tooltip"));
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.users").replaceAll("%1", this.numberFormat.format(dht_count)));
                    break;
                }
                case 1: {
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.disabled"));
                    break;
                }
                case 2: {
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.initializing"));
                    break;
                }
                case 4: {
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.failed"));
                    break;
                }
                default: {
                    needImage = false;
                }
            }
            if (hasImage != needImage) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                if (needImage) {
                    Image img = imageLoader.getImage("sb_count");
                    this.dhtStatus.setImage(img);
                } else {
                    imageLoader.releaseImage("sb_count");
                    this.dhtStatus.setImage(null);
                }
            }
            this.lastDHTstatus = dht_status;
            this.lastDHTcount = dht_count;
        }
    }

    private void updateNatStatus() {
        if (this.connection_manager == null) {
            return;
        }
        int nat_status = this.connection_manager.getNATStatus();
        if (this.lastNATstatus != nat_status) {
            String statusID;
            String tooltipID;
            String imgID;
            switch (nat_status) {
                case 0: {
                    imgID = "grayled";
                    tooltipID = "MainWindow.nat.status.tooltip.unknown";
                    statusID = "MainWindow.nat.status.unknown";
                    break;
                }
                case 1: {
                    imgID = "greenled";
                    tooltipID = "MainWindow.nat.status.tooltip.ok";
                    statusID = "MainWindow.nat.status.ok";
                    break;
                }
                case 2: {
                    imgID = "yellowled";
                    tooltipID = "MainWindow.nat.status.tooltip.probok";
                    statusID = "MainWindow.nat.status.probok";
                    break;
                }
                default: {
                    imgID = "redled";
                    tooltipID = "MainWindow.nat.status.tooltip.bad";
                    statusID = "MainWindow.nat.status.bad";
                }
            }
            if (!imgID.equals(this.lastNATimageID)) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                this.natStatus.setImage(imageLoader.getImage(imgID));
                if (this.lastNATimageID != null) {
                    imageLoader.releaseImage(this.lastNATimageID);
                }
                this.lastNATimageID = imgID;
            }
            this.natStatus.setToolTipText(MessageText.getString(tooltipID));
            this.natStatus.setText(MessageText.getString(statusID));
            this.lastNATstatus = nat_status;
        }
    }

    private void updateShareRatioStatus() {
        long ratio;
        int sr_status;
        if (this.overall_stats == null) {
            this.overall_stats = StatsFactory.getStats();
            if (this.overall_stats == null) {
                return;
            }
        }
        if ((sr_status = (ratio = 1000L * this.overall_stats.getUploadedBytes() / (this.overall_stats.getDownloadedBytes() + 1L)) < 500L ? 0 : (ratio < 900L ? 1 : 2)) != this.last_sr_status) {
            String imgID;
            switch (sr_status) {
                case 2: {
                    imgID = "greenled";
                    break;
                }
                case 1: {
                    imgID = "yellowled";
                    break;
                }
                default: {
                    imgID = "redled";
                }
            }
            if (!imgID.equals(this.lastSRimageID)) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                this.srStatus.setImage(imageLoader.getImage(imgID));
                if (this.lastSRimageID != null) {
                    imageLoader.releaseImage(this.lastSRimageID);
                }
                this.lastSRimageID = imgID;
            }
            this.last_sr_status = sr_status;
        }
        if (ratio != this.last_sr_ratio) {
            String tooltipID;
            switch (sr_status) {
                case 2: {
                    tooltipID = "MainWindow.sr.status.tooltip.ok";
                    break;
                }
                case 1: {
                    tooltipID = "MainWindow.sr.status.tooltip.poor";
                    break;
                }
                default: {
                    tooltipID = "MainWindow.sr.status.tooltip.bad";
                }
            }
            String ratio_str = "";
            String partial = "" + ratio % 1000L;
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            ratio_str = ratio / 1000L + "." + partial;
            this.srStatus.setToolTipText(MessageText.getString(tooltipID, new String[]{ratio_str}));
            this.last_sr_ratio = ratio;
        }
    }

    private void updateIPBlocked() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return;
        }
        AzureusCore azureusCore = AzureusCoreFactory.getSingleton();
        IpFilter ip_filter = azureusCore.getIpFilterManager().getIPFilter();
        this.ipBlocked.setForeground(this.display.getSystemColor(ip_filter.isEnabled() ? 21 : 18));
        this.ipBlocked.setText("IPs: " + this.numberFormat.format(ip_filter.getNbRanges()) + " - " + this.numberFormat.format(ip_filter.getNbIpsBlockedAndLoggable()) + "/" + this.numberFormat.format(ip_filter.getNbBannedIps()) + "/" + this.numberFormat.format(azureusCore.getIpFilterManager().getBadIps().getNbBadIps()));
        this.ipBlocked.setToolTipText(MessageText.getString("MainWindow.IPs.tooltip", new String[]{ip_filter.isEnabled() ? DisplayFormatters.formatDateShort(ip_filter.getLastUpdateTime()) : MessageText.getString("ipfilter.disabled")}));
    }

    public void setDebugInfo(String string) {
        if (this.statusText != null && !this.statusText.isDisposed()) {
            this.statusText.setToolTipText(string);
        }
    }

    public boolean isMouseOver() {
        if (this.statusText == null || this.statusText.isDisposed()) {
            return false;
        }
        return this.statusText.getDisplay().getCursorControl() == this.statusText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStatusEntry(final IMainStatusBar.CLabelUpdater updater) {
        AERunnable r = new AERunnable(){

            public void runSupport() {
                UpdateableCLabel result = new UpdateableCLabel(MainStatusBar.this.plugin_label_composite, 32, updater);
                result.setLayoutData(new GridData(1808));
                MainStatusBar.this.layoutPluginComposite();
                updater.created(result);
            }
        };
        this.this_mon.enter();
        try {
            if (this.listRunAfterInit != null) {
                this.listRunAfterInit.add(r);
                Object var4_3 = null;
                this.this_mon.exit();
                return;
            }
            Object var4_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Utils.execSWTThread(r);
    }

    private void layoutPluginComposite() {
        Control[] plugin_elements = this.plugin_label_composite.getChildren();
        for (int i = 0; i < plugin_elements.length; ++i) {
            if (!(plugin_elements[i] instanceof UpdateableCLabel)) continue;
            ((UpdateableCLabel)plugin_elements[i]).reset();
        }
        this.statusBar.layout();
    }

    private void showProgressBar(boolean state) {
        if (state && !this.progressBar.isVisible()) {
            this.progressGridData.widthHint = 100;
            this.progressBar.setVisible(true);
            this.statusBar.layout();
        } else if (!state && this.progressBar.isVisible()) {
            this.progressBar.setVisible(false);
            this.progressGridData.widthHint = 0;
            this.statusBar.layout();
        }
    }

    public Rectangle getBounds() {
        if (null != this.statusBar) {
            return this.statusBar.getBounds();
        }
        return null;
    }

    public String getUpdateUIName() {
        return ID;
    }

    public class CLabelPadding
    extends Canvas
    implements PaintListener {
        private int lastWidth;
        private long widthSetOn;
        private static final int KEEPWIDTHFOR_MS = 30000;
        String text;
        String tooltip_text;
        private boolean hovering;
        private Image image;
        private Image bgImage;

        public CLabelPadding(Composite parent, int style) {
            super(parent, style | 0x20000000);
            this.lastWidth = 0;
            this.widthSetOn = 0L;
            this.text = "";
            GridData gridData = new GridData(80);
            this.setLayoutData(gridData);
            this.setForeground(parent.getForeground());
            this.addPaintListener(this);
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    CLabelPadding.super.setToolTipText(CLabelPadding.this.tooltip_text);
                    CLabelPadding.this.hovering = true;
                }

                public void mouseExit(MouseEvent e) {
                    CLabelPadding.this.hovering = false;
                }
            });
        }

        public void setToolTipText(String str) {
            if (str == this.tooltip_text) {
                return;
            }
            if (str != null && this.tooltip_text != null && str.equals(this.tooltip_text)) {
                return;
            }
            this.tooltip_text = str;
            if (this.hovering) {
                super.setToolTipText(str);
            }
        }

        public String getToolTipText() {
            return this.tooltip_text;
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.setAdvanced(true);
            if (this.bgImage != null && !this.bgImage.isDisposed()) {
                Rectangle bounds = this.bgImage.getBounds();
                if (MainStatusBar.this.display.getCursorControl() != this) {
                    e.gc.setAlpha(100);
                }
                e.gc.drawImage(this.bgImage, 0, 0, bounds.width, bounds.height, 0, 2, size.x, size.y - 4);
                e.gc.setAlpha(255);
            }
            Rectangle clientArea = this.getClientArea();
            Image image = this.getImage();
            Rectangle imageBounds = null;
            if (image != null && !image.isDisposed()) {
                imageBounds = image.getBounds();
            }
            GCStringPrinter sp = new GCStringPrinter(e.gc, this.getText(), clientArea, true, true, 0x1000000);
            sp.calculateMetrics();
            Point textSize = sp.getCalculatedSize();
            if (imageBounds != null) {
                int pad = 2;
                int ofs = imageBounds.width + imageBounds.x;
                int xStartImage = (clientArea.width - textSize.x - ofs - pad) / 2;
                e.gc.drawImage(image, xStartImage, clientArea.height / 2 - imageBounds.height / 2);
                clientArea.x += xStartImage + ofs + pad;
                clientArea.width -= xStartImage + ofs + pad;
            } else {
                int ofs = clientArea.width / 2 - textSize.x / 2;
                clientArea.x += ofs;
                clientArea.width -= ofs;
            }
            sp.printString(e.gc, clientArea, 16384);
            int x = clientArea.x + clientArea.width - 1;
            e.gc.setAlpha(20);
            e.gc.drawLine(x, 3, x, clientArea.height - 3);
        }

        public Point computeSize(int wHint, int hHint) {
            return this.computeSize(wHint, hHint, true);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            try {
                Point pt = this.computeSize(wHint, hHint, changed, false);
                return pt;
            }
            catch (Throwable t) {
                Debug.out("Error while computing size for CLabel with text:" + this.getText() + "; " + t.toString());
                return new Point(0, 0);
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed, boolean realWidth) {
            if (!this.isVisible()) {
                return new Point(0, 0);
            }
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point pt = new Point(wHint, hHint);
            Point lastSize = new Point(0, 0);
            Image image = this.getImage();
            if (image != null && !image.isDisposed()) {
                Rectangle bounds = image.getBounds();
                int ofs = bounds.width + bounds.x + 5;
                lastSize.x += ofs;
                lastSize.y = bounds.height;
            }
            GC gc = new GC((Drawable)this);
            GCStringPrinter sp = new GCStringPrinter(gc, this.getText(), new Rectangle(0, 0, 10000, 20), true, true, 16384);
            sp.calculateMetrics();
            Point lastTextSize = sp.getCalculatedSize();
            gc.dispose();
            lastSize.x += lastTextSize.x + 10;
            lastSize.y = Math.max(lastSize.y, lastTextSize.y);
            if (wHint == -1) {
                pt.x = lastSize.x;
            }
            if (hHint == -1) {
                pt.y = lastSize.y;
            }
            if (!realWidth) {
                long now = System.currentTimeMillis();
                if (this.lastWidth > pt.x && now - this.widthSetOn < 30000L) {
                    pt.x = this.lastWidth;
                } else {
                    if (this.lastWidth != pt.x) {
                        this.lastWidth = pt.x;
                    }
                    this.widthSetOn = now;
                }
            }
            return pt;
        }

        public void setImage(Image image) {
            this.image = image;
            this.redraw();
        }

        public Image getImage() {
            return this.image;
        }

        public void setBackgroundImage(Image image) {
            this.bgImage = image;
            this.redraw();
        }

        public Image getBackgroundImage() {
            return this.bgImage;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            if (text == null) {
                text = "";
            }
            if (text.equals(this.getText())) {
                return;
            }
            this.text = text;
            int oldWidth = this.lastWidth;
            Point pt = this.computeSize(-1, -1, true, true);
            if (pt.x > oldWidth && text.length() > 0) {
                MainStatusBar.this.statusBar.layout();
            } else if (pt.x < oldWidth) {
                Utils.execSWTThreadLater(30000, new AERunnable(){

                    public void runSupport() {
                        if (MainStatusBar.this.statusBar == null || MainStatusBar.this.statusBar.isDisposed()) {
                            return;
                        }
                        MainStatusBar.this.statusBar.layout();
                    }
                });
            }
            this.redraw();
        }

        public void reset() {
            this.widthSetOn = 0L;
            this.lastWidth = 0;
        }

        public void layoutNow() {
            this.widthSetOn = 0L;
            MainStatusBar.this.statusBar.layout();
        }
    }

    private class ProgressListener
    implements IProgressReportingListener {
        private String lastProgressImageID = null;
        private Set<IProgressReporter> pending_updates = new HashSet<IProgressReporter>();

        private ProgressListener() {
            Utils.execSWTThread(new Runnable(){

                public void run() {
                    ProgressListener.this.swt_setProgressImage();
                }
            });
        }

        private void swt_updateProgressBarDisplay(IProgressReport pReport) {
            if (null == MainStatusBar.this.progressBar || MainStatusBar.this.progressBar.isDisposed()) {
                return;
            }
            if (null != pReport) {
                MainStatusBar.this.progressBar.setMinimum(pReport.getMinimum());
                MainStatusBar.this.progressBar.setMaximum(pReport.getMaximum());
                MainStatusBar.this.progressBar.setIndeterminate(pReport.isIndeterminate());
                MainStatusBar.this.progressBar.setPercentage(pReport.getPercentage());
                MainStatusBar.this.showProgressBar(true);
                if (MainStatusBar.this.isAZ3) {
                    MainStatusBar.this.statusText.setText(pReport.getName());
                } else {
                    MainStatusBar.this.setStatusText(pReport.getName());
                }
            } else {
                MainStatusBar.this.showProgressBar(false);
                if (MainStatusBar.this.isAZ3) {
                    MainStatusBar.this.statusText.setText("");
                } else {
                    MainStatusBar.this.setStatusText(null);
                }
            }
        }

        private void swt_setProgressImage() {
            if (MainStatusBar.this.progressViewerImageLabel.isDisposed()) {
                return;
            }
            String imageID = MainStatusBar.this.PRManager.getReporterCount(2) > 0 ? "progress_error" : (MainStatusBar.this.PRManager.getReporterCount(0) > 0 ? "progress_info" : "progress_viewer");
            if (!imageID.equals(this.lastProgressImageID)) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                MainStatusBar.this.progressViewerImageLabel.setImage(imageLoader.getImage(imageID));
                if (this.lastProgressImageID != null) {
                    imageLoader.releaseImage(this.lastProgressImageID);
                }
                this.lastProgressImageID = imageID;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int reporting(final int eventType, final IProgressReporter reporter) {
            if (eventType == 3) {
                Set<IProgressReporter> set = this.pending_updates;
                synchronized (set) {
                    if (this.pending_updates.contains(reporter)) {
                        return 0;
                    }
                    this.pending_updates.add(reporter);
                }
            }
            Utils.execSWTThread(new Runnable(){

                public void run() {
                    ProgressListener.this.swt_reporting(eventType, reporter);
                }
            });
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int swt_reporting(int eventType, IProgressReporter reporter) {
            Set<IProgressReporter> set = this.pending_updates;
            synchronized (set) {
                this.pending_updates.remove(reporter);
            }
            this.swt_setProgressImage();
            if (null == reporter) {
                return 0;
            }
            if (2 == eventType) {
                this.swt_updateFromPrevious();
            } else if (1 == eventType || 3 == eventType) {
                IProgressReport pReport = reporter.getProgressReport();
                if (pReport.isInErrorState()) {
                    if ("reporterType_updater".equals(pReport.getReporterType())) {
                        return 0;
                    }
                    IProgressReporter final_reporter = reporter;
                    if (!ProgressReporterWindow.isOpened(final_reporter) && !ProgressReporterWindow.isOpened(final_reporter)) {
                        ProgressReporterWindow.open(final_reporter, 0);
                    }
                }
                if (!pReport.isActive()) {
                    this.swt_updateFromPrevious();
                } else {
                    this.swt_update(pReport);
                }
            }
            return 0;
        }

        private void swt_update(IProgressReport pReport) {
            if (null == pReport) {
                this.swt_updateProgressBarDisplay(null);
                return;
            }
            if (MainStatusBar.this.PRManager.hasMultipleActive()) {
                MainStatusBar.this.setStatusText(pReport.getName());
                MainStatusBar.this.progressBar.setIndeterminate(true);
                MainStatusBar.this.showProgressBar(true);
            } else {
                this.swt_updateProgressBarDisplay(pReport);
            }
        }

        private void swt_updateFromPrevious() {
            IProgressReporter previousReporter = MainStatusBar.this.PRManager.getNextActiveReporter();
            if (null != previousReporter) {
                this.swt_update(previousReporter.getProgressReport());
            } else {
                this.swt_update(null);
            }
        }
    }

    private class UpdateableCLabel
    extends CLabelPadding {
        private IMainStatusBar.CLabelUpdater updater;

        public UpdateableCLabel(Composite parent, int style, IMainStatusBar.CLabelUpdater updater) {
            super(parent, style);
            this.updater = updater;
        }

        private void checkForRefresh() {
            if (this.updater.update(this)) {
                MainStatusBar.this.layoutPluginComposite();
            }
        }
    }
}

