/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewSWT_TabsCommon {
    private static final Object NULL_DS = new Object();
    UISWTView parentView;
    TableViewSWT<?> tv;
    private ArrayList<UISWTViewCore> tabViews = new ArrayList(1);
    private ArrayList<UISWTInstance.UISWTViewEventListenerWrapper> removedViews = new ArrayList();
    private CTabFolder tabFolder;
    public Composite tableComposite;
    private boolean minimized;
    private UISWTViewCore selectedView;
    private DownloadManager maximizeTo;
    private UISWTViewCore focused_view = null;

    public TableViewSWT_TabsCommon(UISWTView parentView, TableViewSWT<?> tv) {
        this.parentView = parentView;
        this.tv = tv;
    }

    public void triggerTabViewsDataSourceChanged(boolean sendParent) {
        if (this.tabViews == null || this.tabViews.size() == 0) {
            return;
        }
        if (sendParent) {
            for (int i = 0; i < this.tabViews.size(); ++i) {
                UISWTViewCore view = this.tabViews.get(i);
                if (view == null) continue;
                this.dataSourceChanged(view, this.tv.getParentDataSource());
            }
            return;
        }
        Object[] dataSourcesCore = this.tv.getSelectedDataSources(true);
        Object[] dataSourcesPlugin = null;
        for (int i = 0; i < this.tabViews.size(); ++i) {
            UISWTViewCore view = this.tabViews.get(i);
            if (view == null) continue;
            if (view.useCoreDataSource()) {
                this.dataSourceChanged(view, dataSourcesCore.length == 0 ? this.tv.getParentDataSource() : dataSourcesCore);
                continue;
            }
            if (dataSourcesPlugin == null) {
                dataSourcesPlugin = this.tv.getSelectedDataSources(false);
            }
            this.dataSourceChanged(view, dataSourcesPlugin.length == 0 ? PluginCoreUtils.convert(this.tv.getParentDataSource(), false) : dataSourcesPlugin);
        }
    }

    public void triggerTabViewsDataSourceChanged(TableViewSWT<?> tv) {
        if (this.tabViews == null || this.tabViews.size() == 0) {
            return;
        }
        Object[] dataSourcesCore = tv.getSelectedDataSources(true);
        Object[] dataSourcesPlugin = null;
        for (int i = 0; i < this.tabViews.size(); ++i) {
            UISWTViewCore view = this.tabViews.get(i);
            if (view == null) continue;
            if (view.useCoreDataSource()) {
                this.dataSourceChanged(view, dataSourcesCore.length == 0 ? tv.getParentDataSource() : dataSourcesCore);
                continue;
            }
            if (dataSourcesPlugin == null) {
                dataSourcesPlugin = tv.getSelectedDataSources(false);
            }
            this.dataSourceChanged(view, dataSourcesPlugin.length == 0 ? PluginCoreUtils.convert(tv.getParentDataSource(), false) : dataSourcesPlugin);
        }
    }

    public void triggerTabViewDataSourceChanged(UISWTViewCore view) {
        if (view != null) {
            this.dataSourceChanged(view, this.tv.getParentDataSource());
            if (view.useCoreDataSource()) {
                Object[] dataSourcesCore = this.tv.getSelectedDataSources(true);
                if (dataSourcesCore.length > 0) {
                    this.dataSourceChanged(view, dataSourcesCore.length == 0 ? this.tv.getParentDataSource() : dataSourcesCore);
                }
            } else {
                Object[] dataSourcesPlugin = this.tv.getSelectedDataSources(false);
                if (dataSourcesPlugin.length > 0) {
                    this.dataSourceChanged(view, dataSourcesPlugin.length == 0 ? PluginCoreUtils.convert(this.tv.getParentDataSource(), false) : dataSourcesPlugin);
                }
            }
        }
    }

    public void delete() {
        if (this.tabViews != null && this.tabViews.size() > 0) {
            for (int i = 0; i < this.tabViews.size(); ++i) {
                UISWTViewCore view = this.tabViews.get(i);
                if (view == null) continue;
                view.triggerEvent(7, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("# of SubViews: " + this.tabViews.size());
        writer.indent();
        try {
            for (UISWTViewCore view : this.tabViews) {
                writer.println(view.getTitleID() + ": " + view.getFullTitle());
            }
            Object var5_4 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            writer.exdent();
            throw throwable;
        }
    }

    public void localeChanged() {
        if (this.tabViews != null && this.tabViews.size() > 0) {
            for (int i = 0; i < this.tabViews.size(); ++i) {
                UISWTViewCore view = this.tabViews.get(i);
                if (view == null) continue;
                view.triggerEvent(6, null);
            }
        }
    }

    public UISWTViewCore getActiveSubView() {
        if (!this.tv.isTabViewsEnabled() || this.tabFolder == null || this.tabFolder.isDisposed() || this.minimized) {
            return null;
        }
        return this.selectedView;
    }

    private void dataSourceChanged(final UISWTViewCore view, final Object ds) {
        Composite comp2 = view.getComposite();
        if (comp2 == null || comp2.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new Runnable(){

            public void run() {
                Object[] temp;
                Composite comp2 = view.getComposite();
                if (comp2 == null || comp2.isDisposed()) {
                    return;
                }
                if (ds instanceof Object[] && (temp = (Object[])ds).length == 1) {
                    Object obj = temp[0];
                    if (obj instanceof DownloadManager) {
                        TableViewSWT_TabsCommon.this.maximizeTo = (DownloadManager)obj;
                    } else if (obj instanceof Download) {
                        TableViewSWT_TabsCommon.this.maximizeTo = PluginCoreUtils.unwrap((Download)obj);
                    }
                }
                TableViewSWT_TabsCommon.this.tabFolder.setMaximizeVisible(TableViewSWT_TabsCommon.this.maximizeTo != null);
                if (comp2.isVisible()) {
                    Object old_ds = view.getUserData(TableViewSWT_TabsCommon.class);
                    if (old_ds != null) {
                        view.setUserData(TableViewSWT_TabsCommon.class, null);
                    }
                    view.triggerEvent(1, ds);
                } else {
                    view.setUserData(TableViewSWT_TabsCommon.class, ds == null ? NULL_DS : ds);
                }
            }
        });
    }

    private void checkPendingDataSourceChange(UISWTViewCore view) {
        Object ds = view.getUserData(TableViewSWT_TabsCommon.class);
        if (ds != null) {
            if (ds == NULL_DS) {
                ds = null;
            }
            view.setUserData(TableViewSWT_TabsCommon.class, null);
            view.triggerEvent(1, ds);
        }
    }

    public void refreshSelectedSubView() {
        UISWTViewCore view = this.getActiveSubView();
        if (view != null && view.getComposite().isVisible()) {
            this.checkPendingDataSourceChange(view);
            view.triggerEvent(5, null);
        }
    }

    private String getViewTitleID(String view_id) {
        String history_key = "swt.ui.table.tab.view.namecache." + view_id;
        String id = COConfigurationManager.getStringParameter(history_key, "");
        if (id.length() == 0) {
            String test = view_id + ".title.full";
            if (MessageText.keyExists(test)) {
                return test;
            }
            id = "!" + view_id + "!";
        }
        return id;
    }

    private void addTabView(UISWTInstance.UISWTViewEventListenerWrapper listener, boolean start_of_day, boolean start_minimized) {
        if (this.tabFolder == null) {
            return;
        }
        String view_id = listener.getViewID();
        try {
            UISWTInstance ui_swt;
            UIFunctionsSWT ui_func;
            UISWTViewImpl view = new UISWTViewImpl(this.tv.getTableID(), view_id, listener, null);
            if (this.parentView != null) {
                view.setParentView(this.parentView);
            }
            this.triggerTabViewDataSourceChanged(view);
            int insert_at = this.tabFolder.getItemCount();
            if (!start_of_day && insert_at > 0 && (ui_func = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null && (ui_swt = ui_func.getUISWTInstance()) != null) {
                ArrayList<UISWTInstance.UISWTViewEventListenerWrapper> listeners = new ArrayList<UISWTInstance.UISWTViewEventListenerWrapper>(Arrays.asList(ui_swt.getViewListeners(this.tv.getTableID())));
                int l_index = listeners.indexOf(listener);
                CTabItem[] items = this.tabFolder.getItems();
                for (int j = 0; j < items.length; ++j) {
                    int v_index;
                    UISWTViewImpl v = (UISWTViewImpl)items[j].getData("IView");
                    if (v == null || (v_index = listeners.indexOf(v.getEventListener())) <= l_index) continue;
                    insert_at = j;
                    break;
                }
            }
            CTabItem item = new CTabItem(this.tabFolder, 0, insert_at);
            boolean is_minimized = start_of_day ? start_minimized : this.tabFolder.getMinimized();
            item.setToolTipText(MessageText.getString(is_minimized ? "label.click.to.restore" : "label.dblclick.to.min"));
            item.setData("IView", (Object)view);
            String title_id = view.getTitleID();
            String history_key = "swt.ui.table.tab.view.namecache." + view_id;
            String existing = COConfigurationManager.getStringParameter(history_key, "");
            if (!existing.equals(title_id)) {
                COConfigurationManager.setParameter(history_key, title_id);
            }
            Messages.setLanguageText((Widget)item, title_id);
            view.initialize((Composite)this.tabFolder);
            item.setControl((Control)view.getComposite());
            this.tabViews.add(view);
            if (!start_of_day) {
                this.removedViews.remove(listener);
                this.tabFolder.setSelection(item);
                this.selectedView = (UISWTViewImpl)item.getData("IView");
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private void checkTabViews(Map closed) {
        for (UISWTInstance.UISWTViewEventListenerWrapper l : new ArrayList<UISWTInstance.UISWTViewEventListenerWrapper>(this.removedViews)) {
            String view_id = l.getViewID();
            if (closed.containsKey(view_id)) continue;
            this.addTabView(l, false, false);
        }
        for (CTabItem item : this.tabFolder.getItems()) {
            String view_id;
            UISWTViewImpl view = (UISWTViewImpl)item.getData("IView");
            if (view == null || !closed.containsKey(view_id = view.getViewID())) continue;
            this.removeTabView(item);
        }
    }

    private void removeTabView(CTabItem item) {
        UISWTViewImpl view = (UISWTViewImpl)item.getData("IView");
        if (view != null) {
            this.removedViews.add((UISWTInstance.UISWTViewEventListenerWrapper)view.getEventListener());
            this.tabViews.remove(view);
            view.triggerEvent(7, null);
            item.dispose();
        }
    }

    public Composite createSashForm(Composite composite) {
        double pct;
        Composite cFixLayout;
        UISWTInstance pluginUI;
        if (!this.tv.isTabViewsEnabled()) {
            this.tableComposite = this.tv.createMainPanel(composite);
            return this.tableComposite;
        }
        ConfigurationManager configMan = ConfigurationManager.getInstance();
        int iNumViews = 0;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        UISWTInstance.UISWTViewEventListenerWrapper[] pluginViews = null;
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null) {
            pluginViews = pluginUI.getViewListeners(this.tv.getTableID());
            iNumViews += pluginViews.length;
        }
        if (iNumViews == 0) {
            this.tableComposite = this.tv.createMainPanel(composite);
            return this.tableComposite;
        }
        final String props_prefix = this.tv.getTableID() + "." + this.tv.getPropertiesPrefix();
        final Composite form = new Composite(composite, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        form.setLayout((Layout)flayout);
        GridData gridData = new GridData(1808);
        form.setLayoutData((Object)gridData);
        int TABHEIGHT = 22;
        this.tabFolder = new CTabFolder(form, 2176);
        this.tabFolder.setMinimizeVisible(true);
        this.tabFolder.setTabHeight(22);
        final int iFolderHeightAdj = this.tabFolder.computeSize((int)-1, (int)0).y;
        int SASH_WIDTH = 5;
        final Sash sash = Utils.createSash(form, 5);
        for (cFixLayout = this.tableComposite = this.tv.createMainPanel(form); cFixLayout != null && cFixLayout.getParent() != form; cFixLayout = cFixLayout.getParent()) {
        }
        if (cFixLayout == null) {
            cFixLayout = this.tableComposite;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cFixLayout.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        int iSplitAt = configMan.getIntParameter(props_prefix + ".SplitAt", 3000);
        if (iSplitAt < 100) {
            iSplitAt *= 100;
        }
        if ((pct = (double)iSplitAt / 10000.0) < 0.03) {
            pct = 0.03;
        } else if (pct > 0.97) {
            pct = 0.97;
        }
        sash.setData("PCT", (Object)new Double(pct));
        this.tabFolder.setLayoutData((Object)formData);
        final FormData tabFolderData = formData;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)this.tabFolder);
        formData.height = 5;
        sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)sash);
        cFixLayout.setLayoutData((Object)formData);
        final CTabFolder2Adapter folderListener = new CTabFolder2Adapter(){

            public void minimize(CTabFolderEvent event2) {
                TableViewSWT_TabsCommon.this.minimized = true;
                TableViewSWT_TabsCommon.this.tabFolder.setMinimized(true);
                tabFolderData.height = iFolderHeightAdj;
                CTabItem[] items = TableViewSWT_TabsCommon.this.tabFolder.getItems();
                String tt = MessageText.getString("label.click.to.restore");
                for (int i = 0; i < items.length; ++i) {
                    CTabItem tabItem = items[i];
                    tabItem.setToolTipText(tt);
                    tabItem.getControl().setVisible(false);
                }
                form.layout();
                UISWTViewCore view = TableViewSWT_TabsCommon.this.getActiveSubView();
                TableViewSWT_TabsCommon.this.fireFocusLost(view);
                ConfigurationManager configMan = ConfigurationManager.getInstance();
                configMan.setParameter(props_prefix + ".subViews.minimized", true);
            }

            public void maximize(CTabFolderEvent event2) {
                UIFunctions uiFunctions;
                if (TableViewSWT_TabsCommon.this.maximizeTo != null && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    uiFunctions.openView(5, TableViewSWT_TabsCommon.this.maximizeTo);
                }
            }

            public void restore(CTabFolderEvent event_maybe_null) {
                TableViewSWT_TabsCommon.this.minimized = false;
                TableViewSWT_TabsCommon.this.tabFolder.setMinimized(false);
                CTabItem selection = TableViewSWT_TabsCommon.this.tabFolder.getSelection();
                if (selection != null) {
                    selection.getControl().setVisible(true);
                }
                CTabItem[] items = TableViewSWT_TabsCommon.this.tabFolder.getItems();
                String tt = MessageText.getString("label.dblclick.to.min");
                for (int i = 0; i < items.length; ++i) {
                    CTabItem tabItem = items[i];
                    tabItem.setToolTipText(tt);
                }
                form.notifyListeners(11, null);
                UISWTViewCore view = TableViewSWT_TabsCommon.this.getActiveSubView();
                if (view != null) {
                    TableViewSWT_TabsCommon.this.fireFocusGained(view);
                }
                TableViewSWT_TabsCommon.this.refreshSelectedSubView();
                ConfigurationManager configMan = ConfigurationManager.getInstance();
                configMan.setParameter(props_prefix + ".subViews.minimized", false);
                TableViewSWT_TabsCommon.this.tabFolder.setToolTipText("max");
            }
        };
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                if (TableViewSWT_TabsCommon.this.tabFolder.getMinimized()) {
                    folderListener.restore(null);
                }
                Rectangle area = form.getClientArea();
                int height = area.height - e.y - e.height - iFolderHeightAdj;
                if (!Constants.isWindows) {
                    height -= 5;
                }
                if (area.height - height < 100) {
                    height = area.height - 100;
                }
                if (height < 0) {
                    height = 0;
                }
                tabFolderData.height = height;
                form.layout();
                Double l = new Double((double)((TableViewSWT_TabsCommon)TableViewSWT_TabsCommon.this).tabFolder.getBounds().height / (double)form.getBounds().height);
                sash.setData("PCT", (Object)l);
                if (e.detail != 1) {
                    ConfigurationManager configMan = ConfigurationManager.getInstance();
                    configMan.setParameter(props_prefix + ".SplitAt", (int)(l * 10000.0));
                }
            }
        });
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)folderListener);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableViewSWT_TabsCommon.this.selectedView = null;
                try {
                    ((CTabItem)e.item).getControl().setVisible(true);
                    ((CTabItem)e.item).getControl().moveAbove(null);
                    TableViewSWT_TabsCommon.this.selectedView = (UISWTViewImpl)e.item.getData("IView");
                    UISWTViewCore view = TableViewSWT_TabsCommon.this.getActiveSubView();
                    if (view != null) {
                        TableViewSWT_TabsCommon.this.fireFocusGained(view);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TableViewSWT_TabsCommon.this.tabFolder.getMinimized()) {
                    folderListener.restore(null);
                    e.button = 0;
                    TableViewSWT_TabsCommon.this.tabFolder.notifyListeners(7, null);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (!TableViewSWT_TabsCommon.this.tabFolder.getMinimized()) {
                    folderListener.minimize(null);
                }
            }
        });
        final Menu menu = new Menu((Control)this.tabFolder);
        this.tabFolder.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                for (MenuItem item : menu.getItems()) {
                    item.dispose();
                }
                CTabItem item = TableViewSWT_TabsCommon.this.tabFolder.getItem(TableViewSWT_TabsCommon.this.tabFolder.toControl(event2.x, event2.y));
                boolean need_sep = false;
                if (item != null) {
                    TableViewSWT_TabsCommon.this.tabFolder.setSelection(item);
                    TableViewSWT_TabsCommon.this.selectedView = (UISWTViewImpl)item.getData("IView");
                    if (TableViewSWT_TabsCommon.this.selectedView != null) {
                        final String view_id = TableViewSWT_TabsCommon.this.selectedView.getViewID();
                        MenuItem mi = new MenuItem(menu, 8);
                        mi.setText(MessageText.getString("label.close.tab"));
                        mi.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                String key = props_prefix + ".closedtabs";
                                Map closedtabs = COConfigurationManager.getMapParameter(key, new HashMap());
                                if (!closedtabs.containsKey(view_id)) {
                                    closedtabs.put(view_id, "");
                                    COConfigurationManager.setParameter(key, closedtabs);
                                }
                            }
                        });
                        need_sep = true;
                    }
                } else {
                    for (UISWTInstance.UISWTViewEventListenerWrapper l : TableViewSWT_TabsCommon.this.removedViews) {
                        need_sep = true;
                        final String view_id = l.getViewID();
                        MenuItem mi = new MenuItem(menu, 8);
                        mi.setText(MessageText.getString(TableViewSWT_TabsCommon.this.getViewTitleID(view_id)));
                        mi.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                String key = props_prefix + ".closedtabs";
                                Map closedtabs = COConfigurationManager.getMapParameter(key, new HashMap());
                                if (closedtabs.containsKey(view_id)) {
                                    closedtabs.remove(view_id);
                                    COConfigurationManager.setParameter(key, closedtabs);
                                }
                            }
                        });
                    }
                }
                if (need_sep) {
                    new MenuItem(menu, 2);
                }
                final MenuItem mi = new MenuItem(menu, 32);
                mi.setSelection(COConfigurationManager.getBooleanParameter("Library.ShowTabsInTorrentView"));
                mi.setText(MessageText.getString("ConfigView.section.style.ShowTabsInTorrentView"));
                mi.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        COConfigurationManager.setParameter("Library.ShowTabsInTorrentView", mi.getSelection());
                    }
                });
                menu.setVisible(true);
            }
        });
        form.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (TableViewSWT_TabsCommon.this.tabFolder.getMinimized()) {
                    return;
                }
                Double l = (Double)sash.getData("PCT");
                if (l != null) {
                    tabFolderData.height = (int)((double)form.getBounds().height * l) - iFolderHeightAdj;
                    form.layout();
                }
            }
        });
        String key = props_prefix + ".closedtabs";
        Map closed_tabs = COConfigurationManager.getMapParameter(key, new HashMap());
        COConfigurationManager.addParameterListener(key, new ParameterListener(){

            public void parameterChanged(String name) {
                if (TableViewSWT_TabsCommon.this.tabFolder.isDisposed()) {
                    COConfigurationManager.removeParameterListener(name, this);
                } else {
                    TableViewSWT_TabsCommon.this.checkTabViews(COConfigurationManager.getMapParameter(name, new HashMap()));
                }
            }
        });
        String[] restricted_to = this.tv.getTabViewsRestrictedTo();
        HashSet<String> rt_set = new HashSet<String>();
        if (restricted_to != null) {
            rt_set.addAll(Arrays.asList(restricted_to));
        }
        boolean folder_minimized = configMan.getBooleanParameter(props_prefix + ".subViews.minimized", !this.tv.getTabViewsExpandedByDefault());
        if (pluginViews != null) {
            for (UISWTInstance.UISWTViewEventListenerWrapper l : pluginViews) {
                if (l == null) continue;
                try {
                    String view_id = l.getViewID();
                    if (restricted_to != null && !rt_set.contains(view_id)) continue;
                    if (closed_tabs.containsKey(view_id)) {
                        this.removedViews.add(l);
                        continue;
                    }
                    this.addTabView(l, true, folder_minimized);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (folder_minimized) {
            this.tabFolder.setMinimized(true);
            tabFolderData.height = iFolderHeightAdj;
        } else {
            this.tabFolder.setMinimized(false);
        }
        if (this.tabFolder.getItemCount() > 0) {
            CTabItem item = this.tabFolder.getItem(0);
            this.tabFolder.setSelection(item);
            this.selectedView = (UISWTViewImpl)item.getData("IView");
        }
        return form;
    }

    private void fireFocusGained(UISWTViewCore view) {
        if (this.focused_view != null) {
            this.focused_view.triggerEvent(4, null);
        }
        this.focused_view = view;
        this.checkPendingDataSourceChange(view);
        view.triggerEvent(3, null);
    }

    private void fireFocusLost(UISWTViewCore view) {
        if (this.focused_view != null && this.focused_view != view) {
            this.focused_view.triggerEvent(4, null);
        }
        this.focused_view = null;
        if (view != null) {
            view.triggerEvent(4, null);
        }
    }

    public void swt_refresh() {
        if (this.tv.isTabViewsEnabled() && this.tabFolder != null && !this.tabFolder.isDisposed() && !this.tabFolder.getMinimized()) {
            this.refreshSelectedSubView();
        }
    }
}

