/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices;

import com.aelitis.azureus.core.devices.DeviceManager;
import org.gudy.azureus2.core3.util.Debug;

public class DeviceManagerFactory {
    private static final Class<DeviceManager> impl_class;
    private static DeviceManager singleton;

    public static void preInitialise() {
        if (impl_class != null) {
            try {
                impl_class.getMethod("preInitialise", new Class[0]).invoke(null, (Object[])null);
            }
            catch (Throwable e) {
                Debug.out("preInitialise failed", e);
            }
        }
    }

    public static DeviceManager getSingleton() {
        Class<DeviceManagerFactory> clazz = DeviceManagerFactory.class;
        synchronized (DeviceManagerFactory.class) {
            if (singleton != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
            if (impl_class == null) {
                throw new RuntimeException("No Implementation");
            }
            try {
                singleton = (DeviceManager)impl_class.getMethod("getSingleton", new Class[0]).invoke(null, (Object[])null);
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
            catch (Throwable e) {
                throw new RuntimeException("No Implementation", e);
            }
        }
    }

    static {
        String impl = System.getProperty("az.factory.devicemanager.impl", "com.aelitis.azureus.core.devices.impl.DeviceManagerImpl");
        Class<?> temp = null;
        if (impl.length() > 0) {
            try {
                temp = DeviceManagerFactory.class.getClassLoader().loadClass(impl);
            }
            catch (Throwable e) {
                Debug.out("Failed to load DeviceManagerFactory class: " + impl);
            }
        }
        impl_class = temp;
    }
}

