/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTest;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTestListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTester;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterResult;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterBTImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class NetworkAdminSpeedTestScheduledTestImpl
implements NetworkAdminSpeedTestScheduledTest {
    private static final long REQUEST_TEST = 0L;
    private static final long CHALLENGE_REPLY = 1L;
    private static final long TEST_RESULT = 2L;
    private static int ZERO_DOWNLOAD_SETTING = -1;
    private PluginInterface plugin;
    private NetworkAdminSpeedTesterImpl tester;
    private String detectedRouter;
    private SpeedTestDownloadState preTestSettings;
    private byte[] challenge_id;
    private long delay_millis;
    private long max_speed;
    private TOTorrent test_torrent;
    private volatile boolean aborted;
    private CopyOnWriteList listeners = new CopyOnWriteList();

    protected NetworkAdminSpeedTestScheduledTestImpl(PluginInterface _plugin, NetworkAdminSpeedTesterImpl _tester) {
        this.plugin = _plugin;
        this.tester = _tester;
        PluginInterface upnp = this.plugin.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
        if (upnp != null) {
            this.detectedRouter = upnp.getPluginconfig().getPluginStringParameter("plugin.info");
        }
        this.tester.addListener(new NetworkAdminSpeedTesterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete(NetworkAdminSpeedTester tester, NetworkAdminSpeedTesterResult result) {
                try {
                    NetworkAdminSpeedTestScheduledTestImpl.this.sendResult(result);
                    Object var4_3 = null;
                    NetworkAdminSpeedTestScheduledTestImpl.this.reportComplete();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    NetworkAdminSpeedTestScheduledTestImpl.this.reportComplete();
                    throw throwable;
                }
            }

            public void stage(NetworkAdminSpeedTester tester, String step) {
            }
        });
    }

    public NetworkAdminSpeedTester getTester() {
        return this.tester;
    }

    public long getMaxUpBytePerSec() {
        return this.max_speed;
    }

    public long getMaxDownBytePerSec() {
        return this.max_speed;
    }

    public boolean start() {
        if (this.schedule()) {
            new AEThread("NetworkAdminSpeedTestScheduledTest:delay", true){

                public void runSupport() {
                    long delay_ticks = NetworkAdminSpeedTestScheduledTestImpl.this.delay_millis / 1000L;
                    int i = 0;
                    while ((long)i < delay_ticks && !NetworkAdminSpeedTestScheduledTestImpl.this.aborted) {
                        String testScheduledIn = MessageText.getString("SpeedTestWizard.abort.message.scheduled.in", new String[]{"" + (delay_ticks - (long)i)});
                        NetworkAdminSpeedTestScheduledTestImpl.this.reportStage(testScheduledIn);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    if (!NetworkAdminSpeedTestScheduledTestImpl.this.aborted) {
                        NetworkAdminSpeedTestScheduledTestImpl.this.setSpeedLimits();
                        if (NetworkAdminSpeedTestScheduledTestImpl.this.tester.getTestType() == 1) {
                            ((NetworkAdminSpeedTesterBTImpl)NetworkAdminSpeedTestScheduledTestImpl.this.tester).start(NetworkAdminSpeedTestScheduledTestImpl.this.test_torrent);
                        } else {
                            String unsupportedType = MessageText.getString("SpeedTestWizard.abort.message.unsupported.type");
                            NetworkAdminSpeedTestScheduledTestImpl.this.tester.abort(unsupportedType);
                        }
                    }
                }
            }.start();
            return true;
        }
        return false;
    }

    public void abort() {
        this.abort(MessageText.getString("SpeedTestWizard.abort.message.manual.abort"));
    }

    public void abort(String reason) {
        if (!this.aborted) {
            this.aborted = true;
            this.tester.abort(reason);
        }
    }

    private boolean schedule() {
        try {
            File f;
            String debug;
            String v;
            File f2;
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("request_type", new Long(0L));
            String id = COConfigurationManager.getStringParameter("ID", "unknown");
            File jar_file = null;
            String jar_version = null;
            String explicit_path = System.getProperty("azureus.speed.test.challenge.jar.path", null);
            if (explicit_path != null && (f2 = new File(explicit_path)).exists() && (v = this.getVersionFromJAR(f2)) != null) {
                jar_file = f2;
                jar_version = v;
                System.out.println("SpeedTest: using explicit challenge jar " + jar_file.getAbsolutePath() + ", version " + jar_version);
            }
            if (jar_file == null && !(debug = System.getProperty("debug.speed.test.challenge", "n")).equals("n") && (f = new File("C:\\test\\azureus\\Azureus3.0.1.2.jar")).exists()) {
                jar_file = f;
                jar_version = "3.0.1.2";
                System.out.println("SpeedTest: using old spec challenge jar " + jar_file.getAbsolutePath() + ", version " + jar_version);
            }
            if (jar_file == null) {
                jar_file = FileUtil.getJarFileFromClass(this.getClass());
                if (jar_file != null) {
                    jar_version = "5.6.0.1_B02";
                } else {
                    f2 = new File(SystemProperties.getAzureusJarPath());
                    if (f2.exists()) {
                        jar_version = "5.6.0.1_B02";
                        jar_file = f2;
                    }
                }
            }
            if (jar_file == null) {
                throw new Exception("Failed to locate an 'Azureus2.jar' to use for the challenge protocol");
            }
            request2.put("az-id", id);
            request2.put("type", "both");
            request2.put("jar_ver", jar_version);
            if (this.detectedRouter != null) {
                request2.put("router", this.detectedRouter);
            }
            Map result = this.sendRequest(request2);
            this.challenge_id = (byte[])result.get("challenge_id");
            if (this.challenge_id == null) {
                throw new IllegalStateException("No challenge returned from speed test scheduling service");
            }
            Long responseType = (Long)result.get("reply_type");
            if (responseType.intValue() == 1) {
                result = this.handleChallengeFromSpeedTestService(jar_file, result);
                responseType = (Long)result.get("reply_type");
            }
            if (responseType == null) {
                throw new IllegalStateException("No challenge response returned from speed test scheduling service");
            }
            if (responseType.intValue() == 0) {
                Long time = (Long)result.get("time");
                Long limit = (Long)result.get("limit");
                if (time == null || limit == null) {
                    throw new IllegalArgumentException("Returned time or limit parameter is null");
                }
                this.delay_millis = time;
                this.max_speed = limit;
                Map torrentMap = (Map)result.get("torrent");
                this.test_torrent = TOTorrentFactory.deserialiseFromMap(torrentMap);
                return true;
            }
            throw new IllegalStateException("Unrecognized response from speed test scheduling servcie.");
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
            this.tester.abort(MessageText.getString("SpeedTestWizard.abort.message.scheduling.failed"), t);
            return false;
        }
    }

    private String getVersionFromJAR(File jar_file) {
        try {
            ClassLoader parent = new ClassLoader(){

                protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    if (name.equals("org.gudy.azureus2.core3.util.Constants")) {
                        throw new ClassNotFoundException();
                    }
                    return super.loadClass(name, resolve);
                }
            };
            URLClassLoader cl = new URLClassLoader(new URL[]{jar_file.toURI().toURL()}, parent);
            Class<?> c = cl.loadClass("org.gudy.azureus2.core3.util.Constants");
            Field field = c.getField("AZUREUS_VERSION");
            return (String)field.get(null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map handleChallengeFromSpeedTestService(File jar_file, Map result) throws IOException {
        Map retVal = new HashMap();
        RandomAccessFile raf = null;
        try {
            Long size = (Long)result.get("size");
            Long offset = (Long)result.get("offset");
            if (size == null || offset == null) {
                throw new IllegalStateException("scheduleTestWithSpeedTestService had a null parameter.");
            }
            raf = new RandomAccessFile(jar_file, "r");
            byte[] jarBytes = new byte[size.intValue()];
            raf.seek(offset.intValue());
            raf.read(jarBytes);
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("request_type", new Long(1L));
            request2.put("challenge_id", this.challenge_id);
            request2.put("data", jarBytes);
            retVal = this.sendRequest(request2);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Throwable t) {
                Debug.printStackTrace(t);
            }
            throw throwable;
        }
        try {
            if (raf != null) {
                raf.close();
            }
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
        return retVal;
    }

    private void sendResult(NetworkAdminSpeedTesterResult result) {
        try {
            if (this.challenge_id != null) {
                HashMap<String, Object> request2 = new HashMap<String, Object>();
                request2.put("request_type", new Long(2L));
                request2.put("challenge_id", this.challenge_id);
                request2.put("type", new Long(this.tester.getTestType()));
                request2.put("mode", new Long(this.tester.getMode()));
                request2.put("crypto", new Long(this.tester.getUseCrypto() ? 1L : 0L));
                if (result.hadError()) {
                    request2.put("result", new Long(0L));
                    request2.put("error", result.getLastError());
                } else {
                    request2.put("result", new Long(1L));
                    request2.put("maxup", new Long(result.getUploadSpeed()));
                    request2.put("maxdown", new Long(result.getDownloadSpeed()));
                }
                this.sendRequest(request2);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private Map sendRequest(Map request2) throws IOException {
        request2.put("ver", new Long(1L));
        request2.put("locale", MessageText.getCurrentLocale().toString());
        String speedTestServiceName = System.getProperty("speedtest.service.ip.address", "speedtest.vuze.com");
        URL urlRequestTest = new URL("http://" + speedTestServiceName + ":60000/scheduletest?request=" + URLEncoder.encode(new String(BEncoder.encode(request2), "ISO-8859-1"), "ISO-8859-1"));
        return this.getBEncodedMapFromRequest(urlRequestTest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map getBEncodedMapFromRequest(URL url) throws IOException {
        Map<Object, Object> reply;
        block14: {
            ResourceDownloader rd = ResourceDownloaderFactoryImpl.getSingleton().create(url);
            InputStream is = null;
            reply = new HashMap();
            is = rd.download();
            reply = BDecoder.decode(new BufferedInputStream(is));
            Long res = (Long)reply.get("result");
            if (res == null) {
                throw new IllegalStateException("No result parameter in the response!! reply=" + reply);
            }
            if (res.intValue() == 0) {
                StringBuffer msg = new StringBuffer("Server failed. ");
                String error = new String((byte[])reply.get("error"));
                String errDetail = new String((byte[])reply.get("error_detail"));
                msg.append("Error: ").append(error);
                Debug.outNoStack("SpeedCheck server returned an error: " + error + ", details=" + errDetail);
                throw new IOException(msg.toString());
            }
            Object var10_11 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block14;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            break block14;
            {
                catch (IOException ise) {
                    throw ise;
                }
                catch (Throwable t) {
                    Debug.out(t);
                    Debug.printStackTrace(t);
                    Object var10_12 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block14;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                throw throwable;
            }
        }
        return reply;
    }

    protected synchronized void resetSpeedLimits() {
        if (this.preTestSettings != null) {
            this.preTestSettings.restoreLimits();
            this.preTestSettings = null;
        }
    }

    protected synchronized void setSpeedLimits() {
        this.resetSpeedLimits();
        this.preTestSettings = new SpeedTestDownloadState();
        this.preTestSettings.saveLimits();
    }

    protected void reportStage(String str) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((NetworkAdminSpeedTestScheduledTestListener)it.next()).stage(this, str);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void reportComplete() {
        this.resetSpeedLimits();
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((NetworkAdminSpeedTestScheduledTestListener)it.next()).complete(this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addListener(NetworkAdminSpeedTestScheduledTestListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(NetworkAdminSpeedTestScheduledTestListener listener) {
        this.listeners.remove(listener);
    }

    class SpeedTestDownloadState
    implements ParameterListener,
    DownloadManagerListener {
        private Map torrentLimits = new HashMap();
        public static final String TORRENT_UPLOAD_LIMIT = "u";
        public static final String TORRENT_DOWNLOAD_LIMIT = "d";
        int maxUploadKbs;
        int maxUploadSeedingKbs;
        int maxDownloadKbs;
        boolean autoSpeedEnabled;
        boolean autoSpeedSeedingEnabled;
        boolean LANSpeedEnabled;

        public void parameterChanged(String name) {
            String trace = Debug.getCompressedStackTrace();
            NetworkAdminSpeedTestScheduledTestImpl.this.abort("Configuration parameter '" + name + "' changed (new value=" + COConfigurationManager.getParameter(name) + ") during test (" + trace + ")");
        }

        public void downloadAdded(Download download) {
            if (NetworkAdminSpeedTestScheduledTestImpl.this.test_torrent != null) {
                try {
                    if (Arrays.equals(download.getTorrent().getHash(), NetworkAdminSpeedTestScheduledTestImpl.this.test_torrent.getHash())) {
                        return;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            String downloadAdded = MessageText.getString("SpeedTestWizard.abort.message.download.added", new String[]{download.getName()});
            NetworkAdminSpeedTestScheduledTestImpl.this.abort(downloadAdded);
        }

        public void downloadRemoved(Download download) {
        }

        public void saveLimits() {
            int i;
            PluginConfigImpl.setEnablePluginCoreConfigChange(false);
            NetworkAdminSpeedTestScheduledTestImpl.this.plugin.getDownloadManager().addListener(this, false);
            Download[] d = NetworkAdminSpeedTestScheduledTestImpl.this.plugin.getDownloadManager().getDownloads();
            if (d != null) {
                int len = d.length;
                for (i = 0; i < len; ++i) {
                    NetworkAdminSpeedTestScheduledTestImpl.this.plugin.getDownloadManager().getStats();
                    int downloadLimit = d[i].getDownloadRateLimitBytesPerSecond();
                    int uploadLimit = d[i].getUploadRateLimitBytesPerSecond();
                    this.setDownloadDetails(d[i], uploadLimit, downloadLimit);
                    d[i].setUploadRateLimitBytesPerSecond(ZERO_DOWNLOAD_SETTING);
                    d[i].setDownloadRateLimitBytesPerSecond(ZERO_DOWNLOAD_SETTING);
                }
            }
            this.saveGlobalLimits();
            COConfigurationManager.setParameter("LAN Speed Enabled", false);
            COConfigurationManager.setParameter("Auto Upload Speed Enabled", false);
            COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", false);
            COConfigurationManager.setParameter("Max Upload Speed KBs", NetworkAdminSpeedTestScheduledTestImpl.this.max_speed);
            COConfigurationManager.setParameter("Max Upload Speed Seeding KBs", NetworkAdminSpeedTestScheduledTestImpl.this.max_speed);
            COConfigurationManager.setParameter("Max Download Speed KBs", NetworkAdminSpeedTestScheduledTestImpl.this.max_speed);
            String[] params = TransferSpeedValidator.CONFIG_PARAMS;
            for (i = 0; i < params.length; ++i) {
                COConfigurationManager.addParameterListener(params[i], (ParameterListener)this);
            }
        }

        public void restoreLimits() {
            String[] params = TransferSpeedValidator.CONFIG_PARAMS;
            for (int i = 0; i < params.length; ++i) {
                COConfigurationManager.removeParameterListener(params[i], this);
            }
            NetworkAdminSpeedTestScheduledTestImpl.this.plugin.getDownloadManager().removeListener(this);
            this.restoreGlobalLimits();
            this.restoreIndividualLimits();
            PluginConfigImpl.setEnablePluginCoreConfigChange(true);
        }

        private void saveGlobalLimits() {
            this.maxUploadKbs = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
            this.maxUploadSeedingKbs = COConfigurationManager.getIntParameter("Max Upload Speed Seeding KBs");
            this.maxDownloadKbs = COConfigurationManager.getIntParameter("Max Download Speed KBs");
            this.autoSpeedEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
            this.autoSpeedSeedingEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
            this.LANSpeedEnabled = COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
        }

        private void restoreGlobalLimits() {
            COConfigurationManager.setParameter("LAN Speed Enabled", this.LANSpeedEnabled);
            COConfigurationManager.setParameter("Auto Upload Speed Enabled", this.autoSpeedEnabled);
            COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", this.autoSpeedSeedingEnabled);
            COConfigurationManager.setParameter("Max Upload Speed KBs", this.maxUploadKbs);
            COConfigurationManager.setParameter("Max Upload Speed Seeding KBs", this.maxUploadSeedingKbs);
            COConfigurationManager.setParameter("Max Download Speed KBs", this.maxDownloadKbs);
        }

        private void restoreIndividualLimits() {
            Download[] downloads = this.getAllDownloads();
            if (downloads != null) {
                int nDownloads = downloads.length;
                for (int i = 0; i < nDownloads; ++i) {
                    int uploadLimit = this.getDownloadDetails(downloads[i], TORRENT_UPLOAD_LIMIT);
                    int downLimit = this.getDownloadDetails(downloads[i], TORRENT_DOWNLOAD_LIMIT);
                    downloads[i].setDownloadRateLimitBytesPerSecond(downLimit);
                    downloads[i].setUploadRateLimitBytesPerSecond(uploadLimit);
                }
            }
        }

        private void setDownloadDetails(Download d, int uploadLimit, int downloadLimit) {
            if (d == null) {
                throw new IllegalArgumentException("Download should not be null.");
            }
            HashMap<String, Integer> props = new HashMap<String, Integer>();
            props.put(TORRENT_UPLOAD_LIMIT, new Integer(uploadLimit));
            props.put(TORRENT_DOWNLOAD_LIMIT, new Integer(downloadLimit));
            this.torrentLimits.put(d, props);
        }

        private int getDownloadDetails(Download d, String param) {
            if (d == null || param == null) {
                throw new IllegalArgumentException("null inputs.");
            }
            if (!param.equals(TORRENT_UPLOAD_LIMIT) && !param.equals(TORRENT_DOWNLOAD_LIMIT)) {
                throw new IllegalArgumentException("invalid param. param=" + param);
            }
            Map out = (Map)this.torrentLimits.get(d);
            Integer limit = (Integer)out.get(param);
            return limit;
        }

        private Download[] getAllDownloads() {
            Download[] a = new Download[]{};
            return this.torrentLimits.keySet().toArray(a);
        }
    }
}

