/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.piecepicker.impl;

import com.aelitis.azureus.core.peermanager.control.PeerControlScheduler;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.peermanager.control.SpeedTokenDispenser;
import com.aelitis.azureus.core.peermanager.piecepicker.EndGameModeChunk;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePickerListener;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePriorityProvider;
import com.aelitis.azureus.core.peermanager.piecepicker.PieceRTAProvider;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.CopyOnWriteSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerListenerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class PiecePickerImpl
implements PiecePicker {
    private static final boolean LOG_RTA = false;
    private static final LogIDs LOGID = LogIDs.PIECES;
    private static final long TIME_MIN_AVAILABILITY = 974L;
    private static final long TIME_MIN_FILE_AVAILABILITY = 5000L;
    private static final long TIME_MIN_PRIORITIES = 999L;
    private static final long TIME_AVAIL_REBUILD = 299976L;
    private static final int PRIORITY_W_FIRSTLAST = 999;
    private static final long FIRST_PIECE_MIN_NB = 4L;
    private static final int PRIORITY_W_FILE_BASE = 1000;
    private static final int PRIORITY_W_FILE_RANGE = 1000;
    private static final int PRIORITY_W_COMPLETION = 2000;
    private static final int PRIORITY_W_AGE = 900;
    private static final int PRIORITY_DW_AGE = 60000;
    private static final int PRIORITY_DW_STALE = 120000;
    private static final int PRIORITY_W_PIECE_DONE = 900;
    private static final int PRIORITY_W_SAME_PIECE = 700;
    private static final int PRIORITY_OVERRIDES_RAREST = 9000;
    private static final int PRIORITY_REQUEST_HINT = 3000;
    private static final int PRIORITY_REALTIME = 9999999;
    private static final int PRIORITY_FORCED = 1000000;
    private static final int REQUESTS_MIN_MIN = 2;
    private static final int REQUESTS_MIN_MAX = 8;
    private static final int REQUESTS_MAX = 256;
    private static final int SLOPE_REQUESTS = 4096;
    private static final long RTA_END_GAME_MODE_SIZE_TRIGGER = 262144L;
    private static final long END_GAME_MODE_RESERVED_TRIGGER = 0x500000L;
    private static final long END_GAME_MODE_SIZE_TRIGGER = 0x1400000L;
    private static final long END_GAME_MODE_TIMEOUT = 76800L;
    protected static volatile boolean firstPiecePriority = COConfigurationManager.getBooleanParameter("Prioritize First Piece");
    protected static volatile boolean completionPriority = COConfigurationManager.getBooleanParameter("Prioritize Most Completed Files");
    protected static volatile long paramPriorityChange = Long.MIN_VALUE;
    private static final int NO_REQUEST_BACKOFF_MAX_MILLIS = 5000;
    private static final int NO_REQUEST_BACKOFF_MAX_LOOPS = 5000 / PeerControlScheduler.SCHEDULE_PERIOD_MILLIS;
    private static Random random = new Random();
    private final DiskManager diskManager;
    private final PEPeerControl peerControl;
    private final DiskManagerListenerImpl diskManagerListener;
    protected final Map peerListeners;
    private final PEPeerManagerListener peerManagerListener;
    protected final int nbPieces;
    protected final DiskManagerPiece[] dmPieces;
    protected final PEPiece[] pePieces;
    private List<PEPiece> rarestStartedPieces;
    protected final AEMonitor availabilityMon = new AEMonitor("PiecePicker:avail");
    private final AEMonitor endGameModeChunks_mon = new AEMonitor("PiecePicker:EGM");
    protected volatile int nbPiecesDone;
    protected volatile int[] availabilityAsynch;
    protected volatile long availabilityDrift;
    private long timeAvailRebuild = 299976L;
    protected volatile int[] availability;
    private long time_last_avail;
    protected volatile long availabilityChange;
    private volatile long availabilityComputeChange;
    private long time_last_rebuild;
    private long timeAvailLessThanOne;
    private float globalAvail;
    private float globalAvgAvail;
    private int nbRarestActive;
    private int globalMin;
    private int globalMax;
    private long bytesUnavailable;
    private volatile int globalMinOthers;
    protected volatile long filePriorityChange;
    private volatile long priorityParamChange;
    private volatile long priorityFileChange;
    private volatile long priorityAvailChange;
    private boolean priorityRTAexists;
    private long timeLastPriorities;
    private int[] startPriorities;
    protected volatile boolean hasNeededUndonePiece;
    protected volatile long neededUndonePieceChange;
    private volatile boolean endGameMode;
    private volatile boolean endGameModeAbandoned;
    private volatile long timeEndGameModeEntered;
    private List endGameModeChunks;
    private long lastProviderRecalcTime;
    private CopyOnWriteList rta_providers = new CopyOnWriteList();
    private long[] provider_piece_rtas;
    private CopyOnWriteList priority_providers = new CopyOnWriteList();
    private long[] provider_piece_priorities;
    private int allocate_request_loop_count;
    private int max_file_priority;
    private int min_file_priority;
    private boolean reverse_block_order;
    private int[] global_request_hint;
    private static boolean enable_request_hints;
    private static boolean includeLanPeersInReqLimiting;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private volatile float[] fileAvailabilities;
    private volatile long fileAvailabilitiesCalcTime;
    private volatile CopyOnWriteSet<Integer> forced_pieces;
    private final SpeedTokenDispenser dispenser = PeerControlSchedulerFactory.getSingleton(0).getSpeedTokenDispenser();

    public PiecePickerImpl(PEPeerControl pc) {
        this.peerControl = pc;
        this.diskManager = this.peerControl.getDiskManager();
        this.dmPieces = this.diskManager.getPieces();
        this.nbPieces = this.diskManager.getNbPieces();
        this.nbPiecesDone = 0;
        this.pePieces = pc.getPieces();
        this.availability = new int[this.nbPieces];
        this.hasNeededUndonePiece = false;
        this.neededUndonePieceChange = Long.MIN_VALUE;
        this.time_last_avail = Long.MIN_VALUE;
        this.availabilityChange = -9223372036854775807L;
        this.availabilityComputeChange = Long.MIN_VALUE;
        this.availabilityDrift = this.nbPieces;
        for (int i = 0; i < this.nbPieces; ++i) {
            if (this.dmPieces[i].isDone()) {
                int n = i;
                this.availability[n] = this.availability[n] + 1;
                ++this.nbPiecesDone;
                continue;
            }
            this.hasNeededUndonePiece |= this.dmPieces[i].calcNeeded();
        }
        if (this.hasNeededUndonePiece) {
            ++this.neededUndonePieceChange;
        }
        this.updateAvailability();
        this.peerListeners = new HashMap();
        this.peerManagerListener = new PEPeerManagerListenerImpl();
        this.peerControl.addListener(this.peerManagerListener);
        this.rarestStartedPieces = new ArrayList<PEPiece>();
        this.filePriorityChange = Long.MIN_VALUE;
        this.priorityParamChange = Long.MIN_VALUE;
        this.priorityFileChange = Long.MIN_VALUE;
        this.priorityAvailChange = Long.MIN_VALUE;
        this.timeLastPriorities = Long.MIN_VALUE;
        this.endGameMode = false;
        this.endGameModeAbandoned = false;
        this.timeEndGameModeEntered = 0L;
        this.diskManagerListener = new DiskManagerListenerImpl();
        this.syncFilePriorities();
        this.diskManager.addListener(this.diskManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addHavePiece(PEPeer peer, int pieceNumber) {
        try {
            this.availabilityMon.enter();
            if (this.availabilityAsynch == null) {
                this.availabilityAsynch = (int[])this.availability.clone();
            }
            int n = pieceNumber;
            this.availabilityAsynch[n] = this.availabilityAsynch[n] + 1;
            ++this.availabilityChange;
            Object var4_3 = null;
            this.availabilityMon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.availabilityMon.exit();
            throw throwable;
        }
        if (peer != null && this.dmPieces[pieceNumber].isDownloadable()) {
            peer.setConsecutiveNoRequestCount(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAvailability() {
        int i;
        long now = SystemTime.getCurrentTime();
        if (now >= this.time_last_avail && now < this.time_last_avail + 974L) {
            return;
        }
        if (this.availabilityDrift > 0L || now < this.time_last_rebuild || now - this.time_last_rebuild > this.timeAvailRebuild) {
            try {
                this.availabilityMon.enter();
                this.time_last_rebuild = now;
                int[] new_availability = this.recomputeAvailability();
                if (Constants.isCVSVersion()) {
                    int[] old_availability = this.availabilityAsynch == null ? this.availability : this.availabilityAsynch;
                    int errors = 0;
                    for (int i2 = 0; i2 < new_availability.length; ++i2) {
                        if (new_availability[i2] == old_availability[i2]) continue;
                        ++errors;
                    }
                    if (errors > 0 && errors != this.nbPieces) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent((Object)this.peerControl, LOGID, 3, "updateAvailability(): availability rebuild errors = " + errors + " timeAvailRebuild =" + this.timeAvailRebuild));
                        }
                        this.timeAvailRebuild -= (long)errors;
                    } else {
                        ++this.timeAvailRebuild;
                    }
                }
                this.availabilityAsynch = new_availability;
                this.availabilityDrift = 0L;
                ++this.availabilityChange;
                Object var8_8 = null;
                this.availabilityMon.exit();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.availabilityMon.exit();
                throw throwable;
            }
        } else if (this.availabilityComputeChange >= this.availabilityChange) {
            return;
        }
        try {
            this.availabilityMon.enter();
            this.time_last_avail = now;
            this.availabilityComputeChange = this.availabilityChange;
            if (this.availabilityAsynch != null) {
                this.availability = this.availabilityAsynch;
                this.availabilityAsynch = null;
            }
            Object var10_13 = null;
            this.availabilityMon.exit();
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.availabilityMon.exit();
            throw throwable;
        }
        int allMin = Integer.MAX_VALUE;
        int allMax = 0;
        int rarestMin = Integer.MAX_VALUE;
        for (i = 0; i < this.nbPieces; ++i) {
            int avail = this.availability[i];
            DiskManagerPiece dmPiece = this.dmPieces[i];
            PEPiece pePiece = this.pePieces[i];
            if (avail > 0 && avail < rarestMin && dmPiece.isDownloadable() && (pePiece == null || pePiece.isRequestable())) {
                rarestMin = avail;
            }
            if (avail < allMin) {
                allMin = avail;
            }
            if (avail <= allMax) continue;
            allMax = avail;
        }
        this.globalMin = allMin;
        this.globalMax = allMax;
        this.globalMinOthers = rarestMin;
        int total = 0;
        int rarestActive = 0;
        long totalAvail = 0L;
        long newBytesUnavailable = 0L;
        for (i = 0; i < this.nbPieces; ++i) {
            int avail = this.availability[i];
            DiskManagerPiece dmPiece = this.dmPieces[i];
            PEPiece pePiece = this.pePieces[i];
            if (avail > 0) {
                if (avail > allMin) {
                    ++total;
                }
                if (avail <= rarestMin && dmPiece.isDownloadable() && pePiece != null && !pePiece.isRequested()) {
                    ++rarestActive;
                }
                totalAvail += (long)avail;
                continue;
            }
            newBytesUnavailable += (long)dmPiece.getLength();
        }
        float newGlobalAvail = (float)total / (float)this.nbPieces + (float)allMin;
        if ((double)this.globalAvail >= 1.0 && (double)newGlobalAvail < 1.0) {
            this.timeAvailLessThanOne = now;
        } else if ((double)newGlobalAvail >= 1.0) {
            this.timeAvailLessThanOne = 0L;
        }
        this.bytesUnavailable = newBytesUnavailable;
        this.globalAvail = newGlobalAvail;
        this.nbRarestActive = rarestActive;
        this.globalAvgAvail = (float)totalAvail / (float)this.nbPieces / (float)(1 + this.peerControl.getNbSeeds() + this.peerControl.getNbPeers());
    }

    private final int[] recomputeAvailability() {
        int j;
        if (this.availabilityDrift > 0L && this.availabilityDrift != (long)this.nbPieces && Logger.isEnabled()) {
            Logger.log(new LogEvent((Object)this.diskManager.getTorrent(), LOGID, 0, "Recomputing availabiliy. Drift=" + this.availabilityDrift + ":" + this.peerControl.getDisplayName()));
        }
        List<PEPeer> peers = this.peerControl.getPeers();
        int[] newAvailability = new int[this.nbPieces];
        for (j = 0; j < this.nbPieces; ++j) {
            newAvailability[j] = this.dmPieces[j].isDone() ? 1 : 0;
        }
        int peersSize = peers.size();
        for (int i = 0; i < peersSize; ++i) {
            BitFlags peerHavePieces;
            PEPeerTransport peer = (PEPeerTransport)peers.get(i);
            if (peer == null || peer.getPeerState() != 30 || (peerHavePieces = peer.getAvailable()) == null || peerHavePieces.nbSet <= 0) continue;
            for (j = peerHavePieces.start; j <= peerHavePieces.end; ++j) {
                if (!peerHavePieces.flags[j]) continue;
                int n = j;
                newAvailability[n] = newAvailability[n] + 1;
            }
        }
        return newAvailability;
    }

    public int getNumberOfPieces() {
        return this.nbPieces;
    }

    public final int[] getAvailability() {
        return this.availability;
    }

    public final int getAvailability(int pieceNumber) {
        return this.availability[pieceNumber];
    }

    public final float getMinAvailability() {
        return this.globalAvail;
    }

    public float getMinAvailability(int fileIndex) {
        float[] avails = this.fileAvailabilities;
        if (avails == null) {
            DiskManagerFileInfo[] files = this.diskManager.getFiles();
            avails = new float[files.length];
        }
        if (avails.length == 1) {
            if (this.fileAvailabilities == null) {
                this.fileAvailabilities = avails;
            }
            return this.getMinAvailability();
        }
        long now = SystemTime.getMonotonousTime();
        if (this.fileAvailabilities == null || now - this.fileAvailabilitiesCalcTime > 5000L) {
            int[] current_avail = this.availability;
            if (current_avail == null) {
                return 0.0f;
            }
            DiskManagerFileInfo[] files = this.diskManager.getFiles();
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo file = files[i];
                int start = file.getFirstPieceNumber();
                int end = start + file.getNbPieces();
                int min_avail = Integer.MAX_VALUE;
                for (int j = start; j < end; ++j) {
                    int a = current_avail[j];
                    min_avail = Math.min(a, min_avail);
                }
                int total = 0;
                for (int j = start; j < end; ++j) {
                    int a = current_avail[j];
                    if (a <= 0 || a <= min_avail) continue;
                    ++total;
                }
                avails[i] = (float)total / (float)(end - start + 1) + (float)min_avail;
            }
            this.fileAvailabilities = avails;
            this.fileAvailabilitiesCalcTime = now;
        }
        return avails[fileIndex];
    }

    public final long getBytesUnavailable() {
        return this.bytesUnavailable;
    }

    public final long getAvailWentBadTime() {
        return this.timeAvailLessThanOne;
    }

    public final int getMaxAvailability() {
        return this.globalMax;
    }

    public final float getAvgAvail() {
        return this.globalAvgAvail;
    }

    public int getNbPiecesDone() {
        return this.nbPiecesDone;
    }

    protected final void checkDownloadablePiece() {
        for (int i = 0; i < this.nbPieces; ++i) {
            if (!this.dmPieces[i].isInteresting()) continue;
            if (!this.hasNeededUndonePiece) {
                this.hasNeededUndonePiece = true;
                ++this.neededUndonePieceChange;
            }
            return;
        }
        if (this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = false;
            ++this.neededUndonePieceChange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void allocateRequests() {
        int REQUESTS_MIN;
        boolean done_priorities;
        int uploadersSize;
        ArrayList<PEPeerTransport> bestUploaders;
        block29: {
            block28: {
                Iterator it3;
                int i;
                if (!this.hasNeededUndonePiece) {
                    return;
                }
                ++this.allocate_request_loop_count;
                List<PEPeer> peers = this.peerControl.getPeers();
                int peersSize = peers.size();
                bestUploaders = new ArrayList<PEPeerTransport>(peersSize);
                for (i = 0; i < peersSize; ++i) {
                    int no_req_count;
                    PEPeerTransport peer = (PEPeerTransport)peers.get(i);
                    if (!peer.isDownloadPossible() || (no_req_count = peer.getConsecutiveNoRequestCount()) != 0 && this.allocate_request_loop_count % (no_req_count + 1) != 0) continue;
                    bestUploaders.add(peer);
                }
                Collections.shuffle(bestUploaders);
                for (i = 0; i < 3; ++i) {
                    try {
                        Collections.sort(bestUploaders, new Comparator<PEPeerTransport>(){

                            @Override
                            public int compare(PEPeerTransport pt1, PEPeerTransport pt2) {
                                if (pt1 == pt2) {
                                    return 0;
                                }
                                PEPeerStats stats2 = pt2.getStats();
                                PEPeerStats stats1 = pt1.getStats();
                                int toReturn = 0;
                                if (pt1.isLANLocal() && !pt2.isLANLocal()) {
                                    toReturn = -1;
                                } else if (!pt1.isLANLocal() && pt2.isLANLocal()) {
                                    toReturn = 1;
                                }
                                if (toReturn == 0) {
                                    toReturn = (int)(stats2.getSmoothDataReceiveRate() - stats1.getSmoothDataReceiveRate());
                                }
                                if (!(toReturn != 0 || pt2.isChokedByMe() && pt1.isChokedByMe())) {
                                    toReturn = (int)(stats2.getDataSendRate() - stats1.getDataSendRate());
                                }
                                if (toReturn == 0 && pt2.isSnubbed() && !pt1.isSnubbed()) {
                                    toReturn = -1;
                                }
                                if (toReturn == 0 && !pt2.isSnubbed() && pt1.isSnubbed()) {
                                    toReturn = 1;
                                }
                                if (toReturn == 0 && stats2.getTotalDataBytesReceived() == 0L && stats1.getTotalDataBytesReceived() > 0L) {
                                    toReturn = 1;
                                }
                                if (toReturn == 0 && stats1.getTotalDataBytesReceived() == 0L && stats2.getTotalDataBytesReceived() > 0L) {
                                    toReturn = -1;
                                }
                                return toReturn;
                            }
                        });
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                }
                if ((uploadersSize = bestUploaders.size()) == 0) {
                    return;
                }
                done_priorities = false;
                if (!this.priorityRTAexists) break block28;
                REQUESTS_MIN = 2;
                final Map[] peer_randomiser = new Map[]{null};
                final HashMap block_time_order_peers_metrics = new HashMap(uploadersSize);
                TreeSet<PEPeerTransport> block_time_order_peers = new TreeSet<PEPeerTransport>(new Comparator(){

                    public int compare(Object arg1, Object arg2) {
                        int result;
                        Integer m2;
                        if (arg1 == arg2) {
                            return 0;
                        }
                        PEPeerTransport pt1 = (PEPeerTransport)arg1;
                        PEPeerTransport pt2 = (PEPeerTransport)arg2;
                        Integer m1 = (Integer)block_time_order_peers_metrics.get(pt1);
                        if (m1 == null) {
                            m1 = new Integer(PiecePickerImpl.this.getNextBlockETAFromNow(pt1));
                            block_time_order_peers_metrics.put(pt1, m1);
                        }
                        if ((m2 = (Integer)block_time_order_peers_metrics.get(pt2)) == null) {
                            m2 = new Integer(PiecePickerImpl.this.getNextBlockETAFromNow(pt2));
                            block_time_order_peers_metrics.put(pt2, m2);
                        }
                        if ((result = m1 - m2) == 0) {
                            Integer r_2;
                            Integer r_1;
                            LightHashMap pr = peer_randomiser[0];
                            if (pr == null) {
                                pr = peer_randomiser[0] = new LightHashMap(bestUploaders.size());
                            }
                            if ((r_1 = (Integer)pr.get(pt1)) == null) {
                                r_1 = new Integer(random.nextInt());
                                pr.put(pt1, r_1);
                            }
                            if ((r_2 = (Integer)pr.get(pt2)) == null) {
                                r_2 = new Integer(random.nextInt());
                                pr.put(pt2, r_2);
                            }
                            if ((result = r_1 - r_2) == 0 && (result = pt1.hashCode() - pt2.hashCode()) == 0) {
                                result = 1;
                            }
                        }
                        return result;
                    }
                });
                block_time_order_peers.addAll(bestUploaders);
                PEPeerTransport best_uploader = (PEPeerTransport)bestUploaders.get(0);
                long best_block_eta = SystemTime.getCurrentTime() + (long)this.getNextBlockETAFromNow(best_uploader);
                boolean allocated_request = true;
                HashSet<PEPeerTransport> allocations_started = new HashSet<PEPeerTransport>();
                try {
                    block8: while (allocated_request && this.priorityRTAexists) {
                        allocated_request = false;
                        while (!block_time_order_peers.isEmpty()) {
                            int currentRequests;
                            int allowed_requests;
                            Iterator it2 = block_time_order_peers.iterator();
                            PEPeerTransport pt = (PEPeerTransport)it2.next();
                            it2.remove();
                            if (!pt.isDownloadPossible() || pt.isSnubbed()) continue;
                            int maxRequests = REQUESTS_MIN + (int)(pt.getStats().getDataReceiveRate() / 4096L) + 1;
                            if (maxRequests > 256 || maxRequests < 0) {
                                maxRequests = 256;
                            }
                            if ((allowed_requests = maxRequests - (currentRequests = pt.getNbRequests())) <= 0) continue;
                            if (!done_priorities) {
                                done_priorities = true;
                                this.computeBasePriorities();
                                if (!this.priorityRTAexists) continue block8;
                            }
                            if (!allocations_started.contains(pt)) {
                                pt.requestAllocationStarts(this.startPriorities);
                                allocations_started.add(pt);
                            }
                            if (!this.findRTAPieceToDownload(pt, pt == best_uploader, best_block_eta) || allowed_requests <= 1) continue;
                            block_time_order_peers_metrics.remove(pt);
                            block_time_order_peers.add(pt);
                        }
                    }
                    Object var21_29 = null;
                    it3 = allocations_started.iterator();
                }
                catch (Throwable throwable) {
                    Object var21_30 = null;
                    Iterator it3 = allocations_started.iterator();
                    while (it3.hasNext()) {
                        ((PEPeerTransport)it3.next()).requestAllocationComplete();
                    }
                    throw throwable;
                }
                while (it3.hasNext()) {
                    ((PEPeerTransport)it3.next()).requestAllocationComplete();
                }
                break block29;
            }
            int required_blocks = (int)(this.diskManager.getRemainingExcludingDND() / 16384L);
            int blocks_per_uploader = required_blocks / uploadersSize;
            REQUESTS_MIN = Math.max(2, Math.min(8, blocks_per_uploader / 2));
        }
        this.checkEndGameMode();
        for (int i = 0; i < uploadersSize; ++i) {
            Object var24_35;
            int maxRequests;
            PEPeerTransport pt = (PEPeerTransport)bestUploaders.get(i);
            if (this.dispenser.peek(16384) < 1 && (!pt.isLANLocal() || includeLanPeersInReqLimiting)) break;
            if (!pt.isDownloadPossible()) continue;
            int peer_request_num = pt.getMaxNbRequests();
            if (peer_request_num != -1) {
                maxRequests = peer_request_num;
            } else if (!pt.isSnubbed()) {
                if (!this.endGameMode) {
                    int peer_requests_min = pt.getUnchokedForMillis() < 10000L ? REQUESTS_MIN : 2;
                    maxRequests = peer_requests_min + (int)(pt.getStats().getDataReceiveRate() / 4096L);
                    if (maxRequests > 256 || maxRequests < 0) {
                        maxRequests = 256;
                    }
                } else {
                    maxRequests = 2;
                }
            } else {
                maxRequests = 1;
            }
            if (pt.getNbRequests() > maxRequests * 3 / 5) continue;
            if (!done_priorities) {
                done_priorities = true;
                this.computeBasePriorities();
            }
            int total_allocated = 0;
            try {
                int allocated;
                boolean peer_managing_requests = pt.requestAllocationStarts(this.startPriorities);
                while (pt.isDownloadPossible() && pt.getNbRequests() < maxRequests && (allocated = peer_managing_requests || !this.endGameMode ? this.findPieceToDownload(pt, maxRequests) : this.findPieceInEndGameMode(pt, maxRequests)) != 0) {
                    total_allocated += allocated;
                }
                var24_35 = null;
                pt.requestAllocationComplete();
            }
            catch (Throwable throwable) {
                var24_35 = null;
                pt.requestAllocationComplete();
                throw throwable;
            }
            if (total_allocated == 0) {
                int no_req_count = pt.getConsecutiveNoRequestCount();
                if (no_req_count >= NO_REQUEST_BACKOFF_MAX_LOOPS) continue;
                pt.setConsecutiveNoRequestCount(no_req_count + 1);
                continue;
            }
            pt.setConsecutiveNoRequestCount(0);
        }
    }

    protected int getNextBlockETAFromNow(PEPeerTransport pt) {
        long upRate = pt.getStats().getDataReceiveRate();
        if (upRate < 1L) {
            upRate = 1L;
        }
        int next_block_bytes = (pt.getNbRequests() + 1) * 16384;
        return (int)((long)(next_block_bytes * 1000) / upRate);
    }

    private int calcRarestAllowed() {
        int RarestAllowed = 1;
        if (this.globalMinOthers < 20) {
            RarestAllowed = 2;
        }
        if (this.globalMinOthers < 8) {
            RarestAllowed = 3;
        }
        if (this.globalMinOthers < 4) {
            RarestAllowed = 4;
        }
        if (this.nbPiecesDone < 4) {
            RarestAllowed = 0;
        }
        if (SystemTime.getCurrentTime() - this.peerControl.getTimeStarted(false) < 180000L) {
            RarestAllowed = 0;
        }
        if (this.rarestStartedPieces.size() > RarestAllowed + 2) {
            RarestAllowed = 0;
        }
        for (int i = 0; i < this.rarestStartedPieces.size(); ++i) {
            PEPiece rarestStarted = this.rarestStartedPieces.get(i);
            if (this.pePieces[rarestStarted.getPieceNumber()] == null) {
                this.rarestStartedPieces.remove(i);
                --i;
                continue;
            }
            if (rarestStarted.getAvailability() > this.globalMinOthers && this.globalMinOthers <= this.globalMin || SystemTime.getCurrentTime() - rarestStarted.getLastDownloadTime(SystemTime.getCurrentTime()) >= 60000L && rarestStarted.getNbWritten() != 0 || rarestStarted.isDownloaded()) continue;
            --RarestAllowed;
        }
        return RarestAllowed;
    }

    private void syncFilePriorities() {
        DiskManagerFileInfo[] files = this.diskManager.getFiles();
        int max = 0;
        int min = 0;
        for (DiskManagerFileInfo file : files) {
            int p = file.getPriority();
            if (p > max) {
                max = p;
                continue;
            }
            if (p >= min) continue;
            min = p;
        }
        this.max_file_priority = max;
        this.min_file_priority = min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void computeBasePriorities() {
        long now = SystemTime.getCurrentTime();
        if (now < this.lastProviderRecalcTime || now - this.lastProviderRecalcTime > 1000L) {
            this.lastProviderRecalcTime = now;
            this.priorityRTAexists = this.computeProviderPriorities();
        }
        if (!this.priorityRTAexists && this.startPriorities != null && (now > this.timeLastPriorities && now < this.timeLastPriorities + 999L || this.priorityParamChange >= paramPriorityChange && this.priorityFileChange >= this.filePriorityChange && this.priorityAvailChange >= this.availabilityChange)) {
            return;
        }
        this.timeLastPriorities = now;
        this.priorityParamChange = paramPriorityChange;
        this.priorityFileChange = this.filePriorityChange;
        this.priorityAvailChange = this.availabilityChange;
        boolean foundPieceToDownload = false;
        int[] newPriorities = new int[this.nbPieces];
        boolean firstPiecePriorityL = firstPiecePriority;
        boolean completionPriorityL = completionPriority;
        DMPieceMap pieceMap = this.diskManager.getPieceMap();
        CopyOnWriteSet<Integer> forced = this.forced_pieces;
        try {
            boolean rarestOverride = this.calcRarestAllowed() < 1;
            int nbConnects = this.peerControl.getNbPeers() + this.peerControl.getNbSeeds();
            for (int i = 0; i < this.nbPieces; ++i) {
                DiskManagerPiece dmPiece = this.dmPieces[i];
                if (dmPiece.isDone()) {
                    if (forced == null || !forced.contains(i) || !forced.remove(i) || forced.size() != 0) continue;
                    PiecePickerImpl piecePickerImpl = this;
                    synchronized (piecePickerImpl) {
                        if (this.forced_pieces != null && this.forced_pieces.size() == 0) {
                            this.forced_pieces = null;
                        }
                        continue;
                    }
                }
                int startPriority = Integer.MIN_VALUE;
                DMPieceList pieceList2 = pieceMap.getPieceList(dmPiece.getPieceNumber());
                int pieceListSize = pieceList2.size();
                for (int j = 0; j < pieceListSize; ++j) {
                    long percent;
                    int min;
                    int file_priority;
                    int max;
                    int range;
                    DiskManagerFileInfoImpl fileInfo2 = pieceList2.get(j).getFile();
                    long downloaded = fileInfo2.getDownloaded();
                    long length = fileInfo2.getLength();
                    if (length <= 0L || downloaded >= length || fileInfo2.isSkipped()) continue;
                    int priority = 0;
                    if (firstPiecePriorityL && (long)fileInfo2.getNbPieces() > 4L && (i == fileInfo2.getFirstPieceNumber() || i == fileInfo2.getLastPieceNumber())) {
                        priority += 999;
                    }
                    if ((range = (max = Math.max(file_priority = fileInfo2.getPriority(), this.max_file_priority)) - (min = Math.min(file_priority, this.min_file_priority))) > 0) {
                        int relative_file_priority = file_priority - min;
                        priority += 1000;
                        int adjustment = 1000 * relative_file_priority / range;
                        priority += adjustment;
                    }
                    if (completionPriorityL && (percent = 1000L * downloaded / length) >= 900L) {
                        priority = (int)((long)priority + 2000L * downloaded / this.diskManager.getTotalLength());
                    }
                    if (priority <= startPriority) continue;
                    startPriority = priority;
                }
                if (startPriority >= 0) {
                    dmPiece.setNeeded();
                    foundPieceToDownload = true;
                    int avail = this.availability[i];
                    if (avail > 0 && nbConnects > avail) {
                        startPriority += nbConnects - avail;
                        if (!rarestOverride && avail <= this.globalMinOthers) {
                            startPriority += nbConnects / avail;
                        }
                    }
                    if (this.provider_piece_rtas != null) {
                        if (this.provider_piece_rtas[i] > 0L) {
                            startPriority = 9999999;
                        }
                    } else if (this.provider_piece_priorities != null) {
                        startPriority = (int)((long)startPriority + this.provider_piece_priorities[i]);
                    } else if (forced != null && forced.contains(i)) {
                        startPriority = 1000000;
                    }
                } else {
                    dmPiece.clearNeeded();
                }
                newPriorities[i] = startPriority;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (foundPieceToDownload != this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = foundPieceToDownload;
            ++this.neededUndonePieceChange;
        }
        this.startPriorities = newPriorities;
    }

    private final boolean isRarestOverride() {
        boolean rarestOverride;
        int nbSeeds = this.peerControl.getNbSeeds();
        int nbPeers = this.peerControl.getNbPeers();
        int nbMost = nbPeers > nbSeeds ? nbPeers : nbSeeds;
        int nbActive = this.peerControl.getNbActivePieces();
        boolean bl = rarestOverride = this.nbPiecesDone < 4 || this.endGameMode || this.globalMinOthers > 1 && (this.nbRarestActive >= nbMost || nbActive >= nbMost);
        if (!rarestOverride && this.nbRarestActive > 1 && this.globalMinOthers > 1) {
            rarestOverride = this.globalMinOthers > this.globalMin || this.globalMinOthers >= 2 * nbSeeds && 2 * this.globalMinOthers >= nbPeers;
        }
        return rarestOverride;
    }

    protected final int findPieceToDownload(PEPeerTransport pt, int nbWanted) {
        PEPiece pePiece;
        int pieceNumber = this.getRequestCandidate(pt);
        if (pieceNumber < 0) {
            return 0;
        }
        int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1000;
        if (peerSpeed < 0) {
            peerSpeed = 0;
        }
        if (pt.isSnubbed()) {
            peerSpeed = 0;
        }
        if (this.pePieces[pieceNumber] != null) {
            pePiece = this.pePieces[pieceNumber];
        } else {
            int[] peer_priority_offsets = pt.getPriorityOffsets();
            int this_offset = peer_priority_offsets == null ? 0 : peer_priority_offsets[pieceNumber];
            pePiece = new PEPieceImpl(pt.getManager(), this.dmPieces[pieceNumber], peerSpeed >> 1);
            this.peerControl.addPiece(pePiece, pieceNumber, pt);
            if (this.startPriorities != null) {
                pePiece.setResumePriority(this.startPriorities[pieceNumber] + this_offset);
            } else {
                pePiece.setResumePriority(this_offset);
            }
            if (this.availability[pieceNumber] <= this.globalMinOthers) {
                ++this.nbRarestActive;
            }
        }
        int[] request_hint = null;
        if (enable_request_hints) {
            request_hint = pt.getRequestHint();
            if (request_hint != null && request_hint[0] != pieceNumber) {
                request_hint = null;
            }
            if (request_hint == null && (request_hint = this.global_request_hint) != null && request_hint[0] != pieceNumber) {
                request_hint = null;
            }
        }
        if (!pt.isLANLocal() || includeLanPeersInReqLimiting) {
            nbWanted = this.dispenser.dispense(nbWanted, 16384);
        }
        int[] blocksFound = pePiece.getAndMarkBlocks(pt, nbWanted, request_hint, this.reverse_block_order);
        int blockNumber = blocksFound[0];
        int nbBlocks = blocksFound[1];
        if ((!pt.isLANLocal() || includeLanPeersInReqLimiting) && nbBlocks != nbWanted) {
            this.dispenser.returnUnusedChunks(nbWanted - nbBlocks, 16384);
        }
        if (nbBlocks <= 0) {
            return 0;
        }
        int requested = 0;
        if (this.reverse_block_order) {
            for (int i = nbBlocks - 1; i >= 0; --i) {
                int thisBlock = blockNumber + i;
                if (pt.request(pieceNumber, thisBlock * 16384, pePiece.getBlockSize(thisBlock), true) != null) {
                    ++requested;
                    pt.setLastPiece(pieceNumber);
                    pePiece.setLastRequestedPeerSpeed(peerSpeed);
                    continue;
                }
                pePiece.clearRequested(thisBlock);
            }
        } else {
            for (int i = 0; i < nbBlocks; ++i) {
                int thisBlock = blockNumber + i;
                if (pt.request(pieceNumber, thisBlock * 16384, pePiece.getBlockSize(thisBlock), true) != null) {
                    ++requested;
                    pt.setLastPiece(pieceNumber);
                    pePiece.setLastRequestedPeerSpeed(peerSpeed);
                    continue;
                }
                pePiece.clearRequested(thisBlock);
            }
        }
        if (requested > 0 && pePiece.getAvailability() <= this.globalMinOthers && this.calcRarestAllowed() > 0 && !this.rarestStartedPieces.contains(pePiece)) {
            this.rarestStartedPieces.add(pePiece);
        }
        return requested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean findRTAPieceToDownload(PEPeerTransport pt, boolean best_uploader, long best_uploader_next_block_eta) {
        boolean bl;
        block20: {
            block21: {
                block22: {
                    if (pt == null || pt.getPeerState() != 30) {
                        return false;
                    }
                    BitFlags peerHavePieces = pt.getAvailable();
                    if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                        return false;
                    }
                    String rta_log_str = null;
                    try {
                        RealTimeData rtd;
                        int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1024;
                        int startI = peerHavePieces.start;
                        int endI = peerHavePieces.end;
                        int piece_min_rta_index = -1;
                        int piece_min_rta_block = 0;
                        long piece_min_rta_time = Long.MAX_VALUE;
                        long now = SystemTime.getCurrentTime();
                        long my_next_block_eta = now + (long)this.getNextBlockETAFromNow(pt);
                        block5: for (int i = startI; i <= endI; ++i) {
                            boolean try_allocate_even_though_late;
                            PEPiece pePiece;
                            DiskManagerPiece dmPiece;
                            long piece_rta = this.provider_piece_rtas[i];
                            if (!peerHavePieces.flags[i] || this.startPriorities[i] != 9999999 || piece_rta <= 0L || !(dmPiece = this.dmPieces[i]).isDownloadable() || (pePiece = this.pePieces[i]) != null && pePiece.isDownloaded()) continue;
                            Object realtime_data = null;
                            boolean bl2 = try_allocate_even_though_late = my_next_block_eta > piece_rta && best_uploader_next_block_eta > piece_rta;
                            if (piece_rta >= piece_min_rta_time || my_next_block_eta > piece_rta && !best_uploader && best_uploader_next_block_eta <= piece_rta) continue;
                            if (pePiece == null || (realtime_data = pePiece.getRealTimeData()) == null) {
                                piece_min_rta_time = piece_rta;
                                piece_min_rta_index = i;
                                piece_min_rta_block = 0;
                                continue;
                            }
                            RealTimeData rtd2 = (RealTimeData)realtime_data;
                            List[] peer_requests = rtd2.getRequests();
                            for (int j = 0; j < peer_requests.length; ++j) {
                                if (pePiece.isDownloaded(j) || pePiece.isWritten(j)) continue;
                                List block_peer_requests = peer_requests[j];
                                long best_eta = Long.MAX_VALUE;
                                boolean pt_already_present = false;
                                Iterator it = block_peer_requests.iterator();
                                while (it.hasNext()) {
                                    RealTimePeerRequest pr = (RealTimePeerRequest)it.next();
                                    PEPeerTransport this_pt = pr.getPeer();
                                    if (this_pt.getPeerState() != 30) {
                                        it.remove();
                                        continue;
                                    }
                                    DiskManagerReadRequest this_request = pr.getRequest();
                                    int request_index = this_pt.getRequestIndex(this_request);
                                    if (request_index == -1) {
                                        it.remove();
                                        continue;
                                    }
                                    if (this_pt == pt) {
                                        pt_already_present = true;
                                        break;
                                    }
                                    long this_up_bps = this_pt.getStats().getDataReceiveRate();
                                    if (this_up_bps < 1L) {
                                        this_up_bps = 1L;
                                    }
                                    int next_block_bytes = (request_index + 1) * 16384;
                                    long this_peer_eta = now + (long)(next_block_bytes * 1000) / this_up_bps;
                                    best_eta = Math.min(best_eta, this_peer_eta);
                                }
                                if (pt_already_present) continue;
                                if (block_peer_requests.size() == 0) {
                                    piece_min_rta_time = piece_rta;
                                    piece_min_rta_index = i;
                                    piece_min_rta_block = j;
                                    continue block5;
                                }
                                if (best_eta <= piece_rta || !best_uploader && try_allocate_even_though_late || my_next_block_eta >= best_eta) continue;
                                piece_min_rta_time = piece_rta;
                                piece_min_rta_index = i;
                                piece_min_rta_block = j;
                                continue block5;
                            }
                        }
                        if (piece_min_rta_index == -1) break block20;
                        if (this.dispenser.dispense(1, 16384) != 1 && (!pt.isLANLocal() || includeLanPeersInReqLimiting)) break block21;
                        PEPiece pePiece = this.pePieces[piece_min_rta_index];
                        if (pePiece == null) {
                            pePiece = new PEPieceImpl(pt.getManager(), this.dmPieces[piece_min_rta_index], peerSpeed >> 1);
                            this.peerControl.addPiece(pePiece, piece_min_rta_index, pt);
                            pePiece.setResumePriority(9999999);
                            if (this.availability[piece_min_rta_index] <= this.globalMinOthers) {
                                ++this.nbRarestActive;
                            }
                        }
                        if ((rtd = (RealTimeData)pePiece.getRealTimeData()) == null) {
                            rtd = new RealTimeData(pePiece);
                            pePiece.setRealTimeData(rtd);
                        }
                        pePiece.getAndMarkBlock(pt, piece_min_rta_block);
                        DiskManagerReadRequest request2 = pt.request(piece_min_rta_index, piece_min_rta_block * 16384, pePiece.getBlockSize(piece_min_rta_block), true);
                        if (request2 == null) break block22;
                        List real_time_requests = rtd.getRequests()[piece_min_rta_block];
                        real_time_requests.add(new RealTimePeerRequest(pt, request2));
                        pt.setLastPiece(piece_min_rta_index);
                        pePiece.setLastRequestedPeerSpeed(peerSpeed);
                        boolean bl3 = true;
                        Object var43_39 = null;
                        return bl3;
                    }
                    catch (Throwable throwable) {
                        Object var43_43 = null;
                        throw throwable;
                    }
                }
                if (!pt.isLANLocal() || includeLanPeersInReqLimiting) {
                    this.dispenser.returnUnusedChunks(1, 16384);
                }
                boolean bl4 = false;
                Object var43_40 = null;
                return bl4;
            }
            bl = false;
            Object var43_41 = null;
            return bl;
        }
        bl = false;
        Object var43_42 = null;
        return bl;
    }

    private final int getRequestCandidate(PEPeerTransport pt) {
        int[] g_hint;
        int request_hint_piece_number;
        if (pt == null || pt.getPeerState() != 30) {
            return -1;
        }
        BitFlags peerHavePieces = pt.getAvailable();
        if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
            return -1;
        }
        int[] reservedPieceNumbers = pt.getReservedPieceNumbers();
        if (reservedPieceNumbers != null) {
            for (int reservedPieceNumber : reservedPieceNumbers) {
                String peerReserved;
                PEPiece pePiece = this.pePieces[reservedPieceNumber];
                if (pePiece != null && (peerReserved = pePiece.getReservedBy()) != null && peerReserved.equals(pt.getIp())) {
                    if (peerHavePieces.flags[reservedPieceNumber] && pePiece.isRequestable()) {
                        return reservedPieceNumber;
                    }
                    pePiece.setReservedBy(null);
                }
                pt.removeReservedPieceNumber(reservedPieceNumber);
            }
        }
        int reservedPieceNumber = -1;
        int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1024;
        int lastPiece = pt.getLastPiece();
        int nbSnubbed = this.peerControl.getNbPeersSnubbed();
        long resumeMinAvail = Long.MAX_VALUE;
        int resumeMaxPriority = Integer.MIN_VALUE;
        boolean resumeIsRarest = false;
        int secondChoiceResume = -1;
        BitFlags startCandidates = null;
        int startMaxPriority = Integer.MIN_VALUE;
        int startMinAvail = Integer.MAX_VALUE;
        boolean startIsRarest = false;
        boolean forceStart = false;
        int avail = 0;
        boolean rarestAllowed = this.calcRarestAllowed() > 0;
        int startI = peerHavePieces.start;
        int endI = peerHavePieces.end;
        int[] peerPriorities = pt.getPriorityOffsets();
        long now = SystemTime.getCurrentTime();
        int[] request_hint = pt.getRequestHint();
        if (request_hint != null) {
            request_hint_piece_number = request_hint[0];
            if (this.dmPieces[request_hint_piece_number].isDone()) {
                pt.clearRequestHint();
                request_hint_piece_number = -1;
            }
        } else {
            request_hint_piece_number = -1;
        }
        if (request_hint_piece_number == -1 && (g_hint = this.global_request_hint) != null && this.dmPieces[request_hint_piece_number = g_hint[0]].isDone()) {
            g_hint = null;
            request_hint_piece_number = -1;
        }
        CopyOnWriteSet<Integer> forced = this.forced_pieces;
        for (int i = startI; i <= endI; ++i) {
            PEPiece pePiece;
            if (!peerHavePieces.flags[i]) continue;
            int priority = this.startPriorities[i];
            DiskManagerPiece dmPiece = this.dmPieces[i];
            if (priority < 0 || !dmPiece.isDownloadable()) continue;
            if (peerPriorities != null) {
                int peer_priority = peerPriorities[i];
                if (peer_priority < 0) continue;
                priority += peer_priority;
            }
            if (enable_request_hints && i == request_hint_piece_number) {
                priority += 3000;
                PEPiece pePiece2 = this.pePieces[i];
                if (pePiece2 == null) {
                    forceStart = true;
                } else {
                    pePiece2.setReservedBy(pt.getIp());
                    pt.addReservedPieceNumber(i);
                }
            }
            if ((pePiece = this.pePieces[i]) != null && !pePiece.isRequestable()) continue;
            boolean pieceRarestOverride = priority >= 9000 ? true : rarestAllowed;
            avail = this.availability[i];
            if (avail == 0) {
                this.availability[i] = 1;
                avail = 1;
            } else if (forced != null && forced.contains(i)) {
                avail = this.globalMinOthers;
            }
            if (pePiece != null) {
                if (priority != this.startPriorities[i]) {
                    pePiece.setResumePriority(priority);
                }
                boolean startedRarest = this.rarestStartedPieces.contains(pePiece);
                boolean rarestPrio = avail <= this.globalMinOthers && (startedRarest || rarestAllowed);
                int freeReqs = pePiece.getNbUnrequested();
                if (freeReqs <= 0) {
                    pePiece.setRequested();
                    continue;
                }
                String peerReserved = pePiece.getReservedBy();
                if (peerReserved != null) {
                    if (!peerReserved.equals(pt.getIp())) continue;
                    pt.addReservedPieceNumber(i);
                    return i;
                }
                int pieceSpeed = pePiece.getSpeed();
                boolean mayResume = true;
                if (pt.isSnubbed()) {
                    mayResume &= pieceSpeed < 1;
                    mayResume &= freeReqs > 2 || avail <= nbSnubbed;
                } else {
                    mayResume &= freeReqs * peerSpeed >= pieceSpeed / 2;
                    mayResume &= peerSpeed < 2 || pieceSpeed > 0 || pePiece.getNbRequests() == 0;
                    mayResume |= i == pt.getLastPiece();
                }
                if (secondChoiceResume == -1 || avail > this.availability[secondChoiceResume]) {
                    secondChoiceResume = i;
                }
                if (!mayResume || (long)avail > resumeMinAvail) continue;
                priority += pieceSpeed;
                priority += i == lastPiece ? 700 : 0;
                priority = (int)((long)priority + pePiece.getTimeSinceLastActivity() / 120000L);
                long pieceAge = now - pePiece.getCreationTime();
                if (pieceAge > 0L) {
                    priority = (int)((long)priority + 900L * pieceAge / (long)(60000 * dmPiece.getNbBlocks()));
                }
                pePiece.setResumePriority(priority += 900 * dmPiece.getNbWritten() / dmPiece.getNbBlocks());
                if ((long)avail >= resumeMinAvail && ((long)avail != resumeMinAvail || priority <= resumeMaxPriority) || !pePiece.hasUnrequestedBlock()) continue;
                reservedPieceNumber = i;
                resumeMinAvail = avail;
                resumeMaxPriority = priority;
                resumeMinAvail = avail;
                resumeIsRarest = rarestPrio;
                continue;
            }
            if (avail <= this.globalMinOthers && rarestAllowed) {
                if (!startIsRarest) {
                    if (startCandidates == null) {
                        startCandidates = new BitFlags(this.nbPieces);
                    }
                    startMaxPriority = priority;
                    startMinAvail = avail;
                    startIsRarest = avail <= this.globalMinOthers;
                    startCandidates.setOnly(i);
                    continue;
                }
                if (priority > startMaxPriority) {
                    if (startCandidates == null) {
                        startCandidates = new BitFlags(this.nbPieces);
                    }
                    startMaxPriority = priority;
                    startCandidates.setOnly(i);
                    continue;
                }
                if (priority != startMaxPriority) continue;
                startCandidates.setEnd(i);
                continue;
            }
            if (startIsRarest && rarestAllowed) continue;
            if (priority > startMaxPriority) {
                if (startCandidates == null) {
                    startCandidates = new BitFlags(this.nbPieces);
                }
                startMaxPriority = priority;
                startMinAvail = avail;
                startIsRarest = avail <= this.globalMinOthers;
                startCandidates.setOnly(i);
                continue;
            }
            if (priority != startMaxPriority) continue;
            if (startCandidates == null) {
                startCandidates = new BitFlags(this.nbPieces);
            }
            if (avail < startMinAvail) {
                startMinAvail = avail;
                startIsRarest = avail <= this.globalMinOthers;
                startCandidates.setOnly(i);
                continue;
            }
            if (avail != startMinAvail) continue;
            startCandidates.setEnd(i);
        }
        if (!forceStart || startCandidates == null || startCandidates.nbSet <= 0) {
            if (!(reservedPieceNumber < 0 || !resumeIsRarest && startIsRarest && rarestAllowed && startCandidates != null && startCandidates.nbSet > 0)) {
                return reservedPieceNumber;
            }
            if (secondChoiceResume != -1 && (startCandidates == null || startCandidates.nbSet <= 0)) {
                return secondChoiceResume;
            }
            if (reservedPieceNumber >= 0 && this.globalMinOthers > 0 && this.peerControl.getNbActivePieces() > 32) {
                boolean resumeIsBetter;
                boolean bl = resumeIsBetter = (long)resumeMaxPriority / resumeMinAvail > (long)(startMaxPriority / this.globalMinOthers);
                if (Constants.isCVSVersion() && Logger.isEnabled()) {
                    Logger.log(new LogEvent(new Object[]{pt, this.peerControl}, LOGID, "Start/resume choice; piece #:" + reservedPieceNumber + " resumeIsBetter:" + resumeIsBetter + " globalMinOthers=" + this.globalMinOthers + " startMaxPriority=" + startMaxPriority + " startMinAvail=" + startMinAvail + " resumeMaxPriority=" + resumeMaxPriority + " resumeMinAvail=" + resumeMinAvail + " : " + pt));
                }
                if (resumeIsBetter) {
                    return reservedPieceNumber;
                }
            }
        }
        return this.getPieceToStart(startCandidates);
    }

    protected final int getPieceToStart(BitFlags startCandidates) {
        if (startCandidates == null || startCandidates.nbSet <= 0) {
            return -1;
        }
        if (startCandidates.nbSet == 1) {
            return startCandidates.start;
        }
        int direction = RandomUtils.generateRandomPlusMinus1();
        int startI = direction == 1 ? startCandidates.start : startCandidates.end;
        int targetNb = RandomUtils.generateRandomIntUpto(startCandidates.nbSet);
        int foundNb = -1;
        for (int i = startI; i <= startCandidates.end && i >= startCandidates.start; i += direction) {
            if (!startCandidates.flags[i] || ++foundNb < targetNb) continue;
            return i;
        }
        return -1;
    }

    public final boolean hasDownloadablePiece() {
        return this.hasNeededUndonePiece;
    }

    public final long getNeededUndonePieceChange() {
        return this.neededUndonePieceChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkEndGameMode() {
        long trigger;
        if (this.peerControl.getNbSeeds() + this.peerControl.getNbPeers() < 3) {
            return;
        }
        long mono_now = SystemTime.getMonotonousTime();
        if (this.endGameMode || this.endGameModeAbandoned) {
            if (!this.endGameModeAbandoned && mono_now - this.timeEndGameModeEntered > 76800L) {
                this.abandonEndGameMode();
            }
            return;
        }
        int active_pieces = 0;
        int reserved_pieces = 0;
        for (int i = 0; i < this.nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dmPieces[i];
            if (!dmPiece.isDownloadable()) continue;
            PEPiece pePiece = this.pePieces[i];
            if (pePiece != null) {
                if (pePiece.isDownloaded()) continue;
                if (dmPiece.isNeeded()) {
                    if (pePiece.isRequested()) {
                        ++active_pieces;
                        continue;
                    }
                    if (pePiece.getReservedBy() != null) {
                        if ((long)(++reserved_pieces * this.diskManager.getPieceLength()) <= 0x500000L) continue;
                        return;
                    }
                }
            }
            return;
        }
        boolean use_rta_egm = this.rta_providers.size() > 0;
        long remaining = (long)active_pieces * (long)this.diskManager.getPieceLength();
        long l = trigger = use_rta_egm ? 262144L : 0x1400000L;
        if (remaining <= trigger) {
            try {
                this.endGameModeChunks_mon.enter();
                this.endGameModeChunks = new ArrayList();
                this.timeEndGameModeEntered = mono_now;
                this.endGameMode = true;
                this.computeEndGameModeChunks();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Entering end-game mode: " + this.peerControl.getDisplayName()));
                }
                Object var11_9 = null;
                this.endGameModeChunks_mon.exit();
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                this.endGameModeChunks_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void computeEndGameModeChunks() {
        try {
            this.endGameModeChunks_mon.enter();
            for (int i = 0; i < this.nbPieces; ++i) {
                int j;
                boolean[] written;
                DiskManagerPiece dmPiece = this.dmPieces[i];
                if (!dmPiece.isInteresting()) continue;
                PEPiece pePiece = this.pePieces[i];
                if (pePiece == null) {
                    pePiece = new PEPieceImpl(this.peerControl, dmPiece, 0);
                    this.peerControl.addPiece(pePiece, i, null);
                }
                if ((written = dmPiece.getWritten()) == null) {
                    if (dmPiece.isDone()) continue;
                    for (j = 0; j < pePiece.getNbBlocks(); ++j) {
                        this.endGameModeChunks.add(new EndGameModeChunk(pePiece, j));
                    }
                    continue;
                }
                for (j = 0; j < written.length; ++j) {
                    if (written[j]) continue;
                    this.endGameModeChunks.add(new EndGameModeChunk(pePiece, j));
                }
            }
            Object var7_6 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    public final boolean isInEndGameMode() {
        return this.endGameMode;
    }

    public boolean hasEndGameModeBeenAbandoned() {
        return this.endGameModeAbandoned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEndGameChunks(PEPiece pePiece) {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            int nbChunks = pePiece.getNbBlocks();
            for (int i = 0; i < nbChunks; ++i) {
                this.endGameModeChunks.add(new EndGameModeChunk(pePiece, i));
            }
            Object var5_4 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int findPieceInEndGameMode(PEPeerTransport pt, int wants) {
        block6: {
            block8: {
                int pieceNumber;
                EndGameModeChunk chunk;
                block7: {
                    if (pt == null || wants <= 0 || pt.getPeerState() != 30) {
                        return 0;
                    }
                    try {
                        this.endGameModeChunks_mon.enter();
                        int nbChunks = this.endGameModeChunks.size();
                        if (nbChunks <= 0) break block6;
                        int random = RandomUtils.generateRandomIntUpto(nbChunks);
                        chunk = (EndGameModeChunk)this.endGameModeChunks.get(random);
                        pieceNumber = chunk.getPieceNumber();
                        if (!this.dmPieces[pieceNumber].isWritten(chunk.getBlockNumber())) break block7;
                        this.endGameModeChunks.remove(chunk);
                        int n = 0;
                        Object var10_9 = null;
                        this.endGameModeChunks_mon.exit();
                        return n;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        this.endGameModeChunks_mon.exit();
                        throw throwable;
                    }
                }
                PEPiece pePiece = this.pePieces[pieceNumber];
                if (!pt.isPieceAvailable(pieceNumber) || pePiece == null) break block6;
                if (pt.isSnubbed() && this.availability[pieceNumber] > this.peerControl.getNbPeersSnubbed() || pt.request(pieceNumber, chunk.getOffset(), chunk.getLength(), false) == null) break block8;
                pePiece.setRequested(pt, chunk.getBlockNumber());
                pt.setLastPiece(pieceNumber);
                int n = 1;
                Object var10_10 = null;
                this.endGameModeChunks_mon.exit();
                return n;
            }
            int n = 0;
            Object var10_11 = null;
            this.endGameModeChunks_mon.exit();
            return n;
        }
        this.leaveEndGameMode();
        Object var10_12 = null;
        this.endGameModeChunks_mon.exit();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFromEndGameModeChunks(int pieceNumber, int offset) {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            Iterator iter = this.endGameModeChunks.iterator();
            while (iter.hasNext()) {
                EndGameModeChunk chunk = (EndGameModeChunk)iter.next();
                if (!chunk.equals(pieceNumber, offset)) continue;
                iter.remove();
            }
            Object var6_5 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearEndGameChunks() {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            this.endGameModeChunks.clear();
            this.endGameMode = false;
            Object var2_1 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leaveEndGameMode() {
        try {
            this.endGameModeChunks_mon.enter();
            if (this.endGameMode) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Leaving end-game mode: " + this.peerControl.getDisplayName()));
                }
                this.endGameMode = false;
                this.endGameModeChunks.clear();
                this.timeEndGameModeEntered = 0L;
            }
            Object var2_1 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abandonEndGameMode() {
        if (!this.endGameModeAbandoned) {
            try {
                this.endGameModeChunks_mon.enter();
                this.endGameModeAbandoned = true;
                this.endGameMode = false;
                this.clearEndGameChunks();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Abandoning end-game mode: " + this.peerControl.getDisplayName()));
                }
                Object var2_1 = null;
                this.endGameModeChunks_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.endGameModeChunks_mon.exit();
                throw throwable;
            }
        }
    }

    private boolean computeProviderPriorities() {
        List rta_ps;
        List p_ps = this.priority_providers.getList();
        if (p_ps.size() == 0) {
            if (this.provider_piece_priorities != null) {
                ++paramPriorityChange;
                this.provider_piece_priorities = null;
            }
        } else {
            ++paramPriorityChange;
            this.provider_piece_priorities = new long[this.nbPieces];
            for (int i = 0; i < p_ps.size(); ++i) {
                PiecePriorityProvider shaper = (PiecePriorityProvider)p_ps.get(i);
                long[] priorities = shaper.updatePriorities(this);
                if (priorities == null) continue;
                for (int j = 0; j < priorities.length; ++j) {
                    long priority = priorities[j];
                    if (priority == 0L) continue;
                    int n = j;
                    this.provider_piece_priorities[n] = this.provider_piece_priorities[n] + priority;
                }
            }
        }
        if ((rta_ps = this.rta_providers.getList()).size() == 0) {
            if (this.provider_piece_rtas != null) {
                for (int i = 0; i < this.pePieces.length; ++i) {
                    PEPiece piece = this.pePieces[i];
                    if (piece == null) continue;
                    piece.setRealTimeData(null);
                }
                this.provider_piece_rtas = null;
            }
            return false;
        }
        boolean has_rta = false;
        this.provider_piece_rtas = new long[this.nbPieces];
        for (int i = 0; i < rta_ps.size(); ++i) {
            PieceRTAProvider shaper = (PieceRTAProvider)rta_ps.get(i);
            long[] offsets = shaper.updateRTAs(this);
            if (offsets == null) continue;
            for (int j = 0; j < offsets.length; ++j) {
                long rta = offsets[j];
                if (rta <= 0L) continue;
                this.provider_piece_rtas[j] = this.provider_piece_rtas[j] == 0L ? rta : Math.min(this.provider_piece_rtas[j], rta);
                has_rta = true;
            }
        }
        return has_rta;
    }

    public void addRTAProvider(PieceRTAProvider provider2) {
        this.rta_providers.add(provider2);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((PiecePickerListener)it.next()).providerAdded(provider2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        this.leaveEndGameMode();
    }

    public void removeRTAProvider(PieceRTAProvider provider2) {
        this.rta_providers.remove(provider2);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((PiecePickerListener)it.next()).providerRemoved(provider2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public List getRTAProviders() {
        return this.rta_providers.getList();
    }

    public void addPriorityProvider(PiecePriorityProvider provider2) {
        this.priority_providers.add(provider2);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((PiecePickerListener)it.next()).providerAdded(provider2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void removePriorityProvider(PiecePriorityProvider provider2) {
        this.priority_providers.remove(provider2);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((PiecePickerListener)it.next()).providerRemoved(provider2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public List getPriorityProviders() {
        return this.rta_providers.getList();
    }

    public void addListener(PiecePickerListener listener) {
        this.listeners.add(listener);
        Iterator it = this.rta_providers.iterator();
        while (it.hasNext()) {
            listener.providerAdded((PieceRTAProvider)it.next());
        }
    }

    public void removeListener(PiecePickerListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForcePiece(int pieceNumber, boolean forced) {
        if (pieceNumber < 0 || pieceNumber >= this.nbPieces) {
            Debug.out("Invalid piece number: " + pieceNumber);
            return;
        }
        PiecePickerImpl piecePickerImpl = this;
        synchronized (piecePickerImpl) {
            CopyOnWriteSet<Integer> set = this.forced_pieces;
            if (set == null) {
                if (!forced) {
                    return;
                }
                set = new CopyOnWriteSet(false);
                this.forced_pieces = set;
            }
            if (forced) {
                set.add(pieceNumber);
            } else {
                set.remove(pieceNumber);
                if (set.size() == 0) {
                    this.forced_pieces = null;
                }
            }
        }
        ++paramPriorityChange;
        this.computeBasePriorities();
    }

    public boolean isForcePiece(int pieceNumber) {
        if (pieceNumber < 0 || pieceNumber >= this.nbPieces) {
            Debug.out("Invalid piece number: " + pieceNumber);
            return false;
        }
        CopyOnWriteSet<Integer> set = this.forced_pieces;
        return set != null && set.contains(pieceNumber);
    }

    public void setGlobalRequestHint(int piece_number, int start_bytes, int byte_count) {
        this.global_request_hint = (int[])(piece_number < 0 ? null : new int[]{piece_number, start_bytes, byte_count});
    }

    public int[] getGlobalRequestHint() {
        return this.global_request_hint;
    }

    public void setReverseBlockOrder(boolean is_reverse) {
        this.reverse_block_order = is_reverse;
    }

    public boolean getReverseBlockOrder() {
        return this.reverse_block_order;
    }

    public void destroy() {
    }

    public String getPieceString(int piece_number) {
        CopyOnWriteSet<Integer> forced;
        String str;
        long priority;
        long l = priority = this.startPriorities == null ? 0L : (long)this.startPriorities[piece_number];
        if (priority == 9999999L) {
            long[] rta = this.provider_piece_rtas;
            str = "pri=rta:" + (rta == null ? "?" : "" + (rta[piece_number] - SystemTime.getCurrentTime()));
        } else {
            PEPiece pe_piece = this.pePieces[piece_number];
            if (pe_piece != null) {
                priority = pe_piece.getResumePriority();
            }
            str = "pri=" + priority;
        }
        str = str + ",avail=" + this.availability[piece_number];
        long[] exts = this.provider_piece_priorities;
        if (exts != null) {
            str = str + ",ext=" + exts[piece_number];
        }
        if ((forced = this.forced_pieces) != null && forced.contains(piece_number)) {
            str = str + ", forced";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println("Piece Picker");
        try {
            writer.indent();
            writer.println("globalAvail: " + this.globalAvail);
            writer.println("globalAvgAvail: " + this.globalAvgAvail);
            writer.println("nbRarestActive: " + this.nbRarestActive);
            writer.println("globalMin: " + this.globalMin);
            writer.println("globalMinOthers: " + this.globalMinOthers);
            writer.println("hasNeededUndonePiece: " + this.hasNeededUndonePiece);
            writer.println("endGameMode: " + this.endGameMode);
            writer.println("endGameModeAbandoned: " + this.endGameModeAbandoned);
            writer.println("endGameModeChunks: " + this.endGameModeChunks);
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }

    static {
        class ParameterListenerImpl
        implements ParameterListener {
            ParameterListenerImpl() {
            }

            public final void parameterChanged(String parameterName) {
                if (parameterName.equals("Prioritize Most Completed Files")) {
                    completionPriority = COConfigurationManager.getBooleanParameter(parameterName);
                    ++paramPriorityChange;
                } else if (parameterName.equals("Prioritize First Piece")) {
                    firstPiecePriority = COConfigurationManager.getBooleanParameter(parameterName);
                    ++paramPriorityChange;
                } else if (parameterName.equals("Piece Picker Request Hint Enabled")) {
                    enable_request_hints = COConfigurationManager.getBooleanParameter(parameterName);
                }
                includeLanPeersInReqLimiting = !COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
            }
        }
        ParameterListenerImpl parameterListener = new ParameterListenerImpl();
        COConfigurationManager.addParameterListener("Prioritize Most Completed Files", (ParameterListener)parameterListener);
        COConfigurationManager.addAndFireParameterListener("Prioritize First Piece", parameterListener);
        COConfigurationManager.addAndFireParameterListener("Piece Picker Request Hint Enabled", parameterListener);
        COConfigurationManager.addAndFireParameterListener("LAN Speed Enabled", parameterListener);
    }

    private class DiskManagerListenerImpl
    implements DiskManagerListener {
        private DiskManagerListenerImpl() {
        }

        public final void stateChanged(int oldState, int newState) {
        }

        public final void filePriorityChanged(DiskManagerFileInfo file) {
            int endI;
            int startI;
            PiecePickerImpl.this.syncFilePriorities();
            ++PiecePickerImpl.this.filePriorityChange;
            boolean foundPieceToDownload = false;
            if (PiecePickerImpl.this.hasNeededUndonePiece) {
                startI = 0;
                endI = PiecePickerImpl.this.nbPieces;
            } else {
                startI = file.getFirstPieceNumber();
                endI = file.getLastPieceNumber() + 1;
            }
            for (int i = startI; i < endI; ++i) {
                DiskManagerPiece dmPiece = PiecePickerImpl.this.dmPieces[i];
                if (dmPiece.isDone()) continue;
                foundPieceToDownload |= dmPiece.calcNeeded();
            }
            if (foundPieceToDownload ^ PiecePickerImpl.this.hasNeededUndonePiece) {
                PiecePickerImpl.this.hasNeededUndonePiece = foundPieceToDownload;
                ++PiecePickerImpl.this.neededUndonePieceChange;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void pieceDoneChanged(DiskManagerPiece dmPiece) {
            int pieceNumber = dmPiece.getPieceNumber();
            if (dmPiece.isDone()) {
                PiecePickerImpl.this.addHavePiece(null, pieceNumber);
                ++PiecePickerImpl.this.nbPiecesDone;
                if (PiecePickerImpl.this.nbPiecesDone >= PiecePickerImpl.this.nbPieces) {
                    PiecePickerImpl.this.checkDownloadablePiece();
                }
            } else {
                try {
                    PiecePickerImpl.this.availabilityMon.enter();
                    if (PiecePickerImpl.this.availabilityAsynch == null) {
                        PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                    }
                    if (PiecePickerImpl.this.availabilityAsynch[pieceNumber] > 0) {
                        int n = pieceNumber;
                        PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] - 1;
                    } else {
                        ++PiecePickerImpl.this.availabilityDrift;
                    }
                    ++PiecePickerImpl.this.availabilityChange;
                    Object var4_3 = null;
                    PiecePickerImpl.this.availabilityMon.exit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    PiecePickerImpl.this.availabilityMon.exit();
                    throw throwable;
                }
                --PiecePickerImpl.this.nbPiecesDone;
                if (dmPiece.calcNeeded() && !PiecePickerImpl.this.hasNeededUndonePiece) {
                    PiecePickerImpl.this.hasNeededUndonePiece = true;
                    ++PiecePickerImpl.this.neededUndonePieceChange;
                }
            }
        }

        public final void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
        }
    }

    private class PEPeerListenerImpl
    implements PEPeerListener {
        private PEPeerListenerImpl() {
        }

        public final void stateChanged(PEPeer peer, int newState) {
        }

        public final void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
            if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                for (int i = peerHavePieces.start; i <= peerHavePieces.end; ++i) {
                    if (!peerHavePieces.flags[i]) continue;
                    int n = i;
                    PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] + 1;
                }
                ++PiecePickerImpl.this.availabilityChange;
                Object var5_4 = null;
                PiecePickerImpl.this.availabilityMon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                PiecePickerImpl.this.availabilityMon.exit();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
            if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                for (int i = peerHavePieces.start; i <= peerHavePieces.end; ++i) {
                    if (!peerHavePieces.flags[i]) continue;
                    if (PiecePickerImpl.this.availabilityAsynch[i] > (PiecePickerImpl.this.dmPieces[i].isDone() ? 1 : 0)) {
                        int n = i;
                        PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] - 1;
                        continue;
                    }
                    ++PiecePickerImpl.this.availabilityDrift;
                }
                ++PiecePickerImpl.this.availabilityChange;
                Object var5_4 = null;
                PiecePickerImpl.this.availabilityMon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                PiecePickerImpl.this.availabilityMon.exit();
                throw throwable;
            }
        }
    }

    private class PEPeerManagerListenerImpl
    extends PEPeerManagerListenerAdapter {
        private PEPeerManagerListenerImpl() {
        }

        public final void peerAdded(PEPeerManager manager, PEPeer peer) {
            PEPeerListenerImpl peerListener = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.get(peer);
            if (peerListener == null) {
                peerListener = new PEPeerListenerImpl();
                PiecePickerImpl.this.peerListeners.put(peer, peerListener);
            }
            peer.addListener(peerListener);
        }

        public final void peerRemoved(PEPeerManager manager, PEPeer peer) {
            PEPeerListenerImpl peerListener = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.remove(peer);
            peer.removeListener(peerListener);
        }
    }

    protected static class RealTimeData {
        private List[] peer_requests;

        protected RealTimeData(PEPiece piece) {
            int nb = piece.getNbBlocks();
            this.peer_requests = new List[nb];
            for (int i = 0; i < this.peer_requests.length; ++i) {
                this.peer_requests[i] = new ArrayList(1);
            }
        }

        public final List[] getRequests() {
            return this.peer_requests;
        }
    }

    private static class RealTimePeerRequest {
        private PEPeerTransport peer;
        private DiskManagerReadRequest request;

        protected RealTimePeerRequest(PEPeerTransport _peer, DiskManagerReadRequest _request) {
            this.peer = _peer;
            this.request = _request;
        }

        protected PEPeerTransport getPeer() {
            return this.peer;
        }

        protected DiskManagerReadRequest getRequest() {
            return this.request;
        }
    }
}

