/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.png;

import com.aelitis.azureus.core.util.png.IDATChunk;
import com.aelitis.azureus.core.util.png.IENDChunk;
import com.aelitis.azureus.core.util.png.IHDRChunk;
import com.aelitis.azureus.core.util.png.PngSignatureChunk;
import java.nio.ByteBuffer;

public class PNG {
    public static byte[] getPNGBytesForWidth(int width) {
        return PNG.getPNGBytesForSize(width, 1);
    }

    public static byte[] getPNGBytesForSize(int width, int height) {
        byte[] signature = new PngSignatureChunk().getChunkPayload();
        byte[] ihdr = new IHDRChunk(width, height).getChunkPayload();
        byte[] idat = new IDATChunk(width, height).getChunkPayload();
        byte[] iend = new IENDChunk().getChunkPayload();
        ByteBuffer buffer = ByteBuffer.allocate(signature.length + ihdr.length + idat.length + iend.length);
        buffer.put(signature);
        buffer.put(ihdr);
        buffer.put(idat);
        buffer.put(iend);
        buffer.position(0);
        return buffer.array();
    }
}

