/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.proxy.impl.AEPluginProxyHandler;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginUtils;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginViewInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPluginBeta {
    public static final boolean DEBUG_ENABLED = System.getProperty("az.chat.buddy.debug", "0").equals("1");
    public static final boolean BETA_CHAN_ENABLED = System.getProperty("az.chat.buddy.beta.chan", "1").equals("1");
    public static final String BETA_CHAT_KEY = "test:beta:chat";
    public static final int PRIVATE_CHAT_DISABLED = 1;
    public static final int PRIVATE_CHAT_PINNED_ONLY = 2;
    public static final int PRIVATE_CHAT_ENABLED = 3;
    private static final String FLAGS_MSG_STATUS_KEY = "s";
    private static final int FLAGS_MSG_STATUS_CHAT_NONE = 0;
    private static final int FLAGS_MSG_STATUS_CHAT_QUIT = 1;
    public static final String FLAGS_MSG_ORIGIN_KEY = "o";
    public static final int FLAGS_MSG_ORIGIN_USER = 0;
    public static final int FLAGS_MSG_ORIGIN_RATINGS = 1;
    public static final String FLAGS_MSG_FLASH_OVERRIDE = "f";
    public static final int FLAGS_MSG_FLASH_NO = 0;
    public static final int FLAGS_MSG_FLASH_YES = 1;
    private BuddyPlugin plugin;
    private PluginInterface plugin_interface;
    private BooleanParameter enabled;
    private AsyncDispatcher dispatcher = new AsyncDispatcher("BuddyPluginBeta");
    private Map<String, ChatInstance> chat_instances_map = new HashMap<String, ChatInstance>();
    private CopyOnWriteList<ChatInstance> chat_instances_list = new CopyOnWriteList();
    private PluginInterface azmsgsync_pi;
    private TimerEventPeriodic timer;
    private String shared_public_nickname;
    private String shared_anon_nickname;
    private int max_chat_ui_lines;
    private int max_chat_ui_kb;
    private int private_chat_state;
    private boolean shared_anon_endpoint;
    private boolean sound_enabled;
    private String sound_file;
    private Map<String, Long> favourite_map;
    private Map<String, Long> save_messages_map;
    private Map<String, Long> log_messages_map;
    private Map<String, byte[]> lmi_map;
    private CopyOnWriteList<FTUXStateChangeListener> ftux_listeners = new CopyOnWriteList();
    private boolean ftux_accepted = false;
    private CopyOnWriteList<ChatManagerListener> listeners = new CopyOnWriteList();
    private AtomicInteger private_chat_id = new AtomicInteger();
    private AESemaphore init_complete = new AESemaphore("bpb:init");

    protected BuddyPluginBeta(PluginInterface _pi, BuddyPlugin _plugin, BooleanParameter _enabled) {
        this.plugin_interface = _pi;
        this.plugin = _plugin;
        this.enabled = _enabled;
        this.ftux_accepted = COConfigurationManager.getBooleanParameter("azbuddy.dchat.ftux.accepted", false);
        this.shared_public_nickname = COConfigurationManager.getStringParameter("azbuddy.chat.shared_nick", "");
        this.shared_anon_nickname = COConfigurationManager.getStringParameter("azbuddy.chat.shared_anon_nick", "");
        this.private_chat_state = COConfigurationManager.getIntParameter("azbuddy.chat.private_chat_state", 3);
        this.shared_anon_endpoint = COConfigurationManager.getBooleanParameter("azbuddy.chat.share_i2p_endpoint", true);
        this.sound_enabled = COConfigurationManager.getBooleanParameter("azbuddy.chat.notif.sound.enable", true);
        this.sound_file = COConfigurationManager.getStringParameter("azbuddy.chat.notif.sound.file", "");
        this.favourite_map = COConfigurationManager.getMapParameter("azbuddy.dchat.favemap", new HashMap());
        this.save_messages_map = COConfigurationManager.getMapParameter("azbuddy.dchat.savemsgmap", new HashMap());
        this.log_messages_map = COConfigurationManager.getMapParameter("azbuddy.dchat.logmsgmap", new HashMap());
        this.lmi_map = COConfigurationManager.getMapParameter("azbuddy.dchat.lmimap", new HashMap());
        this.max_chat_ui_lines = COConfigurationManager.getIntParameter("azbuddy.dchat.ui.max.lines", 250);
        this.max_chat_ui_kb = COConfigurationManager.getIntParameter("azbuddy.dchat.ui.max.char.kb", 10);
        SimpleTimer.addPeriodicEvent("BPB:checkfave", 30000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                BuddyPluginBeta.this.checkFavourites();
            }
        });
    }

    public boolean isAvailable() {
        return this.plugin_interface.getPluginManager().getPluginInterfaceByID("azmsgsync", true) != null;
    }

    public boolean isInitialised() {
        return this.init_complete.isReleasedForever();
    }

    public int getMaxUILines() {
        return this.max_chat_ui_lines;
    }

    public void setMaxUILines(int num) {
        this.max_chat_ui_lines = num;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.max.lines", num);
        COConfigurationManager.setDirty();
    }

    public int getMaxUICharsKB() {
        return this.max_chat_ui_kb;
    }

    public void setMaxUICharsKB(int num) {
        this.max_chat_ui_kb = num;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.max.char.kb", num);
        COConfigurationManager.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFavourite(String net, String key) {
        Map<String, Long> map = this.favourite_map;
        synchronized (map) {
            Long l = this.favourite_map.get(net + ":" + key);
            if (l == null) {
                return false;
            }
            return l == 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFavourite(String net, String key, boolean b) {
        Map<String, Long> map = this.favourite_map;
        synchronized (map) {
            String net_key = net + ":" + key;
            Long existing = this.favourite_map.get(net_key);
            if (existing == null && !b) {
                return;
            }
            if (existing != null && b == (existing == 1L)) {
                return;
            }
            if (b) {
                this.favourite_map.put(net_key, 1L);
            } else {
                this.favourite_map.remove(net_key);
            }
            COConfigurationManager.setParameter("azbuddy.dchat.favemap", this.favourite_map);
        }
        COConfigurationManager.setDirty();
        this.checkFavourites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> getFavourites() {
        Map<String, Long> map = this.favourite_map;
        synchronized (map) {
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (Map.Entry<String, Long> entry : this.favourite_map.entrySet()) {
                String net_key = entry.getKey();
                Long value = entry.getValue();
                if (value != 1L) continue;
                String[] bits = net_key.split(":", 2);
                String network = AENetworkClassifier.internalise(bits[0]);
                String key = bits[1];
                result.add(new String[]{network, key});
            }
            return result;
        }
    }

    private void checkFavourites() {
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    String key;
                    String net;
                    List<String[]> faves = BuddyPluginBeta.this.getFavourites();
                    HashSet<String> set = new HashSet<String>();
                    for (String[] fave : faves) {
                        net = fave[0];
                        key = fave[1];
                        set.add(net + ":" + key);
                        ChatInstance chat = BuddyPluginBeta.this.peekChatInstance(net, key, false);
                        if (chat != null && chat.getKeepAlive()) continue;
                        try {
                            chat = BuddyPluginBeta.this.getChat(net, key);
                            chat.setKeepAlive(true);
                        }
                        catch (Throwable e) {}
                    }
                    for (ChatInstance chat : BuddyPluginBeta.this.chat_instances_list) {
                        if (!chat.getKeepAlive()) continue;
                        net = chat.getNetwork();
                        key = chat.getKey();
                        if (set.contains(net + ":" + key) || net == "Public" && key.equals(BuddyPluginBeta.BETA_CHAT_KEY)) continue;
                        chat.setKeepAlive(false);
                        chat.destroy();
                    }
                    Object var10_9 = null;
                    BuddyPluginBeta.this.init_complete.releaseForever();
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    BuddyPluginBeta.this.init_complete.releaseForever();
                    throw throwable;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSaveMessages(String net, String key) {
        Map<String, Long> map = this.save_messages_map;
        synchronized (map) {
            Long l = this.save_messages_map.get(net + ":" + key);
            if (l == null) {
                return false;
            }
            return l == 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSaveMessages(String net, String key, boolean b) {
        Map<String, Long> map = this.save_messages_map;
        synchronized (map) {
            String net_key = net + ":" + key;
            Long existing = this.save_messages_map.get(net_key);
            if (existing == null && !b) {
                return;
            }
            if (existing != null && b == (existing == 1L)) {
                return;
            }
            if (b) {
                this.save_messages_map.put(net_key, 1L);
            } else {
                this.save_messages_map.remove(net_key);
            }
            COConfigurationManager.setParameter("azbuddy.dchat.savemsgmap", this.save_messages_map);
        }
        COConfigurationManager.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLogMessages(String net, String key) {
        Map<String, Long> map = this.log_messages_map;
        synchronized (map) {
            Long l = this.log_messages_map.get(net + ":" + key);
            if (l == null) {
                return false;
            }
            return l == 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogMessages(String net, String key, boolean b) {
        Map<String, Long> map = this.log_messages_map;
        synchronized (map) {
            String net_key = net + ":" + key;
            Long existing = this.log_messages_map.get(net_key);
            if (existing == null && !b) {
                return;
            }
            if (existing != null && b == (existing == 1L)) {
                return;
            }
            if (b) {
                this.log_messages_map.put(net_key, 1L);
            } else {
                this.log_messages_map.remove(net_key);
            }
            COConfigurationManager.setParameter("azbuddy.dchat.logmsgmap", this.log_messages_map);
        }
        COConfigurationManager.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastMessageInfo(String net, String key) {
        Map<String, byte[]> map = this.lmi_map;
        synchronized (map) {
            byte[] info = this.lmi_map.get(net + ":" + key);
            if (info != null) {
                try {
                    return new String(info, "UTF-8");
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastMessageInfo(String net, String key, String info) {
        Map<String, byte[]> map = this.lmi_map;
        synchronized (map) {
            String net_key = net + ":" + key;
            try {
                this.lmi_map.put(net_key, info.getBytes("UTF-8"));
                COConfigurationManager.setParameter("azbuddy.dchat.lmimap", this.lmi_map);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        COConfigurationManager.setDirty();
    }

    public String getSharedPublicNickname() {
        return this.shared_public_nickname;
    }

    public void setSharedPublicNickname(String _nick) {
        if (!_nick.equals(this.shared_public_nickname)) {
            this.shared_public_nickname = _nick;
            COConfigurationManager.setParameter("azbuddy.chat.shared_nick", _nick);
            COConfigurationManager.setDirty();
            this.allUpdated();
        }
    }

    public String getSharedAnonNickname() {
        return this.shared_anon_nickname;
    }

    public void setSharedAnonNickname(String _nick) {
        if (!_nick.equals(this.shared_anon_nickname)) {
            this.shared_anon_nickname = _nick;
            COConfigurationManager.setParameter("azbuddy.chat.shared_anon_nick", _nick);
            COConfigurationManager.setDirty();
            this.allUpdated();
        }
    }

    public int getPrivateChatState() {
        return this.private_chat_state;
    }

    public void setPrivateChatState(int state) {
        if (state != this.private_chat_state) {
            this.private_chat_state = state;
            COConfigurationManager.setParameter("azbuddy.chat.private_chat_state", state);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    public boolean getSharedAnonEndpoint() {
        return this.shared_anon_endpoint;
    }

    public void setSharedAnonEndpoint(boolean b) {
        if (b != this.shared_anon_endpoint) {
            this.shared_anon_endpoint = b;
            COConfigurationManager.setParameter("azbuddy.chat.share_i2p_endpoint", b);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    public void setSoundEnabled(boolean b) {
        if (b != this.sound_enabled) {
            this.sound_enabled = b;
            COConfigurationManager.setParameter("azbuddy.chat.notif.sound.enable", b);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    public boolean getSoundEnabled() {
        return this.sound_enabled;
    }

    public String getSoundFile() {
        return this.sound_file;
    }

    public void setSoundFile(String _file) {
        if (!_file.equals(this.sound_file)) {
            this.sound_file = _file;
            COConfigurationManager.setParameter("azbuddy.chat.notif.sound.file", _file);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    private void allUpdated() {
        for (ChatInstance chat : this.chat_instances_list) {
            chat.updated();
        }
        this.plugin.fireUpdated();
    }

    protected void startup() {
        PluginInterface[] plugins;
        this.plugin_interface.addEventListener(new PluginEventListener(){

            public void handleEvent(PluginEvent ev) {
                int type = ev.getType();
                if (type == 5) {
                    try {
                        ShareResource[] existing;
                        ShareManager share_manager = BuddyPluginBeta.this.plugin_interface.getShareManager();
                        share_manager.addListener(new ShareManagerListener(){

                            public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
                                BuddyPluginBeta.this.checkTag(new_resource);
                            }

                            public void resourceDeleted(ShareResource resource) {
                            }

                            public void resourceAdded(ShareResource resource) {
                                BuddyPluginBeta.this.checkTag(resource);
                            }

                            public void reportProgress(int percent_complete) {
                            }

                            public void reportCurrentTask(String task_description) {
                            }
                        });
                        for (ShareResource sr : existing = share_manager.getShares()) {
                            BuddyPluginBeta.this.checkTag(sr);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                } else if (type == 8) {
                    BuddyPluginBeta.this.pluginAdded((PluginInterface)ev.getValue());
                } else if (type == 9) {
                    BuddyPluginBeta.this.pluginRemoved((PluginInterface)ev.getValue());
                }
            }
        });
        for (PluginInterface pi : plugins = this.plugin_interface.getPluginManager().getPlugins(true)) {
            if (!pi.getPluginState().isOperational()) continue;
            this.pluginAdded(pi);
        }
    }

    private void checkTag(ShareResource resource) {
        String ud;
        Map<String, String> properties = resource.getProperties();
        if (properties != null && (ud = properties.get("user_data")).equals("buddyplugin:share")) {
            try {
                Download download;
                Torrent torrent = null;
                if (resource instanceof ShareResourceFile) {
                    torrent = ((ShareResourceFile)resource).getItem().getTorrent();
                } else if (resource instanceof ShareResourceDir) {
                    torrent = ((ShareResourceDir)resource).getItem().getTorrent();
                }
                if (torrent != null && (download = this.plugin_interface.getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(torrent.getHash())) != null) {
                    this.tagDownload(download);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public void tagDownload(Download download) {
        try {
            TagType tt = TagManagerFactory.getTagManager().getTagType(3);
            Tag tag = tt.getTag("tag.azbuddy.dchat.shares", false);
            if (tag == null) {
                tag = tt.createTag("tag.azbuddy.dchat.shares", true);
                tag.setCanBePublic(false);
                tag.setPublic(false);
            }
            tag.addTaggable(PluginCoreUtils.unwrap(download));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected void closedown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pluginAdded(PluginInterface pi) {
        if (pi.getPluginID().equals("azmsgsync")) {
            Map<String, ChatInstance> map = this.chat_instances_map;
            synchronized (map) {
                this.azmsgsync_pi = pi;
                Iterator<ChatInstance> it = this.chat_instances_map.values().iterator();
                while (it.hasNext()) {
                    ChatInstance inst = it.next();
                    try {
                        inst.bind(this.azmsgsync_pi, null);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        it.remove();
                    }
                }
            }
            this.dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        if (Constants.isCVSVersion() && BuddyPluginBeta.this.enabled.getValue() && BETA_CHAN_ENABLED) {
                            ChatInstance chat = BuddyPluginBeta.this.getChat("Public", BuddyPluginBeta.BETA_CHAT_KEY);
                            chat.setKeepAlive(true);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pluginRemoved(PluginInterface pi) {
        if (pi.getPluginID().equals("azmsgsync")) {
            Map<String, ChatInstance> map = this.chat_instances_map;
            synchronized (map) {
                this.azmsgsync_pi = null;
                Iterator<ChatInstance> it = this.chat_instances_map.values().iterator();
                while (it.hasNext()) {
                    ChatInstance inst = it.next();
                    inst.unbind();
                    if (!inst.isPrivateChat()) continue;
                    it.remove();
                }
            }
        }
    }

    public boolean isI2PAvailable() {
        return AEPluginProxyHandler.hasPluginProxyForNetwork("I2P", false);
    }

    public InputStream handleURI(String url_str, boolean open_only) throws Exception {
        String network;
        String protocol;
        int pos = url_str.indexOf(63);
        String key = null;
        String format = null;
        if (pos != -1) {
            String[] bits;
            protocol = url_str.substring(0, pos).toLowerCase(Locale.US);
            String args = url_str.substring(pos + 1);
            for (String bit : bits = args.split("&")) {
                String[] temp = bit.split("=");
                if (temp.length == 1) {
                    key = UrlUtils.decode(temp[0]);
                    continue;
                }
                String lhs = temp[0].toLowerCase(Locale.US);
                String rhs = UrlUtils.decode(temp[1]);
                if (lhs.equals("key")) {
                    key = rhs;
                    continue;
                }
                if (!lhs.equals("format")) continue;
                format = rhs;
            }
        } else {
            throw new Exception("Malformed request");
        }
        if (key == null) {
            throw new Exception("Key missing");
        }
        if (open_only) {
            format = null;
        }
        if (protocol.startsWith("chat:anon")) {
            if (!this.isI2PAvailable()) {
                throw new Exception("I2P unavailable");
            }
            network = "I2P";
        } else if (protocol.startsWith("chat")) {
            network = "Public";
        } else {
            throw new Exception("Invalid protocol: " + protocol);
        }
        if (format == null || !format.equalsIgnoreCase("rss")) {
            BuddyPluginViewInterface ui = this.plugin.getSWTUI();
            if (ui == null) {
                throw new Exception("UI unavailable");
            }
            ChatInstance chat = this.getChat(network, key);
            ui.openChat(chat);
            return null;
        }
        ChatInstance chat = this.peekChatInstance(network, key, true);
        if (chat == null) {
            throw new Exception("Chat unavailable");
        }
        if (!chat.isFavourite()) {
            chat.setFavourite(true);
            chat.setKeepAlive(true);
        }
        if (!chat.getSaveMessages()) {
            chat.setSaveMessages(true);
        }
        List<ChatMessage> messages = chat.getMessages();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\">");
        pw.println("<channel>");
        pw.println("<title>" + this.escape(chat.getName()) + "</title>");
        long last_modified = messages.size() == 0 ? SystemTime.getCurrentTime() : messages.get(messages.size() - 1).getTimeStamp();
        pw.println("<pubDate>" + TimeFormatter.getHTTPDate(last_modified) + "</pubDate>");
        for (ChatMessage message : messages) {
            List<Map<String, Object>> magnets = this.extractMagnets(message.getMessage());
            if (magnets.size() == 0) continue;
            String item_date = TimeFormatter.getHTTPDate(message.getTimeStamp());
            for (Map<String, Object> magnet : magnets) {
                String link;
                String hash = (String)magnet.get("hash");
                if (hash == null) continue;
                String title = (String)magnet.get("title");
                if (title == null) {
                    title = hash;
                }
                if ((link = (String)magnet.get("link")) == null) {
                    link = (String)magnet.get("magnet");
                }
                pw.println("<item>");
                pw.println("<title>" + this.escape(title) + "</title>");
                pw.println("<guid>" + hash + "</guid>");
                String cdp = (String)magnet.get("cdp");
                if (cdp != null) {
                    pw.println("<link>" + this.escape(cdp) + "</link>");
                }
                Long size = (Long)magnet.get("size");
                Long seeds = (Long)magnet.get("seeds");
                Long leechers = (Long)magnet.get("leechers");
                Long date = (Long)magnet.get("date");
                String enclosure = "<enclosure type=\"application/x-bittorrent\" url=\"" + this.escape(link) + "\"";
                if (size != null) {
                    enclosure = enclosure + " length=\"" + size + "\"";
                }
                enclosure = enclosure + " />";
                pw.println(enclosure);
                String date_str = date == null || date <= 0L ? item_date : TimeFormatter.getHTTPDate(date);
                pw.println("<pubDate>" + date_str + "</pubDate>");
                if (size != null) {
                    pw.println("<vuze:size>" + size + "</vuze:size>");
                }
                if (seeds != null) {
                    pw.println("<vuze:seeds>" + seeds + "</vuze:seeds>");
                }
                if (leechers != null) {
                    pw.println("<vuze:peers>" + leechers + "</vuze:peers>");
                }
                pw.println("<vuze:assethash>" + hash + "</vuze:assethash>");
                pw.println("<vuze:downloadurl>" + this.escape(link) + "</vuze:downloadurl>");
                pw.println("</item>");
            }
        }
        pw.println("</channel>");
        pw.println("</rss>");
        pw.flush();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private List<Map<String, Object>> extractMagnets(String str) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int len = str.length();
        String lc_str = str.toLowerCase(Locale.US);
        int pos = 0;
        while (pos < len && (pos = lc_str.indexOf("magnet:", pos)) != -1) {
            String[] bits;
            char c;
            int start = pos;
            while (!(pos >= len || Character.isWhitespace(c = str.charAt(pos)) || c == '\"' && start > 0 && lc_str.charAt(start - 1) == '\"')) {
                ++pos;
            }
            String magnet = str.substring(start, pos);
            int x = magnet.indexOf(63);
            if (x == -1) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            int p1 = magnet.lastIndexOf("[[");
            if (p1 != -1 && magnet.endsWith("]]")) {
                magnet = magnet.substring(0, p1);
            }
            map.put("magnet", magnet);
            ArrayList<String> trackers = new ArrayList<String>();
            map.put("trackers", trackers);
            for (String bit : bits = magnet.substring(x + 1).split("&")) {
                String[] temp = bit.split("=");
                if (temp.length != 2) continue;
                try {
                    String lhs = temp[0].toLowerCase(Locale.US);
                    String rhs = UrlUtils.decode(temp[1]);
                    if (lhs.equals("xt")) {
                        String lc_rhs = rhs.toLowerCase(Locale.US);
                        int p = lc_rhs.indexOf("btih:");
                        if (p < 0) continue;
                        map.put("hash", lc_rhs.substring(p + 5).toUpperCase(Locale.US));
                        continue;
                    }
                    if (lhs.equals("dn")) {
                        map.put("title", rhs);
                        continue;
                    }
                    if (lhs.equals("tr")) {
                        trackers.add(rhs);
                        continue;
                    }
                    if (lhs.equals("fl")) {
                        map.put("link", rhs);
                        continue;
                    }
                    if (lhs.equals("xl")) {
                        long size = Long.parseLong(rhs);
                        map.put("size", size);
                        continue;
                    }
                    if (lhs.equals("_d")) {
                        long date = Long.parseLong(rhs);
                        map.put("date", date);
                        continue;
                    }
                    if (lhs.equals("_s")) {
                        long seeds = Long.parseLong(rhs);
                        map.put("seeds", seeds);
                        continue;
                    }
                    if (lhs.equals("_l")) {
                        long leechers = Long.parseLong(rhs);
                        map.put("leechers", leechers);
                        continue;
                    }
                    if (!lhs.equals("_c")) continue;
                    map.put("cdp", rhs);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            result.add(map);
        }
        return result;
    }

    private String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }

    public boolean getFTUXAccepted() {
        return this.ftux_accepted;
    }

    public void setFTUXAccepted(boolean accepted) {
        this.ftux_accepted = accepted;
        COConfigurationManager.setParameter("azbuddy.dchat.ftux.accepted", true);
        COConfigurationManager.save();
        for (FTUXStateChangeListener l : this.ftux_listeners) {
            l.stateChanged(accepted);
        }
    }

    public void addFTUXStateChangeListener(FTUXStateChangeListener listener) {
        this.ftux_listeners.add(listener);
        listener.stateChanged(this.ftux_accepted);
    }

    public void removeFTUXStateChangeListener(FTUXStateChangeListener listener) {
        this.ftux_listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessage(ChatInstance chat, ChatMessage message) {
        File log_dir = AEDiagnostics.getLogDir();
        if (!(log_dir = new File(log_dir, "chat")).exists()) {
            log_dir.mkdir();
        }
        File log_file = new File(log_dir, FileUtil.convertOSSpecificChars(chat.getName(), false) + ".log");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(log_file, true), "UTF-8"));
            SimpleDateFormat time_format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
            String msg = "[" + time_format.format(new Date(message.getTimeStamp())) + "]";
            msg = msg + " <" + message.getParticipant().getName(true) + "> " + message.getMessage();
            pw.println(msg);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (pw != null) {
                pw.close();
            }
            throw throwable;
        }
    }

    public void getAndShowChat(String network, String key) throws Exception {
        BuddyPluginViewInterface ui = this.plugin.getSWTUI();
        if (ui == null) {
            throw new Exception("UI unavailable");
        }
        ChatInstance chat = this.getChat(network, key);
        ui.openChat(chat);
    }

    public void showChat(ChatInstance inst) throws Exception {
        BuddyPluginViewInterface ui = this.plugin.getSWTUI();
        if (ui == null) {
            throw new Exception("UI unavailable");
        }
        ui.openChat(inst);
    }

    private String pkToString(byte[] pk) {
        byte[] temp = new byte[3];
        if (pk != null) {
            System.arraycopy(pk, 8, temp, 0, 3);
        }
        return ByteFormatter.encodeString(temp);
    }

    public ChatInstance importChat(String import_data) throws Exception {
        if (this.azmsgsync_pi == null) {
            throw new Exception("Plugin unavailable ");
        }
        HashMap<String, byte[]> options = new HashMap<String, byte[]>();
        options.put("import_data", import_data.getBytes("UTF-8"));
        Map reply = (Map)this.azmsgsync_pi.getIPC().invoke("importMessageHandler", new Object[]{options});
        String key = new String((byte[])reply.get("key"), "UTF-8");
        String network = (String)reply.get("network");
        Object handler = reply.get("handler");
        return this.getChat(network, key, null, handler, false);
    }

    public ChatInstance getChat(Download download) {
        String key = BuddyPluginUtils.getChatKey(download);
        if (key != null) {
            String[] networks = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
            boolean has_i2p = false;
            for (String net : networks) {
                if (net == "Public") {
                    try {
                        ChatInstance inst = this.getChat(net, key);
                        return inst;
                    }
                    catch (Throwable e) {
                        continue;
                    }
                }
                if (net != "I2P") continue;
                has_i2p = true;
            }
            if (has_i2p) {
                try {
                    ChatInstance inst = this.getChat("I2P", key);
                    return inst;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public ChatInstance getChat(String network, String key) throws Exception {
        return this.getChat(network, key, null, null, false);
    }

    public ChatInstance getChat(ChatParticipant participant) throws Exception {
        String key = participant.getChat().getKey() + " - " + participant.getName() + " (outgoing)[" + this.private_chat_id.getAndIncrement() + "]";
        return this.getChat(participant.getChat().getNetwork(), key, participant, null, true);
    }

    public ChatInstance getChat(ChatParticipant parent_participant, Object handler) throws Exception {
        String key = parent_participant.getChat().getKey() + " - " + parent_participant.getName() + " (incoming)[" + this.private_chat_id.getAndIncrement() + "]";
        return this.getChat(parent_participant.getChat().getNetwork(), key, null, handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatInstance getChat(String network, String key, ChatParticipant private_target, Object handler, boolean is_private_chat) throws Exception {
        ChatInstance result;
        if (!this.enabled.getValue()) {
            throw new Exception("Plugin not enabled");
        }
        String meta_key = network + ":" + key;
        ChatInstance added = null;
        Map<String, ChatInstance> map = this.chat_instances_map;
        synchronized (map) {
            result = this.chat_instances_map.get(meta_key);
            if (result == null) {
                result = new ChatInstance(network, key, private_target, is_private_chat);
                this.chat_instances_map.put(meta_key, result);
                this.chat_instances_list.add(result);
                added = result;
                if (this.azmsgsync_pi != null) {
                    try {
                        result.bind(this.azmsgsync_pi, handler);
                    }
                    catch (Throwable e) {
                        this.chat_instances_map.remove(meta_key);
                        this.chat_instances_list.remove(result);
                        added = null;
                        result.destroy();
                        if (e instanceof Exception) {
                            throw (Exception)e;
                        }
                        throw new Exception(e);
                    }
                }
            } else {
                result.addReference();
            }
            if (this.timer == null) {
                this.timer = SimpleTimer.addPeriodicEvent("BPB:timer", 2500L, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        for (ChatInstance inst : BuddyPluginBeta.this.chat_instances_list) {
                            inst.update();
                        }
                    }
                });
            }
        }
        if (added != null) {
            for (ChatManagerListener l : this.listeners) {
                try {
                    l.chatAdded(added);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatInstance peekChatInstance(String network, String key, boolean create_if_missing) {
        String meta_key = network + ":" + key;
        Map<String, ChatInstance> map = this.chat_instances_map;
        synchronized (map) {
            ChatInstance inst = this.chat_instances_map.get(meta_key);
            if (inst == null && create_if_missing) {
                try {
                    inst = this.getChat(network, key);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return inst;
        }
    }

    public Map<String, Object> peekChat(Download download) {
        String key = BuddyPluginUtils.getChatKey(download);
        if (key != null) {
            String[] networks = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
            boolean has_i2p = false;
            for (String net : networks) {
                if (net == "Public") {
                    try {
                        return this.peekChat(net, key);
                    }
                    catch (Throwable e) {
                        continue;
                    }
                }
                if (net != "I2P") continue;
                has_i2p = true;
            }
            if (has_i2p) {
                try {
                    return this.peekChat("I2P", key);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> peekChat(String network, String key) {
        Map<String, Object> reply = new HashMap<String, Object>();
        try {
            PluginInterface pi;
            Map<String, ChatInstance> map = this.chat_instances_map;
            synchronized (map) {
                pi = this.azmsgsync_pi;
            }
            if (pi != null) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("network", network);
                options.put("key", key.getBytes("UTF-8"));
                options.put("timeout", 60000);
                reply = (Map)pi.getIPC().invoke("peekMessageHandler", new Object[]{options});
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return reply;
    }

    public List<ChatInstance> getChats() {
        return this.chat_instances_list.getList();
    }

    public void addListener(ChatManagerListener l, boolean fire_for_existing) {
        this.listeners.add(l);
        if (fire_for_existing) {
            for (ChatInstance inst : this.chat_instances_list) {
                l.chatAdded(inst);
            }
        }
    }

    public void removeListener(ChatManagerListener l) {
        this.listeners.remove(l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChatInstance {
        private static final int MSG_HISTORY_MAX = 512;
        private final String network;
        private final String key;
        private boolean is_private_chat;
        private final ChatParticipant private_target;
        private Object binding_lock = new Object();
        private AESemaphore binding_sem;
        private volatile PluginInterface msgsync_pi;
        private volatile Object handler;
        private byte[] my_public_key;
        private byte[] managing_public_key;
        private boolean read_only;
        private int ipc_version;
        private InetSocketAddress my_address;
        private Object chat_lock = this;
        private AtomicInteger message_uid_next = new AtomicInteger();
        private List<ChatMessage> messages = new ArrayList<ChatMessage>();
        private ByteArrayHashMap<String> message_ids = new ByteArrayHashMap();
        private int messages_not_mine_count;
        private ByteArrayHashMap<ChatParticipant> participants = new ByteArrayHashMap();
        private Map<String, List<ChatParticipant>> nick_clash_map = new HashMap<String, List<ChatParticipant>>();
        private CopyOnWriteList<ChatListener> listeners = new CopyOnWriteList();
        private Map<Object, Object> user_data = new HashMap<Object, Object>();
        private boolean keep_alive;
        private boolean have_interest;
        private Map<String, Object> status;
        private boolean is_shared_nick;
        private String instance_nick;
        private int reference_count;
        private ChatMessage last_message_requiring_attention;
        private boolean message_outstanding;
        private boolean is_favourite;
        private boolean auto_notify;
        private boolean save_messages;
        private boolean log_messages;
        private boolean destroyed;
        private TimerEvent sort_event;
        private boolean sort_force_changed;
        AsyncDispatcher dispatcher = new AsyncDispatcher("sendAsync");

        private ChatInstance(String _network, String _key, ChatParticipant _private_target, boolean _is_private_chat) {
            this.network = _network;
            this.key = _key;
            this.private_target = _private_target;
            this.is_private_chat = _is_private_chat;
            String chat_key_base = "azbuddy.chat." + this.getNetAndKey();
            String shared_key = chat_key_base + ".shared";
            String nick_key = chat_key_base + ".nick";
            this.is_shared_nick = COConfigurationManager.getBooleanParameter(shared_key, true);
            this.instance_nick = COConfigurationManager.getStringParameter(nick_key, "");
            if (!this.is_private_chat) {
                this.is_favourite = BuddyPluginBeta.this.getFavourite(this.network, this.key);
                this.save_messages = BuddyPluginBeta.this.getSaveMessages(this.network, this.key);
                this.log_messages = BuddyPluginBeta.this.getLogMessages(this.network, this.key);
            }
            this.addReference();
        }

        public ChatInstance getClone() throws Exception {
            if (this.is_private_chat) {
                this.addReference();
                return this;
            }
            return BuddyPluginBeta.this.getChat(this.network, this.key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addReference() {
            Object object = this.chat_lock;
            synchronized (object) {
                ++this.reference_count;
            }
        }

        public String getName() {
            String str = this.key;
            int pos = str.lastIndexOf(91);
            if (pos != -1 && str.endsWith("]")) {
                String temp = str.substring(pos + 1, str.length() - 1);
                if (temp.contains("pk=")) {
                    str = str.substring(0, pos);
                    str = temp.contains("ro=1") ? str + "[R]" : str + "[M]";
                } else {
                    str = str.substring(0, pos);
                }
            }
            return MessageText.getString(this.network == "Public" ? "label.public" : "label.anon") + " - '" + str + "'";
        }

        public String getShortName() {
            String short_name = this.getName();
            if (short_name.length() > 60) {
                short_name = short_name.substring(0, 60) + "...";
            }
            return short_name;
        }

        public String getNetwork() {
            return this.network;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isFavourite() {
            return this.is_favourite;
        }

        public void setAutoNotify(boolean b) {
            this.auto_notify = b;
        }

        public boolean isAutoNotify() {
            return this.auto_notify;
        }

        public boolean isInteresting() {
            return this.have_interest;
        }

        public boolean isStatistics() {
            return this.key.startsWith("Statistics:");
        }

        public void setFavourite(boolean b) {
            if (!this.is_private_chat && b != this.is_favourite) {
                this.is_favourite = b;
                BuddyPluginBeta.this.setFavourite(this.network, this.key, b);
            }
        }

        public boolean getSaveMessages() {
            return this.save_messages;
        }

        public void setSaveMessages(boolean b) {
            if (!this.is_private_chat && b != this.save_messages) {
                this.save_messages = b;
                BuddyPluginBeta.this.setSaveMessages(this.network, this.key, b);
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("save_messages", b);
                try {
                    this.updateOptions(options);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        public boolean getLogMessages() {
            return this.log_messages;
        }

        public void setLogMessages(boolean b) {
            if (!this.is_private_chat && b != this.log_messages) {
                this.log_messages = b;
                BuddyPluginBeta.this.setLogMessages(this.network, this.key, b);
            }
        }

        private void setSpammer(ChatParticipant participant, boolean is_spammer) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("pk", participant.getPublicKey());
            options.put("spammer", is_spammer);
            try {
                this.updateOptions(options);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        public boolean isManaged() {
            return this.managing_public_key != null;
        }

        public boolean amManager() {
            return this.managing_public_key != null && Arrays.equals(this.my_public_key, this.managing_public_key);
        }

        public boolean isManagedFor(String network, String key) {
            if (this.getNetwork() != network) {
                return false;
            }
            return this.getKey().equals(key + "[pk=" + Base32.encode(this.getPublicKey()) + "]");
        }

        public ChatInstance getManagedChannel() throws Exception {
            if (this.isManaged()) {
                throw new Exception("Channel is already managed");
            }
            String new_key = this.getKey() + "[pk=" + Base32.encode(this.getPublicKey()) + "]";
            ChatInstance inst = BuddyPluginBeta.this.getChat(this.getNetwork(), new_key);
            return inst;
        }

        public boolean isReadOnlyFor(String network, String key) {
            if (this.getNetwork() != network) {
                return false;
            }
            return this.getKey().equals(key + "[pk=" + Base32.encode(this.getPublicKey()) + "&ro=1]");
        }

        public ChatInstance getReadOnlyChannel() throws Exception {
            if (this.isManaged()) {
                throw new Exception("Channel is already managed");
            }
            String new_key = this.getKey() + "[pk=" + Base32.encode(this.getPublicKey()) + "&ro=1]";
            ChatInstance inst = BuddyPluginBeta.this.getChat(this.getNetwork(), new_key);
            return inst;
        }

        public boolean isReadOnly() {
            return this.read_only && !this.amManager();
        }

        public String getURL() {
            if (this.network == "Public") {
                return "chat:?" + UrlUtils.encode(this.key);
            }
            return "chat:anon:?" + UrlUtils.encode(this.key);
        }

        public byte[] getPublicKey() {
            return this.my_public_key;
        }

        public boolean isPrivateChat() {
            return this.is_private_chat;
        }

        public boolean isAnonymous() {
            return this.network != "Public";
        }

        public String getNetAndKey() {
            return this.network + ": " + this.key;
        }

        public void setKeepAlive(boolean b) {
            this.keep_alive = b;
        }

        public boolean getKeepAlive() {
            return this.keep_alive;
        }

        public boolean isSharedNickname() {
            return this.is_shared_nick;
        }

        public void setSharedNickname(boolean _shared) {
            if (_shared != this.is_shared_nick) {
                this.is_shared_nick = _shared;
                String chat_key_base = "azbuddy.chat." + this.getNetAndKey();
                String shared_key = chat_key_base + ".shared";
                COConfigurationManager.setParameter(shared_key, _shared);
                this.updated();
            }
        }

        public String getInstanceNickname() {
            return this.instance_nick;
        }

        public void setInstanceNickname(String _nick) {
            if (!_nick.equals(this.instance_nick)) {
                this.instance_nick = _nick;
                String chat_key_base = "azbuddy.chat." + this.getNetAndKey();
                String nick_key = chat_key_base + ".nick";
                COConfigurationManager.setParameter(nick_key, _nick);
                this.updated();
            }
        }

        public String getNickname() {
            if (this.is_shared_nick) {
                return this.network == "Public" ? BuddyPluginBeta.this.shared_public_nickname : BuddyPluginBeta.this.shared_anon_nickname;
            }
            return this.instance_nick;
        }

        private Object getHandler() {
            return this.handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bind(PluginInterface _msgsync_pi, Object _handler) throws Exception {
            boolean inform_avail = false;
            Object object = this.binding_lock;
            synchronized (object) {
                this.binding_sem = new AESemaphore("bpb:bind");
                try {
                    Number ipc_v;
                    Boolean ro;
                    Map reply;
                    HashMap<String, Object> options;
                    this.msgsync_pi = _msgsync_pi;
                    if (_handler != null) {
                        this.handler = _handler;
                        try {
                            options = new HashMap();
                            options.put("handler", _handler);
                            options.put("addlistener", this);
                            reply = (Map)this.msgsync_pi.getIPC().invoke("updateMessageHandler", new Object[]{options});
                            this.my_public_key = (byte[])reply.get("pk");
                            this.managing_public_key = (byte[])reply.get("mpk");
                            ro = (Boolean)reply.get("ro");
                            this.read_only = ro != null && ro != false;
                            ipc_v = (Number)reply.get("ipc_version");
                            this.ipc_version = ipc_v == null ? 1 : ipc_v.intValue();
                            inform_avail = true;
                        }
                        catch (Throwable e) {
                            throw new Exception(e);
                        }
                    }
                    try {
                        options = new HashMap<String, Object>();
                        options.put("network", this.network);
                        options.put("key", this.key.getBytes("UTF-8"));
                        if (this.private_target != null) {
                            options.put("parent_handler", this.private_target.getChat().getHandler());
                            options.put("target_pk", this.private_target.getPublicKey());
                            options.put("target_contact", this.private_target.getContact());
                        }
                        if (this.network != "Public") {
                            options.put("server_id", BuddyPluginBeta.this.getSharedAnonEndpoint() ? "dchat_shared" : "dchat");
                        }
                        options.put("listener", this);
                        if (this.getSaveMessages()) {
                            options.put("save_messages", true);
                        }
                        reply = (Map)this.msgsync_pi.getIPC().invoke("getMessageHandler", new Object[]{options});
                        this.handler = reply.get("handler");
                        this.my_public_key = (byte[])reply.get("pk");
                        this.managing_public_key = (byte[])reply.get("mpk");
                        ro = (Boolean)reply.get("ro");
                        this.read_only = ro != null && ro != false;
                        ipc_v = (Number)reply.get("ipc_version");
                        this.ipc_version = ipc_v == null ? 1 : ipc_v.intValue();
                        inform_avail = true;
                    }
                    catch (Throwable e) {
                        throw new Exception(e);
                    }
                    Object var10_12 = null;
                    this.binding_sem.releaseForever();
                    this.binding_sem = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    this.binding_sem.releaseForever();
                    this.binding_sem = null;
                    throw throwable;
                }
            }
            if (inform_avail) {
                for (ChatListener l : this.listeners) {
                    try {
                        l.stateChanged(true);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }

        private void updateOptions(Map<String, Object> options) throws Exception {
            if (this.handler == null || this.msgsync_pi == null) {
                Debug.out("No handler!");
            } else {
                options.put("handler", this.handler);
                this.msgsync_pi.getIPC().invoke("updateMessageHandler", new Object[]{options});
            }
        }

        private void unbind() {
            for (ChatListener l : this.listeners) {
                try {
                    l.stateChanged(false);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.handler = null;
            this.msgsync_pi = null;
        }

        public boolean isAvailable() {
            return this.handler != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChatMessage[] getHistory() {
            Object object = this.chat_lock;
            synchronized (object) {
                return this.messages.toArray(new ChatMessage[this.messages.size()]);
            }
        }

        private void update() {
            PluginInterface current_pi = this.msgsync_pi;
            Object current_handler = this.handler;
            if (current_handler != null && current_pi != null) {
                try {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("handler", current_handler);
                    this.status = (Map)current_pi.getIPC().invoke("getStatus", new Object[]{options});
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.updated();
        }

        private void updated() {
            for (ChatListener l : this.listeners) {
                try {
                    l.updated();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        public int getEstimatedNodes() {
            Map<String, Object> map = this.status;
            if (map == null) {
                return -1;
            }
            return ((Number)map.get("node_est")).intValue();
        }

        public int getMessageCount(boolean not_mine) {
            if (not_mine) {
                return this.messages_not_mine_count;
            }
            return this.messages.size();
        }

        public int getIncomingSyncState() {
            Map<String, Object> map = this.status;
            if (map == null) {
                return -3;
            }
            Number in_pending = (Number)map.get("msg_in_pending");
            return in_pending == null ? -2 : in_pending.intValue();
        }

        public int getOutgoingSyncState() {
            Map<String, Object> map = this.status;
            if (map == null) {
                return -3;
            }
            Number out_pending = (Number)map.get("msg_out_pending");
            return out_pending == null ? -2 : out_pending.intValue();
        }

        public String getStatus() {
            PluginInterface current_pi = this.msgsync_pi;
            Object current_handler = this.handler;
            if (current_pi == null) {
                return MessageText.getString("azbuddy.dchat.status.noplugin");
            }
            if (current_handler == null) {
                return MessageText.getString("azbuddy.dchat.status.nohandler");
            }
            Map<String, Object> map = this.status;
            if (map == null) {
                return MessageText.getString("azbuddy.dchat.status.notavail");
            }
            int status = ((Number)map.get("status")).intValue();
            int dht_count = ((Number)map.get("dht_nodes")).intValue();
            int nodes_local = ((Number)map.get("nodes_local")).intValue();
            int nodes_live = ((Number)map.get("nodes_live")).intValue();
            int nodes_dying = ((Number)map.get("nodes_dying")).intValue();
            int req_in = ((Number)map.get("req_in")).intValue();
            double req_in_rate = ((Number)map.get("req_in_rate")).doubleValue();
            int req_out_ok = ((Number)map.get("req_out_ok")).intValue();
            int req_out_fail = ((Number)map.get("req_out_fail")).intValue();
            double req_out_rate = ((Number)map.get("req_out_rate")).doubleValue();
            if (status == 0 || status == 1) {
                String arg2;
                String arg1;
                if (this.isPrivateChat()) {
                    arg1 = MessageText.getString("label.private.chat") + ": ";
                    arg2 = "";
                } else if (status == 0) {
                    arg1 = MessageText.getString("pairing.status.initialising") + ": ";
                    arg2 = "DHT=" + (dht_count < 0 ? "..." : String.valueOf(dht_count)) + ", ";
                } else if (status == 1) {
                    arg1 = "";
                    arg2 = "DHT=" + dht_count + ", ";
                } else {
                    arg1 = "";
                    arg2 = "";
                }
                String arg3 = nodes_local + "/" + nodes_live + "/" + nodes_dying;
                String arg4 = DisplayFormatters.formatDecimal(req_out_rate, 1) + "/" + DisplayFormatters.formatDecimal(req_in_rate, 1);
                String str = MessageText.getString("azbuddy.dchat.node.status", new String[]{arg1, arg2, arg3, arg4});
                if (this.isReadOnly()) {
                    str = str + ", R-";
                } else if (this.amManager()) {
                    str = this.read_only ? str + ", R+" : str + ", M+";
                } else if (this.isManaged()) {
                    str = str + ", M-";
                }
                return str;
            }
            return MessageText.getString("azbuddy.dchat.status.destroyed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortMessages(boolean force_change) {
            Object object = this.chat_lock;
            synchronized (object) {
                if (force_change) {
                    this.sort_force_changed = true;
                }
                if (this.sort_event != null) {
                    return;
                }
                this.sort_event = SimpleTimer.addEvent("msgsort", SystemTime.getOffsetTime(500L), new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        boolean changed = false;
                        Object object = ChatInstance.this.chat_lock;
                        synchronized (object) {
                            ChatInstance.this.sort_event = null;
                            changed = ChatInstance.this.sortMessagesSupport();
                            if (ChatInstance.this.sort_force_changed) {
                                changed = true;
                                ChatInstance.this.sort_force_changed = false;
                            }
                        }
                        if (changed) {
                            for (ChatListener l : ChatInstance.this.listeners) {
                                l.messagesChanged();
                            }
                        }
                    }
                });
            }
        }

        private boolean sortMessagesSupport() {
            ChatMessage msg;
            ChatMessage prev_msg;
            int num_messages = this.messages.size();
            ByteArrayHashMap<ChatMessage> id_map = new ByteArrayHashMap<ChatMessage>(num_messages);
            HashMap<ChatMessage, ChatMessage> prev_map = new HashMap<ChatMessage, ChatMessage>(num_messages);
            HashMap<ChatMessage, ChatMessage> next_map = new HashMap<ChatMessage, ChatMessage>(num_messages);
            for (ChatMessage msg2 : this.messages) {
                byte[] id = msg2.getID();
                id_map.put(id, msg2);
            }
            for (ChatMessage msg2 : this.messages) {
                ChatMessage prev_msg2;
                byte[] prev_id = msg2.getPreviousID();
                if (prev_id == null || (prev_msg2 = (ChatMessage)id_map.get(prev_id)) == null) continue;
                msg2.setPreviousID(prev_msg2.getID());
                prev_map.put(msg2, prev_msg2);
                next_map.put(prev_msg2, msg2);
            }
            Comparator<ChatMessage> message_comparator = new Comparator<ChatMessage>(){

                @Override
                public int compare(ChatMessage o1, ChatMessage o2) {
                    return o1.getUID() - o2.getUID();
                }
            };
            TreeSet<ChatMessage> linked_messages = new TreeSet<ChatMessage>(message_comparator);
            linked_messages.addAll(prev_map.keySet());
            block2: while (linked_messages.size() > 0) {
                ChatMessage start = (ChatMessage)linked_messages.iterator().next();
                linked_messages.remove(start);
                ChatMessage current = start;
                int loops = 0;
                while (true) {
                    if (++loops > num_messages) {
                        Debug.out("infinte loop");
                        continue block2;
                    }
                    prev_msg = (ChatMessage)prev_map.get(current);
                    if (prev_msg == null) continue block2;
                    linked_messages.remove(prev_msg);
                    if (prev_msg == start) {
                        prev_map.put(current, null);
                        next_map.put(prev_msg, null);
                        continue block2;
                    }
                    current = prev_msg;
                }
            }
            TreeSet<ChatMessage> chain_heads = new TreeSet<ChatMessage>(message_comparator);
            block4: for (ChatMessage msg3 : this.messages) {
                prev_msg = (ChatMessage)prev_map.get(msg3);
                if (prev_msg == null) continue;
                int loops = 0;
                while (true) {
                    if (++loops > num_messages) {
                        Debug.out("infinte loop");
                        continue block4;
                    }
                    ChatMessage prev_prev = (ChatMessage)prev_map.get(prev_msg);
                    if (prev_prev == null) {
                        chain_heads.add(prev_msg);
                        continue block4;
                    }
                    prev_msg = prev_prev;
                }
            }
            HashSet<ChatMessage> remainder_set = new HashSet<ChatMessage>(this.messages);
            List<ChatMessage> result = null;
            for (ChatMessage head : chain_heads) {
                ArrayList<ChatMessage> chain = new ArrayList<ChatMessage>(num_messages);
                msg = head;
                while (msg != null) {
                    chain.add(msg);
                    remainder_set.remove(msg);
                    msg = (ChatMessage)next_map.get(msg);
                }
                if (result == null) {
                    result = chain;
                    continue;
                }
                result = this.merge(result, chain);
            }
            if (remainder_set.size() > 0) {
                ArrayList<ChatMessage> remainder = new ArrayList<ChatMessage>(remainder_set);
                Collections.sort(remainder, new Comparator<ChatMessage>(){

                    @Override
                    public int compare(ChatMessage m1, ChatMessage m2) {
                        long l = m1.getTimeStamp() - m2.getTimeStamp();
                        if (l < 0L) {
                            return -1;
                        }
                        if (l > 0L) {
                            return 1;
                        }
                        return m1.getUID() - m2.getUID();
                    }
                });
                result = result == null ? remainder : this.merge(result, remainder);
            }
            if (result == null) {
                return false;
            }
            boolean changed = false;
            if (this.messages.size() != result.size()) {
                Debug.out("Inconsistent: " + this.messages.size() + "/" + result.size());
                changed = true;
            }
            HashSet<ChatParticipant> participants = new HashSet<ChatParticipant>();
            for (int i = 0; i < result.size(); ++i) {
                msg = result.get(i);
                ChatParticipant p = msg.getParticipant();
                participants.add(p);
                if (changed || this.messages.get(i) == msg) continue;
                changed = true;
            }
            if (changed) {
                this.messages = result;
                for (ChatParticipant p : participants) {
                    p.resetMessages();
                }
                HashSet<ChatParticipant> updated = new HashSet<ChatParticipant>();
                for (ChatMessage msg4 : this.messages) {
                    ChatParticipant p = msg4.getParticipant();
                    if (!p.replayMessage(msg4)) continue;
                    updated.add(p);
                }
                for (ChatParticipant p : updated) {
                    this.updated(p);
                }
            }
            return changed;
        }

        private List<ChatMessage> merge(List<ChatMessage> list1, List<ChatMessage> list2) {
            int size1 = list1.size();
            int size2 = list2.size();
            ArrayList<ChatMessage> result = new ArrayList<ChatMessage>(size1 + size2);
            int pos1 = 0;
            int pos2 = 0;
            while (true) {
                long t2;
                if (pos1 == size1) {
                    for (int i = pos2; i < size2; ++i) {
                        result.add(list2.get(i));
                    }
                    break;
                }
                if (pos2 == size2) {
                    for (int i = pos1; i < size1; ++i) {
                        result.add(list1.get(i));
                    }
                    break;
                }
                ChatMessage m1 = list1.get(pos1);
                ChatMessage m2 = list2.get(pos2);
                long t1 = m1.getTimeStamp();
                if (t1 < (t2 = m2.getTimeStamp()) || t1 == t2 && m1.getUID() < m2.getUID()) {
                    result.add(m1);
                    ++pos1;
                    continue;
                }
                result.add(m2);
                ++pos2;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(Map<String, Object> message_map) throws IPCException {
            AESemaphore sem;
            Object object = this.binding_lock;
            synchronized (object) {
                sem = this.binding_sem;
            }
            if (sem != null) {
                sem.reserve();
            }
            ChatMessage msg = new ChatMessage(this.message_uid_next.incrementAndGet(), message_map);
            ChatParticipant new_participant = null;
            boolean sort_outstanding = false;
            byte[] prev_id = msg.getPreviousID();
            Object object2 = this.chat_lock;
            synchronized (object2) {
                byte[] pk;
                ChatParticipant participant;
                byte[] id = msg.getID();
                if (this.message_ids.containsKey(id)) {
                    return;
                }
                this.message_ids.put(id, "");
                int old_msgs = this.messages.size();
                this.messages.add(msg);
                if (this.messages.size() > 512) {
                    ChatMessage removed = this.messages.remove(0);
                    --old_msgs;
                    this.message_ids.remove(removed.getID());
                    ChatParticipant rem_part = removed.getParticipant();
                    rem_part.removeMessage(removed);
                    if (!rem_part.isMe()) {
                        --this.messages_not_mine_count;
                    }
                }
                if ((participant = this.participants.get(pk = msg.getPublicKey())) == null) {
                    new_participant = participant = new ChatParticipant(this, pk);
                    this.participants.put(pk, participant);
                    participant.addMessage(msg);
                } else {
                    participant.addMessage(msg);
                }
                if (this.log_messages && !msg.isIgnored()) {
                    BuddyPluginBeta.this.logMessage(this, msg);
                }
                if (participant.isMe()) {
                    InetSocketAddress address = msg.getAddress();
                    if (address != null) {
                        this.my_address = address;
                    }
                    if (msg.getFlagFlashOverride()) {
                        this.last_message_requiring_attention = msg;
                    }
                } else {
                    this.last_message_requiring_attention = msg;
                    ++this.messages_not_mine_count;
                }
                if (this.sort_event != null) {
                    sort_outstanding = true;
                } else if (!(old_msgs == 0 || prev_id != null && Arrays.equals(prev_id, this.messages.get(old_msgs - 1).getID()) || msg.getMessageType() != 1)) {
                    this.sortMessages(true);
                    sort_outstanding = true;
                }
            }
            if (new_participant != null) {
                for (ChatListener l : this.listeners) {
                    l.participantAdded(new_participant);
                }
            }
            if (!sort_outstanding) {
                for (ChatListener l : this.listeners) {
                    l.messageReceived(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> chatRequested(Map<String, Object> message_map) throws IPCException {
            AESemaphore sem;
            Object object = this.binding_lock;
            synchronized (object) {
                sem = this.binding_sem;
            }
            if (sem != null) {
                sem.reserve();
            }
            if (BuddyPluginBeta.this.private_chat_state == 1) {
                throw new IPCException("Private chat disabled by recipient");
            }
            try {
                ChatParticipant participant;
                Object new_handler = message_map.get("handler");
                byte[] remote_pk = (byte[])message_map.get("pk");
                Object object2 = this.chat_lock;
                synchronized (object2) {
                    participant = this.participants.get(remote_pk);
                }
                if (participant == null) {
                    throw new IPCException("Private chat requires you send at least one message to the main chat first");
                }
                if (BuddyPluginBeta.this.private_chat_state == 2 && !participant.isPinned()) {
                    throw new IPCException("Recipient will only accept private chats from pinned participants");
                }
                BuddyPluginViewInterface ui = BuddyPluginBeta.this.plugin.getSWTUI();
                if (ui == null) {
                    throw new IPCException("Chat unavailable");
                }
                ChatInstance inst = BuddyPluginBeta.this.getChat(participant, new_handler);
                if (!this.isSharedNickname()) {
                    inst.setSharedNickname(false);
                    inst.setInstanceNickname(this.getInstanceNickname());
                }
                ui.openChat(inst);
                HashMap<String, Object> reply = new HashMap<String, Object>();
                reply.put("nickname", participant.getName());
                return reply;
            }
            catch (IPCException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IPCException(e);
            }
        }

        public void sendMessage(String message, Map<String, Object> options) {
            this.sendMessage(message, null, options);
        }

        public void sendMessage(final String message, final Map<String, Object> flags, final Map<String, Object> options) {
            this.dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    ChatInstance.this.sendMessageSupport(message, flags, options);
                }
            });
        }

        public void sendLocalMessage(final String message, final String[] args, final int message_type) {
            if (this.ipc_version < 2) {
                return;
            }
            this.dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    String raw_message = message.startsWith("!") && message.endsWith("!") ? message.substring(1, message.length() - 1) : MessageText.getString(message, args);
                    options.put("is_local", true);
                    options.put("message", raw_message);
                    options.put("message_type", message_type);
                    ChatInstance.this.sendMessageSupport("", null, options);
                }
            });
        }

        public void sendControlMessage(final String cmd) {
            if (this.ipc_version < 3) {
                return;
            }
            this.dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("is_control", true);
                    options.put("cmd", cmd);
                    ChatInstance.this.sendMessageSupport("", null, options);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sendMessageSupport(String message, Map<String, Object> flags, Map<String, Object> options) {
            if (this.handler == null || this.msgsync_pi == null) {
                Debug.out("No handler/plugin");
                return;
            }
            if (message.equals("!dump!")) {
                Object object = this.chat_lock;
                synchronized (object) {
                    Iterator<ChatMessage> i$ = this.messages.iterator();
                    while (i$.hasNext()) {
                        ChatMessage msg = i$.next();
                        System.out.println(BuddyPluginBeta.this.pkToString(msg.getID()) + ", " + BuddyPluginBeta.this.pkToString(msg.getPreviousID()) + " - " + msg.getMessage());
                    }
                    return;
                }
            }
            if (message.equals("!sort!")) {
                this.sortMessages(false);
                return;
            }
            if (message.equals("!flood!")) {
                if (!DEBUG_ENABLED) return;
                SimpleTimer.addPeriodicEvent("flooder", 1500L, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        ChatInstance.this.sendMessage("flood - " + SystemTime.getCurrentTime(), null);
                    }
                });
                return;
            }
            if (message.equals("!ftux!")) {
                BuddyPluginBeta.this.plugin.getBeta().setFTUXAccepted(false);
                return;
            }
            if (message.startsWith("/")) {
                String[] bits = message.split("[\\s]+", 3);
                String command = bits[0].toLowerCase(Locale.US);
                boolean ok = false;
                try {
                    if (command.equals("/help")) {
                        String link = MessageText.getString("azbuddy.dchat.link.url");
                        this.sendLocalMessage("label.see.x.for.help", new String[]{link}, 2);
                        return;
                    }
                    if (command.equals("/join")) {
                        if (bits.length > 1) {
                            bits = message.split("[\\s]+", 2);
                            String key = bits[1];
                            if (key.startsWith("\"") && key.endsWith("\"")) {
                                key = key.substring(1, key.length() - 1);
                            }
                            BuddyPluginBeta.this.getAndShowChat(this.getNetwork(), key);
                            return;
                        }
                    } else if (command.equals("/pjoin")) {
                        if (bits.length > 1) {
                            bits = message.split("[\\s]+", 2);
                            String key = bits[1];
                            if (key.startsWith("\"") && key.endsWith("\"")) {
                                key = key.substring(1, key.length() - 1);
                            }
                            BuddyPluginBeta.this.getAndShowChat("Public", key);
                            return;
                        }
                    } else if (command.equals("/ajoin")) {
                        if (bits.length > 1 && BuddyPluginBeta.this.isI2PAvailable()) {
                            bits = message.split("[\\s]+", 2);
                            String key = bits[1];
                            if (key.startsWith("\"") && key.endsWith("\"")) {
                                key = key.substring(1, key.length() - 1);
                            }
                            BuddyPluginBeta.this.getAndShowChat("I2P", key);
                            return;
                        }
                    } else if (command.equals("/msg") || command.equals("/query")) {
                        if (bits.length > 1) {
                            String nick = bits[1];
                            String pm = bits.length == 2 ? "" : bits[2].trim();
                            ChatParticipant p = this.getParticipant(nick);
                            if (p == null) {
                                throw new Exception("Nick not found: " + nick);
                            }
                            if (p.isMe()) {
                                throw new Exception("Can't chat to yourself");
                            }
                            ChatInstance ci = p.createPrivateChat();
                            if (pm.length() > 0) {
                                ci.sendMessage(pm, new HashMap<String, Object>());
                            }
                            BuddyPluginBeta.this.showChat(ci);
                            return;
                        }
                    } else if (command.equals("/ignore")) {
                        if (bits.length > 1) {
                            ChatParticipant p;
                            String nick = bits[1];
                            boolean ignore = true;
                            if (nick.equals("-r") && bits.length > 2) {
                                nick = bits[2];
                                ignore = false;
                            }
                            if ((p = this.getParticipant(nick)) == null) {
                                throw new Exception("Nick not found: " + nick);
                            }
                            p.setIgnored(ignore);
                            this.updated(p);
                            return;
                        }
                    } else if (command.equals("/control")) {
                        if (this.ipc_version >= 3) {
                            String[] bits2 = message.split("[\\s]+", 2);
                            if (bits2.length <= 1) throw new Exception("Invalid command: " + message);
                            this.sendControlMessage(bits2[1]);
                            return;
                        }
                    } else if (command.equals("/peek")) {
                        if (bits.length > 1) {
                            Map<String, Object> result = BuddyPluginBeta.this.peekChat(this.getNetwork(), bits[1]);
                            this.sendLocalMessage("!" + result + "!", null, 2);
                            return;
                        }
                    } else if (command.equals("/clone")) {
                        BuddyPluginBeta.this.getAndShowChat(this.getNetwork(), this.getKey());
                        return;
                    }
                    if (ok) return;
                    throw new Exception("Unhandled command: " + message);
                }
                catch (Throwable e) {
                    this.sendLocalMessage("!" + Debug.getNestedExceptionMessage(e) + "!", null, 3);
                }
                return;
            }
            try {
                ChatMessage prev_message = null;
                Object command = this.chat_lock;
                synchronized (command) {
                    if (this.messages.size() > 0) {
                        prev_message = this.messages.get(this.messages.size() - 1);
                    }
                }
                if (options == null) {
                    options = new HashMap<String, Object>();
                }
                options.put("handler", this.handler);
                HashMap<String, Object> payload = new HashMap<String, Object>();
                payload.put("msg", message.getBytes("UTF-8"));
                payload.put("nick", this.getNickname().getBytes("UTF-8"));
                if (prev_message != null) {
                    payload.put("pre", prev_message.getID());
                }
                if (flags != null) {
                    payload.put(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE, flags);
                }
                options.put("content", BEncoder.encode(payload));
                Map reply = (Map)this.msgsync_pi.getIPC().invoke("sendMessage", new Object[]{options});
                this.have_interest = true;
                return;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        public String export() {
            if (this.handler == null || this.msgsync_pi == null) {
                return "";
            }
            try {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("handler", this.handler);
                Map reply = (Map)this.msgsync_pi.getIPC().invoke("exportMessageHandler", new Object[]{options});
                return (String)reply.get("export_data");
            }
            catch (Throwable e) {
                Debug.out(e);
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ChatMessage> getMessages() {
            Object object = this.chat_lock;
            synchronized (object) {
                return new ArrayList<ChatMessage>(this.messages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChatParticipant[] getParticipants() {
            Object object = this.chat_lock;
            synchronized (object) {
                return this.participants.values().toArray(new ChatParticipant[this.participants.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChatParticipant getParticipant(String nick) {
            Object object = this.chat_lock;
            synchronized (object) {
                for (ChatParticipant cp : this.participants.values()) {
                    if (!cp.getName().equals(nick)) continue;
                    return cp;
                }
            }
            return null;
        }

        protected void updated(ChatParticipant p) {
            for (ChatListener l : this.listeners) {
                l.participantChanged(p);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerNick(ChatParticipant p, String old_nick, String new_nick) {
            Object object = this.chat_lock;
            synchronized (object) {
                List<ChatParticipant> list;
                if (old_nick != null) {
                    list = this.nick_clash_map.get(old_nick);
                    if (list != null && list.remove(p)) {
                        if (list.size() == 0) {
                            this.nick_clash_map.remove(old_nick);
                        } else if (list.size() == 1) {
                            list.get(0).setNickClash(false);
                        }
                    } else {
                        Debug.out("inconsistent");
                    }
                }
                if ((list = this.nick_clash_map.get(new_nick)) == null) {
                    list = new ArrayList<ChatParticipant>();
                    this.nick_clash_map.put(new_nick, list);
                }
                if (list.contains(p)) {
                    Debug.out("inconsistent");
                } else {
                    list.add(p);
                    if (list.size() > 1) {
                        p.setNickClash(true);
                        if (list.size() == 2) {
                            list.get(0).setNickClash(true);
                        }
                    } else {
                        p.setNickClash(false);
                    }
                }
            }
        }

        public ChatMessage getLastMessageRequiringAttention() {
            return this.last_message_requiring_attention;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUserData(Object key, Object value) {
            Map<Object, Object> map = this.user_data;
            synchronized (map) {
                this.user_data.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getUserData(Object key) {
            Map<Object, Object> map = this.user_data;
            synchronized (map) {
                return this.user_data.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getMessageOutstanding() {
            Object object = this.chat_lock;
            synchronized (object) {
                return this.message_outstanding;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMessageOutstanding(boolean b) {
            Object object = this.chat_lock;
            synchronized (object) {
                if (this.message_outstanding == b) {
                    return;
                }
                this.message_outstanding = b;
                if (!b && this.messages.size() > 0) {
                    ChatMessage last_read_msg = this.messages.get(this.messages.size() - 1);
                    long last_read_time = last_read_msg.getTimeStamp();
                    String last_info = SystemTime.getCurrentTime() / 1000L + "/" + last_read_time / 1000L + "/" + Base32.encode(last_read_msg.getID());
                    BuddyPluginBeta.this.setLastMessageInfo(this.network, this.key, last_info);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isOldOutstandingMessage(ChatMessage msg) {
            Object object = this.chat_lock;
            synchronized (object) {
                String info = BuddyPluginBeta.this.getLastMessageInfo(this.network, this.key);
                if (info != null) {
                    String[] bits = info.split("/");
                    try {
                        long old_time_secs = Long.parseLong(bits[0]);
                        long old_msg_secs = Long.parseLong(bits[1]);
                        byte[] old_id = Base32.decode(bits[2]);
                        long msg_secs = msg.getTimeStamp() / 1000L;
                        byte[] id = msg.getID();
                        if (Arrays.equals(id, old_id)) {
                            return true;
                        }
                        long old_cuttoff = old_time_secs - 300L;
                        if (old_msg_secs > old_cuttoff) {
                            old_cuttoff = old_msg_secs;
                        }
                        if (msg_secs <= old_cuttoff) {
                            return true;
                        }
                        if (this.message_ids.containsKey(old_id) && this.message_ids.containsKey(id)) {
                            int msg_index = -1;
                            int old_msg_index = -1;
                            for (int i = 0; i < this.messages.size(); ++i) {
                                ChatMessage m = this.messages.get(i);
                                if (m == msg) {
                                    msg_index = i;
                                    continue;
                                }
                                if (!Arrays.equals(m.getID(), old_id)) continue;
                                old_msg_index = i;
                            }
                            if (msg_index <= old_msg_index) {
                                return true;
                            }
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            return false;
        }

        public InetSocketAddress getMyAddress() {
            return this.my_address;
        }

        public void addListener(ChatListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ChatListener listener) {
            this.listeners.remove(listener);
        }

        public boolean isDestroyed() {
            return this.destroyed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void destroy() {
            block36: {
                Object object = this.chat_lock;
                synchronized (object) {
                    --this.reference_count;
                    if (this.reference_count > 0) {
                        return;
                    }
                }
                if (!(this.keep_alive || this.have_interest && !this.is_private_chat)) {
                    this.destroyed = true;
                    if (this.handler != null) {
                        ChatInstance removed2222;
                        String meta_key2222;
                        if (this.is_private_chat) {
                            HashMap<String, Object> flags = new HashMap<String, Object>();
                            flags.put(BuddyPluginBeta.FLAGS_MSG_STATUS_KEY, 1);
                            this.sendMessageSupport("", flags, new HashMap<String, Object>());
                        }
                        try {
                            HashMap<String, Object> options = new HashMap<String, Object>();
                            options.put("handler", this.handler);
                            Map map = (Map)this.msgsync_pi.getIPC().invoke("removeMessageHandler", new Object[]{options});
                            Object var4_5 = null;
                            meta_key2222 = this.network + ":" + this.key;
                            removed2222 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            String meta_key2222 = this.network + ":" + this.key;
                            ChatInstance removed2222 = null;
                            Map map = BuddyPluginBeta.this.chat_instances_map;
                            synchronized (map) {
                                ChatInstance inst = (ChatInstance)BuddyPluginBeta.this.chat_instances_map.remove(meta_key2222);
                                if (inst != null) {
                                    removed2222 = inst;
                                    BuddyPluginBeta.this.chat_instances_list.remove(inst);
                                }
                                if (BuddyPluginBeta.this.chat_instances_map.size() == 0 && BuddyPluginBeta.this.timer != null) {
                                    BuddyPluginBeta.this.timer.cancel();
                                    BuddyPluginBeta.this.timer = null;
                                }
                            }
                            if (removed2222 != null) {
                                for (ChatManagerListener l : BuddyPluginBeta.this.listeners) {
                                    try {
                                        l.chatRemoved(removed2222);
                                    }
                                    catch (Throwable e2) {
                                        Debug.out(e2);
                                    }
                                }
                            }
                            throw throwable;
                        }
                        Map map = BuddyPluginBeta.this.chat_instances_map;
                        synchronized (map) {
                            ChatInstance inst = (ChatInstance)BuddyPluginBeta.this.chat_instances_map.remove(meta_key2222);
                            if (inst != null) {
                                removed2222 = inst;
                                BuddyPluginBeta.this.chat_instances_list.remove(inst);
                            }
                            if (BuddyPluginBeta.this.chat_instances_map.size() == 0 && BuddyPluginBeta.this.timer != null) {
                                BuddyPluginBeta.this.timer.cancel();
                                BuddyPluginBeta.this.timer = null;
                            }
                        }
                        if (removed2222 != null) {
                            for (ChatManagerListener l : BuddyPluginBeta.this.listeners) {
                                try {
                                    l.chatRemoved(removed2222);
                                }
                                catch (Throwable e2) {
                                    Debug.out(e2);
                                }
                            }
                        }
                        break block36;
                        {
                            catch (Throwable e) {
                                Debug.out(e);
                                Object var4_6 = null;
                                String meta_key2222 = this.network + ":" + this.key;
                                removed2222 = null;
                                Map map2 = BuddyPluginBeta.this.chat_instances_map;
                                synchronized (map2) {
                                    ChatInstance inst = (ChatInstance)BuddyPluginBeta.this.chat_instances_map.remove(meta_key2222);
                                    if (inst != null) {
                                        removed2222 = inst;
                                        BuddyPluginBeta.this.chat_instances_list.remove(inst);
                                    }
                                    if (BuddyPluginBeta.this.chat_instances_map.size() == 0 && BuddyPluginBeta.this.timer != null) {
                                        BuddyPluginBeta.this.timer.cancel();
                                        BuddyPluginBeta.this.timer = null;
                                    }
                                }
                                if (removed2222 != null) {
                                    for (ChatManagerListener l : BuddyPluginBeta.this.listeners) {
                                        try {
                                            l.chatRemoved(removed2222);
                                        }
                                        catch (Throwable e2) {
                                            Debug.out(e2);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface ChatListener {
        public void messageReceived(ChatMessage var1);

        public void messagesChanged();

        public void participantAdded(ChatParticipant var1);

        public void participantChanged(ChatParticipant var1);

        public void participantRemoved(ChatParticipant var1);

        public void stateChanged(boolean var1);

        public void updated();
    }

    public static interface ChatManagerListener {
        public void chatAdded(ChatInstance var1);

        public void chatRemoved(ChatInstance var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChatMessage {
        public static final int MT_NORMAL = 1;
        public static final int MT_INFO = 2;
        public static final int MT_ERROR = 3;
        private final int uid;
        private final Map<String, Object> map;
        private final byte[] message_id;
        private final long timestamp;
        private ChatParticipant participant;
        private byte[] previous_id;
        private boolean is_ignored;
        private boolean is_nick_clash;

        private ChatMessage(int _uid, Map<String, Object> _map) {
            this.uid = _uid;
            this.map = _map;
            this.message_id = (byte[])this.map.get("id");
            this.timestamp = SystemTime.getCurrentTime() - (long)this.getAge() * 1000L;
            Map<String, Object> payload = this.getPayload();
            this.previous_id = (byte[])payload.get("pre");
        }

        protected int getUID() {
            return this.uid;
        }

        private void setParticipant(ChatParticipant p) {
            this.participant = p;
        }

        public ChatParticipant getParticipant() {
            return this.participant;
        }

        private void setNickClash(boolean clash) {
            this.is_nick_clash = clash;
        }

        public boolean isNickClash() {
            return this.is_nick_clash;
        }

        private Map<String, Object> getPayload() {
            try {
                byte[] content_bytes = (byte[])this.map.get("content");
                if (content_bytes != null && content_bytes.length > 0) {
                    return BDecoder.decode(content_bytes);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new HashMap<String, Object>();
        }

        private int getMessageStatus() {
            Number status;
            Map flags;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (flags = (Map)payload.get(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE)) != null && (status = (Number)flags.get(BuddyPluginBeta.FLAGS_MSG_STATUS_KEY)) != null) {
                return status.intValue();
            }
            return 0;
        }

        private boolean getFlagFlashOverride() {
            Number override;
            Map flags;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (flags = (Map)payload.get(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE)) != null && (override = (Number)flags.get(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE)) != null) {
                return override.intValue() != 0;
            }
            return false;
        }

        public String getMessage() {
            try {
                byte[] msg_bytes;
                String report = (String)this.map.get("error");
                if (report != null) {
                    if (report.length() > 2 && report.charAt(1) == ':') {
                        return report.substring(2);
                    }
                    return report;
                }
                if (this.getMessageStatus() == 1) {
                    return this.participant.getName() + " has quit";
                }
                Map<String, Object> payload = this.getPayload();
                if (payload != null && (msg_bytes = (byte[])payload.get("msg")) != null) {
                    return new String(msg_bytes, "UTF-8");
                }
                return new String((byte[])this.map.get("content"), "UTF-8");
            }
            catch (Throwable e) {
                Debug.out(e);
                return "";
            }
        }

        public int getMessageType() {
            String report = (String)this.map.get("error");
            if (report == null) {
                if (this.getMessageStatus() == 1) {
                    return 2;
                }
                return 1;
            }
            if (report.length() < 2 || report.charAt(1) != ':') {
                return 3;
            }
            char type = report.charAt(0);
            if (type == 'i') {
                return 2;
            }
            return 3;
        }

        public boolean isIgnored() {
            return this.is_ignored;
        }

        public void setIgnored(boolean b) {
            this.is_ignored = b;
        }

        public byte[] getID() {
            return this.message_id;
        }

        public byte[] getPreviousID() {
            return this.previous_id;
        }

        private void setPreviousID(byte[] pid) {
            this.previous_id = pid;
        }

        public byte[] getPublicKey() {
            return (byte[])this.map.get("pk");
        }

        public Map<String, Object> getContact() {
            return (Map)this.map.get("contact");
        }

        public InetSocketAddress getAddress() {
            return (InetSocketAddress)this.map.get("address");
        }

        private int getAge() {
            return ((Number)this.map.get("age")).intValue();
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public String getNickName() {
            Object nick;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (nick = (byte[])payload.get("nick")) != null) {
                try {
                    String str = new String((byte[])nick, "UTF-8");
                    if (str.length() > 0) {
                        return str;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.getMessageType() != 1 && ((String)(nick = (Object)this.participant.getChat().getNickname())).length() > 0) {
                return nick;
            }
            return BuddyPluginBeta.this.pkToString(this.getPublicKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChatParticipant {
        private final ChatInstance chat;
        private final byte[] pk;
        private String nickname;
        private boolean is_ignored;
        private boolean is_spammer;
        private boolean is_pinned;
        private boolean nick_clash;
        private List<ChatMessage> participant_messages = new ArrayList<ChatMessage>();
        private Boolean is_me;

        private ChatParticipant(ChatInstance _chat, byte[] _pk) {
            this.chat = _chat;
            this.pk = _pk;
            this.nickname = BuddyPluginBeta.this.pkToString(this.pk);
            this.is_pinned = COConfigurationManager.getBooleanParameter(this.getPinKey(), false);
            this.chat.registerNick(this, null, this.nickname);
        }

        public ChatInstance getChat() {
            return this.chat;
        }

        public byte[] getPublicKey() {
            return this.pk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> getContact() {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                if (this.participant_messages.isEmpty()) {
                    return null;
                }
                return this.participant_messages.get(this.participant_messages.size() - 1).getContact();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InetSocketAddress getAddress() {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                if (this.participant_messages.isEmpty()) {
                    return null;
                }
                return this.participant_messages.get(this.participant_messages.size() - 1).getAddress();
            }
        }

        public boolean isMe() {
            if (this.is_me != null) {
                return this.is_me;
            }
            byte[] chat_key = this.chat.getPublicKey();
            if (chat_key != null) {
                this.is_me = Arrays.equals(this.pk, chat_key);
            }
            return this.is_me == null ? false : this.is_me;
        }

        public String getName() {
            return this.getName(true);
        }

        public String getName(boolean use_nick) {
            if (use_nick) {
                return this.nickname;
            }
            return BuddyPluginBeta.this.pkToString(this.pk);
        }

        public boolean hasNickname() {
            return !this.nickname.equals(BuddyPluginBeta.this.pkToString(this.pk));
        }

        private void addMessage(ChatMessage message) {
            this.participant_messages.add(message);
            message.setParticipant(this);
            message.setIgnored(this.is_ignored || this.is_spammer);
            String new_nickname = message.getNickName();
            if (!this.nickname.equals(new_nickname)) {
                this.chat.registerNick(this, this.nickname, new_nickname);
                message.setNickClash(this.isNickClash());
                this.nickname = new_nickname;
                this.chat.updated(this);
            } else {
                message.setNickClash(this.isNickClash());
            }
        }

        private boolean replayMessage(ChatMessage message) {
            this.participant_messages.add(message);
            message.setIgnored(this.is_ignored || this.is_spammer);
            String new_nickname = message.getNickName();
            if (!this.nickname.equals(new_nickname)) {
                this.chat.registerNick(this, this.nickname, new_nickname);
                message.setNickClash(this.isNickClash());
                this.nickname = new_nickname;
                return true;
            }
            message.setNickClash(this.isNickClash());
            return false;
        }

        private void removeMessage(ChatMessage message) {
            this.participant_messages.remove(message);
        }

        private void resetMessages() {
            String new_nickname = BuddyPluginBeta.this.pkToString(this.pk);
            if (!this.nickname.equals(new_nickname)) {
                this.chat.registerNick(this, this.nickname, new_nickname);
                this.nickname = new_nickname;
            }
            this.participant_messages.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ChatMessage> getMessages() {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                return new ArrayList<ChatMessage>(this.participant_messages);
            }
        }

        public boolean isIgnored() {
            return this.is_ignored;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIgnored(boolean b) {
            if (b != this.is_ignored) {
                this.is_ignored = b;
                Object object = this.chat.chat_lock;
                synchronized (object) {
                    for (ChatMessage message : this.participant_messages) {
                        message.setIgnored(b || this.is_spammer);
                    }
                }
            }
        }

        public boolean isSpammer() {
            return this.is_spammer;
        }

        public boolean canSpammer() {
            return this.participant_messages.size() >= 5 && !this.is_spammer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSpammer(boolean b) {
            if (b != this.is_spammer) {
                this.is_spammer = b;
                this.chat.setSpammer(this, b);
                Object object = this.chat.chat_lock;
                synchronized (object) {
                    for (ChatMessage message : this.participant_messages) {
                        message.setIgnored(b || this.is_ignored);
                    }
                }
            }
        }

        public boolean isPinned() {
            return this.is_pinned;
        }

        private String getPinKey() {
            return "azbuddy.chat.pinned." + ByteFormatter.encodeString(this.pk, 0, 16);
        }

        public void setPinned(boolean b) {
            if (b != this.is_pinned) {
                this.is_pinned = b;
                String key = this.getPinKey();
                if (this.is_pinned) {
                    COConfigurationManager.setParameter(key, true);
                } else {
                    COConfigurationManager.removeParameter(key);
                }
                COConfigurationManager.setDirty();
            }
        }

        public boolean isNickClash() {
            return this.nick_clash;
        }

        private void setNickClash(boolean b) {
            this.nick_clash = b;
        }

        public ChatInstance createPrivateChat() throws Exception {
            ChatInstance inst = BuddyPluginBeta.this.getChat(this);
            ChatInstance parent = this.getChat();
            if (!parent.isSharedNickname()) {
                inst.setSharedNickname(false);
                inst.setInstanceNickname(parent.getInstanceNickname());
            }
            return inst;
        }
    }

    public static interface FTUXStateChangeListener {
        public void stateChanged(boolean var1);
    }
}

