/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginViewInterface;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPluginUtils {
    private static AsyncDispatcher peek_dispatcher = new AsyncDispatcher("peeker");
    private static final Object i2p_install_lock = new Object();
    private static boolean i2p_installing = false;

    private static BuddyPlugin getPlugin() {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azbuddy", true);
        if (pi != null) {
            return (BuddyPlugin)pi.getPlugin();
        }
        return null;
    }

    public static BuddyPluginBeta getBetaPlugin() {
        BuddyPluginBeta beta;
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled() && (beta = bp.getBeta()).isAvailable()) {
            return beta;
        }
        return null;
    }

    public static boolean isBetaChatAvailable() {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().isAvailable();
        }
        return false;
    }

    public static boolean isBetaChatAnonAvailable() {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().isAvailable() && bp.getBeta().isI2PAvailable();
        }
        return false;
    }

    public static void createBetaChat(final String network, final String key, final Runnable callback) {
        new AEThread2("Chat create async"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
                        bp.getBeta().getAndShowChat(network, key);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        Object var3_4 = null;
                        if (callback != null) {
                            callback.run();
                        }
                    }
                    Object var3_3 = null;
                    if (callback != null) {
                        callback.run();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (callback != null) {
                        callback.run();
                    }
                    throw throwable;
                }
            }
        }.start();
    }

    public static Map<String, Object> peekChat(String net, String key) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().peekChat(net, key);
        }
        return null;
    }

    public static Map<String, Object> peekChat(Download download) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().peekChat(download);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void peekChatAsync(final String net, final String key, final Runnable done) {
        boolean async;
        block4: {
            block5: {
                async = false;
                try {
                    if (!BuddyPluginUtils.isBetaChatAvailable()) break block4;
                    if (net != "Public" && !BuddyPluginUtils.isBetaChatAnonAvailable()) {
                        Object var5_4 = null;
                        if (async) return;
                        done.run();
                        return;
                    }
                    if (peek_dispatcher.getQueueSize() > 200) {
                        break block5;
                    }
                    peek_dispatcher.dispatch(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            try {
                                Map<String, Object> peek_data = BuddyPluginUtils.peekChat(net, key);
                                if (peek_data != null) {
                                    BuddyPluginBeta.ChatInstance chat;
                                    Number message_count = (Number)peek_data.get("m");
                                    Number node_count = (Number)peek_data.get("n");
                                    if (message_count != null && node_count != null && message_count.intValue() > 0 && (chat = BuddyPluginUtils.getChat(net, key)) != null) {
                                        chat.setAutoNotify(true);
                                    }
                                }
                                Object var6_5 = null;
                                done.run();
                            }
                            catch (Throwable throwable) {
                                Object var6_6 = null;
                                done.run();
                                throw throwable;
                            }
                        }
                    });
                    async = true;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (async) throw throwable;
                    done.run();
                    throw throwable;
                }
            }
            Object var5_5 = null;
            if (async) return;
            done.run();
            return;
        }
        Object var5_6 = null;
        if (async) return;
        done.run();
    }

    public static BuddyPluginBeta.ChatInstance getChat(String net, String key) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            try {
                return bp.getBeta().getChat(net, key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static BuddyPluginBeta.ChatInstance getChat(Download download) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().getChat(download);
        }
        return null;
    }

    public static BuddyPluginViewInterface.View buildChatView(Map<String, Object> properties, BuddyPluginViewInterface.ViewListener listener) {
        BuddyPluginViewInterface ui;
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled() && bp.getBeta().isAvailable() && (ui = bp.getSWTUI()) != null) {
            return ui.buildView(properties, listener);
        }
        return null;
    }

    public static String getChatKey(TOTorrent torrent) {
        if (torrent == null) {
            return null;
        }
        return BuddyPluginUtils.getChatKey(PluginCoreUtils.wrap(torrent));
    }

    public static String getChatKey(Download download) {
        return BuddyPluginUtils.getChatKey(download.getTorrent());
    }

    public static String getChatKey(Torrent torrent) {
        if (torrent == null) {
            return null;
        }
        String torrent_name = null;
        try {
            TOTorrent to_torrent = PluginCoreUtils.unwrap(torrent);
            torrent_name = to_torrent.getUTF8Name();
            if (torrent_name == null) {
                torrent_name = new String(to_torrent.getName(), "UTF-8");
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (torrent_name == null) {
            torrent_name = torrent.getName();
        }
        String key = "Download: " + torrent_name + " {" + ByteFormatter.encodeString(torrent.getHash()) + "}";
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstallingI2PHelper() {
        Object object = i2p_install_lock;
        synchronized (object) {
            return i2p_installing;
        }
    }

    public static boolean installI2PHelper(String remember_id, boolean[] install_outcome, Runnable callback) {
        return BuddyPluginUtils.installI2PHelper(null, remember_id, install_outcome, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installI2PHelper(String extra_text, String remember_id, final boolean[] install_outcome, final Runnable callback) {
        boolean bl;
        block21: {
            boolean install;
            UIFunctions uif;
            boolean installing;
            block19: {
                boolean bl2;
                block20: {
                    Object object;
                    Object object2 = i2p_install_lock;
                    synchronized (object2) {
                        if (i2p_installing) {
                            Debug.out("I2P Helper already installing");
                            return false;
                        }
                        i2p_installing = true;
                    }
                    installing = false;
                    try {
                        uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) break block19;
                        Debug.out("UIFunctions unavailable - can't install plugin");
                        bl2 = false;
                        Object var12_10 = null;
                        if (installing) break block20;
                        object = i2p_install_lock;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        if (!installing) {
                            Object object3 = i2p_install_lock;
                            synchronized (object3) {
                                i2p_installing = false;
                            }
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        i2p_installing = false;
                    }
                }
                return bl2;
            }
            String title = MessageText.getString("azneti2phelper.install");
            String text = "";
            if (extra_text != null) {
                text = extra_text + "\n\n";
            }
            text = text + MessageText.getString("azneti2phelper.install.text");
            UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
            if (remember_id != null) {
                prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            }
            prompter.setAutoCloseInMS(0);
            prompter.open(null);
            boolean bl3 = install = prompter.waitUntilClosed() == 0;
            if (install) {
                installing = true;
                uif.installPlugin("azneti2phelper", "azneti2phelper.install", new UIFunctions.actionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionComplete(Object result) {
                        try {
                            if (callback != null) {
                                if (result instanceof Boolean) {
                                    install_outcome[0] = (Boolean)result;
                                }
                                callback.run();
                            }
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            Object object = i2p_install_lock;
                            synchronized (object) {
                                i2p_installing = false;
                            }
                            throw throwable;
                        }
                        Object object = i2p_install_lock;
                        synchronized (object) {
                            i2p_installing = false;
                        }
                    }
                });
            } else {
                Debug.out("I2P Helper install declined (either user reply or auto-remembered)");
            }
            bl = install;
            Object var12_11 = null;
            if (installing) break block21;
            Object object = i2p_install_lock;
            synchronized (object) {
                i2p_installing = false;
            }
        }
        return bl;
    }
}

