/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import com.aelitis.azureus.core.AzureusCoreFactory;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.TorrentCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentLog
extends TorrentCommand
implements ILogEventListener {
    private static int MODE_OFF = 0;
    private static int MODE_ON = 1;
    private static int MODE_FLIP = 2;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("[h:mm:ss.SSS] ");
    private static FieldPosition formatPos = new FieldPosition(0);
    private int mode = 0;
    private AEMonitor dms_mon = new AEMonitor("TorrentLog");
    private ArrayList dms = new ArrayList();
    private boolean gm_listener_added;

    public TorrentLog() {
        super("tlog", "tl", "Torrent Logging");
    }

    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        this.mode = MODE_ON;
        Vector<String> newargs = new Vector<String>(args);
        if (newargs.isEmpty()) {
            this.mode = MODE_FLIP;
        } else if (newargs.contains("off")) {
            newargs.removeElement("off");
            this.mode = MODE_OFF;
        } else if (!newargs.contains("on")) {
            this.mode = MODE_FLIP;
        }
        super.execute(commandName, ci, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        block12: {
            try {
                try {
                    boolean turnOn;
                    this.dms_mon.enter();
                    if (!this.gm_listener_added) {
                        this.gm_listener_added = true;
                        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                        gm.addListener(new GlobalManagerAdapter(){

                            public void downloadManagerRemoved(DownloadManager dm) {
                                TorrentLog.this.dms.remove(dm);
                            }
                        }, false);
                    }
                    if (this.mode == MODE_FLIP) {
                        turnOn = !this.dms.contains(dm);
                    } else {
                        boolean bl = turnOn = this.mode == MODE_ON;
                    }
                    if (turnOn) {
                        ci.out.print("->on] ");
                        if (this.dms.contains(dm)) {
                            boolean bl = true;
                            Object var7_9 = null;
                            this.dms_mon.exit();
                            return bl;
                        }
                        this.dms.add(dm);
                        if (this.dms.size() == 1) {
                            Logger.addListener(this);
                        }
                        break block12;
                    }
                    ci.out.print("->off] ");
                    this.dms.remove(dm);
                    if (this.dms.size() == 0) {
                        Logger.removeListener(this);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(ci.out);
                    boolean bl = false;
                    Object var7_11 = null;
                    this.dms_mon.exit();
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                this.dms_mon.exit();
                throw throwable;
            }
        }
        Object var7_10 = null;
        this.dms_mon.exit();
        return true;
    }

    @Override
    public String getCommandDescriptions() {
        return "tl [on|off]\tTorrentLogging";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(LogEvent event2) {
        boolean bMatch = false;
        if (event2.relatedTo == null) {
            return;
        }
        try {
            this.dms_mon.enter();
            for (int i = 0; !bMatch && i < event2.relatedTo.length; ++i) {
                Object obj = event2.relatedTo[i];
                if (obj == null) continue;
                for (int j = 0; !bMatch && j < this.dms.size(); ++j) {
                    Object newObj;
                    if (obj instanceof LogRelation && (newObj = ((LogRelation)obj).queryForClass(DownloadManager.class)) != null) {
                        obj = newObj;
                    }
                    if (obj != this.dms.get(j)) continue;
                    bMatch = true;
                }
            }
            Object var8_11 = null;
            this.dms_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.dms_mon.exit();
            throw throwable;
        }
        if (bMatch) {
            StringBuffer buf = new StringBuffer();
            dateFormatter.format(event2.timeStamp, buf, formatPos);
            buf.append("{").append(event2.logID).append("} ");
            buf.append(event2.text);
            if (event2.relatedTo != null) {
                buf.append("; \t| ");
                for (int j = 0; j < event2.relatedTo.length; ++j) {
                    Object obj = event2.relatedTo[j];
                    if (j > 0) {
                        buf.append("; ");
                    }
                    if (obj instanceof LogRelation) {
                        buf.append(((LogRelation)obj).getRelationText());
                        continue;
                    }
                    if (obj == null) continue;
                    buf.append(obj.getClass().getName()).append(": '").append(obj.toString()).append("'");
                }
            }
            System.out.println(buf.toString());
        }
    }
}

