/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.shell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.ui.swt.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellManager {
    private static ShellManager instance = new ShellManager();
    private final Collection<Shell> shells = new ArrayList<Shell>();
    private final List addHandlers = new LinkedList();
    private final List removeHandlers = new LinkedList();

    public static final ShellManager sharedManager() {
        return instance;
    }

    public final void addWindow(final Shell shell) {
        if (this.shells.contains(shell)) {
            return;
        }
        this.shells.add(shell);
        this.notifyAddListeners(shell);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                try {
                    ShellManager.this.removeWindow(shell);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "removeWindow", e));
                }
            }
        });
        shell.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                Utils.verifyShellRect(shell, false);
            }
        });
    }

    public final void removeWindow(Shell shell) {
        this.shells.remove(shell);
        this.notifyRemoveListeners(shell);
    }

    public final Iterator<Shell> getWindows() {
        return this.shells.iterator();
    }

    public final boolean isEmpty() {
        return this.shells.isEmpty();
    }

    public final int getSize() {
        return this.shells.size();
    }

    public final void performForShells(Listener command) {
        Iterator<Shell> iter = this.shells.iterator();
        for (int i = 0; i < this.shells.size(); ++i) {
            Shell aShell = iter.next();
            Event evt = new Event();
            evt.widget = aShell;
            evt.data = this;
            command.handleEvent(evt);
        }
    }

    protected final Collection getManagedShellSet() {
        return this.shells;
    }

    public final void addWindowAddedListener(Listener listener) {
        this.addHandlers.add(listener);
    }

    public final void removeWindowAddedListener(Listener listener) {
        this.addHandlers.remove(listener);
    }

    public final void addWindowRemovedListener(Listener listener) {
        this.removeHandlers.add(listener);
    }

    public final void removeWindowRemovedListener(Listener listener) {
        this.removeHandlers.remove(listener);
    }

    protected final void notifyAddListeners(Shell sender) {
        Iterator iter = this.addHandlers.iterator();
        for (int i = 0; i < this.addHandlers.size(); ++i) {
            ((Listener)iter.next()).handleEvent(this.getSWTEvent(sender));
        }
    }

    protected final void notifyRemoveListeners(Shell sender) {
        Iterator iter = this.removeHandlers.iterator();
        for (int i = 0; i < this.removeHandlers.size(); ++i) {
            ((Listener)iter.next()).handleEvent(this.getSWTEvent(sender));
        }
    }

    protected Event getSWTEvent(Shell shell) {
        Event e = new Event();
        e.widget = shell;
        e.item = shell;
        return e;
    }
}

