/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.DebugMenuHelper;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;

public class MainMenu
implements IMainMenu {
    private Menu menuBar;

    public MainMenu(Shell shell) {
        this.createMenus(shell);
    }

    public void linkMenuBar(Shell parent) {
        parent.setMenuBar(this.menuBar);
    }

    private void createMenus(Shell parent) {
        this.menuBar = new Menu((Decorations)parent, 2);
        parent.setMenuBar(this.menuBar);
        this.addFileMenu(parent);
        if (Constants.isOSX) {
            this.addViewMenu(parent);
            this.addTransferMenu(parent);
            this.addTorrentMenu(parent);
        } else {
            this.addTransferMenu(parent);
            this.addTorrentMenu(parent);
            this.addViewMenu(parent);
            this.addToolsMenu(parent);
        }
        this.addPluginsMenu(parent);
        if (Constants.isOSX) {
            this.addWindowMenu(parent);
        }
        if (Constants.isCVSVersion()) {
            DebugMenuHelper.createDebugMenuItem(this.menuBar);
        }
        this.addV2HelpMenu(parent);
        MenuFactory.updateEnabledStates(this.menuBar);
    }

    private void addWindowMenu(Shell parent) {
        MenuItem menu_window = MenuFactory.createWindowMenuItem(this.menuBar);
        Menu windowMenu = menu_window.getMenu();
        MenuFactory.addMinimizeWindowMenuItem(windowMenu);
        MenuFactory.addZoomWindowMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.addBlockedIPsMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.addBringAllToFrontMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.appendWindowMenuItems(windowMenu);
    }

    private void addFileMenu(Shell parent) {
        MenuItem fileItem = MenuFactory.createFileMenuItem(this.menuBar);
        Menu fileMenu = fileItem.getMenu();
        MenuFactory.addCreateMenuItem(fileMenu);
        MenuItem openMenuItem = MenuFactory.createOpenMenuItem(fileMenu);
        Menu openSubMenu = openMenuItem.getMenu();
        MenuFactory.addOpenTorrentMenuItem(openSubMenu);
        MenuFactory.addOpenURIMenuItem(openSubMenu);
        MenuFactory.addOpenTorrentForTrackingMenuItem(openSubMenu);
        MenuFactory.addOpenVuzeFileMenuItem(openSubMenu);
        MenuItem shareMenuItem = MenuFactory.createShareMenuItem(fileMenu);
        Menu shareSubMenu = shareMenuItem.getMenu();
        MenuFactory.addShareFileMenuItem(shareSubMenu);
        MenuFactory.addShareFolderMenuItem(shareSubMenu);
        MenuFactory.addShareFolderContentMenuItem(shareSubMenu);
        MenuFactory.addShareFolderContentRecursiveMenuItem(shareSubMenu);
        MenuFactory.addSearchMenuItem(fileMenu);
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.addImportMenuItem(fileMenu);
        MenuFactory.addExportMenuItem(fileMenu);
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.addCloseWindowMenuItem(fileMenu);
        MenuFactory.addCloseTabMenuItem(fileMenu);
        MenuFactory.addCloseDetailsMenuItem(fileMenu);
        MenuFactory.addCloseDownloadBarsToMenu(fileMenu);
        if (!Utils.isCarbon) {
            MenuFactory.addSeparatorMenuItem(fileMenu);
            MenuFactory.addRestartMenuItem(fileMenu);
        }
        if (!Constants.isOSX) {
            MenuFactory.addExitMenuItem(fileMenu);
        }
    }

    private void addTransferMenu(Shell parent) {
        MenuFactory.createTransfersMenuItem(this.menuBar);
    }

    private void addViewMenu(Shell parent) {
        try {
            MenuItem viewItem = MenuFactory.createViewMenuItem(this.menuBar);
            final Menu viewMenu = viewItem.getMenu();
            viewMenu.addListener(22, new Listener(){

                public void handleEvent(Event event2) {
                    Utils.disposeSWTObjects(viewMenu.getItems());
                    MainMenu.this.buildSimpleViewMenu(viewMenu);
                }
            });
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    protected void buildSimpleViewMenu(Menu viewMenu) {
        try {
            boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
            if (enabled) {
                MenuFactory.addMenuItem(viewMenu, 32, "MainWindow.menu.view.beta", new Listener(){

                    public void handleEvent(Event event2) {
                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                        MdiEntry entry = mdi.createEntryFromSkinRef(null, "BetaProgramme", "main.area.beta", "{Sidebar.beta.title}", null, null, true, "");
                        entry.setImageLeftID("image.sidebar.beta");
                        mdi.showEntry(entry);
                    }
                });
            }
            MenuFactory.addMyTorrentsMenuItem(viewMenu);
            MenuFactory.addMyTrackerMenuItem(viewMenu);
            MenuFactory.addMySharesMenuItem(viewMenu);
            MenuFactory.addViewToolbarMenuItem(viewMenu);
            MenuFactory.addTransferBarToMenu(viewMenu);
            MenuFactory.addAllPeersMenuItem(viewMenu);
            MenuFactory.addClientStatsMenuItem(viewMenu);
            MenuFactory.addPairingMenuItem(viewMenu);
            if (PluginsMenuHelper.getInstance().buildViewMenu(viewMenu, viewMenu.getShell()) && Constants.isOSX) {
                MenuFactory.addSeparatorMenuItem(viewMenu);
            }
            if (Constants.isOSX) {
                MenuFactory.addConsoleMenuItem(viewMenu);
                MenuFactory.addStatisticsMenuItem(viewMenu);
                MenuFactory.addSpeedLimitsToMenu(viewMenu);
            }
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void addTorrentMenu(Shell parent) {
        if (COConfigurationManager.getBooleanParameter("show_torrents_menu")) {
            MenuFactory.createTorrentMenuItem(this.menuBar);
        }
    }

    private void addToolsMenu(Shell parent) {
        MenuItem item = MenuFactory.createToolsMenuItem(this.menuBar);
        Menu toolsMenu = item.getMenu();
        MenuFactory.addBlockedIPsMenuItem(toolsMenu);
        MenuFactory.addConsoleMenuItem(toolsMenu);
        MenuFactory.addStatisticsMenuItem(toolsMenu);
        MenuFactory.addSpeedLimitsToMenu(toolsMenu);
        MenuFactory.addNatTestMenuItem(toolsMenu);
        MenuFactory.addSpeedTestMenuItem(toolsMenu);
        MenuFactory.addSeparatorMenuItem(toolsMenu);
        MenuFactory.addConfigWizardMenuItem(toolsMenu);
        MenuFactory.addOptionsMenuItem(toolsMenu);
    }

    private void addPluginsMenu(Shell parent) {
        MenuFactory.createPluginsMenuItem(this.menuBar, false);
    }

    private void addV2HelpMenu(Shell parent) {
        MenuItem helpItem = MenuFactory.createHelpMenuItem(this.menuBar);
        Menu helpMenu = helpItem.getMenu();
        if (!Constants.isOSX) {
            MenuFactory.addAboutMenuItem(helpMenu);
            MenuFactory.addSeparatorMenuItem(helpMenu);
        }
        MenuFactory.addHealthMenuItem(helpMenu);
        MenuFactory.addReleaseNotesMenuItem(helpMenu);
        MenuFactory.addWhatsNewMenuItem(helpMenu);
        MenuFactory.addWikiMenuItem(helpMenu);
        MenuFactory.addGetPluginsMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        if (!SystemProperties.isJavaWebStartInstance()) {
            MenuFactory.addCheckUpdateMenuItem(helpMenu);
            MenuFactory.addBetaMenuItem(helpMenu);
            MenuFactory.addVoteMenuItem(helpMenu);
        }
        MenuFactory.addDonationMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        MenuFactory.addAdvancedHelpMenuItem(helpMenu);
        MenuFactory.addDebugHelpMenuItem(helpMenu);
    }

    public Menu getMenu(String id) {
        if ("menu.bar".equals(id)) {
            return this.menuBar;
        }
        return MenuFactory.findMenu(this.menuBar, id);
    }
}

