/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesListener;
import com.aelitis.azureus.activities.VuzeActivitiesLoadedListener;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkListener;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManager;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetworkPropertyChangeListener;
import com.aelitis.azureus.core.messenger.config.PlatformVuzeActivitiesMessenger;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VuzeActivitiesManager {
    public static final long MAX_LIFE_MS = 63072000000L;
    private static final long DEFAULT_PLATFORM_REFRESH = 86400000L;
    private static final String SAVE_FILENAME = "VuzeActivities.config";
    private static ArrayList<VuzeActivitiesListener> listeners = new ArrayList();
    private static ArrayList<VuzeActivitiesLoadedListener> listenersLoaded = new ArrayList();
    private static final Object listenersLoadedLock = new Object();
    private static ArrayList<VuzeActivitiesEntry> allEntries = new ArrayList();
    private static AEMonitor allEntries_mon = new AEMonitor("VuzeActivityMan");
    private static List<VuzeActivitiesEntry> removedEntries = new ArrayList<VuzeActivitiesEntry>();
    private static PlatformVuzeActivitiesMessenger.GetEntriesReplyListener replyListener;
    private static AEDiagnosticsLogger diag_logger;
    private static Map<String, Long> lastNewsAt;
    private static boolean skipAutoSave;
    private static AEMonitor config_mon;
    private static boolean saveEventsOnClose;

    public static void initialize(final AzureusCore core) {
        new AEThread2("lazy init", true){

            public void run() {
                VuzeActivitiesManager._initialize(core);
            }
        }.start();
    }

    private static void _initialize(AzureusCore core) {
        if (diag_logger != null) {
            diag_logger.log("Initialize Called");
        }
        core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void stopping(AzureusCore core) {
                if (saveEventsOnClose) {
                    VuzeActivitiesManager.saveEventsNow();
                }
            }
        });
        VuzeActivitiesManager.loadEvents();
        ContentNetworkManager cnm = ContentNetworkManagerFactory.getSingleton();
        if (cnm != null) {
            ContentNetwork[] contentNetworks = cnm.getContentNetworks();
            cnm.addListener(new ContentNetworkListener(){

                public void networkRemoved(ContentNetwork network) {
                }

                public void networkChanged(ContentNetwork network) {
                }

                public void networkAdded(ContentNetwork cn) {
                    VuzeActivitiesManager.setupContentNetwork(cn);
                }

                public void networkAddFailed(long network_id, Throwable error) {
                }
            });
            for (ContentNetwork cn : contentNetworks) {
                VuzeActivitiesManager.setupContentNetwork(cn);
            }
        }
        replyListener = new PlatformVuzeActivitiesMessenger.GetEntriesReplyListener(){

            public void gotVuzeNewsEntries(VuzeActivitiesEntry[] entries, long refreshInMS) {
                if (diag_logger != null) {
                    diag_logger.log("Received Reply from platform with " + entries.length + " entries.  Refresh in " + refreshInMS);
                }
                VuzeActivitiesManager.addEntries(entries);
                if (refreshInMS <= 0L) {
                    refreshInMS = 86400000L;
                }
                SimpleTimer.addEvent("GetVuzeNews", SystemTime.getOffsetTime(refreshInMS), new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        VuzeActivitiesManager.pullActivitiesNow(5000L, "timer", false);
                    }
                });
            }
        };
        VuzeActivitiesManager.pullActivitiesNow(5000L, "initial", false);
    }

    private static void setupContentNetwork(final ContentNetwork cn) {
        cn.addPersistentPropertyChangeListener(new ContentNetworkPropertyChangeListener(){

            public void propertyChanged(String name) {
                boolean isActive;
                if (!"active".equals(name)) {
                    return;
                }
                Object oIsActive = cn.getPersistentProperty("active");
                boolean bl = isActive = oIsActive instanceof Boolean ? (Boolean)oIsActive : false;
                if (isActive) {
                    VuzeActivitiesManager.pullActivitiesNow(2000L, "CN:PropChange", false);
                }
            }
        });
    }

    public static void pullActivitiesNow(long delay, String reason, boolean alwaysPull) {
        ContentNetwork cn = ConstantsVuze.getDefaultContentNetwork();
        if (cn == null) {
            return;
        }
        String id = "" + cn.getID();
        Long oLastPullTime = lastNewsAt.get(id);
        long lastPullTime = oLastPullTime != null ? oLastPullTime : 0L;
        long now = SystemTime.getCurrentTime();
        long diff = now - lastPullTime;
        if (!alwaysPull && diff < 5000L) {
            return;
        }
        if (diff > 63072000000L) {
            diff = 63072000000L;
        }
        PlatformVuzeActivitiesMessenger.getEntries(diff, delay, reason, replyListener);
    }

    public static void clearLastPullTimes() {
        lastNewsAt = new HashMap<String, Long>();
    }

    public static void resetRemovedEntries() {
        removedEntries.clear();
        VuzeActivitiesManager.saveEvents();
    }

    private static void saveEvents() {
        saveEventsOnClose = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEvents() {
        block31: {
            Object value2;
            long cutoffTime;
            Object object;
            Map map;
            skipAutoSave = true;
            try {
                map = FileUtil.readResilientConfigFile(SAVE_FILENAME);
                if (map == null || map.size() <= 0 || MapUtils.getMapLong(map, "version", 0L) >= 2L) break block32;
                VuzeActivitiesManager.clearLastPullTimes();
                skipAutoSave = false;
                VuzeActivitiesManager.saveEventsNow();
                Object var10_1 = null;
                skipAutoSave = false;
                object = listenersLoadedLock;
            }
            catch (Throwable throwable) {
                Object var10_4 = null;
                skipAutoSave = false;
                Object object2 = listenersLoadedLock;
                synchronized (object2) {
                    if (listenersLoaded != null) {
                        for (VuzeActivitiesLoadedListener l : listenersLoaded) {
                            try {
                                l.vuzeActivitiesLoaded();
                            }
                            catch (Exception e) {
                                Debug.out(e);
                            }
                        }
                        listenersLoaded = null;
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                if (listenersLoaded != null) {
                    for (VuzeActivitiesLoadedListener l : listenersLoaded) {
                        try {
                            l.vuzeActivitiesLoaded();
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                    }
                    listenersLoaded = null;
                }
            }
            {
                List newRemovedEntries;
                long lastVuzeNewsAt;
                block32: {
                    return;
                }
                cutoffTime = VuzeActivitiesManager.getCutoffTime();
                try {
                    lastNewsAt = MapUtils.getMapMap(map, "LastChecks", new HashMap());
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                if (lastNewsAt.size() == 0 && (lastVuzeNewsAt = MapUtils.getMapLong(map, "LastCheck", 0L)) > 0L) {
                    if (lastVuzeNewsAt < cutoffTime) {
                        lastVuzeNewsAt = cutoffTime;
                    }
                    lastNewsAt.put("1", new Long(lastVuzeNewsAt));
                }
                if ((newRemovedEntries = (List)MapUtils.getMapObject(map, "removed-entries", null, List.class)) != null) {
                    for (Object value2 : newRemovedEntries) {
                        VuzeActivitiesEntry entry;
                        if (!(value2 instanceof Map) || (entry = VuzeActivitiesManager.createEntryFromMap((Map)value2, true)) == null || entry.getTimestamp() <= cutoffTime) continue;
                        removedEntries.add(entry);
                    }
                }
                if ((value2 = map.get("entries")) instanceof List) break block33;
            }
            Object var10_2 = null;
            skipAutoSave = false;
            Object object3 = listenersLoadedLock;
            synchronized (object3) {
                if (listenersLoaded != null) {
                    for (VuzeActivitiesLoadedListener l : listenersLoaded) {
                        try {
                            l.vuzeActivitiesLoaded();
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                    }
                    listenersLoaded = null;
                }
            }
            {
                block33: {
                    return;
                }
                List entries = (List)value2;
                ArrayList<VuzeActivitiesEntry> entriesToAdd = new ArrayList<VuzeActivitiesEntry>(entries.size());
                for (Object value2 : entries) {
                    VuzeActivitiesEntry entry;
                    if (!(value2 instanceof Map) || (entry = VuzeActivitiesManager.createEntryFromMap((Map)value2, true)) == null || entry.getTimestamp() <= cutoffTime) continue;
                    entriesToAdd.add(entry);
                }
                int num = entriesToAdd.size();
                if (num <= 0) break block31;
                VuzeActivitiesManager.addEntries(entriesToAdd.toArray(new VuzeActivitiesEntry[num]));
            }
        }
        Object var10_3 = null;
        skipAutoSave = false;
        Object object = listenersLoadedLock;
        synchronized (object) {
            if (listenersLoaded != null) {
                for (VuzeActivitiesLoadedListener l : listenersLoaded) {
                    try {
                        l.vuzeActivitiesLoaded();
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
                listenersLoaded = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveEventsNow() {
        if (skipAutoSave) {
            return;
        }
        try {
            try {
                config_mon.enter();
                HashMap<String, Object> mapSave = new HashMap<String, Object>();
                mapSave.put("LastChecks", lastNewsAt);
                mapSave.put("version", new Long(2L));
                ArrayList<Map<String, Object>> entriesList = new ArrayList<Map<String, Object>>();
                VuzeActivitiesEntry[] allEntriesArray = VuzeActivitiesManager.getAllEntries();
                for (int i = 0; i < allEntriesArray.length; ++i) {
                    boolean isHeader;
                    VuzeActivitiesEntry entry = allEntriesArray[i];
                    if (entry == null || (isHeader = "Header".equals(entry.getTypeID()))) continue;
                    entriesList.add(entry.toMap());
                }
                mapSave.put("entries", entriesList);
                ArrayList<Map<String, Object>> removedEntriesList = new ArrayList<Map<String, Object>>();
                for (VuzeActivitiesEntry entry : removedEntries) {
                    removedEntriesList.add(entry.toDeletedMap());
                }
                mapSave.put("removed-entries", removedEntriesList);
                FileUtil.writeResilientConfigFile(SAVE_FILENAME, mapSave);
            }
            catch (Throwable t) {
                Debug.out(t);
                Object var7_10 = null;
                config_mon.exit();
            }
            Object var7_9 = null;
            config_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            config_mon.exit();
            throw throwable;
        }
    }

    public static long getCutoffTime() {
        return SystemTime.getOffsetTime(-63072000000L);
    }

    public static void addListener(VuzeActivitiesListener l) {
        listeners.add(l);
    }

    public static void removeListener(VuzeActivitiesListener l) {
        listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(VuzeActivitiesLoadedListener l) {
        Object object = listenersLoadedLock;
        synchronized (object) {
            if (listenersLoaded != null) {
                listenersLoaded.add(l);
            } else {
                try {
                    l.vuzeActivitiesLoaded();
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(VuzeActivitiesLoadedListener l) {
        Object object = listenersLoadedLock;
        synchronized (object) {
            if (listenersLoaded != null) {
                listenersLoaded.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VuzeActivitiesEntry[] addEntries(VuzeActivitiesEntry[] entries) {
        long cutoffTime = VuzeActivitiesManager.getCutoffTime();
        ArrayList<VuzeActivitiesEntry> newEntries = new ArrayList<VuzeActivitiesEntry>(entries.length);
        ArrayList<VuzeActivitiesEntry> existingEntries = new ArrayList<VuzeActivitiesEntry>(0);
        try {
            allEntries_mon.enter();
            for (int i = 0; i < entries.length; ++i) {
                VuzeActivitiesEntry entry = entries[i];
                boolean isHeader = "Header".equals(entry.getTypeID());
                if (entry.getTimestamp() < cutoffTime && !isHeader || removedEntries.contains(entry)) continue;
                if (allEntries.contains(entry)) {
                    existingEntries.add(entry);
                    continue;
                }
                newEntries.add(entry);
                allEntries.add(entry);
            }
            Object var9_9 = null;
            allEntries_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            allEntries_mon.exit();
            throw throwable;
        }
        VuzeActivitiesEntry[] newEntriesArray = newEntries.toArray(new VuzeActivitiesEntry[newEntries.size()]);
        if (newEntriesArray.length > 0) {
            VuzeActivitiesManager.saveEventsNow();
            Object[] listenersArray = listeners.toArray();
            for (int i = 0; i < listenersArray.length; ++i) {
                VuzeActivitiesListener l = (VuzeActivitiesListener)listenersArray[i];
                l.vuzeNewsEntriesAdded(newEntriesArray);
            }
        }
        if (existingEntries.size() > 0) {
            if (newEntriesArray.length == 0) {
                VuzeActivitiesManager.saveEvents();
            }
            for (VuzeActivitiesEntry entry : existingEntries) {
                VuzeActivitiesManager.triggerEntryChanged(entry);
            }
        }
        return newEntriesArray;
    }

    public static void removeEntries(VuzeActivitiesEntry[] entries) {
        VuzeActivitiesManager.removeEntries(entries, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEntries(VuzeActivitiesEntry[] entries, boolean allowReAdd) {
        long cutoffTime = VuzeActivitiesManager.getCutoffTime();
        try {
            allEntries_mon.enter();
            for (int i = 0; i < entries.length; ++i) {
                VuzeActivitiesEntry entry = entries[i];
                if (entry == null) continue;
                allEntries.remove(entry);
                boolean isHeader = "Header".equals(entry.getTypeID());
                if (allowReAdd || entry.getTimestamp() <= cutoffTime || isHeader) continue;
                removedEntries.add(entry);
            }
            Object var8_9 = null;
            allEntries_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            allEntries_mon.exit();
            throw throwable;
        }
        Object[] listenersArray = listeners.toArray();
        for (int i = 0; i < listenersArray.length; ++i) {
            VuzeActivitiesListener l = (VuzeActivitiesListener)listenersArray[i];
            l.vuzeNewsEntriesRemoved(entries);
        }
        VuzeActivitiesManager.saveEventsNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VuzeActivitiesEntry getEntryByID(String id) {
        try {
            String entryID;
            VuzeActivitiesEntry entry;
            allEntries_mon.enter();
            Iterator<VuzeActivitiesEntry> iter = allEntries.iterator();
            do {
                if (iter.hasNext()) continue;
                Object var6_6 = null;
                allEntries_mon.exit();
                return null;
            } while ((entry = iter.next()) == null || (entryID = entry.getID()) == null || !entryID.equals(id));
            VuzeActivitiesEntry vuzeActivitiesEntry = entry;
            Object var6_5 = null;
            allEntries_mon.exit();
            return vuzeActivitiesEntry;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            allEntries_mon.exit();
            throw throwable;
        }
    }

    public static boolean isEntryIdRemoved(String id) {
        for (VuzeActivitiesEntry entry : removedEntries) {
            if (!entry.getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static VuzeActivitiesEntry[] getAllEntries() {
        return allEntries.toArray(new VuzeActivitiesEntry[allEntries.size()]);
    }

    public static int getNumEntries() {
        return allEntries.size();
    }

    public static void log(String s) {
        if (diag_logger != null) {
            diag_logger.log(s);
        }
    }

    public static void triggerEntryChanged(VuzeActivitiesEntry entry) {
        Object[] listenersArray = listeners.toArray();
        for (int i = 0; i < listenersArray.length; ++i) {
            VuzeActivitiesListener l = (VuzeActivitiesListener)listenersArray[i];
            l.vuzeNewsEntryChanged(entry);
        }
        VuzeActivitiesManager.saveEvents();
    }

    public static VuzeActivitiesEntry createEntryFromMap(Map<?, ?> map, boolean internalMap) {
        VuzeActivitiesEntry entry = new VuzeActivitiesEntry();
        if (internalMap) {
            entry.loadFromInternalMap(map);
        } else {
            entry.loadFromExternalMap(map);
        }
        return entry;
    }

    static {
        lastNewsAt = new HashMap<String, Long>();
        skipAutoSave = true;
        config_mon = new AEMonitor("ConfigMon");
        saveEventsOnClose = false;
        if (System.getProperty("debug.vuzenews", "0").equals("1")) {
            diag_logger = AEDiagnostics.getLogger("v3.vuzenews");
            diag_logger.log("\n\nVuze News Logging Starts");
        } else {
            diag_logger = null;
        }
    }
}

