/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.security;

import com.aelitis.azureus.core.security.CryptoManagerException;
import com.aelitis.azureus.core.security.CryptoSTSEngine;
import java.security.PrivateKey;
import java.security.PublicKey;

public interface CryptoHandler {
    public int getType();

    public void unlock() throws CryptoManagerException;

    public void lock();

    public boolean isUnlocked();

    public int getUnlockTimeoutSeconds();

    public void setUnlockTimeoutSeconds(int var1);

    public byte[] sign(byte[] var1, String var2) throws CryptoManagerException;

    public boolean verify(byte[] var1, byte[] var2, byte[] var3) throws CryptoManagerException;

    public byte[] encrypt(byte[] var1, byte[] var2, String var3) throws CryptoManagerException;

    public byte[] decrypt(byte[] var1, byte[] var2, String var3) throws CryptoManagerException;

    public CryptoSTSEngine getSTSEngine(String var1) throws CryptoManagerException;

    public CryptoSTSEngine getSTSEngine(PublicKey var1, PrivateKey var2) throws CryptoManagerException;

    public byte[] peekPublicKey();

    public byte[] getPublicKey(String var1) throws CryptoManagerException;

    public byte[] getEncryptedPrivateKey(String var1) throws CryptoManagerException;

    public boolean verifyPublicKey(byte[] var1);

    public void recoverKeys(byte[] var1, byte[] var2) throws CryptoManagerException;

    public void resetKeys(String var1) throws CryptoManagerException;

    public String exportKeys() throws CryptoManagerException;

    public int getDefaultPasswordHandlerType();

    public void setDefaultPasswordHandlerType(int var1) throws CryptoManagerException;

    public boolean importKeys(String var1) throws CryptoManagerException;
}

