/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.LimitControl;
import com.aelitis.azureus.core.speedmanager.impl.v2.LimitControlDropUploadFirst;
import com.aelitis.azureus.core.speedmanager.impl.v2.PSMonitorListener;
import com.aelitis.azureus.core.speedmanager.impl.v2.PingSpaceMapper;
import com.aelitis.azureus.core.speedmanager.impl.v2.PingSpaceMon;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMConst;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMInstance;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMSearchLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMUpdate;
import com.aelitis.azureus.core.speedmanager.impl.v2.SaturatedMode;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitConfidence;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitListener;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.TransferMode;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.RealTimeInfo;
import org.gudy.azureus2.core3.util.SystemTime;

public class SpeedLimitMonitor
implements PSMonitorListener {
    private int uploadLimitMax = 30720;
    private int uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
    private int downloadLimitMax = 61440;
    private int downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
    private TransferMode transferMode = new TransferMode();
    private SaturatedMode uploadBandwidthStatus = SaturatedMode.NONE;
    private SaturatedMode downloadBandwidthStatus = SaturatedMode.NONE;
    private SaturatedMode uploadLimitSettingStatus = SaturatedMode.AT_LIMIT;
    private SaturatedMode downloadLimitSettingStatus = SaturatedMode.AT_LIMIT;
    private SpeedLimitConfidence uploadLimitConf = SpeedLimitConfidence.NONE;
    private SpeedLimitConfidence downloadLimitConf = SpeedLimitConfidence.NONE;
    private long clLastIncreaseTime = -1L;
    private long clFirstBadPingTime = -1L;
    private boolean currTestDone;
    private boolean beginLimitTest;
    private int highestUploadRate = 0;
    private int highestDownloadRate = 0;
    private int preTestUploadCapacity = 5042;
    private int preTestUploadLimit = 5142;
    private int preTestDownloadCapacity = 5042;
    private int preTestDownloadLimit = 5142;
    public static final String UPLOAD_CONF_LIMIT_SETTING = "SpeedLimitMonitor.setting.upload.limit.conf";
    public static final String DOWNLOAD_CONF_LIMIT_SETTING = "SpeedLimitMonitor.setting.download.limit.conf";
    public static final String UPLOAD_CHOKE_PING_COUNT = "SpeedLimitMonitor.setting.choke.ping.count";
    private static final long CONF_LIMIT_TEST_LENGTH = 30000L;
    private boolean isUploadMaxPinned = true;
    private boolean isDownloadMaxPinned = true;
    private long uploadAtLimitStartTime = SystemTime.getCurrentTime();
    private long downloadAtLimitStartTime = SystemTime.getCurrentTime();
    private int uploadChokePingCount = 1;
    private int uploadPinCounter = 0;
    private static final long TIME_AT_LIMIT_BEFORE_UNPINNING = 30000L;
    public static final String USED_UPLOAD_CAPACITY_DOWNLOAD_MODE = "SpeedLimitMonitor.setting.upload.used.download.mode";
    public static final String USED_UPLOAD_CAPACITY_SEEDING_MODE = "SpeedLimitMonitor.setting.upload.used.seeding.mode";
    private float percentUploadCapacityDownloadMode = 0.6f;
    PingSpaceMapper pingMapOfDownloadMode;
    PingSpaceMapper pingMapOfSeedingMode;
    boolean useVariancePingMap = false;
    SpeedManagerPingMapper transientPingMap;
    PingSpaceMon longTermMonitor = new PingSpaceMon();
    LimitControl slider = new LimitControlDropUploadFirst();
    SpeedLimitListener persistentMapListener;

    public SpeedLimitMonitor(SpeedManager sm) {
        this.longTermMonitor.addListener(this);
        this.persistentMapListener = new SpeedLimitListener(this);
        sm.addListener(this.persistentMapListener);
    }

    public void updateSettingsFromCOConfigManager() {
        this.percentUploadCapacityDownloadMode = (float)COConfigurationManager.getIntParameter(USED_UPLOAD_CAPACITY_DOWNLOAD_MODE, 60) / 100.0f;
        this.slider.updateSeedSettings(this.percentUploadCapacityDownloadMode);
    }

    public void updateFromCOConfigManager() {
        this.uploadLimitMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit");
        this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
        this.downloadLimitMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit");
        this.downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
        this.uploadLimitConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter(UPLOAD_CONF_LIMIT_SETTING));
        this.downloadLimitConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter(DOWNLOAD_CONF_LIMIT_SETTING));
        this.percentUploadCapacityDownloadMode = (float)COConfigurationManager.getIntParameter(USED_UPLOAD_CAPACITY_DOWNLOAD_MODE, 60) / 100.0f;
        this.uploadChokePingCount = Math.min(COConfigurationManager.getIntParameter(UPLOAD_CHOKE_PING_COUNT), 30);
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        this.slider.updateSeedSettings(this.percentUploadCapacityDownloadMode);
        if (this.isSettingDownloadUnlimited()) {
            this.slider.setDownloadUnlimitedMode(true);
        }
    }

    public void readFromPersistentMap() {
        SpeedManager sm = AzureusCoreFactory.getSingleton().getSpeedManager();
        SpeedManagerLimitEstimate uEst = SMConst.filterEstimate(sm.getEstimatedUploadCapacityBytesPerSec(), 30720);
        int upPingMapLimit = uEst.getBytesPerSec();
        this.uploadLimitMax = upPingMapLimit < 30720 ? 30720 : upPingMapLimit;
        this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
        SpeedManagerLimitEstimate dEst = SMConst.filterEstimate(sm.getEstimatedDownloadCapacityBytesPerSec(), 61440);
        int downPingMapLimit = dEst.getBytesPerSec();
        if (this.isSettingDownloadUnlimited()) {
            this.slider.setDownloadUnlimitedMode(true);
        } else {
            this.slider.setDownloadUnlimitedMode(false);
        }
        this.downloadLimitMax = downPingMapLimit < 61440 ? 61440 : downPingMapLimit;
        this.downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
        this.uploadLimitConf = SpeedLimitConfidence.convertType(uEst.getEstimateType());
        this.downloadLimitConf = SpeedLimitConfidence.convertType(dEst.getEstimateType());
        this.percentUploadCapacityDownloadMode = (float)COConfigurationManager.getIntParameter(USED_UPLOAD_CAPACITY_DOWNLOAD_MODE, 60) / 100.0f;
        this.saveToCOConfiguration();
    }

    public void saveToCOConfiguration() {
        COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
        COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
        COConfigurationManager.setParameter(UPLOAD_CONF_LIMIT_SETTING, this.uploadLimitConf.getString());
        COConfigurationManager.setParameter(DOWNLOAD_CONF_LIMIT_SETTING, this.downloadLimitConf.getString());
        COConfigurationManager.setParameter(UPLOAD_CHOKE_PING_COUNT, this.uploadChokePingCount);
    }

    private void logPMData(int oRate, SpeedLimitConfidence oConf, int nRate, float nConf, String type) {
    }

    public void logPMDataEx() {
        int tuploadLimitMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit");
        int tdownloadLimitMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit");
        SpeedManager sm = AzureusCoreFactory.getSingleton().getSpeedManager();
        SpeedManagerLimitEstimate dEst = sm.getEstimatedDownloadCapacityBytesPerSec();
        int tmpDMax = dEst.getBytesPerSec();
        float tmpDMaxConf = dEst.getEstimateType();
        SpeedManagerLimitEstimate uEst = sm.getEstimatedUploadCapacityBytesPerSec();
        int tmpUMax = uEst.getBytesPerSec();
        float tmpUMaxConf = uEst.getEstimateType();
        SpeedLimitConfidence tuploadLimitConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter(UPLOAD_CONF_LIMIT_SETTING));
        SpeedLimitConfidence tdownloadLimitConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter(DOWNLOAD_CONF_LIMIT_SETTING));
        this.logPMData(tuploadLimitMax, tuploadLimitConf, tmpUMax, tmpUMaxConf, "check-upload");
        this.logPMData(tdownloadLimitMax, tdownloadLimitConf, tmpDMax, tmpDMaxConf, "check-download");
    }

    private boolean isSettingDownloadUnlimited() {
        SpeedManagerAlgorithmProviderAdapter adpter = SMInstance.getInstance().getAdapter();
        SpeedManager sm = adpter.getSpeedManager();
        SpeedManagerLimitEstimate dEst = sm.getEstimatedDownloadCapacityBytesPerSec();
        int rate = dEst.getBytesPerSec();
        float type = dEst.getEstimateType();
        if (rate == 0 && type == 1.0f) {
            return true;
        }
        return rate == 0 && type == -0.1f;
    }

    public void setDownloadBandwidthMode(int rate, int limit) {
        this.downloadBandwidthStatus = SaturatedMode.getSaturatedMode(rate, limit);
    }

    public void setUploadBandwidthMode(int rate, int limit) {
        this.uploadBandwidthStatus = SaturatedMode.getSaturatedMode(rate, limit);
    }

    public void setDownloadLimitSettingMode(int currLimit) {
        this.downloadLimitSettingStatus = SaturatedMode.getSaturatedMode(currLimit, this.downloadLimitMax);
    }

    public void setUploadLimitSettingMode(int currLimit) {
        this.uploadLimitSettingStatus = !this.transferMode.isDownloadMode() ? SaturatedMode.getSaturatedMode(currLimit, this.uploadLimitMax) : SaturatedMode.getSaturatedMode(currLimit, this.uploadLimitMax);
    }

    public int getUploadMaxLimit() {
        return this.uploadLimitMax;
    }

    public int getDownloadMaxLimit() {
        return this.downloadLimitMax;
    }

    public int getUploadMinLimit() {
        return this.uploadLimitMin;
    }

    public int getDownloadMinLimit() {
        return this.downloadLimitMin;
    }

    public String getUploadConfidence() {
        return this.uploadLimitConf.getString();
    }

    public String getDownloadConfidence() {
        return this.downloadLimitConf.getString();
    }

    public SaturatedMode getDownloadBandwidthMode() {
        return this.downloadBandwidthStatus;
    }

    public SaturatedMode getUploadBandwidthMode() {
        return this.uploadBandwidthStatus;
    }

    public SaturatedMode getDownloadLimitSettingMode() {
        return this.downloadLimitSettingStatus;
    }

    public SaturatedMode getUploadLimitSettingMode() {
        return this.uploadLimitSettingStatus;
    }

    public void updateTransferMode() {
        this.transferMode.updateStatus(this.downloadBandwidthStatus);
    }

    public String getTransferModeAsString() {
        return this.transferMode.getString();
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    public boolean bandwidthUsageLow() {
        return this.uploadBandwidthStatus.compareTo(SaturatedMode.LOW) <= 0 && this.downloadBandwidthStatus.compareTo(SaturatedMode.LOW) <= 0;
    }

    public boolean bandwidthUsageMedium() {
        return this.uploadBandwidthStatus.compareTo(SaturatedMode.MED) <= 0 && this.downloadBandwidthStatus.compareTo(SaturatedMode.MED) <= 0;
    }

    public boolean bandwidthUsageAtLimit() {
        return this.uploadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0 && this.downloadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0;
    }

    public boolean isUploadBandwidthUsageHigh() {
        return this.uploadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0 || this.uploadBandwidthStatus.compareTo(SaturatedMode.HIGH) == 0;
    }

    public boolean isEitherLimitUnpinned() {
        return !this.isUploadMaxPinned || !this.isDownloadMaxPinned;
    }

    public SMUpdate modifyLimits(float signalStrength, float multiple, int currUpLimit, int currDownLimit) {
        if (this.isStartLimitTestFlagSet()) {
            SpeedManagerLogger.trace("modifyLimits - startLimitTesting.");
            SMUpdate update = this.startLimitTesting(currUpLimit, currDownLimit);
            return this.checkActiveProgressiveDownloadLimit(update);
        }
        if (this.isEitherLimitUnpinned()) {
            SpeedManagerLogger.trace("modifyLimits - calculateNewUnpinnedLimits");
            SMUpdate update = this.calculateNewUnpinnedLimits(signalStrength);
            return this.checkActiveProgressiveDownloadLimit(update);
        }
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        this.slider.updateStatus(currUpLimit, this.uploadBandwidthStatus, currDownLimit, this.downloadBandwidthStatus, this.transferMode);
        SMUpdate update = this.slider.adjust(signalStrength * multiple);
        return this.checkActiveProgressiveDownloadLimit(update);
    }

    private SMUpdate checkActiveProgressiveDownloadLimit(SMUpdate update) {
        long prgDownLimit = RealTimeInfo.getProgressiveActiveBytesPerSec();
        if (prgDownLimit == 0L) {
            return update;
        }
        int MULTIPLE = 2;
        if (prgDownLimit * 2L > (long)update.newDownloadLimit && update.newDownloadLimit != 0) {
            this.log("Active Progressive download in progress. Overriding limit. curr=" + update.newDownloadLimit + " progDownloadLimit=" + prgDownLimit * 2L);
            update.newDownloadLimit = (int)prgDownLimit * 2;
        }
        return update;
    }

    private void logPinningInfo() {
        StringBuffer sb = new StringBuffer("pin: ");
        if (this.isUploadMaxPinned) {
            sb.append("ul-pinned:");
        } else {
            sb.append("ul-unpinned:");
        }
        if (this.isDownloadMaxPinned) {
            sb.append("dl-pinned:");
        } else {
            sb.append("dl-unpinned:");
        }
        long currTime = SystemTime.getCurrentTime();
        long upWait = currTime - this.uploadAtLimitStartTime;
        long downWait = currTime - this.downloadAtLimitStartTime;
        sb.append(upWait).append(":").append(downWait);
        this.log(sb.toString());
    }

    public SMUpdate calculateNewUnpinnedLimits(float signalStrength) {
        if (signalStrength < 0.0f) {
            this.isUploadMaxPinned = true;
            this.isDownloadMaxPinned = true;
        }
        boolean updateUpload = false;
        boolean updateDownload = false;
        if (this.uploadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0 && this.uploadLimitSettingStatus.compareTo(SaturatedMode.AT_LIMIT) == 0) {
            updateUpload = true;
        }
        if (this.downloadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0 && this.downloadLimitSettingStatus.compareTo(SaturatedMode.AT_LIMIT) == 0) {
            updateDownload = true;
        }
        boolean uploadChanged = false;
        boolean downloadChanged = false;
        if (updateUpload && !this.transferMode.isDownloadMode()) {
            ++this.uploadPinCounter;
            if ((double)this.uploadPinCounter % Math.ceil(Math.sqrt(this.uploadChokePingCount)) == 0.0) {
                this.uploadLimitMax += this.calculateUnpinnedStepSize(this.uploadLimitMax);
                uploadChanged = true;
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
                COConfigurationManager.setParameter(UPLOAD_CHOKE_PING_COUNT, this.uploadChokePingCount);
            }
        }
        if (updateDownload && !this.slider.isDownloadUnlimitedMode()) {
            this.downloadLimitMax += this.calculateUnpinnedStepSize(this.downloadLimitMax);
            downloadChanged = true;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
        }
        if (this.uploadLimitMax > this.downloadLimitMax) {
            this.downloadLimitMax = this.uploadLimitMax;
            downloadChanged = true;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
        }
        this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
        this.downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
        if (this.slider.isDownloadUnlimitedMode()) {
            SpeedManagerLogger.trace("upload unpinned while download is unlimited.");
            return new SMUpdate(this.uploadLimitMax, uploadChanged, 0, false);
        }
        return new SMUpdate(this.uploadLimitMax, uploadChanged, this.downloadLimitMax, downloadChanged);
    }

    private int calculateUnpinnedStepSize(int currLimitMax) {
        if (currLimitMax < 102400) {
            return 1024;
        }
        if (currLimitMax < 409600) {
            return 5120;
        }
        return 10240;
    }

    public void checkForUnpinningCondition() {
        long currTime = SystemTime.getCurrentTime();
        this.slider.setDownloadUnlimitedMode(this.isSettingDownloadUnlimited());
        if (!this.uploadBandwidthStatus.equals(SaturatedMode.AT_LIMIT) || !this.uploadLimitSettingStatus.equals(SaturatedMode.AT_LIMIT)) {
            this.uploadAtLimitStartTime = currTime;
        } else if (this.uploadAtLimitStartTime + 30000L * (long)this.uploadChokePingCount < currTime) {
            if (this.isUploadConfidenceLow()) {
                if (!this.transferMode.isDownloadMode()) {
                    this.isUploadMaxPinned = false;
                }
            } else if (!this.isUploadConfidenceAbsolute()) {
                this.isUploadMaxPinned = false;
                SpeedManagerLogger.trace("unpinning the upload max limit!! #choke-pings=" + this.uploadChokePingCount + ", pin-counter=" + this.uploadPinCounter);
            }
        }
        if (!this.downloadBandwidthStatus.equals(SaturatedMode.AT_LIMIT) || !this.downloadLimitSettingStatus.equals(SaturatedMode.AT_LIMIT)) {
            this.downloadAtLimitStartTime = currTime;
        } else if (this.downloadAtLimitStartTime + 30000L < currTime) {
            if (this.isDownloadConfidenceLow()) {
                if (this.transferMode.isDownloadMode()) {
                    this.triggerLimitTestingFlag();
                }
            } else if (!this.isDownloadConfidenceAbsolute()) {
                this.isDownloadMaxPinned = false;
                SpeedManagerLogger.trace("unpinning the download max limit!!");
            }
        }
        this.logPinningInfo();
    }

    public void notifyOfDownSignal() {
        String msg;
        if (!this.isUploadMaxPinned) {
            ++this.uploadChokePingCount;
            msg = "pinning the upload max limit, due to downtick signal. #downtick=" + this.uploadChokePingCount;
            SpeedManagerLogger.trace(msg);
            SMSearchLogger.log(msg);
        }
        if (!this.isDownloadMaxPinned) {
            msg = "pinning the download max limit, due to downtick signal.";
            SpeedManagerLogger.trace(msg);
            SMSearchLogger.log(msg);
        }
        this.resetPinSearch();
    }

    void resetPinSearch() {
        long currTime;
        this.uploadAtLimitStartTime = currTime = SystemTime.getCurrentTime();
        this.downloadAtLimitStartTime = currTime;
        this.isUploadMaxPinned = true;
        this.isDownloadMaxPinned = true;
    }

    void resetPinSearch(SpeedManagerLimitEstimate estimate) {
        float type = estimate.getEstimateType();
        if (type >= 0.5f) {
            ++this.uploadChokePingCount;
        }
        this.resetPinSearch();
    }

    public boolean isConfTestingLimits() {
        return this.transferMode.isConfTestingLimits();
    }

    public boolean isDownloadConfidenceLow() {
        return this.downloadLimitConf.compareTo(SpeedLimitConfidence.MED) < 0;
    }

    public boolean isUploadConfidenceLow() {
        return this.uploadLimitConf.compareTo(SpeedLimitConfidence.MED) < 0;
    }

    public boolean isDownloadConfidenceAbsolute() {
        return this.downloadLimitConf.compareTo(SpeedLimitConfidence.ABSOLUTE) == 0;
    }

    public boolean isUploadConfidenceAbsolute() {
        return this.uploadLimitConf.compareTo(SpeedLimitConfidence.ABSOLUTE) == 0;
    }

    public synchronized void updateLimitTestingData(int downloadRate, int uploadRate) {
        long currTime;
        if (downloadRate > this.highestDownloadRate) {
            this.highestDownloadRate = downloadRate;
        }
        if (uploadRate > this.highestUploadRate) {
            this.highestUploadRate = uploadRate;
        }
        if ((currTime = SystemTime.getCurrentTime()) > this.clLastIncreaseTime + 30000L) {
            this.currTestDone = true;
        }
        if (this.clFirstBadPingTime != -1L && currTime > this.clFirstBadPingTime + 30000L) {
            this.currTestDone = true;
        }
    }

    public void updateLimitTestingPing(int lastMetric) {
        if (lastMetric > 500) {
            this.updateLimitTestingPing(-1.0f);
        }
    }

    public void updateLimitTestingPing(float lastMetric) {
        if (lastMetric < -0.3f) {
            this.clFirstBadPingTime = SystemTime.getCurrentTime();
        }
    }

    public SMUpdate startLimitTesting(int currUploadLimit, int currDownloadLimit) {
        SMUpdate retVal;
        this.clLastIncreaseTime = SystemTime.getCurrentTime();
        this.clFirstBadPingTime = -1L;
        this.highestUploadRate = 0;
        this.highestDownloadRate = 0;
        this.currTestDone = false;
        this.beginLimitTest = false;
        this.preTestUploadLimit = currUploadLimit;
        this.preTestDownloadLimit = currDownloadLimit;
        if (this.transferMode.isDownloadMode()) {
            retVal = new SMUpdate(this.uploadLimitMin, true, Math.round((float)this.downloadLimitMax * 1.2f), true);
            this.preTestDownloadCapacity = this.downloadLimitMax;
            this.transferMode.setMode(TransferMode.State.DOWNLOAD_LIMIT_SEARCH);
        } else {
            retVal = new SMUpdate(Math.round((float)this.uploadLimitMax * 1.2f), true, this.downloadLimitMin, true);
            this.preTestUploadCapacity = this.uploadLimitMax;
            this.transferMode.setMode(TransferMode.State.UPLOAD_LIMIT_SEARCH);
        }
        return retVal;
    }

    public SMUpdate rampTestingLimit(int uploadLimit, int downloadLimit) {
        SMUpdate retVal;
        if (this.transferMode.getMode() == TransferMode.State.DOWNLOAD_LIMIT_SEARCH && this.downloadBandwidthStatus.isGreater(SaturatedMode.MED)) {
            downloadLimit = (int)((float)downloadLimit * 1.1f);
            this.clLastIncreaseTime = SystemTime.getCurrentTime();
            retVal = new SMUpdate(uploadLimit, false, downloadLimit, true);
        } else if (this.transferMode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH && this.uploadBandwidthStatus.isGreater(SaturatedMode.MED)) {
            uploadLimit = (int)((float)uploadLimit * 1.1f);
            this.clLastIncreaseTime = SystemTime.getCurrentTime();
            retVal = new SMUpdate(uploadLimit, true, downloadLimit, false);
        } else {
            retVal = new SMUpdate(uploadLimit, false, downloadLimit, false);
            SpeedManagerLogger.trace("ERROR: rampTestLimit should only be called during limit testing. ");
        }
        return retVal;
    }

    public void triggerLimitTestingFlag() {
        SpeedManagerLogger.trace("triggerd fast limit test.");
        this.beginLimitTest = true;
        if (this.useVariancePingMap) {
            SMInstance pm = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter adapter = pm.getAdapter();
            if (this.transientPingMap != null) {
                this.transientPingMap.destroy();
            }
            this.transientPingMap = adapter.createTransientPingMapper();
        }
    }

    public synchronized boolean isStartLimitTestFlagSet() {
        return this.beginLimitTest;
    }

    public synchronized boolean isConfLimitTestFinished() {
        return this.currTestDone;
    }

    public synchronized SMUpdate endLimitTesting(int downloadCapacityGuess, int uploadCapacityGuess) {
        SpeedManagerLogger.trace(" repalce highestDownloadRate: " + this.highestDownloadRate + " with " + downloadCapacityGuess);
        SpeedManagerLogger.trace(" replace highestUploadRate: " + this.highestUploadRate + " with " + uploadCapacityGuess);
        this.highestDownloadRate = downloadCapacityGuess;
        this.highestUploadRate = uploadCapacityGuess;
        return this.endLimitTesting();
    }

    public synchronized SMUpdate endLimitTesting() {
        SMUpdate retVal;
        if (this.transferMode.getMode() == TransferMode.State.DOWNLOAD_LIMIT_SEARCH) {
            this.downloadLimitConf = this.determineConfidenceLevel();
            SpeedManagerLogger.trace("pre-upload-setting=" + this.preTestUploadCapacity + " up-capacity" + this.uploadLimitMax + " pre-download-setting=" + this.preTestDownloadCapacity + " down-capacity=" + this.downloadLimitMax);
            retVal = new SMUpdate(this.preTestUploadLimit, true, this.downloadLimitMax, true);
            this.transferMode.setMode(TransferMode.State.DOWNLOADING);
        } else if (this.transferMode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH) {
            this.uploadLimitConf = this.determineConfidenceLevel();
            retVal = new SMUpdate(this.uploadLimitMax, true, this.downloadLimitMax, true);
            this.transferMode.setMode(TransferMode.State.SEEDING);
        } else {
            SpeedManagerLogger.log("SpeedLimitMonitor had IllegalState during endLimitTesting.");
            retVal = new SMUpdate(this.preTestUploadLimit, true, this.preTestDownloadLimit, true);
        }
        this.currTestDone = true;
        this.uploadAtLimitStartTime = SystemTime.getCurrentTime();
        this.downloadAtLimitStartTime = SystemTime.getCurrentTime();
        return retVal;
    }

    public SpeedLimitConfidence determineConfidenceLevel() {
        int highestValue;
        int preTestValue;
        boolean isDownload;
        String settingMaxLimitName;
        String settingConfidenceName;
        SpeedLimitConfidence retVal = SpeedLimitConfidence.NONE;
        if (this.transferMode.getMode() == TransferMode.State.DOWNLOAD_LIMIT_SEARCH) {
            settingConfidenceName = DOWNLOAD_CONF_LIMIT_SETTING;
            settingMaxLimitName = "SpeedManagerAlgorithmProviderV2.setting.download.max.limit";
            isDownload = true;
            preTestValue = this.preTestDownloadCapacity;
            highestValue = this.highestDownloadRate;
        } else if (this.transferMode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH) {
            settingConfidenceName = UPLOAD_CONF_LIMIT_SETTING;
            settingMaxLimitName = "SpeedManagerAlgorithmProviderV2.setting.upload.max.limit";
            isDownload = false;
            preTestValue = this.preTestUploadCapacity;
            highestValue = this.highestUploadRate;
        } else {
            SpeedManagerLogger.log("IllegalState in determineConfidenceLevel(). Setting level to NONE.");
            return SpeedLimitConfidence.NONE;
        }
        boolean hadChockingPing = this.hadChockingPing();
        float percentDiff = (float)Math.abs(highestValue - preTestValue) / (float)Math.max(highestValue, preTestValue);
        retVal = percentDiff < 0.15f && hadChockingPing ? SpeedLimitConfidence.MED : SpeedLimitConfidence.LOW;
        COConfigurationManager.setParameter(settingConfidenceName, retVal.getString());
        int newMaxLimitSetting = highestValue;
        COConfigurationManager.setParameter(settingMaxLimitName, newMaxLimitSetting);
        int newMinLimitSetting = isDownload ? SMConst.calculateMinDownload(newMaxLimitSetting) : SMConst.calculateMinUpload(newMaxLimitSetting);
        StringBuffer sb = new StringBuffer();
        if (this.transferMode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH) {
            sb.append("new upload limits: ");
            this.uploadLimitMax = newMaxLimitSetting;
            this.uploadLimitMin = newMinLimitSetting;
            if (this.downloadLimitMax < this.uploadLimitMax) {
                this.downloadLimitMax = this.uploadLimitMax;
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
            }
            sb.append(this.uploadLimitMax);
        } else {
            sb.append("new download limits: ");
            this.downloadLimitMax = newMaxLimitSetting;
            this.downloadLimitMin = newMinLimitSetting;
            if (this.uploadLimitMax * 40 < this.downloadLimitMax) {
                this.uploadLimitMax = this.downloadLimitMax / 40;
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
                this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
            }
            sb.append(this.downloadLimitMax);
        }
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        SpeedManagerLogger.trace(sb.toString());
        return retVal;
    }

    public boolean areSettingsInSpec(int currUploadLimit, int currDownloadLimit) {
        if (this.isConfTestingLimits()) {
            return true;
        }
        boolean retVal = true;
        if (currUploadLimit > this.uploadLimitMax) {
            retVal = false;
        }
        if (currDownloadLimit > this.downloadLimitMax && this.slider.isDownloadUnlimitedMode()) {
            retVal = false;
        }
        return retVal;
    }

    private int choseBestLimit(SpeedManagerLimitEstimate estimate, int currMaxLimit, SpeedLimitConfidence currConf) {
        int chosenLimit;
        float type = estimate.getEstimateType();
        int estBytesPerSec = estimate.getBytesPerSec();
        if (estBytesPerSec < currMaxLimit && estBytesPerSec < 20480) {
            return currMaxLimit;
        }
        String reason = "";
        if (type == 1.0f) {
            chosenLimit = estBytesPerSec;
            reason = "manual";
        } else if (type == -0.1f) {
            chosenLimit = Math.max(estBytesPerSec, currMaxLimit);
            reason = "unknown";
        } else if (type == 0.0f) {
            if ((double)estimate.getMetricRating() >= 0.0) {
                return currMaxLimit;
            }
            chosenLimit = estBytesPerSec;
            reason = "estimate and bad metric";
        } else {
            chosenLimit = estBytesPerSec;
        }
        SpeedManagerLogger.trace("bestChosenLimit: reason=" + reason + ",chosenLimit=" + chosenLimit);
        return chosenLimit;
    }

    public void setRefLimits(SpeedManagerLimitEstimate estUp, SpeedManagerLimitEstimate estDown) {
        SpeedManagerLimitEstimate up = SMConst.filterEstimate(estUp, 5120);
        int upMax = this.choseBestLimit(up, this.uploadLimitMax, this.uploadLimitConf);
        SpeedManagerLimitEstimate down = SMConst.filterEstimate(estDown, 20480);
        int downMax = this.choseBestLimit(down, this.downloadLimitMax, this.downloadLimitConf);
        if (downMax < upMax) {
            SpeedManagerLogger.trace("down max-limit was less then up-max limit. increasing down max-limit. upMax=" + upMax + " downMax=" + downMax);
            downMax = upMax;
        }
        this.setRefLimits(upMax, downMax);
    }

    public void setRefLimits(int uploadMax, int downloadMax) {
        if (this.uploadLimitMax != uploadMax && uploadMax > 0) {
            this.uploadLimitMax = uploadMax;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
        }
        this.uploadLimitMin = SMConst.calculateMinUpload(uploadMax);
        if (this.downloadLimitMax != downloadMax && downloadMax > 0) {
            this.downloadLimitMax = downloadMax;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
        }
        this.downloadLimitMin = SMConst.calculateMinDownload(downloadMax);
        SpeedManagerLogger.trace("setRefLimits uploadMax=" + uploadMax + " uploadLimitMax=" + this.uploadLimitMax + ", downloadMax=" + downloadMax + " downloadLimitMax=" + this.downloadLimitMax);
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
    }

    public SMUpdate adjustLimitsToSpec(int currUploadLimit, int currDownloadLimit) {
        int newUploadLimit = currUploadLimit;
        boolean uploadChanged = false;
        int newDownloadLimit = currDownloadLimit;
        boolean downloadChanged = false;
        StringBuffer reason = new StringBuffer();
        if (currUploadLimit > this.uploadLimitMax && this.uploadLimitMax != 0) {
            newUploadLimit = this.uploadLimitMax;
            uploadChanged = true;
            reason.append(" (a) upload line-speed cap below current limit. ");
        }
        if (this.uploadLimitMax == 0) {
            reason.append("** uploadLimitMax=0 (Unlimited)! ** ");
        }
        if (currDownloadLimit > this.downloadLimitMax && !this.slider.isDownloadUnlimitedMode()) {
            newDownloadLimit = this.downloadLimitMax;
            downloadChanged = true;
            reason.append(" (b) download line-speed cap below current limit. ");
        }
        if (currUploadLimit < this.uploadLimitMin) {
            newUploadLimit = this.uploadLimitMin;
            uploadChanged = true;
            reason.append(" (c) min upload limit raised. ");
        }
        if (currDownloadLimit < this.downloadLimitMin) {
            newDownloadLimit = this.downloadLimitMin;
            downloadChanged = true;
            reason.append(" (d)  min download limit raised. ");
        }
        SpeedManagerLogger.trace("Adjusting limits due to out of spec: new-up=" + newUploadLimit + " new-down=" + newDownloadLimit + "  reasons: " + reason.toString());
        return new SMUpdate(newUploadLimit, uploadChanged, newDownloadLimit, downloadChanged);
    }

    protected void log(String str) {
        SpeedManagerLogger.log(str);
    }

    public void initPingSpaceMap(int maxGoodPing, int minBadPing) {
        this.pingMapOfDownloadMode = new PingSpaceMapper(maxGoodPing, minBadPing);
        this.pingMapOfSeedingMode = new PingSpaceMapper(maxGoodPing, minBadPing);
        this.useVariancePingMap = false;
    }

    public void initPingSpaceMap() {
        this.useVariancePingMap = true;
    }

    public void betaLogPingMapperEstimates(String name, SpeedManagerLimitEstimate transEst, boolean hadChockPing, SpeedManagerLimitEstimate permEst, PingSpaceMapper downMode, PingSpaceMapper seedMode) {
        boolean upChockPing;
        boolean downChockPing;
        int rateDown;
        float conf;
        int rate;
        StringBuffer sb = new StringBuffer("beta-ping-maps-").append(name).append(": ");
        if (transEst != null) {
            rate = transEst.getBytesPerSec();
            conf = transEst.getMetricRating();
            sb.append("transient-").append(rate).append("(").append(conf).append(")");
        }
        sb.append(" chockPing=").append(hadChockPing);
        if (permEst != null) {
            rate = permEst.getBytesPerSec();
            conf = permEst.getMetricRating();
            sb.append("; perm-").append(rate).append("(").append(conf).append(")");
        }
        if (downMode != null) {
            rateDown = downMode.guessDownloadLimit();
            int rateUp = downMode.guessUploadLimit();
            downChockPing = downMode.hadChockingPing(true);
            upChockPing = downMode.hadChockingPing(false);
            sb.append("; downMode- ");
            sb.append("rateDown=").append(rateDown).append(" ");
            sb.append("rateUp=").append(rateUp).append(" ");
            sb.append("downChockPing=").append(downChockPing).append(" ");
            sb.append("upChockPing=").append(upChockPing).append(" ");
        }
        if (seedMode != null) {
            rateDown = seedMode.guessDownloadLimit();
            int rateUp = seedMode.guessUploadLimit();
            downChockPing = seedMode.hadChockingPing(true);
            upChockPing = seedMode.hadChockingPing(false);
            sb.append("; seedMode- ");
            sb.append("rateDown=").append(rateDown).append(" ");
            sb.append("rateUp=").append(rateUp).append(" ");
            sb.append("downChockPing=").append(downChockPing).append(" ");
            sb.append("upChockPing=").append(upChockPing).append(" ");
        }
        SpeedManagerLogger.log(sb.toString());
    }

    public int guessDownloadLimit() {
        if (!this.useVariancePingMap) {
            return this.pingMapOfDownloadMode.guessDownloadLimit();
        }
        boolean wasChocked = true;
        SpeedManagerLimitEstimate transientEst = null;
        if (this.transientPingMap != null && (transientEst = this.transientPingMap.getLastBadDownloadLimit()) == null) {
            wasChocked = false;
            transientEst = this.transientPingMap.getEstimatedDownloadLimit(false);
        }
        SMInstance pm = SMInstance.getInstance();
        SpeedManagerAlgorithmProviderAdapter adapter = pm.getAdapter();
        SpeedManagerPingMapper persistentMap = adapter.getPingMapper();
        SpeedManagerLimitEstimate persistentEst = persistentMap.getEstimatedDownloadLimit(false);
        this.betaLogPingMapperEstimates("down", transientEst, wasChocked, persistentEst, this.pingMapOfDownloadMode, this.pingMapOfSeedingMode);
        if (transientEst != null) {
            return this.choseBestLimit(transientEst, this.downloadLimitMax, this.downloadLimitConf);
        }
        return this.downloadLimitMax;
    }

    public int guessUploadLimit() {
        if (!this.useVariancePingMap) {
            int dmUpLimitGuess = this.pingMapOfDownloadMode.guessUploadLimit();
            int smUpLimitGuess = this.pingMapOfSeedingMode.guessUploadLimit();
            return Math.max(dmUpLimitGuess, smUpLimitGuess);
        }
        boolean wasChocked = true;
        SpeedManagerLimitEstimate transientEst = null;
        if (this.transientPingMap != null && (transientEst = this.transientPingMap.getLastBadUploadLimit()) == null) {
            wasChocked = false;
            transientEst = this.transientPingMap.getEstimatedUploadLimit(false);
        }
        SMInstance pm = SMInstance.getInstance();
        SpeedManagerAlgorithmProviderAdapter adapter = pm.getAdapter();
        SpeedManagerPingMapper persistentMap = adapter.getPingMapper();
        SpeedManagerLimitEstimate persistentEst = persistentMap.getEstimatedUploadLimit(false);
        this.betaLogPingMapperEstimates("up", transientEst, wasChocked, persistentEst, this.pingMapOfDownloadMode, this.pingMapOfSeedingMode);
        if (transientEst != null) {
            return this.choseBestLimit(transientEst, this.uploadLimitMax, this.uploadLimitConf);
        }
        return this.uploadLimitMax;
    }

    public boolean hadChockingPing() {
        if (!this.useVariancePingMap) {
            return this.pingMapOfDownloadMode.hadChockingPing(true);
        }
        SpeedManagerPingMapper pm = SMInstance.getInstance().getAdapter().getPingMapper();
        SpeedManagerLimitEstimate dEst = pm.getEstimatedDownloadLimit(true);
        SpeedManagerLimitEstimate uEst = pm.getEstimatedUploadLimit(true);
        boolean hadChokePingUp = uEst.getEstimateType() == 0.5f;
        boolean hadChokePingDown = dEst.getEstimateType() == 0.5f;
        return hadChokePingUp || hadChokePingDown;
    }

    public void logPingMapData() {
        if (!this.useVariancePingMap) {
            int downLimGuess = this.pingMapOfDownloadMode.guessDownloadLimit();
            int upLimGuess = this.pingMapOfDownloadMode.guessUploadLimit();
            int seedingUpLimGuess = this.pingMapOfSeedingMode.guessUploadLimit();
            StringBuffer sb = new StringBuffer("ping-map: ");
            sb.append(":down=").append(downLimGuess);
            sb.append(":up=").append(upLimGuess);
            sb.append(":(seed)up=").append(seedingUpLimGuess);
            SpeedManagerLogger.log(sb.toString());
        } else {
            SMInstance pm = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter adapter = pm.getAdapter();
            SpeedManagerPingMapper persistentMap = adapter.getPingMapper();
            SpeedManagerLimitEstimate estUp = persistentMap.getEstimatedUploadLimit(false);
            SpeedManagerLimitEstimate estDown = persistentMap.getEstimatedDownloadLimit(false);
            int downLimGuess = estDown.getBytesPerSec();
            float downConf = estDown.getMetricRating();
            int upLimGuess = estUp.getBytesPerSec();
            float upConf = estUp.getMetricRating();
            String name = persistentMap.getName();
            StringBuffer sb = new StringBuffer("new-ping-map: ");
            sb.append(" name=").append(name);
            sb.append(", down=").append(downLimGuess);
            sb.append(", down-conf=").append(downConf);
            sb.append(", up=").append(upLimGuess);
            sb.append(", up-conf=").append(upConf);
            SpeedManagerLogger.log(sb.toString());
        }
    }

    public void setCurrentTransferRates(int downRate, int upRate) {
        if (this.pingMapOfDownloadMode != null && this.pingMapOfSeedingMode != null) {
            this.pingMapOfDownloadMode.setCurrentTransferRates(downRate, upRate);
            this.pingMapOfSeedingMode.setCurrentTransferRates(downRate, upRate);
        }
    }

    public void resetPingSpace() {
        if (this.pingMapOfDownloadMode != null && this.pingMapOfSeedingMode != null) {
            this.pingMapOfDownloadMode.reset();
            this.pingMapOfSeedingMode.reset();
        }
        if (this.transientPingMap != null) {
            this.transientPingMap.destroy();
        }
    }

    public void addToPingMapData(int lastMetricValue) {
        String modeStr = this.getTransferModeAsString();
        if (modeStr.equalsIgnoreCase(TransferMode.State.DOWNLOADING.getString()) || modeStr.equalsIgnoreCase(TransferMode.State.DOWNLOAD_LIMIT_SEARCH.getString())) {
            this.pingMapOfDownloadMode.addMetricToMap(lastMetricValue);
        } else if (modeStr.equalsIgnoreCase(TransferMode.State.SEEDING.getString()) || modeStr.equalsIgnoreCase(TransferMode.State.UPLOAD_LIMIT_SEARCH.getString())) {
            this.pingMapOfSeedingMode.addMetricToMap(lastMetricValue);
        }
        this.updateLimitTestingPing(lastMetricValue);
        this.longTermMonitor.updateStatus(this.transferMode);
    }

    public void notifyUpload(SpeedManagerLimitEstimate estimate) {
        int bestLimit = this.choseBestLimit(estimate, this.uploadLimitMax, this.uploadLimitConf);
        SpeedManagerLogger.trace("notifyUpload uploadLimitMax=" + this.uploadLimitMax);
        this.tempLogEstimate(estimate);
        if (bestLimit != this.uploadLimitMax) {
            SpeedManagerLogger.log("persistent PingMap changed upload limit to " + bestLimit);
            this.resetPinSearch(estimate);
            this.uploadLimitMax = bestLimit;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
        }
        this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        SMSearchLogger.log("new upload rate: " + this.uploadLimitMax);
    }

    public void notifyDownload(SpeedManagerLimitEstimate estimate) {
        int bestLimit = this.choseBestLimit(estimate, this.downloadLimitMax, this.downloadLimitConf);
        SpeedManagerLogger.trace("notifyDownload downloadLimitMax=" + this.downloadLimitMax + " conf=" + this.downloadLimitConf.getString() + " (" + this.downloadLimitConf.asEstimateType() + ")");
        this.tempLogEstimate(estimate);
        if (this.downloadLimitMax != bestLimit) {
            SpeedManagerLogger.log("persistent PingMap changed download limit to " + bestLimit);
            this.downloadLimitMax = bestLimit;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", bestLimit);
        }
        this.downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        if (estimate.getBytesPerSec() != 0) {
            this.slider.setDownloadUnlimitedMode(false);
        } else {
            this.slider.setDownloadUnlimitedMode(true);
        }
        SMSearchLogger.log("download " + this.downloadLimitMax);
    }

    private void tempLogEstimate(SpeedManagerLimitEstimate est) {
        if (est == null) {
            SpeedManagerLogger.trace("notify log: SpeedManagerLimitEstimate was null");
            return;
        }
        StringBuffer sb = new StringBuffer();
        float metric = est.getMetricRating();
        float type = est.getEstimateType();
        int rate = est.getBytesPerSec();
        String str = est.getString();
        sb.append("notify log: ").append(str);
        sb.append(" metricRating=").append(metric);
        sb.append(" rate=").append(rate);
        sb.append(" type=").append(type);
        SpeedManagerLogger.trace(sb.toString());
    }
}

