/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagFeatureFileLocation;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagFeatureRSSFeed;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.impl.TagManagerImpl;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.util.Set;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;

public abstract class TagBase
implements Tag,
SimpleTimer.TimerTickReceiver {
    protected static final String AT_RATELIMIT_UP = "rl.up";
    protected static final String AT_RATELIMIT_DOWN = "rl.down";
    protected static final String AT_VISIBLE = "vis";
    protected static final String AT_PUBLIC = "pub";
    protected static final String AT_GROUP = "gr";
    protected static final String AT_CAN_BE_PUBLIC = "canpub";
    protected static final String AT_ORIGINAL_NAME = "oname";
    protected static final String AT_IMAGE_ID = "img.id";
    protected static final String AT_COLOR_ID = "col.rgb";
    protected static final String AT_RSS_ENABLE = "rss.enable";
    protected static final String AT_RATELIMIT_UP_PRI = "rl.uppri";
    protected static final String AT_XCODE_TARGET = "xcode.to";
    protected static final String AT_FL_MOVE_COMP = "fl.comp";
    protected static final String AT_FL_COPY_COMP = "fl.copy";
    protected static final String AT_FL_INIT_LOC = "fl.init";
    protected static final String AT_RATELIMIT_MIN_SR = "rl.minsr";
    protected static final String AT_RATELIMIT_MAX_SR = "rl.maxsr";
    protected static final String AT_PROPERTY_PREFIX = "pp.";
    protected static final String AT_EOA_PREFIX = "eoa.";
    private static final String[] EMPTY_STRING_LIST = new String[0];
    private TagTypeBase tag_type;
    private int tag_id;
    private String tag_name;
    private static final int TL_ADD = 1;
    private static final int TL_REMOVE = 2;
    private static final int TL_SYNC = 3;
    private ListenerManager<TagListener> t_listeners = ListenerManager.createManager("TagListeners", new ListenerManagerDispatcher<TagListener>(){

        @Override
        public void dispatch(TagListener listener, int type, Object value) {
            if (type == 1) {
                listener.taggableAdded(TagBase.this, (Taggable)value);
            } else if (type == 2) {
                listener.taggableRemoved(TagBase.this, (Taggable)value);
            } else if (type == 3) {
                listener.taggableSync(TagBase.this);
            }
        }
    });
    private Boolean is_visible;
    private Boolean is_public;
    private String group;
    private TagFeatureRateLimit tag_rl;
    private TagFeatureRSSFeed tag_rss;
    private TagFeatureFileLocation tag_fl;
    private static final int HISTORY_MAX_SECS = 1800;
    private volatile boolean history_retention_required;
    private long[] history;
    private int history_pos;
    private boolean history_wrapped;
    private boolean timer_registered;

    protected TagBase(TagTypeBase _tag_type, int _tag_id, String _tag_name) {
        this.tag_type = _tag_type;
        this.tag_id = _tag_id;
        this.tag_name = _tag_name;
        if (this.getManager().isEnabled()) {
            this.is_visible = this.readBooleanAttribute(AT_VISIBLE, null);
            this.is_public = this.readBooleanAttribute(AT_PUBLIC, null);
            this.group = this.readStringAttribute(AT_GROUP, null);
            if (this instanceof TagFeatureRateLimit) {
                this.tag_rl = (TagFeatureRateLimit)((Object)this);
            }
            if (this instanceof TagFeatureRSSFeed) {
                this.tag_rss = (TagFeatureRSSFeed)((Object)this);
                if (this.tag_rss.isTagRSSFeedEnabled()) {
                    this.getManager().checkRSSFeeds(this, true);
                }
            }
            if (this instanceof TagFeatureFileLocation) {
                this.tag_fl = (TagFeatureFileLocation)((Object)this);
            }
        }
    }

    protected void addTag() {
        if (this.getManager().isEnabled()) {
            this.tag_type.addTag(this);
        }
    }

    protected TagManagerImpl getManager() {
        return this.tag_type.getTagManager();
    }

    public TagTypeBase getTagType() {
        return this.tag_type;
    }

    public int getTagID() {
        return this.tag_id;
    }

    public long getTagUID() {
        return (long)this.getTagType().getTagType() << 32 | (long)this.tag_id;
    }

    protected String getTagNameRaw() {
        return this.tag_name;
    }

    public String getTagName(boolean localize) {
        if (localize) {
            if (this.tag_name.startsWith("tag.")) {
                return MessageText.getString(this.tag_name);
            }
            return this.tag_name;
        }
        if (this.tag_name.startsWith("tag.")) {
            return this.tag_name;
        }
        String original_name = this.readStringAttribute(AT_ORIGINAL_NAME, null);
        if (original_name != null && original_name.startsWith("tag.")) {
            return original_name;
        }
        return "!" + this.tag_name + "!";
    }

    public void setTagName(String name) throws TagException {
        String original_name;
        if (this.getTagType().isTagTypeAuto()) {
            throw new TagException("Not supported");
        }
        if (this.tag_name.startsWith("tag.") && (original_name = this.readStringAttribute(AT_ORIGINAL_NAME, null)) == null) {
            this.writeStringAttribute(AT_ORIGINAL_NAME, this.tag_name);
        }
        this.tag_name = name;
        this.tag_type.fireChanged(this);
    }

    public boolean isPublic() {
        boolean pub;
        boolean bl = pub = this.is_public == null ? this.getPublicDefault() : this.is_public.booleanValue();
        if (pub && this.isTagAuto()) {
            pub = false;
        }
        return pub;
    }

    public void setPublic(boolean v) {
        if (this.is_public == null || v != this.is_public) {
            if (v && !this.canBePublic()) {
                Debug.out("Invalid attempt to set public");
                return;
            }
            this.is_public = v;
            this.writeBooleanAttribute(AT_PUBLIC, v);
            this.tag_type.fireChanged(this);
        }
    }

    protected boolean getPublicDefault() {
        if (!this.getCanBePublicDefault()) {
            return false;
        }
        return this.tag_type.getTagManager().getTagPublicDefault();
    }

    public void setCanBePublic(boolean can_be_public) {
        this.writeBooleanAttribute(AT_CAN_BE_PUBLIC, can_be_public);
        if (!can_be_public && this.isPublic()) {
            this.setPublic(false);
        }
    }

    public boolean canBePublic() {
        return this.readBooleanAttribute(AT_CAN_BE_PUBLIC, this.getCanBePublicDefault());
    }

    protected boolean getCanBePublicDefault() {
        return true;
    }

    public boolean isTagAuto() {
        return false;
    }

    public boolean isVisible() {
        return this.is_visible == null ? this.getVisibleDefault() : this.is_visible.booleanValue();
    }

    public void setVisible(boolean v) {
        if (this.is_visible == null || v != this.is_visible) {
            this.is_visible = v;
            this.writeBooleanAttribute(AT_VISIBLE, v);
            this.tag_type.fireChanged(this);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String new_group) {
        if (this.group == null && new_group == null) {
            return;
        }
        if (this.group == null || new_group == null || !this.group.equals(new_group)) {
            this.group = new_group;
            this.writeStringAttribute(AT_GROUP, new_group);
            this.tag_type.fireChanged(this);
        }
    }

    protected boolean getVisibleDefault() {
        return true;
    }

    public String getImageID() {
        return this.readStringAttribute(AT_IMAGE_ID, null);
    }

    public void setImageID(String id) {
        this.writeStringAttribute(AT_IMAGE_ID, id);
    }

    private int[] decodeRGB(String str) {
        if (str == null) {
            return null;
        }
        String[] bits = str.split(",");
        if (bits.length != 3) {
            return null;
        }
        int[] rgb = new int[3];
        for (int i = 0; i < bits.length; ++i) {
            try {
                rgb[i] = Integer.parseInt(bits[i]);
                continue;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return rgb;
    }

    private String encodeRGB(int[] rgb) {
        if (rgb == null || rgb.length != 3) {
            return null;
        }
        return rgb[0] + "," + rgb[1] + "," + rgb[2];
    }

    public int[] getColor() {
        int[] result = this.decodeRGB(this.readStringAttribute(AT_COLOR_ID, null));
        if (result == null) {
            result = this.tag_type.getColorDefault();
        }
        return result;
    }

    public void setColor(int[] rgb) {
        this.writeStringAttribute(AT_COLOR_ID, this.encodeRGB(rgb));
        this.tag_type.fireChanged(this);
    }

    public boolean isTagRSSFeedEnabled() {
        if (this.tag_rss != null) {
            return this.readBooleanAttribute(AT_RSS_ENABLE, false);
        }
        return false;
    }

    public void setTagRSSFeedEnabled(boolean enable) {
        if (this.tag_rss != null && this.isTagRSSFeedEnabled() != enable) {
            this.writeBooleanAttribute(AT_RSS_ENABLE, enable);
            this.tag_type.fireChanged(this);
            this.tag_type.getTagManager().checkRSSFeeds(this, enable);
        }
    }

    public boolean supportsTagInitialSaveFolder() {
        return false;
    }

    public File getTagInitialSaveFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_INIT_LOC, null);
            if (str == null) {
                return null;
            }
            return new File(str);
        }
        return null;
    }

    public void setTagInitialSaveFolder(File folder) {
        if (this.tag_fl != null) {
            File existing = this.getTagInitialSaveFolder();
            if (existing == null && folder == null) {
                return;
            }
            if (existing == null || folder == null || !existing.equals(folder)) {
                this.writeStringAttribute(AT_FL_INIT_LOC, folder == null ? null : folder.getAbsolutePath());
                this.tag_type.fireChanged(this);
            }
        }
    }

    public boolean supportsTagMoveOnComplete() {
        return false;
    }

    public File getTagMoveOnCompleteFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_MOVE_COMP, null);
            if (str == null) {
                return null;
            }
            return new File(str);
        }
        return null;
    }

    public void setTagMoveOnCompleteFolder(File folder) {
        if (this.tag_fl != null) {
            File existing = this.getTagMoveOnCompleteFolder();
            if (existing == null && folder == null) {
                return;
            }
            if (existing == null || folder == null || !existing.equals(folder)) {
                this.writeStringAttribute(AT_FL_MOVE_COMP, folder == null ? null : folder.getAbsolutePath());
                this.tag_type.fireChanged(this);
            }
        }
    }

    public boolean supportsTagCopyOnComplete() {
        return false;
    }

    public File getTagCopyOnCompleteFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_COPY_COMP, null);
            if (str == null) {
                return null;
            }
            return new File(str);
        }
        return null;
    }

    public void setTagCopyOnCompleteFolder(File folder) {
        if (this.tag_fl != null) {
            File existing = this.getTagCopyOnCompleteFolder();
            if (existing == null && folder == null) {
                return;
            }
            if (existing == null || folder == null || !existing.equals(folder)) {
                this.writeStringAttribute(AT_FL_COPY_COMP, folder == null ? null : folder.getAbsolutePath());
                this.tag_type.fireChanged(this);
            }
        }
    }

    public int getTagMinShareRatio() {
        return -1;
    }

    public void setTagMinShareRatio(int sr) {
        Debug.out("not supported");
    }

    public int getTagMaxShareRatio() {
        return -1;
    }

    public void setTagMaxShareRatio(int sr) {
        Debug.out("not supported");
    }

    public TagFeatureProperties.TagProperty[] getSupportedProperties() {
        return new TagFeatureProperties.TagProperty[0];
    }

    public TagFeatureProperties.TagProperty getProperty(String name) {
        TagFeatureProperties.TagProperty[] props;
        for (TagFeatureProperties.TagProperty prop : props = this.getSupportedProperties()) {
            if (prop.getName(false) != name) continue;
            return prop;
        }
        return null;
    }

    protected TagFeatureProperties.TagProperty createTagProperty(String name, int type) {
        return new TagPropertyImpl(name, type);
    }

    public int getSupportedActions() {
        return 0;
    }

    public boolean supportsAction(int action) {
        return (this.getSupportedActions() & action) != 0;
    }

    public boolean isActionEnabled(int action) {
        if (!this.supportsAction(action)) {
            Debug.out("not supported");
            return false;
        }
        return this.readBooleanAttribute(AT_PROPERTY_PREFIX + action, false);
    }

    public void setActionEnabled(int action, boolean enabled) {
        if (!this.supportsAction(action)) {
            Debug.out("not supported");
            return;
        }
        this.writeBooleanAttribute(AT_PROPERTY_PREFIX + action, enabled);
    }

    public void addTaggable(Taggable t) {
        this.t_listeners.dispatch(1, t);
        this.tag_type.taggableAdded(this, t);
        this.tag_type.fireChanged(this);
    }

    public void removeTaggable(Taggable t) {
        this.t_listeners.dispatch(2, t);
        this.tag_type.taggableRemoved(this, t);
        this.tag_type.fireChanged(this);
    }

    protected void sync() {
        this.t_listeners.dispatch(3, null);
        this.tag_type.taggableSync(this);
    }

    public void removeTag() {
        boolean was_rss = this.isTagRSSFeedEnabled();
        this.tag_type.removeTag(this);
        if (was_rss) {
            this.tag_type.getTagManager().checkRSSFeeds(this, false);
        }
    }

    public String getDescription() {
        return null;
    }

    public void addTagListener(TagListener listener, boolean fire_for_existing) {
        if (!this.t_listeners.hasListener(listener)) {
            this.t_listeners.addListener(listener);
        }
        if (fire_for_existing) {
            for (Taggable t : this.getTagged()) {
                listener.taggableAdded(this, t);
            }
        }
    }

    protected void destroy() {
        Set<Taggable> taggables = this.getTagged();
        for (Taggable t : taggables) {
            this.t_listeners.dispatch(2, t);
            this.tag_type.taggableRemoved(this, t);
        }
    }

    public void removeTagListener(TagListener listener) {
        this.t_listeners.removeListener(listener);
    }

    protected Boolean readBooleanAttribute(String attr, Boolean def) {
        return this.tag_type.readBooleanAttribute(this, attr, def);
    }

    protected boolean writeBooleanAttribute(String attr, boolean value) {
        return this.tag_type.writeBooleanAttribute(this, attr, value);
    }

    protected long readLongAttribute(String attr, long def) {
        return this.tag_type.readLongAttribute(this, attr, def);
    }

    protected void writeLongAttribute(String attr, long value) {
        this.tag_type.writeLongAttribute(this, attr, value);
    }

    protected String readStringAttribute(String attr, String def) {
        return this.tag_type.readStringAttribute(this, attr, def);
    }

    protected void writeStringAttribute(String attr, String value) {
        this.tag_type.writeStringAttribute(this, attr, value);
    }

    protected String[] readStringListAttribute(String attr, String[] def) {
        return this.tag_type.readStringListAttribute(this, attr, def);
    }

    protected boolean writeStringListAttribute(String attr, String[] value) {
        return this.tag_type.writeStringListAttribute(this, attr, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecentHistoryRetention(boolean required) {
        if (this.tag_rl == null || !this.tag_rl.supportsTagRates()) {
            return;
        }
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (required) {
                if (!this.history_retention_required) {
                    this.history = new long[1800];
                    this.history_pos = 0;
                    this.history_retention_required = true;
                    if (!this.timer_registered) {
                        SimpleTimer.addTickReceiver(this);
                        this.timer_registered = true;
                    }
                }
            } else {
                this.history = null;
                this.history_retention_required = false;
                if (this.timer_registered) {
                    SimpleTimer.removeTickReceiver(this);
                    this.timer_registered = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getRecentHistory() {
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (this.history == null) {
                return new int[2][0];
            }
            int entries = this.history_wrapped ? 1800 : this.history_pos;
            int start = this.history_wrapped ? this.history_pos : 0;
            int[][] result = new int[2][entries];
            int pos = start;
            for (int i = 0; i < entries; ++i) {
                if (pos == 1800) {
                    pos = 0;
                }
                long entry = this.history[pos++];
                int send_rate = (int)(entry >> 32 & 0xFFFFFFFFL);
                int recv_rate = (int)(entry & 0xFFFFFFFFL);
                result[0][i] = send_rate;
                result[1][i] = recv_rate;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(long mono_now, int count) {
        if (!this.history_retention_required) {
            return;
        }
        long send_rate = this.tag_rl.getTagCurrentUploadRate();
        long receive_rate = this.tag_rl.getTagCurrentDownloadRate();
        long entry = send_rate << 32 & 0xFFFFFFFF00000000L | receive_rate & 0xFFFFFFFFL;
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (this.history != null) {
                this.history[this.history_pos++] = entry;
                if (this.history_pos == 1800) {
                    this.history_pos = 0;
                    this.history_wrapped = true;
                }
            }
        }
    }

    private class TagPropertyImpl
    implements TagFeatureProperties.TagProperty {
        private String name;
        private int type;
        private CopyOnWriteList<TagFeatureProperties.TagPropertyListener> listeners = new CopyOnWriteList();

        private TagPropertyImpl(String _name, int _type) {
            this.name = _name;
            this.type = _type;
        }

        public Tag getTag() {
            return TagBase.this;
        }

        public int getType() {
            return this.type;
        }

        public String getName(boolean localize) {
            if (localize) {
                return MessageText.getString("tag.property." + this.name);
            }
            return this.name;
        }

        public void setStringList(String[] value) {
            if (TagBase.this.writeStringListAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, value)) {
                for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                    try {
                        l.propertyChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                TagBase.this.tag_type.fireChanged(TagBase.this);
            }
        }

        public String[] getStringList() {
            return TagBase.this.readStringListAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, EMPTY_STRING_LIST);
        }

        public void setBoolean(boolean value) {
            if (TagBase.this.writeBooleanAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, value)) {
                for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                    try {
                        l.propertyChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                TagBase.this.tag_type.fireChanged(TagBase.this);
            }
        }

        public Boolean getBoolean() {
            return TagBase.this.readBooleanAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, null);
        }

        public String getString() {
            String value = null;
            switch (this.getType()) {
                case 1: {
                    String[] vals = this.getStringList();
                    if (vals == null || vals.length <= 0) break;
                    value = "";
                    if (this.getName(false).equals("tracker_templates")) {
                        String str_merge = MessageText.getString("label.merge");
                        String str_replace = MessageText.getString("label.replace");
                        String str_remove = MessageText.getString("Button.remove");
                        for (String val : vals) {
                            String[] bits = val.split(":");
                            String type = bits[0];
                            String str = bits[1];
                            str = type.equals("m") ? str + ": " + str_merge : (type.equals("r") ? str + ": " + str_replace : str + ": " + str_remove);
                            value = value + (value.length() == 0 ? "" : ",") + str;
                        }
                    } else {
                        for (String val : vals) {
                            value = value + (value.length() == 0 ? "" : ",") + val;
                        }
                    }
                    break;
                }
                case 2: {
                    Boolean val = this.getBoolean();
                    if (val == null) break;
                    value = String.valueOf(val);
                    break;
                }
                default: {
                    value = "Unknown type";
                }
            }
            if (value == null) {
                return "";
            }
            return this.getName(true) + "=" + value;
        }

        public void addListener(TagFeatureProperties.TagPropertyListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(TagFeatureProperties.TagPropertyListener listener) {
            this.listeners.remove(listener);
        }

        public void syncListeners() {
            for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                try {
                    l.propertySync(this);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }
}

