/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.getright;

import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderFactory;
import com.aelitis.azureus.plugins.extseed.impl.getright.ExternalSeedReaderGetRight;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderFactoryGetRight
implements ExternalSeedReaderFactory {
    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Download download) {
        return this.getSeedReaders(plugin, download.getName(), download.getTorrent());
    }

    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Torrent torrent) {
        return this.getSeedReaders(plugin, torrent.getName(), torrent);
    }

    private ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, String name, Torrent torrent) {
        try {
            HashMap<String, Object> config = new HashMap<String, Object>();
            Object obj = torrent.getAdditionalProperty("url-list");
            if (obj != null) {
                config.put("url-list", obj);
            }
            if ((obj = torrent.getAdditionalProperty("url-list-params")) != null) {
                config.put("url-list-params", obj);
            }
            if ((obj = torrent.getAdditionalProperty("url-list-params2")) != null) {
                config.put("url-list-params2", obj);
            }
            return this.getSeedReaders(plugin, name, torrent, config);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ExternalSeedReader[0];
        }
    }

    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Download download, Map config) {
        return this.getSeedReaders(plugin, download.getName(), download.getTorrent(), config);
    }

    private ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, String name, Torrent torrent, Map config) {
        try {
            Object obj = config.get("url-list");
            if (obj instanceof byte[]) {
                ArrayList l = new ArrayList();
                l.add(obj);
                obj = l;
            }
            if (obj instanceof List) {
                List urls = (List)obj;
                ArrayList<ExternalSeedReaderGetRight> readers = new ArrayList<ExternalSeedReaderGetRight>();
                Object _global_params = config.get("url-list-params");
                Object _specific_params = config.get("url-list-params2");
                Map global_params = _global_params instanceof Map ? (Map)_global_params : new HashMap();
                List specific_params = _specific_params instanceof List ? (List)_specific_params : new ArrayList();
                for (int i = 0; i < urls.size(); ++i) {
                    Object o;
                    if (readers.size() > 10) {
                        Debug.out("Too many GR seeds, truncating");
                        break;
                    }
                    Map my_params = global_params;
                    if (i < specific_params.size() && (o = specific_params.get(i)) instanceof Map) {
                        my_params = (Map)o;
                    }
                    try {
                        String url_str = new String((byte[])urls.get(i), "UTF-8");
                        url_str = url_str.replaceAll(" ", "%20");
                        if (url_str.length() <= 0) continue;
                        URL url = new URL(url_str);
                        String protocol = url.getProtocol().toLowerCase();
                        if (protocol.startsWith("http")) {
                            readers.add(new ExternalSeedReaderGetRight(plugin, torrent, url, my_params));
                            continue;
                        }
                        plugin.log(name + ": GR unsupported protocol: " + url);
                        continue;
                    }
                    catch (Throwable e) {
                        Object o2 = urls.get(i);
                        String str = o2 instanceof byte[] ? new String((byte[])o2) : String.valueOf(o2);
                        Debug.out("GR seed invalid: " + str, e);
                    }
                }
                ExternalSeedReader[] res = new ExternalSeedReader[readers.size()];
                readers.toArray(res);
                return res;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new ExternalSeedReader[0];
    }
}

