/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.util.Arrays;

class IntArray {
    private int[] m_ints;

    public IntArray(int intLen) {
        this.m_ints = new int[intLen];
    }

    public IntArray(int[] ints) {
        this.m_ints = ints;
    }

    public IntArray(BigInteger bigInt) {
        this(bigInt, 0);
    }

    public IntArray(BigInteger bigInt, int minIntLen) {
        int barrI;
        int intLen;
        if (bigInt.signum() == -1) {
            throw new IllegalArgumentException("Only positive Integers allowed");
        }
        if (bigInt.equals(ECConstants.ZERO)) {
            this.m_ints = new int[]{0};
            return;
        }
        byte[] barr = bigInt.toByteArray();
        int barrLen = barr.length;
        int barrStart = 0;
        if (barr[0] == 0) {
            --barrLen;
            barrStart = 1;
        }
        this.m_ints = (intLen = (barrLen + 3) / 4) < minIntLen ? new int[minIntLen] : new int[intLen];
        int iarrJ = intLen - 1;
        int rem = barrLen % 4 + barrStart;
        int temp = 0;
        if (barrStart < rem) {
            for (barrI = barrStart; barrI < rem; ++barrI) {
                temp <<= 8;
                int barrBarrI = barr[barrI];
                if (barrBarrI < 0) {
                    barrBarrI += 256;
                }
                temp |= barrBarrI;
            }
            this.m_ints[iarrJ--] = temp;
        }
        while (iarrJ >= 0) {
            temp = 0;
            for (int i = 0; i < 4; ++i) {
                int barrBarrI;
                temp <<= 8;
                if ((barrBarrI = barr[barrI++]) < 0) {
                    barrBarrI += 256;
                }
                temp |= barrBarrI;
            }
            this.m_ints[iarrJ] = temp;
            --iarrJ;
        }
    }

    public boolean isZero() {
        return this.m_ints.length == 0 || this.m_ints[0] == 0 && this.getUsedLength() == 0;
    }

    public int getUsedLength() {
        int highestIntPos = this.m_ints.length;
        if (highestIntPos < 1) {
            return 0;
        }
        if (this.m_ints[0] != 0) {
            while (this.m_ints[--highestIntPos] == 0) {
            }
            return highestIntPos + 1;
        }
        do {
            if (this.m_ints[--highestIntPos] == 0) continue;
            return highestIntPos + 1;
        } while (highestIntPos > 0);
        return 0;
    }

    public int bitLength() {
        int intLen = this.getUsedLength();
        if (intLen == 0) {
            return 0;
        }
        int last = intLen - 1;
        int highest = this.m_ints[last];
        int bits = (last << 5) + 1;
        if ((highest & 0xFFFF0000) != 0) {
            if ((highest & 0xFF000000) != 0) {
                bits += 24;
                highest >>>= 24;
            } else {
                bits += 16;
                highest >>>= 16;
            }
        } else if (highest > 255) {
            bits += 8;
            highest >>>= 8;
        }
        while (highest != 1) {
            ++bits;
            highest >>>= 1;
        }
        return bits;
    }

    private int[] resizedInts(int newLen) {
        int[] newInts = new int[newLen];
        int oldLen = this.m_ints.length;
        int copyLen = oldLen < newLen ? oldLen : newLen;
        System.arraycopy(this.m_ints, 0, newInts, 0, copyLen);
        return newInts;
    }

    public BigInteger toBigInteger() {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return ECConstants.ZERO;
        }
        int highestInt = this.m_ints[usedLen - 1];
        byte[] temp = new byte[4];
        int barrI = 0;
        boolean trailingZeroBytesDone = false;
        for (int j = 3; j >= 0; --j) {
            byte thisByte = (byte)(highestInt >>> 8 * j);
            if (!trailingZeroBytesDone && thisByte == 0) continue;
            trailingZeroBytesDone = true;
            temp[barrI++] = thisByte;
        }
        int barrLen = 4 * (usedLen - 1) + barrI;
        byte[] barr = new byte[barrLen];
        for (int j = 0; j < barrI; ++j) {
            barr[j] = temp[j];
        }
        for (int iarrJ = usedLen - 2; iarrJ >= 0; --iarrJ) {
            for (int j = 3; j >= 0; --j) {
                barr[barrI++] = (byte)(this.m_ints[iarrJ] >>> 8 * j);
            }
        }
        return new BigInteger(1, barr);
    }

    public void shiftLeft() {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return;
        }
        if (this.m_ints[usedLen - 1] < 0 && ++usedLen > this.m_ints.length) {
            this.m_ints = this.resizedInts(this.m_ints.length + 1);
        }
        boolean carry = false;
        for (int i = 0; i < usedLen; ++i) {
            boolean nextCarry = this.m_ints[i] < 0;
            int n = i;
            this.m_ints[n] = this.m_ints[n] << 1;
            if (carry) {
                int n2 = i;
                this.m_ints[n2] = this.m_ints[n2] | 1;
            }
            carry = nextCarry;
        }
    }

    public IntArray shiftLeft(int n) {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return this;
        }
        if (n == 0) {
            return this;
        }
        if (n > 31) {
            throw new IllegalArgumentException("shiftLeft() for max 31 bits , " + n + "bit shift is not possible");
        }
        int[] newInts = new int[usedLen + 1];
        int nm32 = 32 - n;
        newInts[0] = this.m_ints[0] << n;
        for (int i = 1; i < usedLen; ++i) {
            newInts[i] = this.m_ints[i] << n | this.m_ints[i - 1] >>> nm32;
        }
        newInts[usedLen] = this.m_ints[usedLen - 1] >>> nm32;
        return new IntArray(newInts);
    }

    public void addShifted(IntArray other, int shift) {
        int usedLenOther = other.getUsedLength();
        int newMinUsedLen = usedLenOther + shift;
        if (newMinUsedLen > this.m_ints.length) {
            this.m_ints = this.resizedInts(newMinUsedLen);
        }
        for (int i = 0; i < usedLenOther; ++i) {
            int n = i + shift;
            this.m_ints[n] = this.m_ints[n] ^ other.m_ints[i];
        }
    }

    public int getLength() {
        return this.m_ints.length;
    }

    public boolean testBit(int n) {
        int theInt = n >> 5;
        int theBit = n & 0x1F;
        int tester = 1 << theBit;
        return (this.m_ints[theInt] & tester) != 0;
    }

    public void flipBit(int n) {
        int theInt = n >> 5;
        int theBit = n & 0x1F;
        int flipper = 1 << theBit;
        int n2 = theInt;
        this.m_ints[n2] = this.m_ints[n2] ^ flipper;
    }

    public void setBit(int n) {
        int theInt = n >> 5;
        int theBit = n & 0x1F;
        int setter = 1 << theBit;
        int n2 = theInt;
        this.m_ints[n2] = this.m_ints[n2] | setter;
    }

    public IntArray multiply(IntArray other, int m) {
        int t = m + 31 >> 5;
        if (this.m_ints.length < t) {
            this.m_ints = this.resizedInts(t);
        }
        IntArray b = new IntArray(other.resizedInts(other.getLength() + 1));
        IntArray c = new IntArray(m + m + 31 >> 5);
        int testBit = 1;
        for (int k = 0; k < 32; ++k) {
            for (int j = 0; j < t; ++j) {
                if ((this.m_ints[j] & testBit) == 0) continue;
                c.addShifted(b, j);
            }
            testBit <<= 1;
            b.shiftLeft();
        }
        return c;
    }

    public void reduce(int m, int[] redPol) {
        for (int i = m + m - 2; i >= m; --i) {
            if (!this.testBit(i)) continue;
            int bit = i - m;
            this.flipBit(bit);
            this.flipBit(i);
            int l = redPol.length;
            while (--l >= 0) {
                this.flipBit(redPol[l] + bit);
            }
        }
        this.m_ints = this.resizedInts(m + 31 >> 5);
    }

    public IntArray square(int m) {
        int[] table = new int[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85};
        int t = m + 31 >> 5;
        if (this.m_ints.length < t) {
            this.m_ints = this.resizedInts(t);
        }
        IntArray c = new IntArray(t + t);
        for (int i = 0; i < t; ++i) {
            int v0 = 0;
            for (int j = 0; j < 4; ++j) {
                v0 >>>= 8;
                int u = this.m_ints[i] >>> j * 4 & 0xF;
                int w = table[u] << 24;
                v0 |= w;
            }
            c.m_ints[i + i] = v0;
            v0 = 0;
            int upper = this.m_ints[i] >>> 16;
            for (int j = 0; j < 4; ++j) {
                v0 >>>= 8;
                int u = upper >>> j * 4 & 0xF;
                int w = table[u] << 24;
                v0 |= w;
            }
            c.m_ints[i + i + 1] = v0;
        }
        return c;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntArray)) {
            return false;
        }
        IntArray other = (IntArray)o;
        int usedLen = this.getUsedLength();
        if (other.getUsedLength() != usedLen) {
            return false;
        }
        for (int i = 0; i < usedLen; ++i) {
            if (this.m_ints[i] == other.m_ints[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int usedLen = this.getUsedLength();
        int hash = 0;
        for (int i = 0; i < usedLen; ++i) {
            hash ^= this.m_ints[i];
        }
        return hash;
    }

    public Object clone() {
        return new IntArray(Arrays.clone(this.m_ints));
    }

    public String toString() {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return "0";
        }
        StringBuffer sb = new StringBuffer(Integer.toBinaryString(this.m_ints[usedLen - 1]));
        for (int iarrJ = usedLen - 2; iarrJ >= 0; --iarrJ) {
            String hexString = Integer.toBinaryString(this.m_ints[iarrJ]);
            for (int i = hexString.length(); i < 8; ++i) {
                hexString = "0" + hexString;
            }
            sb.append(hexString);
        }
        return sb.toString();
    }
}

