/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessControllerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import com.aelitis.azureus.core.util.LinkFileMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerAllocationScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoSetImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class DiskManagerImpl
extends LogRelation
implements DiskManagerHelper {
    private static final int DM_FREE_PIECELIST_TIMEOUT = 120000;
    private static final LogIDs LOGID = LogIDs.DISK;
    private static DiskAccessController disk_access_controller;
    private static boolean reorder_storage_mode;
    private static int reorder_storage_mode_min_mb;
    private static DiskManagerRecheckScheduler recheck_scheduler;
    private static DiskManagerAllocationScheduler allocation_scheduler;
    private static ThreadPool start_pool;
    private boolean used = false;
    private boolean started = false;
    private AESemaphore started_sem = new AESemaphore("DiskManager::started");
    private boolean starting;
    private boolean stopping;
    private int state_set_via_method;
    protected String errorMessage = "";
    private int pieceLength;
    private int lastPieceLength;
    private int nbPieces;
    private long totalLength;
    private int percentDone;
    private long allocated;
    private long remaining;
    private TOTorrent torrent;
    private DMReader reader;
    private DMChecker checker;
    private DMWriter writer;
    private RDResumeHandler resume_handler;
    private DMPieceMapper piece_mapper;
    private DiskManagerPieceImpl[] pieces;
    private DMPieceMap piece_map_use_accessor;
    private long piece_map_use_accessor_time;
    private DiskManagerFileInfoImpl[] files;
    private DiskManagerFileInfoSet fileset;
    protected DownloadManager download_manager;
    private boolean alreadyMoved = false;
    private boolean skipped_file_set_changed = true;
    private long skipped_file_set_size;
    private long skipped_but_downloaded;
    private boolean checking_enabled = true;
    private volatile boolean move_in_progress;
    private volatile int move_progress;
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_PRIOCHANGED = 2;
    private static final int LDT_PIECE_DONE_CHANGED = 3;
    private static final int LDT_ACCESS_MODE_CHANGED = 4;
    protected static ListenerManager<DiskManagerListener> listeners_aggregator;
    private ListenerManager<DiskManagerListener> listeners = ListenerManager.createManager("DiskM:ListenDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

        @Override
        public void dispatch(DiskManagerListener listener, int type, Object value) {
            listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private AEMonitor start_stop_mon = new AEMonitor("DiskManager:startStop");
    private AEMonitor file_piece_mon = new AEMonitor("DiskManager:filePiece");

    public static DiskAccessController getDefaultDiskAccessController() {
        return disk_access_controller;
    }

    public DiskManagerImpl(TOTorrent _torrent, DownloadManager _dmanager) {
        this.torrent = _torrent;
        this.download_manager = _dmanager;
        this.pieces = new DiskManagerPieceImpl[0];
        this.setState(1);
        this.percentDone = 0;
        if (this.torrent == null) {
            this.errorMessage = "Torrent not available";
            this.setState(10);
            return;
        }
        LocaleUtilDecoder locale_decoder = null;
        try {
            locale_decoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this.errorMessage = TorrentUtils.exceptionToText(e);
            this.setState(10);
            return;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Initialisation failed - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.piece_mapper = DMPieceMapperFactory.create(this.torrent);
        try {
            this.piece_mapper.construct(locale_decoder, this.download_manager.getAbsoluteSaveLocation().getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Failed to build piece map - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.remaining = this.totalLength = this.piece_mapper.getTotalLength();
        this.nbPieces = this.torrent.getNumberOfPieces();
        this.pieceLength = (int)this.torrent.getPieceLength();
        this.lastPieceLength = this.piece_mapper.getLastPieceLength();
        this.pieces = new DiskManagerPieceImpl[this.nbPieces];
        for (int i = 0; i < this.nbPieces; ++i) {
            this.pieces[i] = new DiskManagerPieceImpl(this, i, i == this.nbPieces - 1 ? this.lastPieceLength : this.pieceLength);
        }
        this.reader = DMAccessFactory.createReader(this);
        this.checker = DMAccessFactory.createChecker(this);
        this.writer = DMAccessFactory.createWriter(this);
        this.resume_handler = new RDResumeHandler(this, this.checker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            if (this.move_in_progress) {
                Debug.out("start called while move in progress!");
            }
            this.start_stop_mon.enter();
            if (this.used) {
                Debug.out("DiskManager reuse not supported!!!!");
            }
            this.used = true;
            if (this.getState() == 10) {
                Debug.out("starting a faulty disk manager");
                Object var2_1 = null;
                this.start_stop_mon.exit();
                return;
            }
            this.started = true;
            this.starting = true;
            start_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    boolean stop_required;
                    try {
                        try {
                            try {
                                DiskManagerImpl.this.start_stop_mon.enter();
                                if (DiskManagerImpl.this.stopping) {
                                    throw new Exception("Stopped during startup");
                                }
                                Object var2_1 = null;
                                DiskManagerImpl.this.start_stop_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var2_2 = null;
                                DiskManagerImpl.this.start_stop_mon.exit();
                                throw throwable;
                            }
                            DiskManagerImpl.this.startSupport();
                        }
                        catch (Throwable e) {
                            DiskManagerImpl.this.errorMessage = Debug.getNestedExceptionMessage(e) + " (start)";
                            Debug.printStackTrace(e);
                            DiskManagerImpl.this.setState(10);
                            Object var4_7 = null;
                            DiskManagerImpl.this.started_sem.release();
                        }
                        Object var4_6 = null;
                        DiskManagerImpl.this.started_sem.release();
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        DiskManagerImpl.this.started_sem.release();
                        throw throwable;
                    }
                    try {
                        DiskManagerImpl.this.start_stop_mon.enter();
                        stop_required = DiskManagerImpl.this.getState() == 10 || DiskManagerImpl.this.stopping;
                        DiskManagerImpl.this.starting = false;
                        Object var6_10 = null;
                        DiskManagerImpl.this.start_stop_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        DiskManagerImpl.this.start_stop_mon.exit();
                        throw throwable;
                    }
                    if (stop_required) {
                        DiskManagerImpl.this.stop(false);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.start_stop_mon.exit();
            throw throwable;
        }
        Object var2_2 = null;
        this.start_stop_mon.exit();
    }

    private void startSupport() {
        boolean files_exist = false;
        if (this.download_manager.isPersistent()) {
            File[] move_to_dirs = DownloadManagerMoveHandler.getRelatedDirs(this.download_manager);
            for (int i = 0; i < move_to_dirs.length; ++i) {
                String move_to_dir = move_to_dirs[i].getAbsolutePath();
                if (!this.filesExist(move_to_dir)) continue;
                files_exist = true;
                this.alreadyMoved = true;
                this.download_manager.setTorrentSaveDir(move_to_dir);
                break;
            }
        }
        this.reader.start();
        this.checker.start();
        this.writer.start();
        if (!this.alreadyMoved && !this.download_manager.isDataAlreadyAllocated()) {
            SaveLocationChange transfer;
            if (!files_exist) {
                files_exist = this.filesExist();
            }
            if (!files_exist && (transfer = DownloadManagerMoveHandler.onInitialisation(this.download_manager)) != null) {
                if (transfer.download_location != null || transfer.download_name != null) {
                    File dl_location = transfer.download_location;
                    if (dl_location == null) {
                        dl_location = this.download_manager.getAbsoluteSaveLocation().getParentFile();
                    }
                    if (transfer.download_name == null) {
                        this.download_manager.setTorrentSaveDir(dl_location.getAbsolutePath());
                    } else {
                        this.download_manager.setTorrentSaveDir(dl_location.getAbsolutePath(), transfer.download_name);
                    }
                }
                if (transfer.torrent_location != null || transfer.torrent_name != null) {
                    try {
                        this.download_manager.setTorrentFile(transfer.torrent_location, transfer.torrent_name);
                    }
                    catch (DownloadManagerException e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        int newFiles = this.allocateFiles();
        if (this.getState() == 10) {
            return;
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(3);
        this.resume_handler.start();
        if (this.checking_enabled) {
            if (newFiles == 0) {
                this.resume_handler.checkAllPieces(false);
                if (this.getRemainingExcludingDND() == 0L) {
                    this.checkFreePieceList(true);
                }
            } else if (newFiles != this.files.length) {
                this.resume_handler.checkAllPieces(true);
            }
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(boolean closing) {
        block13: {
            block12: {
                try {
                    if (this.move_in_progress) {
                        Debug.out("stop called while move in progress!");
                    }
                    this.start_stop_mon.enter();
                    if (this.started) break block12;
                    boolean bl = false;
                    Object var4_6 = null;
                    this.start_stop_mon.exit();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    this.start_stop_mon.exit();
                    throw throwable;
                }
            }
            if (!this.starting) break block13;
            this.stopping = true;
            this.checker.stop();
            this.writer.stop();
            this.reader.stop();
            this.resume_handler.stop(closing);
            this.saveState(false);
            boolean bl = true;
            Object var4_7 = null;
            this.start_stop_mon.exit();
            return bl;
        }
        this.started = false;
        this.stopping = false;
        Object var4_8 = null;
        this.start_stop_mon.exit();
        this.started_sem.reserve();
        this.checker.stop();
        this.writer.stop();
        this.reader.stop();
        this.resume_handler.stop(closing);
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    if (this.files[i] == null) continue;
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable e) {
                    this.setFailed("File close fails: " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
        if (this.getState() == 4) {
            try {
                this.saveResumeData(false);
            }
            catch (Exception e) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
            }
        }
        this.saveState();
        this.listeners.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        if (this.move_in_progress) {
            Debug.out("isStopped called while move in progress!");
        }
        try {
            this.start_stop_mon.enter();
            boolean bl = !this.started && !this.starting && !this.stopping;
            Object var3_2 = null;
            this.start_stop_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.start_stop_mon.exit();
            throw throwable;
        }
    }

    public boolean filesExist() {
        return this.filesExist(this.download_manager.getAbsoluteSaveLocation().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean filesExist(String root_dir) {
        File parent;
        Object var18_17;
        File current;
        File data_file;
        boolean close_it;
        DiskManagerFileInfoImpl file_info;
        if (!this.torrent.isSimpleTorrent()) {
            root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
        }
        if (!root_dir.endsWith(File.separator)) {
            root_dir = root_dir + File.separator;
        }
        DMPieceMapperFile[] pm_files = this.piece_mapper.getFiles();
        String[] storage_types = this.getStorageTypes();
        DownloadManagerState state = this.download_manager.getDownloadState();
        int i = 0;
        while (true) {
            if (i >= pm_files.length) {
                return true;
            }
            DMPieceMapperFile pm_info = pm_files[i];
            File relative_file = pm_info.getDataFile();
            long target_length = pm_info.getLength();
            file_info = pm_info.getFileInfo();
            close_it = false;
            try {
                if (file_info == null) {
                    int storage_type = DiskManagerUtil.convertDMStorageTypeFromString(storage_types[i]);
                    file_info = this.createFileInfo(state, pm_info, i, root_dir, relative_file, storage_type);
                    close_it = true;
                }
                try {
                    CacheFile cache_file = file_info.getCacheFile();
                    data_file = file_info.getFile(true);
                    if (!cache_file.exists()) {
                        current = data_file;
                        break;
                    }
                    long existing_length = file_info.getCacheFile().getLength();
                    if (existing_length > target_length) {
                        if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                            file_info.setAccessMode(2);
                            file_info.getCacheFile().setLength(target_length);
                            Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                        } else {
                            this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                            boolean bl = false;
                            var18_17 = null;
                            if (!close_it) return bl;
                            file_info.getCacheFile().close();
                            return bl;
                        }
                    }
                    var18_17 = null;
                    if (close_it) {
                        file_info.getCacheFile().close();
                    }
                }
                catch (Throwable throwable) {
                    var18_17 = null;
                    if (close_it) {
                        file_info.getCacheFile().close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (filesExist:" + relative_file.toString() + ")";
                return false;
            }
            ++i;
        }
        while (!current.exists() && (parent = current.getParentFile()) != null) {
            if (!parent.exists()) {
                current = parent;
                continue;
            }
            this.errorMessage = parent.isDirectory() ? current.toString() + " not found." : parent.toString() + " is not a directory.";
            boolean bl = false;
            var18_17 = null;
            if (!close_it) return bl;
            file_info.getCacheFile().close();
            return bl;
        }
        this.errorMessage = data_file.toString() + " not found.";
        boolean bl = false;
        var18_17 = null;
        if (!close_it) return bl;
        file_info.getCacheFile().close();
        return bl;
    }

    private DiskManagerFileInfoImpl createFileInfo(DownloadManagerState state, DMPieceMapperFile pm_info, int file_index, String root_dir, File relative_file, int storage_type) throws Exception {
        try {
            return new DiskManagerFileInfoImpl(this, root_dir, relative_file, file_index, pm_info.getTorrentFile(), storage_type);
        }
        catch (CacheFileManagerException e) {
            if (Debug.getNestedExceptionMessage(e).contains("volume label syntax is incorrect")) {
                File temp;
                File target_file = new File(root_dir + relative_file.toString());
                File actual_file = state.getFileLink(file_index, target_file);
                if (actual_file == null) {
                    actual_file = target_file;
                }
                Stack<String> comps = new Stack<String>();
                boolean fixed = false;
                for (temp = actual_file; temp != null && !temp.exists(); temp = temp.getParentFile()) {
                    char[] chars;
                    String old_name = temp.getName();
                    String new_name = "";
                    for (char c : chars = old_name.toCharArray()) {
                        char i_c = c;
                        new_name = i_c >= '\u0000' && i_c < ' ' ? new_name + "_" : new_name + c;
                    }
                    comps.push(new_name);
                    if (old_name.equals(new_name)) continue;
                    fixed = true;
                }
                if (fixed) {
                    while (!comps.isEmpty()) {
                        String comp2 = (String)comps.pop();
                        if (comps.isEmpty()) {
                            String prefix = Base32.encode(new SHA1Simple().calculateHash(relative_file.toString().getBytes("UTF-8"))).substring(0, 4);
                            comp2 = prefix + "_" + comp2;
                        }
                        temp = new File(temp, comp2);
                    }
                    Debug.outNoStack("Fixing unsupported file path: " + actual_file.getAbsolutePath() + " -> " + temp.getAbsolutePath());
                    state.setFileLink(file_index, target_file, temp);
                    return new DiskManagerFileInfoImpl(this, root_dir, relative_file, file_index, pm_info.getTorrentFile(), storage_type);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int allocateFiles() {
        block65: {
            block64: {
                block62: {
                    block61: {
                        block60: {
                            block58: {
                                block66: {
                                    block57: {
                                        file_set = new HashSet<String>();
                                        pm_files = this.piece_mapper.getFiles();
                                        allocated_files = new DiskManagerFileInfoImpl[pm_files.length];
                                        state = this.download_manager.getDownloadState();
                                        try {
                                            DiskManagerImpl.allocation_scheduler.register(this);
                                            this.setState(2);
                                            this.allocated = 0L;
                                            numNewFiles = 0;
                                            root_dir = this.download_manager.getAbsoluteSaveLocation().getParent();
                                            if (!this.torrent.isSimpleTorrent()) {
                                                root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
                                            }
                                            root_dir = root_dir + File.separator;
                                            storage_types = this.getStorageTypes();
                                            incomplete_suffix = state.getAttribute("incompfilesuffix");
                                            for (i = 0; i < pm_files.length; ++i) {
                                                block63: {
                                                    block68: {
                                                        block59: {
                                                            block67: {
                                                                if (!this.stopping) break block67;
                                                                this.errorMessage = "File allocation interrupted - download is stopping";
                                                                this.setState(10);
                                                                var10_11 = -1;
                                                                var28_34 = null;
                                                                DiskManagerImpl.allocation_scheduler.unregister(this);
                                                                if (this.files != null) ** GOTO lbl28
                                                                i = 0;
lbl26:
                                                                // 2 sources

                                                                while (true) {
                                                                    if (i < allocated_files.length) break block57;
lbl28:
                                                                    // 2 sources

                                                                    return var10_11;
                                                                }
                                                            }
                                                            pm_info = pm_files[i];
                                                            target_length = pm_info.getLength();
                                                            relative_data_file = pm_info.getDataFile();
                                                            try {
                                                                storage_type = DiskManagerUtil.convertDMStorageTypeFromString(storage_types[i]);
                                                                allocated_files[i] = fileInfo = this.createFileInfo(state, pm_info, i, root_dir, relative_data_file, storage_type);
                                                                pm_info.setFileInfo(fileInfo);
                                                            }
                                                            catch (Exception e) {
                                                                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles:" + relative_data_file.toString() + ")";
                                                                this.setState(10);
                                                                var16_19 = -1;
                                                                var28_35 = null;
                                                                DiskManagerImpl.allocation_scheduler.unregister(this);
                                                                if (this.files == null) {
                                                                    for (i = 0; i < allocated_files.length; ++i) {
                                                                        if (allocated_files[i] == null) continue;
                                                                        try {
                                                                            allocated_files[i].getCacheFile().close();
                                                                            continue;
                                                                        }
                                                                        catch (Throwable e) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                return var16_19;
                                                            }
                                                            cache_file = fileInfo.getCacheFile();
                                                            data_file = fileInfo.getFile(true);
                                                            file_key = data_file.getAbsolutePath();
                                                            if (Constants.isWindows) {
                                                                file_key = file_key.toLowerCase();
                                                            }
                                                            if (file_set.contains(file_key)) {
                                                                this.errorMessage = "File occurs more than once in download: " + data_file.toString() + ".\nRename one of the files in Files view via the right-click menu.";
                                                                this.setState(10);
                                                                var18_22 = -1;
                                                                break block58;
                                                            }
                                                            file_set.add(file_key);
                                                            ext = data_file.getName();
                                                            if (incomplete_suffix != null && ext.endsWith(incomplete_suffix)) {
                                                                ext = ext.substring(0, ext.length() - incomplete_suffix.length());
                                                            }
                                                            if ((separator = ext.lastIndexOf(".")) == -1) {
                                                                separator = 0;
                                                            }
                                                            fileInfo.setExtension(ext.substring(separator));
                                                            extensions = COConfigurationManager.getStringParameter("priorityExtensions", "");
                                                            if (!extensions.equals("")) {
                                                                bIgnoreCase = COConfigurationManager.getBooleanParameter("priorityExtensionsIgnoreCase");
                                                                st = new StringTokenizer(extensions, ";");
                                                                while (st.hasMoreTokens()) {
                                                                    extension = st.nextToken();
                                                                    if (!(extension = extension.trim()).startsWith(".")) {
                                                                        extension = "." + extension;
                                                                    }
                                                                    if (!(bHighPriority = bIgnoreCase != false ? fileInfo.getExtension().equalsIgnoreCase(extension) : fileInfo.getExtension().equals(extension))) continue;
                                                                    fileInfo.setPriority(1);
                                                                }
                                                            }
                                                            fileInfo.setDownloaded(0L);
                                                            st = cache_file.getStorageType();
                                                            compact = st == 2 || st == 4;
                                                            v0 = mustExistOrAllocate = compact == false || RDResumeHandler.fileMustExist(this.download_manager, fileInfo) != false;
                                                            if (!mustExistOrAllocate && cache_file.exists()) {
                                                                data_file.delete();
                                                            }
                                                            if (!cache_file.exists()) break block68;
                                                            try {
                                                                existing_length = fileInfo.getCacheFile().getLength();
                                                                if (existing_length > target_length) {
                                                                    if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                                                                        fileInfo.setAccessMode(2);
                                                                        cache_file.setLength(target_length);
                                                                        fileInfo.setAccessMode(1);
                                                                        Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                                                                        break block59;
                                                                    }
                                                                    this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                                                                    this.setState(10);
                                                                    var26_67 = -1;
                                                                    break block60;
                                                                }
                                                            }
                                                            catch (Throwable e) {
                                                                this.fileAllocFailed(data_file, target_length, false, e);
                                                                this.setState(10);
                                                                var25_69 = -1;
                                                                var28_39 = null;
                                                                DiskManagerImpl.allocation_scheduler.unregister(this);
                                                                if (this.files == null) {
                                                                    for (i = 0; i < allocated_files.length; ++i) {
                                                                        if (allocated_files[i] == null) continue;
                                                                        ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl118:
                                                                        // 1 sources

                                                                        allocated_files[i].getCacheFile().close();
                                                                        continue;
lbl120:
                                                                        // 1 sources

                                                                        catch (Throwable e) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                return var25_69;
                                                            }
                                                            {
                                                                if (existing_length >= target_length || compact || this.allocateFile(fileInfo, data_file, existing_length, target_length)) break block59;
                                                                var26_68 = -1;
                                                            }
                                                            break block61;
                                                        }
                                                        this.allocated += target_length;
                                                        continue;
                                                    }
                                                    if (!mustExistOrAllocate) continue;
                                                    if (this.download_manager.isDataAlreadyAllocated()) {
                                                        this.errorMessage = "Data file missing: " + data_file.getAbsolutePath();
                                                        this.setState(10);
                                                        e = -1;
                                                        break block62;
                                                    }
                                                    try {
                                                        if (this.allocateFile(fileInfo, data_file, -1L, target_length)) break block63;
                                                        e = -1;
                                                        break block64;
                                                    }
                                                    catch (Throwable e) {
                                                        this.fileAllocFailed(data_file, target_length, true, e);
                                                        this.setState(10);
                                                        var25_70 = -1;
                                                        var28_42 = null;
                                                        DiskManagerImpl.allocation_scheduler.unregister(this);
                                                        if (this.files == null) {
                                                            for (i = 0; i < allocated_files.length; ++i) {
                                                                if (allocated_files[i] == null) continue;
                                                                ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl154:
                                                                // 1 sources

                                                                allocated_files[i].getCacheFile().close();
                                                                continue;
lbl156:
                                                                // 1 sources

                                                                catch (Throwable e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        return var25_70;
                                                    }
                                                }
                                                ++numNewFiles;
                                            }
                                            this.files = allocated_files;
                                            this.fileset = new DiskManagerFileInfoSetImpl(this.files, this);
                                            this.loadFilePriorities();
                                            this.download_manager.setDataAlreadyAllocated(true);
                                            var9_9 = numNewFiles;
                                            break block65;
                                        }
                                        catch (Throwable var27_71) {
                                            var28_44 = null;
                                            DiskManagerImpl.allocation_scheduler.unregister(this);
                                            if (this.files == null) {
                                                for (i = 0; i < allocated_files.length; ++i) {
                                                    if (allocated_files[i] == null) continue;
                                                    ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl178:
                                                    // 1 sources

                                                    allocated_files[i].getCacheFile().close();
                                                    continue;
lbl180:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            throw var27_71;
                                        }
                                    }
                                    if (allocated_files[i] != null) {
                                        ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl187:
                                        // 1 sources

                                        allocated_files[i].getCacheFile().close();
                                        break block66;
lbl189:
                                        // 1 sources

                                        catch (Throwable e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                ++i;
                                ** while (true)
                            }
                            var28_36 = null;
                            DiskManagerImpl.allocation_scheduler.unregister(this);
                            if (this.files == null) {
                                for (i = 0; i < allocated_files.length; ++i) {
                                    if (allocated_files[i] == null) continue;
                                    ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl201:
                                    // 1 sources

                                    allocated_files[i].getCacheFile().close();
                                    continue;
lbl203:
                                    // 1 sources

                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                }
                            }
                            return var18_22;
                        }
                        var28_37 = null;
                        DiskManagerImpl.allocation_scheduler.unregister(this);
                        if (this.files == null) {
                            for (i = 0; i < allocated_files.length; ++i) {
                                if (allocated_files[i] == null) continue;
                                ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl214:
                                // 1 sources

                                allocated_files[i].getCacheFile().close();
                                continue;
lbl216:
                                // 1 sources

                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                        }
                        return var26_67;
                    }
                    var28_38 = null;
                    DiskManagerImpl.allocation_scheduler.unregister(this);
                    if (this.files == null) {
                        for (i = 0; i < allocated_files.length; ++i) {
                            if (allocated_files[i] == null) continue;
                            ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl227:
                            // 1 sources

                            allocated_files[i].getCacheFile().close();
                            continue;
lbl229:
                            // 1 sources

                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                    }
                    return var26_68;
                }
                var28_40 = null;
                DiskManagerImpl.allocation_scheduler.unregister(this);
                if (this.files == null) {
                    for (i = 0; i < allocated_files.length; ++i) {
                        if (allocated_files[i] == null) continue;
                        ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl240:
                        // 1 sources

                        allocated_files[i].getCacheFile().close();
                        continue;
lbl242:
                        // 1 sources

                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                }
                return e;
            }
            var28_41 = null;
            DiskManagerImpl.allocation_scheduler.unregister(this);
            if (this.files == null) {
                for (i = 0; i < allocated_files.length; ++i) {
                    if (allocated_files[i] == null) continue;
                    ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl253:
                    // 1 sources

                    allocated_files[i].getCacheFile().close();
                    continue;
lbl255:
                    // 1 sources

                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            return e;
        }
        var28_43 = null;
        DiskManagerImpl.allocation_scheduler.unregister(this);
        if (this.files == null) {
            for (i = 0; i < allocated_files.length; ++i) {
                if (allocated_files[i] == null) continue;
                ** try [egrp 5[TRYBLOCK] [15 : 1180->1195)] { 
lbl266:
                // 1 sources

                allocated_files[i].getCacheFile().close();
                continue;
lbl268:
                // 1 sources

                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return var9_9;
    }

    /*
     * Loose catch block
     */
    private boolean allocateFile(DiskManagerFileInfoImpl fileInfo2, File data_file, long existing_length, long target_length) throws Throwable {
        block24: {
            while (this.started && !allocation_scheduler.getPermission(this)) {
            }
            if (!this.started) {
                return false;
            }
            fileInfo2.setAccessMode(2);
            if (COConfigurationManager.getBooleanParameter("Enable incremental file creation")) {
                if (existing_length < 0L) {
                    fileInfo2.getCacheFile().setLength(0L);
                }
            } else if (target_length > 0L && !Constants.isWindows && COConfigurationManager.getBooleanParameter("XFS Allocation")) {
                long resvp_len;
                long resvp_start;
                fileInfo2.getCacheFile().setLength(target_length);
                if (existing_length > 0L) {
                    resvp_start = existing_length;
                    resvp_len = target_length - existing_length;
                } else {
                    resvp_start = 0L;
                    resvp_len = target_length;
                }
                String[] cmd = new String[]{"/usr/sbin/xfs_io", "-c", "resvsp " + resvp_start + " " + resvp_len, data_file.getAbsolutePath()};
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    int count = p.getErrorStream().read(buffer);
                    while (count > 0) {
                        os.write(buffer, 0, count);
                        count = p.getErrorStream().read(buffer);
                    }
                    os.close();
                    p.waitFor();
                }
                catch (IOException e) {
                    String message = MessageText.getString("xfs.allocation.xfs_io.not.found", new String[]{e.getMessage()});
                    Logger.log(new LogAlert((Object)this, false, 3, message));
                }
                if (os.size() > 0) {
                    String message = os.toString().trim();
                    if (message.endsWith("is not on an XFS filesystem")) {
                        Logger.log(new LogEvent(this, LogIDs.DISK, "XFS file allocation impossible because \"" + data_file.getAbsolutePath() + "\" is not on an XFS filesystem. Original error reported by xfs_io : \"" + message + "\""));
                    } else {
                        throw new Exception(message);
                    }
                }
                this.allocated += target_length;
            } else {
                if (COConfigurationManager.getBooleanParameter("Zero New")) {
                    boolean successfulAlloc = false;
                    successfulAlloc = this.writer.zeroFile(fileInfo2, target_length);
                    Object var17_15 = null;
                    if (successfulAlloc) break block24;
                    try {
                        fileInfo2.getCacheFile().close();
                        fileInfo2.getCacheFile().delete();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    this.setState(10);
                    {
                        break block24;
                        catch (Throwable e) {
                            this.fileAllocFailed(data_file, target_length, existing_length == -1L, e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_16 = null;
                        if (!successfulAlloc) {
                            try {
                                fileInfo2.getCacheFile().close();
                                fileInfo2.getCacheFile().delete();
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            this.setState(10);
                        }
                        throw throwable;
                    }
                }
                fileInfo2.getCacheFile().setLength(target_length);
                this.allocated += target_length;
            }
        }
        fileInfo2.setAccessMode(1);
        return true;
    }

    private void fileAllocFailed(File file, long length, boolean is_new, Throwable e) {
        this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles " + (is_new ? "new" : "existing") + ":" + file.toString() + ")";
        if (this.errorMessage.indexOf("not enough space") != -1) {
            this.errorMessage = length >= 0x100000000L ? MessageText.getString("DiskManager.error.nospace_fat32") : MessageText.getString("DiskManager.error.nospace");
        }
    }

    public DiskAccessController getDiskAccessController() {
        return disk_access_controller;
    }

    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.reader.readBlock(request2, listener);
    }

    public boolean hasOutstandingReadRequestForPiece(int piece_number) {
        return this.reader.hasOutstandingReadRequestForPiece(piece_number);
    }

    public int getNbPieces() {
        return this.nbPieces;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public void setPercentDone(int num) {
        this.percentDone = num;
    }

    public long getRemaining() {
        return this.remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixupSkippedCalculation() {
        if (this.skipped_file_set_changed) {
            DownloadManagerStats stats2;
            DiskManagerFileInfoImpl[] current_files = this.files;
            if (current_files != null) {
                this.skipped_file_set_changed = false;
                try {
                    this.file_piece_mon.enter();
                    this.skipped_file_set_size = 0L;
                    this.skipped_but_downloaded = 0L;
                    for (int i = 0; i < current_files.length; ++i) {
                        DiskManagerFileInfoImpl file = current_files[i];
                        if (!file.isSkipped()) continue;
                        this.skipped_file_set_size += file.getLength();
                        this.skipped_but_downloaded += file.getDownloaded();
                    }
                    Object var5_5 = null;
                    this.file_piece_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.file_piece_mon.exit();
                    throw throwable;
                }
            }
            if ((stats2 = this.download_manager.getStats()) instanceof DownloadManagerStatsImpl) {
                ((DownloadManagerStatsImpl)stats2).setSkippedFileStats(this.skipped_file_set_size, this.skipped_but_downloaded);
            }
        }
    }

    public long getRemainingExcludingDND() {
        this.fixupSkippedCalculation();
        long rem = this.remaining - (this.skipped_file_set_size - this.skipped_but_downloaded);
        if (rem < 0L) {
            rem = 0L;
        }
        return rem;
    }

    public long getSizeExcludingDND() {
        this.fixupSkippedCalculation();
        return this.totalLength - this.skipped_file_set_size;
    }

    public int getPercentDoneExcludingDND() {
        long sizeExcludingDND = this.getSizeExcludingDND();
        if (sizeExcludingDND <= 0L) {
            return 0;
        }
        float pct = (float)(sizeExcludingDND - this.getRemainingExcludingDND()) / (float)sizeExcludingDND;
        return (int)(1000.0f * pct);
    }

    public long getAllocated() {
        return this.allocated;
    }

    public void setAllocated(long num) {
        this.allocated = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPieceDone(DiskManagerPieceImpl dmPiece, boolean done) {
        int piece_number = dmPiece.getPieceNumber();
        int piece_length = dmPiece.getLength();
        try {
            this.file_piece_mon.enter();
            if (dmPiece.isDone() != done) {
                dmPiece.setDoneSupport(done);
                this.remaining = done ? (this.remaining -= (long)piece_length) : (this.remaining += (long)piece_length);
                DMPieceList piece_list = this.getPieceList(piece_number);
                for (int i = 0; i < piece_list.size(); ++i) {
                    long file_done;
                    DMPieceMapEntry piece_map_entry = piece_list.get(i);
                    DiskManagerFileInfoImpl this_file = piece_map_entry.getFile();
                    long file_length = this_file.getLength();
                    long file_done_before = file_done = this_file.getDownloaded();
                    file_done = done ? (file_done += (long)piece_map_entry.getLength()) : (file_done -= (long)piece_map_entry.getLength());
                    if (file_done < 0L) {
                        Debug.out("piece map entry length negative");
                        file_done = 0L;
                    } else if (file_done > file_length) {
                        Debug.out("piece map entry length too large");
                        file_done = file_length;
                    }
                    if (this_file.isSkipped()) {
                        this.skipped_but_downloaded += file_done - file_done_before;
                    }
                    this_file.setDownloaded(file_done);
                    if (file_done != file_length) continue;
                    try {
                        DownloadManagerState state;
                        block26: {
                            Object var25_22;
                            state = this.download_manager.getDownloadState();
                            try {
                                String suffix = state.getAttribute("incompfilesuffix");
                                if (suffix != null && suffix.length() > 0) {
                                    File save_location;
                                    String name;
                                    File base_file = this_file.getFile(false);
                                    int file_index = this_file.getIndex();
                                    File link = state.getFileLink(file_index, base_file);
                                    if (link != null) {
                                        String name2 = link.getName();
                                        if (name2.endsWith(suffix) && name2.length() > suffix.length()) {
                                            String new_name = name2.substring(0, name2.length() - suffix.length());
                                            File new_file = new File(link.getParentFile(), new_name);
                                            if (!new_file.exists()) {
                                                this_file.renameFile(new_name);
                                                if (base_file.equals(new_file)) {
                                                    state.setFileLink(file_index, base_file, null);
                                                } else {
                                                    state.setFileLink(file_index, base_file, new_file);
                                                }
                                            }
                                        }
                                    } else if (this_file.getTorrentFile().getTorrent().isSimpleTorrent() && (name = (save_location = this.download_manager.getSaveLocation()).getName()).endsWith(suffix) && name.length() > suffix.length()) {
                                        String new_name = name.substring(0, name.length() - suffix.length());
                                        File new_file = new File(save_location.getParentFile(), new_name);
                                        if (!new_file.exists()) {
                                            this_file.renameFile(new_name);
                                            if (save_location.equals(new_file)) {
                                                state.setFileLink(0, save_location, null);
                                            } else {
                                                state.setFileLink(0, save_location, new_file);
                                            }
                                        }
                                    }
                                }
                                var25_22 = null;
                                if (this_file.getAccessMode() != 2) break block26;
                            }
                            catch (Throwable throwable) {
                                var25_22 = null;
                                if (this_file.getAccessMode() == 2) {
                                    this_file.setAccessMode(1);
                                }
                                if (this.getState() == 4) {
                                    state.setLongParameter("stats.download.file.completed.time", SystemTime.getCurrentTime());
                                }
                                throw throwable;
                            }
                            this_file.setAccessMode(1);
                        }
                        if (this.getState() != 4) continue;
                        state.setLongParameter("stats.download.file.completed.time", SystemTime.getCurrentTime());
                        {
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        this.setFailed("Disk access error - " + Debug.getNestedExceptionMessage(e));
                        Debug.printStackTrace(e);
                    }
                }
                if (this.getState() == 4) {
                    this.listeners.dispatch(3, dmPiece);
                }
            }
            Object var27_24 = null;
            this.file_piece_mon.exit();
        }
        catch (Throwable throwable) {
            Object var27_25 = null;
            this.file_piece_mon.exit();
            throw throwable;
        }
    }

    public void accessModeChanged(DiskManagerFileInfoImpl file, int old_mode, int new_mode) {
        this.listeners.dispatch(4, new Object[]{file, new Integer(old_mode), new Integer(new_mode)});
    }

    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    public DiskManagerPiece getPiece(int PieceNumber) {
        return this.pieces[PieceNumber];
    }

    public int getPieceLength() {
        return this.pieceLength;
    }

    public int getPieceLength(int piece_number) {
        if (piece_number == this.nbPieces - 1) {
            return this.lastPieceLength;
        }
        return this.pieceLength;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public int getLastPieceLength() {
        return this.lastPieceLength;
    }

    public int getState() {
        return this.state_set_via_method;
    }

    protected void setState(int _state) {
        if (this.state_set_via_method == 10) {
            if (_state != 10) {
                Debug.out("DiskManager: attempt to move from faulty state to " + _state);
            }
            return;
        }
        if (this.state_set_via_method != _state) {
            int[] params = new int[]{this.state_set_via_method, _state};
            this.state_set_via_method = _state;
            this.listeners.dispatch(1, params);
        }
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    public DiskManagerFileInfoSet getFileSet() {
        return this.fileset;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setFailed(final String reason) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
            }
        }.start();
    }

    public void setFailed(final DiskManagerFileInfo file, final String reason) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
                RDResumeHandler.recheckFile(DiskManagerImpl.this.download_manager, file);
            }
        }.start();
    }

    public int getCacheMode() {
        return 1;
    }

    public long[] getReadStats() {
        if (this.reader == null) {
            return new long[]{0L, 0L};
        }
        return this.reader.getStats();
    }

    public DMPieceMap getPieceMap() {
        DMPieceMap map = this.piece_map_use_accessor;
        if (map == null) {
            this.piece_map_use_accessor = map = this.piece_mapper.getPieceMap();
        }
        this.piece_map_use_accessor_time = SystemTime.getCurrentTime();
        return map;
    }

    public DMPieceList getPieceList(int piece_number) {
        DMPieceMap map = this.getPieceMap();
        return map.getPieceList(piece_number);
    }

    public void checkFreePieceList(boolean force_discard) {
        if (this.piece_map_use_accessor == null) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (!force_discard) {
            if (now < this.piece_map_use_accessor_time) {
                this.piece_map_use_accessor_time = now;
                return;
            }
            if (now - this.piece_map_use_accessor_time < 120000L) {
                return;
            }
        }
        this.piece_map_use_accessor = null;
    }

    public byte[] getPieceHash(int piece_number) throws TOTorrentException {
        return this.torrent.getPieces()[piece_number];
    }

    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return this.reader.createReadRequest(pieceNumber, offset, length);
    }

    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        return this.checker.createCheckRequest(pieceNumber, user_data);
    }

    public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
        return this.checker.hasOutstandingCheckRequestForPiece(piece_number);
    }

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCompleteRecheckRequest(request2, listener);
    }

    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCheckRequest(request2, listener);
    }

    public int getCompleteRecheckStatus() {
        return this.checker.getCompleteRecheckStatus();
    }

    public int getMoveProgress() {
        if (this.move_in_progress) {
            return this.move_progress;
        }
        return -1;
    }

    public void setPieceCheckingEnabled(boolean enabled) {
        this.checking_enabled = enabled;
        this.checker.setCheckingEnabled(enabled);
    }

    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        return this.reader.readBlock(pieceNumber, offset, length);
    }

    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
        return this.writer.createWriteRequest(pieceNumber, offset, data, user_data);
    }

    public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
        this.writer.writeBlock(request2, listener);
    }

    public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
        return this.writer.hasOutstandingWriteRequestForPiece(piece_number);
    }

    public boolean checkBlockConsistencyForWrite(String originator, int pieceNumber, int offset, DirectByteBuffer data) {
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " pieceNumber=" + pieceNumber + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int length = this.pieceLength;
        if (pieceNumber == this.nbPieces - 1) {
            length = this.lastPieceLength;
        }
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " > length=" + length));
            }
            return false;
        }
        int size = data.remaining((byte)8);
        if (size <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " size=" + size + " <= 0"));
            }
            return false;
        }
        if (offset + size > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " + size=" + size + " > length=" + length));
            }
            return false;
        }
        return true;
    }

    public boolean checkBlockConsistencyForRead(String originator, boolean peer_request, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, originator, peer_request, pieceNumber, offset, length);
    }

    public boolean checkBlockConsistencyForHint(String originator, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, originator, pieceNumber, offset, length);
    }

    public void saveResumeData(boolean interim_save) throws Exception {
        this.resume_handler.saveResumeData(interim_save);
    }

    public void downloadEnded(DiskManager.OperationStatus op_status) {
        this.moveDownloadFilesWhenEndedOrRemoved(false, true, op_status);
    }

    public void downloadRemoved() {
        this.moveDownloadFilesWhenEndedOrRemoved(true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean moveDownloadFilesWhenEndedOrRemoved(boolean removing, boolean torrent_file_exists, final DiskManager.OperationStatus op_status) {
        block12: {
            block10: {
                block11: {
                    try {
                        this.start_stop_mon.enter();
                        v0 = ending = removing == false;
                        if (!ending) ** GOTO lbl34
                        if (!this.alreadyMoved) break block10;
                        var5_5 = false;
                        var8_7 = null;
                        this.start_stop_mon.exit();
                        if (removing) break block11;
                    }
                    catch (Throwable var7_14) {
                        block13: {
                            var8_9 = null;
                            this.start_stop_mon.exit();
                            if (removing) break block13;
                            try {
                                this.saveResumeData(false);
                            }
                            catch (Throwable e) {
                                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
                            }
                        }
                        throw var7_14;
                    }
                    try {
                        this.saveResumeData(false);
                    }
                    catch (Throwable e) {
                        this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
                    }
                }
                return var5_5;
            }
            this.alreadyMoved = true;
lbl34:
            // 2 sources

            if (removing) {
                move_details = DownloadManagerMoveHandler.onRemoval(this.download_manager);
            } else {
                DownloadManagerMoveHandler.onCompletion(this.download_manager, new DownloadManagerMoveHandler.MoveCallback(){

                    public void perform(SaveLocationChange move_details) {
                        DiskManagerImpl.this.moveFiles(move_details, true, op_status);
                    }
                });
                move_details = null;
            }
            if (move_details != null) {
                this.moveFiles(move_details, true, op_status);
            }
            var6_13 = true;
            var8_8 = null;
            this.start_stop_mon.exit();
            if (removing) break block12;
            try {
                this.saveResumeData(false);
            }
            catch (Throwable e) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
            }
        }
        return var6_13;
    }

    public void moveDataFiles(File new_parent_dir, String new_name, DiskManager.OperationStatus op_status) {
        SaveLocationChange loc_change = new SaveLocationChange();
        loc_change.download_location = new_parent_dir;
        loc_change.download_name = new_name;
        this.moveFiles(loc_change, false, op_status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveFiles(SaveLocationChange loc_change, boolean change_to_read_only, DiskManager.OperationStatus op_status) {
        boolean move_files = false;
        if (loc_change.hasDownloadChange()) {
            move_files = !this.isFileDestinationIsItself(loc_change);
        }
        try {
            block8: {
                try {
                    this.start_stop_mon.enter();
                    boolean files_moved = true;
                    if (move_files) {
                        try {
                            this.move_progress = 0;
                            this.move_in_progress = true;
                            files_moved = this.moveDataFiles0(loc_change, change_to_read_only, op_status);
                            Object var7_7 = null;
                            this.move_in_progress = false;
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            this.move_in_progress = false;
                            throw throwable;
                        }
                    }
                    if (!loc_change.hasTorrentChange() || !files_moved) break block8;
                    this.moveTorrentFile(loc_change);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    Object var9_11 = null;
                    this.start_stop_mon.exit();
                }
            }
            Object var9_10 = null;
            this.start_stop_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.start_stop_mon.exit();
            throw throwable;
        }
    }

    private void logMoveFileError(String destination_path, String message) {
        Logger.log(new LogEvent((Object)this, LOGID, 3, message));
        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{destination_path, message});
    }

    private boolean isFileDestinationIsItself(SaveLocationChange loc_change) {
        File old_location = this.download_manager.getAbsoluteSaveLocation();
        File new_location = loc_change.normaliseDownloadLocation(old_location);
        try {
            old_location = old_location.getCanonicalFile();
            new_location = new_location.getCanonicalFile();
            if (old_location.equals(new_location)) {
                return true;
            }
            if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(new_location, old_location)) {
                String msg = "Target is sub-directory of files";
                this.logMoveFileError(new_location.toString(), msg);
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean moveDataFiles0(SaveLocationChange loc_change, boolean change_to_read_only, DiskManager.OperationStatus op_status) throws Exception {
        boolean bl;
        try {
            this.file_piece_mon.enter();
            Object var5_4 = null;
            this.file_piece_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.file_piece_mon.exit();
            throw throwable;
        }
        File move_to_dir_name = loc_change.download_location;
        if (move_to_dir_name == null) {
            move_to_dir_name = this.download_manager.getAbsoluteSaveLocation().getParentFile();
        }
        String move_to_dir = move_to_dir_name.toString();
        String new_name = loc_change.download_name;
        if (this.files == null) {
            return false;
        }
        if (this.isFileDestinationIsItself(loc_change)) {
            return false;
        }
        final boolean[] got_there = new boolean[]{false};
        if (op_status != null) {
            op_status.gonnaTakeAWhile(new DiskManager.GettingThere(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean hasGotThere() {
                    boolean[] blArray = got_there;
                    synchronized (got_there) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return got_there[0];
                    }
                }
            });
        }
        try {
            String new_root_dir;
            String old_root_dir;
            boolean simple_torrent = this.download_manager.getTorrent().isSimpleTorrent();
            File save_location = this.download_manager.getAbsoluteSaveLocation();
            String move_from_name = save_location.getName();
            String move_from_dir = save_location.getParentFile().getCanonicalFile().getPath();
            final File[] new_files = new File[this.files.length];
            File[] old_files = new File[this.files.length];
            boolean[] link_only = new boolean[this.files.length];
            long total_bytes = 0L;
            final long[] file_lengths_to_move = new long[this.files.length];
            for (int i = 0; i < this.files.length; ++i) {
                File new_file;
                File old_file = this.files[i].getFile(false);
                File linked_file = FMFileManagerFactory.getSingleton().getFileLink(this.torrent, i, old_file);
                if (!linked_file.equals(old_file)) {
                    if (simple_torrent) {
                        if (linked_file.getParentFile().getCanonicalPath().equals(save_location.getParentFile().getCanonicalPath())) {
                            old_file = linked_file;
                        } else {
                            link_only[i] = true;
                        }
                    } else if (linked_file.getCanonicalPath().startsWith(save_location.getCanonicalPath())) {
                        old_file = linked_file;
                    } else {
                        link_only[i] = true;
                    }
                }
                old_files[i] = old_file;
                String old_parent_path = old_file.getCanonicalFile().getParent();
                if (!old_parent_path.startsWith(move_from_dir)) {
                    this.logMoveFileError(move_to_dir, "Could not determine relative path for file - " + old_parent_path);
                    throw new IOException("relative path assertion failed: move_from_dir=\"" + move_from_dir + "\", old_parent_path=\"" + old_parent_path + "\"");
                }
                String sub_path = old_parent_path.substring(move_from_dir.length());
                if (sub_path.startsWith(File.separator)) {
                    sub_path = sub_path.substring(1);
                }
                if (new_name == null) {
                    new_file = new File(new File(move_to_dir, sub_path), old_file.getName());
                } else if (simple_torrent) {
                    new_file = new File(new File(move_to_dir, sub_path), new_name);
                } else {
                    String new_path;
                    int pos = sub_path.indexOf(File.separator);
                    if (pos == -1) {
                        new_path = new_name;
                    } else {
                        String sub_sub_path = sub_path.substring(pos);
                        String expected_old_name = sub_path.substring(0, pos);
                        new_path = new_name + sub_sub_path;
                        boolean assert_expected_old_name = expected_old_name.equals(save_location.getName());
                        if (!assert_expected_old_name) {
                            Debug.out("Assertion check for renaming file in multi-name torrent " + (assert_expected_old_name ? "passed" : "failed") + "\n" + "  Old parent path: " + old_parent_path + "\n" + "  Subpath: " + sub_path + "\n" + "  Sub-subpath: " + sub_sub_path + "\n" + "  Expected old name: " + expected_old_name + "\n" + "  Torrent pre-move name: " + save_location.getName() + "\n" + "  New torrent name: " + new_name + "\n" + "  Old file: " + old_file + "\n" + "  Linked file: " + linked_file + "\n" + "\n" + "  Move-to-dir: " + move_to_dir + "\n" + "  New path: " + new_path + "\n" + "  Old file [name]: " + old_file.getName() + "\n");
                        }
                    }
                    new_file = new File(new File(move_to_dir, new_path), old_file.getName());
                }
                new_files[i] = new_file;
                if (link_only[i]) continue;
                file_lengths_to_move[i] = old_file.length();
                total_bytes += file_lengths_to_move[i];
                if (new_file.exists()) {
                    String msg = "" + linked_file.getName() + " already exists in MoveTo destination dir";
                    Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
                    Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefileexists"), new String[]{old_file.getName()});
                    Debug.out(msg);
                    boolean new_path = false;
                    Object var45_38 = null;
                    boolean[] blArray = got_there;
                    synchronized (got_there) {
                        got_there[0] = true;
                        // ** MonitorExit[var46_42] (shouldn't be in output)
                        return new_path;
                    }
                }
                FileUtil.mkdirs(new_file.getParentFile());
            }
            String abs_path = move_to_dir_name.getAbsolutePath();
            String _average_config_key = null;
            try {
                _average_config_key = "dm.move.target.abps." + Base32.encode(abs_path.getBytes("UTF-8"));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            final String average_config_key = _average_config_key;
            if (total_bytes == 0L) {
                total_bytes = 1L;
            }
            long done_bytes = 0L;
            final Object progress_lock = new Object();
            final int[] current_file_index = new int[]{0};
            final long[] current_file_bs = new long[]{0L};
            final long f_total_bytes = total_bytes;
            final long[] last_progress_bytes = new long[]{0L};
            final long[] last_progress_update = new long[]{SystemTime.getMonotonousTime()};
            TimerEventPeriodic timer_event1 = SimpleTimer.addPeriodicEvent("MoveFile:speedster", 1000L, new TimerEventPerformer(){
                private long start_time = SystemTime.getMonotonousTime();
                private long last_update_processed;
                private long estimated_speed = 0x100000L;
                {
                    long val;
                    if (average_config_key != null && (val = COConfigurationManager.getLongParameter(average_config_key, 0L)) > 0L) {
                        this.estimated_speed = val;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform(TimerEvent event2) {
                    Object object = progress_lock;
                    synchronized (object) {
                        long secs_since_last_update;
                        int file_index = current_file_index[0];
                        if (file_index >= new_files.length) {
                            return;
                        }
                        long now = SystemTime.getMonotonousTime();
                        long last_update = last_progress_update[0];
                        long bytes_moved = last_progress_bytes[0];
                        if (last_update != this.last_update_processed) {
                            this.last_update_processed = last_update;
                            if (bytes_moved > 0xA00000L) {
                                long elapsed = now - this.start_time;
                                this.estimated_speed = bytes_moved * 1000L / elapsed;
                            }
                        }
                        if ((secs_since_last_update = (now - last_update) / 1000L) > 2L) {
                            long file_start_overall = current_file_bs[0];
                            long file_end_overall = file_start_overall + file_lengths_to_move[file_index];
                            long bytes_of_file_remaining = file_end_overall - bytes_moved;
                            long pretend_bytes = 0L;
                            long current_speed = this.estimated_speed;
                            long current_remaining = bytes_of_file_remaining;
                            long current_added = 0L;
                            int percentage_to_slow_at = 80;
                            int i = 0;
                            while ((long)i < secs_since_last_update) {
                                pretend_bytes += current_speed;
                                if ((current_added += current_speed) > (long)percentage_to_slow_at * current_remaining / 100L) {
                                    percentage_to_slow_at = 50;
                                    current_remaining = bytes_of_file_remaining - pretend_bytes;
                                    current_added = 0L;
                                    if ((current_speed /= 2L) < 1024L) {
                                        current_speed = 1024L;
                                    }
                                }
                                if (pretend_bytes >= bytes_of_file_remaining) {
                                    pretend_bytes = bytes_of_file_remaining;
                                    break;
                                }
                                ++i;
                            }
                            long pretend_bytes_moved = bytes_moved + pretend_bytes;
                            DiskManagerImpl.this.move_progress = (int)(1000L * pretend_bytes_moved / f_total_bytes);
                        }
                    }
                }
            });
            TimerEventPeriodic timer_event2 = SimpleTimer.addPeriodicEvent("MoveFile:observer", 500L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform(TimerEvent event2) {
                    File file;
                    int index;
                    Object object = progress_lock;
                    synchronized (object) {
                        index = current_file_index[0];
                        if (index >= new_files.length) {
                            return;
                        }
                        file = new_files[index];
                    }
                    long file_length = file.length();
                    Object object2 = progress_lock;
                    synchronized (object2) {
                        if (index == current_file_index[0]) {
                            long done_bytes = current_file_bs[0] + file_length;
                            DiskManagerImpl.this.move_progress = (int)(1000L * done_bytes / f_total_bytes);
                            last_progress_bytes[0] = done_bytes;
                            last_progress_update[0] = SystemTime.getMonotonousTime();
                        }
                    }
                }
            });
            long start = SystemTime.getMonotonousTime();
            if (simple_torrent) {
                old_root_dir = move_from_dir;
                new_root_dir = move_to_dir;
            } else {
                old_root_dir = move_from_dir + File.separator + move_from_name;
                new_root_dir = move_to_dir + File.separator + (new_name == null ? move_from_name : new_name);
            }
            try {
                for (int i = 0; i < this.files.length; ++i) {
                    File new_file = new_files[i];
                    try {
                        long initial_done_bytes = done_bytes;
                        this.files[i].moveFile(new_root_dir, new_file, link_only[i]);
                        Object object = progress_lock;
                        synchronized (object) {
                            current_file_index[0] = i + 1;
                            current_file_bs[0] = done_bytes = initial_done_bytes + file_lengths_to_move[i];
                            this.move_progress = (int)(1000L * done_bytes / total_bytes);
                            last_progress_bytes[0] = done_bytes;
                            last_progress_update[0] = SystemTime.getMonotonousTime();
                            if (!change_to_read_only) continue;
                        }
                        this.files[i].setAccessMode(1);
                        continue;
                    }
                    catch (CacheFileManagerException e) {
                        String msg = "Failed to move " + old_files[i].toString() + " to destination " + new_root_dir + ": " + new_file + "/" + link_only[i];
                        Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
                        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{old_files[i].toString(), Debug.getNestedExceptionMessage(e)});
                        int j = 0;
                        while (true) {
                            if (j >= i) {
                                boolean bl2 = false;
                                Object var43_62 = null;
                                timer_event1.cancel();
                                timer_event2.cancel();
                                Object var45_39 = null;
                                boolean[] blArray = got_there;
                                synchronized (got_there) {
                                    got_there[0] = true;
                                    // ** MonitorExit[var46_43] (shouldn't be in output)
                                    return bl2;
                                }
                            }
                            try {
                                this.files[j].moveFile(old_root_dir, old_files[j], link_only[j]);
                            }
                            catch (CacheFileManagerException f) {
                                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilerecoveryfails"), new String[]{old_files[j].toString(), Debug.getNestedExceptionMessage(f)});
                            }
                            ++j;
                        }
                    }
                }
                Object var43_63 = null;
                timer_event1.cancel();
                timer_event2.cancel();
            }
            catch (Throwable throwable) {
                Object var43_64 = null;
                timer_event1.cancel();
                timer_event2.cancel();
                throw throwable;
            }
            long elapsed_secs = (SystemTime.getMonotonousTime() - start) / 1000L;
            if (total_bytes > 0xA00000L && elapsed_secs > 10L) {
                long bps = total_bytes / elapsed_secs;
                if (average_config_key != null) {
                    COConfigurationManager.setParameter(average_config_key, bps);
                }
            }
            if (save_location.isDirectory()) {
                TorrentUtils.recursiveEmptyDirDelete(save_location, false);
            }
            if (new_name == null) {
                this.download_manager.setTorrentSaveDir(move_to_dir);
            } else {
                this.download_manager.setTorrentSaveDir(move_to_dir, new_name);
            }
            bl = true;
            Object var45_40 = null;
            boolean[] blArray = got_there;
        }
        catch (Throwable throwable) {
            Object var45_41 = null;
            boolean[] blArray = got_there;
            synchronized (got_there) {
                got_there[0] = true;
                // ** MonitorExit[var46_45] (shouldn't be in output)
                throw throwable;
            }
        }
        synchronized (got_there) {
            got_there[0] = true;
            // ** MonitorExit[var46_44] (shouldn't be in output)
            return bl;
        }
    }

    private void moveTorrentFile(SaveLocationChange loc_change) {
        if (!loc_change.hasTorrentChange()) {
            return;
        }
        File old_torrent_file = new File(this.download_manager.getTorrentFileName());
        File new_torrent_file = loc_change.normaliseTorrentLocation(old_torrent_file);
        if (!old_torrent_file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 1, "Torrent file '" + old_torrent_file.getPath() + "' has been deleted, move operation ignored"));
            }
            return;
        }
        try {
            this.download_manager.setTorrentFile(loc_change.torrent_location, loc_change.torrent_name);
        }
        catch (DownloadManagerException e) {
            String msg = "Failed to move " + old_torrent_file.toString() + " to " + new_torrent_file.toString();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
            }
            Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{old_torrent_file.toString(), new_torrent_file.toString()});
            Debug.out(msg);
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void addListener(DiskManagerListener l) {
        this.listeners.addListener(l);
        int[] params = new int[]{this.getState(), this.getState()};
        this.listeners.dispatch(l, 1, params);
    }

    public void removeListener(DiskManagerListener l) {
        this.listeners.removeListener(l);
    }

    public boolean hasListener(DiskManagerListener l) {
        return this.listeners.hasListener(l);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file, boolean force_no_recycle) {
        block8: {
            if (torrent == null || torrent_save_file == null) {
                return;
            }
            try {
                if (torrent.isSimpleTorrent()) {
                    File target = new File(torrent_save_dir, torrent_save_file);
                    target = FMFileManagerFactory.getSingleton().getFileLink(torrent, 0, target.getCanonicalFile());
                    FileUtil.deleteWithRecycle(target, force_no_recycle);
                    break block8;
                }
                PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
                if (Constants.isOSX && torrent_save_file.length() > 0 && COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && !force_no_recycle && mgr.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    try {
                        String dir = torrent_save_dir + File.separatorChar + torrent_save_file + File.separatorChar;
                        int numDataFiles = DiskManagerImpl.countDataFiles(torrent, torrent_save_dir, torrent_save_file);
                        if (DiskManagerImpl.countFiles(new File(dir), numDataFiles) == numDataFiles) {
                            mgr.performRecoverableFileDelete(dir);
                            break block8;
                        }
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file, force_no_recycle);
                    }
                    catch (PlatformManagerException ex) {
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file, force_no_recycle);
                    }
                    break block8;
                }
                DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file, force_no_recycle);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private static int countFiles(File f, int stopAfterCount) {
        if (f.isFile()) {
            return 1;
        }
        int res = 0;
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length && (res += DiskManagerImpl.countFiles(files[i], stopAfterCount)) <= stopAfterCount; ++i) {
            }
        }
        return res;
    }

    private static int countDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        try {
            int res = 0;
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] files = torrent.getFiles();
            for (int i = 0; i < files.length; ++i) {
                byte[][] path_comps = files[i].getPathComponents();
                String path_str = torrent_save_dir + File.separator + torrent_save_file + File.separator;
                for (int j = 0; j < path_comps.length; ++j) {
                    String comp2 = locale_decoder.decodeString(path_comps[j]);
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp2;
                }
                File file = new File(path_str).getCanonicalFile();
                File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, i, file);
                boolean skip = false;
                if (linked_file != file && !linked_file.getCanonicalPath().startsWith(new File(torrent_save_dir).getCanonicalPath())) {
                    skip = true;
                }
                if (skip || !file.exists() || file.isDirectory()) continue;
                ++res;
            }
            return res;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return -1;
        }
    }

    private static void deleteDataFileContents(TOTorrent torrent, String torrent_save_dir, String torrent_save_file, boolean force_no_recycle) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
        TOTorrentFile[] files = torrent.getFiles();
        String root_path = torrent_save_dir + File.separator + torrent_save_file + File.separator;
        boolean delete_if_not_in_dir = COConfigurationManager.getBooleanParameter("File.delete.include_files_outside_save_dir");
        for (int i = 0; i < files.length; ++i) {
            boolean delete;
            byte[][] path_comps = files[i].getPathComponents();
            String path_str = root_path;
            for (int j = 0; j < path_comps.length; ++j) {
                try {
                    String comp2 = locale_decoder.decodeString(path_comps[j]);
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp2;
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    Debug.out("file - unsupported encoding!!!!");
                }
            }
            File file = new File(path_str);
            File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, i, file);
            if (linked_file == file) {
                delete = true;
            } else {
                try {
                    if (delete_if_not_in_dir || linked_file.getCanonicalPath().startsWith(new File(root_path).getCanonicalPath())) {
                        file = linked_file;
                        delete = true;
                    } else {
                        delete = false;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    delete = false;
                }
            }
            if (!delete || !file.exists() || file.isDirectory()) continue;
            try {
                FileUtil.deleteWithRecycle(file, force_no_recycle);
                continue;
            }
            catch (Exception e) {
                Debug.out(e.toString());
            }
        }
        TorrentUtils.recursiveEmptyDirDelete(new File(torrent_save_dir, torrent_save_file));
    }

    public void skippedFileSetChanged(DiskManagerFileInfo file) {
        this.skipped_file_set_changed = true;
        this.listeners.dispatch(2, file);
    }

    public void priorityChanged(DiskManagerFileInfo file) {
        this.listeners.dispatch(2, file);
    }

    private void loadFilePriorities() {
        DiskManagerUtil.loadFilePriorities(this.download_manager, this.fileset);
    }

    protected void storeFilePriorities() {
        DiskManagerImpl.storeFilePriorities(this.download_manager, this.files);
    }

    protected static void storeFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        DiskManagerUtil.storeFilePriorities(download_manager, files);
    }

    protected static void storeFileDownloaded(DownloadManager download_manager, DiskManagerFileInfo[] files, boolean persist) {
        DownloadManagerState state = download_manager.getDownloadState();
        HashMap details = new HashMap();
        ArrayList<Long> downloaded = new ArrayList<Long>();
        details.put("downloaded", downloaded);
        for (int i = 0; i < files.length; ++i) {
            downloaded.add(new Long(files[i].getDownloaded()));
        }
        state.setMapAttribute("filedownloaded", details);
        if (persist) {
            state.save();
        }
    }

    public void saveState() {
        this.saveState(true);
    }

    protected void saveState(boolean persist) {
        if (this.files != null) {
            DiskManagerImpl.storeFileDownloaded(this.download_manager, this.files, persist);
            this.storeFilePriorities();
        }
        this.checkFreePieceList(false);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    public String getInternalName() {
        return this.download_manager.getInternalName();
    }

    public DownloadManagerState getDownloadState() {
        return this.download_manager.getDownloadState();
    }

    public File getSaveLocation() {
        return this.download_manager.getSaveLocation();
    }

    public String[] getStorageTypes() {
        return DiskManagerImpl.getStorageTypes(this.download_manager);
    }

    public String getStorageType(int fileIndex) {
        return DiskManagerImpl.getStorageType(this.download_manager, fileIndex);
    }

    public static String[] getStorageTypes(DownloadManager download_manager) {
        DownloadManagerState state = download_manager.getDownloadState();
        String[] types = state.getListAttribute("storetypes");
        if (types == null || types.length == 0) {
            TOTorrentFile[] files = download_manager.getTorrent().getFiles();
            types = new String[download_manager.getTorrent().getFiles().length];
            if (reorder_storage_mode) {
                int existing = state.getIntAttribute("reordermb");
                if (existing < 0) {
                    existing = reorder_storage_mode_min_mb;
                    state.setIntAttribute("reordermb", existing);
                }
                for (int i = 0; i < types.length; ++i) {
                    types[i] = files[i].getLength() / 0x100000L >= (long)existing ? "R" : "L";
                }
            } else {
                for (int i = 0; i < types.length; ++i) {
                    types[i] = "L";
                }
            }
            state.setListAttribute("storetypes", types);
        }
        return types;
    }

    public static String getStorageType(DownloadManager download_manager, int fileIndex) {
        DownloadManagerState state = download_manager.getDownloadState();
        String type = state.getListAttribute("storetypes", fileIndex);
        if (type != null) {
            return type;
        }
        return DiskManagerImpl.getStorageTypes(download_manager)[fileIndex];
    }

    public static void setFileLinks(DownloadManager download_manager, LinkFileMap links) {
        try {
            CacheFileManagerFactory.getSingleton().setFileLinks(download_manager.getTorrent(), links);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public String getRelationText() {
        return "TorrentDM: '" + this.download_manager.getDisplayName() + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager, this.torrent};
    }

    public DiskManagerRecheckScheduler getRecheckScheduler() {
        return recheck_scheduler;
    }

    public boolean isInteresting(int pieceNumber) {
        return this.pieces[pieceNumber].isInteresting();
    }

    public boolean isDone(int pieceNumber) {
        return this.pieces[pieceNumber].isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println("Disk Manager");
        try {
            writer.indent();
            writer.println("percent_done=" + this.percentDone + ",allocated=" + this.allocated + ",remaining=" + this.remaining);
            writer.println("skipped_file_set_size=" + this.skipped_file_set_size + ",skipped_but_downloaded=" + this.skipped_but_downloaded);
            writer.println("already_moved=" + this.alreadyMoved);
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }

    static {
        int max_read_threads = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxthreads");
        int max_read_mb = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxmb");
        int max_write_threads = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxthreads");
        int max_write_mb = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxmb");
        disk_access_controller = DiskAccessControllerFactory.create("core", max_read_threads, max_read_mb, max_write_threads, max_write_mb);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Disk access controller params: " + max_read_threads + "/" + max_read_mb + "/" + max_write_threads + "/" + max_write_mb));
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable reorder storage mode", "Reorder storage mode min MB"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                reorder_storage_mode = COConfigurationManager.getBooleanParameter("Enable reorder storage mode");
                reorder_storage_mode_min_mb = COConfigurationManager.getIntParameter("Reorder storage mode min MB");
            }
        });
        recheck_scheduler = new DiskManagerRecheckScheduler();
        allocation_scheduler = new DiskManagerAllocationScheduler();
        start_pool = new ThreadPool("DiskManager:start", 64, true);
        start_pool.setThreadPriority(1);
        listeners_aggregator = ListenerManager.createAsyncManager("DiskM:ListenAggregatorDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

            @Override
            public void dispatch(DiskManagerListener listener, int type, Object value) {
                if (type == 1) {
                    int[] params = (int[])value;
                    listener.stateChanged(params[0], params[1]);
                } else if (type == 2) {
                    listener.filePriorityChanged((DiskManagerFileInfo)value);
                } else if (type == 3) {
                    listener.pieceDoneChanged((DiskManagerPiece)value);
                } else if (type == 4) {
                    Object[] o = (Object[])value;
                    listener.fileAccessModeChanged((DiskManagerFileInfo)o[0], (Integer)o[1], (Integer)o[2]);
                }
            }
        });
    }
}

