/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.util.HashCodeUtils;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.LightHashSet;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class StringInterner {
    public static boolean DISABLE_INTERNING = false;
    private static final int SCHEDULED_CLEANUP_INTERVAL = 60000;
    private static final boolean TRACE_CLEANUP = false;
    private static final boolean TRACE_MULTIHITS = false;
    private static final int IMMEDIATE_CLEANUP_TRIGGER = 2000;
    private static final int IMMEDIATE_CLEANUP_GOAL = 1500;
    private static final int SCHEDULED_CLEANUP_TRIGGER = 1500;
    private static final int SCHEDULED_CLEANUP_GOAL = 1000;
    private static final int SCHEDULED_AGING_THRESHOLD = 750;
    private static LightHashSet managedInterningSet = new LightHashSet(800);
    private static LightHashSet unmanagedInterningSet = new LightHashSet();
    private static ReadWriteLock managedSetLock = new ReentrantReadWriteLock();
    private static final ReferenceQueue managedRefQueue = new ReferenceQueue();
    private static final ReferenceQueue unmanagedRefQueue = new ReferenceQueue();
    private static final String[] COMMON_KEYS = new String[]{"src", "port", "prot", "ip", "udpport", "azver", "httpport", "downloaded", "Content", "Refresh On", "path.utf-8", "uploaded", "completed", "persistent", "attributes", "encoding", "azureus_properties", "stats.download.added.time", "networks", "p1", "resume data", "dndflags", "blocks", "resume", "primaryfile", "resumecomplete", "data", "peersources", "name.utf-8", "valid", "torrent filename", "parameters", "secrets", "timesincedl", "tracker_cache", "filedownloaded", "timesinceul", "tracker_peers", "trackerclientextensions", "GlobalRating", "comment.utf-8", "Count", "String", "stats.counted", "Thumbnail", "Plugin.<internal>.DDBaseTTTorrent::sha1", "type", "Title", "displayname", "Publisher", "Creation Date", "Revision Date", "Content Hash", "flags", "stats.download.completed.time", "Description", "Progressive", "Content Type", "QOS Class", "DRM", "hash", "ver", "id", "body", "seed", "eip", "rid", "iip", "dp2", "tp", "orig", "dp", "Quality", "private", "dht_backup_enable", "max.uploads", "filelinks", "Speed Bps", "cdn_properties", "sha1", "ed2k", "DRM Key", "Plugin.aeseedingengine.attributes", "initial_seed", "dht_backup_requested", "ta", "size", "DIRECTOR PUBLISH", "Plugin.azdirector.ContentMap", "dateadded", "bytesin", "announces", "status", "bytesout", "scrapes", "passive"};
    private static final ByteArrayHashMap byte_map = new ByteArrayHashMap(COMMON_KEYS.length);
    private static final Comparator savingsComp;

    public static String intern(byte[] bytes) {
        String res = (String)byte_map.get(bytes);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object internObject(Object toIntern) {
        Object internedItem;
        if (DISABLE_INTERNING) {
            return toIntern;
        }
        if (toIntern == null) {
            return null;
        }
        WeakEntry checkEntry = new WeakEntry(toIntern, unmanagedRefQueue);
        LightHashSet lightHashSet = unmanagedInterningSet;
        synchronized (lightHashSet) {
            WeakEntry internedEntry = (WeakEntry)unmanagedInterningSet.get(checkEntry);
            if (internedEntry == null || (internedItem = internedEntry.get()) == null) {
                internedItem = toIntern;
                if (!unmanagedInterningSet.add(checkEntry)) {
                    System.out.println("unexpected modification");
                }
            }
            StringInterner.sanitizeLight();
        }
        if (!toIntern.equals(internedItem)) {
            System.err.println("mismatch");
        }
        return internedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String intern(String toIntern) {
        String internedString;
        if (DISABLE_INTERNING) {
            return toIntern;
        }
        if (toIntern == null) {
            return null;
        }
        WeakStringEntry checkEntry = new WeakStringEntry(toIntern);
        WeakStringEntry internedEntry = null;
        boolean hit = false;
        managedSetLock.readLock().lock();
        try {
            internedEntry = (WeakStringEntry)managedInterningSet.get(checkEntry);
            if (internedEntry != null && (internedString = internedEntry.getString()) != null) {
                hit = true;
            } else {
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    internedEntry = (WeakStringEntry)managedInterningSet.get(checkEntry);
                    if (internedEntry != null && (internedString = internedEntry.getString()) != null) {
                        hit = true;
                    } else {
                        toIntern = new String(toIntern);
                        checkEntry = new WeakStringEntry(toIntern);
                        managedInterningSet.add(checkEntry);
                        internedString = toIntern;
                    }
                    Object var6_5 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                    throw throwable;
                }
            }
            Object var8_8 = null;
            managedSetLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            managedSetLock.readLock().unlock();
            throw throwable;
        }
        if (hit) {
            internedEntry.incHits();
            checkEntry.destroy();
        }
        return internedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] intern(char[] toIntern) {
        char[] internedCharArray;
        if (DISABLE_INTERNING) {
            return toIntern;
        }
        if (toIntern == null) {
            return null;
        }
        WeakCharArrayEntry checkEntry = new WeakCharArrayEntry(toIntern);
        WeakCharArrayEntry internedEntry = null;
        boolean hit = false;
        managedSetLock.readLock().lock();
        try {
            internedEntry = (WeakCharArrayEntry)managedInterningSet.get(checkEntry);
            if (internedEntry != null && (internedCharArray = internedEntry.getCharArray()) != null) {
                hit = true;
            } else {
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    internedEntry = (WeakCharArrayEntry)managedInterningSet.get(checkEntry);
                    if (internedEntry != null && (internedCharArray = internedEntry.getCharArray()) != null) {
                        hit = true;
                    } else {
                        managedInterningSet.add(checkEntry);
                        internedCharArray = toIntern;
                    }
                    Object var6_5 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                    throw throwable;
                }
            }
            Object var8_8 = null;
            managedSetLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            managedSetLock.readLock().unlock();
            throw throwable;
        }
        if (hit) {
            System.out.println("hit for " + new String(toIntern));
            internedEntry.incHits();
            checkEntry.destroy();
        }
        return internedCharArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] internBytes(byte[] toIntern) {
        byte[] internedArray;
        if (DISABLE_INTERNING) {
            return toIntern;
        }
        if (toIntern == null) {
            return null;
        }
        WeakByteArrayEntry checkEntry = new WeakByteArrayEntry(toIntern);
        WeakByteArrayEntry internedEntry = null;
        boolean hit = false;
        managedSetLock.readLock().lock();
        try {
            internedEntry = (WeakByteArrayEntry)managedInterningSet.get(checkEntry);
            if (internedEntry != null && (internedArray = internedEntry.getArray()) != null) {
                hit = true;
            } else {
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    internedEntry = (WeakByteArrayEntry)managedInterningSet.get(checkEntry);
                    if (internedEntry != null && (internedArray = internedEntry.getArray()) != null) {
                        hit = true;
                    } else {
                        managedInterningSet.add(checkEntry);
                        internedArray = toIntern;
                    }
                    Object var6_5 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                    throw throwable;
                }
            }
            Object var8_8 = null;
            managedSetLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            managedSetLock.readLock().unlock();
            throw throwable;
        }
        if (hit) {
            internedEntry.incHits();
            checkEntry.destroy();
        }
        if (!Arrays.equals(toIntern, internedArray)) {
            System.err.println("mismatch");
        }
        return internedArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File internFile(File toIntern) {
        File internedFile;
        if (DISABLE_INTERNING) {
            return toIntern;
        }
        if (toIntern == null) {
            return null;
        }
        WeakFileEntry checkEntry = new WeakFileEntry(toIntern);
        WeakFileEntry internedEntry = null;
        boolean hit = false;
        managedSetLock.readLock().lock();
        try {
            internedEntry = (WeakFileEntry)managedInterningSet.get(checkEntry);
            if (internedEntry != null && (internedFile = internedEntry.getFile()) != null) {
                hit = true;
            } else {
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    internedEntry = (WeakFileEntry)managedInterningSet.get(checkEntry);
                    if (internedEntry != null && (internedFile = internedEntry.getFile()) != null) {
                        hit = true;
                    } else {
                        managedInterningSet.add(checkEntry);
                        internedFile = toIntern;
                    }
                    Object var6_5 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                    throw throwable;
                }
            }
            Object var8_8 = null;
            managedSetLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            managedSetLock.readLock().unlock();
            throw throwable;
        }
        if (hit) {
            internedEntry.incHits();
            checkEntry.destroy();
        }
        if (!toIntern.equals(internedFile)) {
            System.err.println("mismatch");
        }
        return internedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL internURL(URL toIntern) {
        URL internedURL;
        if (DISABLE_INTERNING) {
            return toIntern;
        }
        if (toIntern == null) {
            return null;
        }
        WeakURLEntry checkEntry = new WeakURLEntry(toIntern);
        WeakURLEntry internedEntry = null;
        boolean hit = false;
        managedSetLock.readLock().lock();
        try {
            internedEntry = (WeakURLEntry)managedInterningSet.get(checkEntry);
            if (internedEntry != null && (internedURL = internedEntry.getURL()) != null) {
                hit = true;
            } else {
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    internedEntry = (WeakURLEntry)managedInterningSet.get(checkEntry);
                    if (internedEntry != null && (internedURL = internedEntry.getURL()) != null) {
                        hit = true;
                    } else {
                        managedInterningSet.add(checkEntry);
                        internedURL = toIntern;
                    }
                    Object var6_5 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                    throw throwable;
                }
            }
            Object var8_8 = null;
            managedSetLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            managedSetLock.readLock().unlock();
            throw throwable;
        }
        if (hit) {
            internedEntry.incHits();
            checkEntry.destroy();
        }
        if (!toIntern.toExternalForm().equals(internedURL.toExternalForm())) {
            System.err.println("mismatch");
        }
        return internedURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sanitizeLight() {
        LightHashSet lightHashSet = unmanagedInterningSet;
        synchronized (lightHashSet) {
            WeakEntry ref;
            while ((ref = (WeakEntry)unmanagedRefQueue.poll()) != null) {
                unmanagedInterningSet.remove(ref);
            }
            unmanagedInterningSet.compactify(-1.0f);
        }
    }

    private static void sanitize(boolean scheduled) {
        block14: {
            WeakWeightedEntry ref;
            while ((ref = (WeakWeightedEntry)managedRefQueue.poll()) != null) {
                if (!ref.isDestroyed()) {
                    managedInterningSet.remove(ref);
                    continue;
                }
                System.err.println("double removal " + ref);
            }
            int currentSetSize = managedInterningSet.size();
            if (currentSetSize >= 2000 || scheduled) {
                WeakWeightedEntry entry;
                ArrayList<WeakWeightedEntry> remaining = new ArrayList<WeakWeightedEntry>();
                Iterator it = managedInterningSet.iterator();
                while (it.hasNext()) {
                    if (managedInterningSet.size() >= 1500 || scheduled) {
                        entry = (WeakWeightedEntry)it.next();
                        if (entry.hits == 0) {
                            it.remove();
                            continue;
                        }
                        remaining.add(entry);
                        continue;
                    }
                    break block14;
                }
                currentSetSize = managedInterningSet.size();
                if (currentSetSize >= 1500 || !scheduled) {
                    if (currentSetSize >= 1500 || scheduled) {
                        Collections.sort(remaining, savingsComp);
                        for (int i = 0; !(i >= remaining.size() || (currentSetSize = managedInterningSet.size()) < 1000 && scheduled); ++i) {
                            if (currentSetSize >= 1500 || scheduled) {
                                entry = (WeakWeightedEntry)remaining.get(i);
                                managedInterningSet.remove(entry);
                                continue;
                            }
                            break;
                        }
                    }
                } else if (!((currentSetSize = managedInterningSet.size()) < 750 && scheduled || currentSetSize < 1500 && !scheduled)) {
                    Iterator it2 = managedInterningSet.iterator();
                    while (it2.hasNext()) {
                        ((WeakWeightedEntry)it2.next()).decHits();
                    }
                }
            }
        }
        if (scheduled) {
            managedInterningSet.compactify(-1.0f);
        }
    }

    static {
        try {
            for (int i = 0; i < COMMON_KEYS.length; ++i) {
                byte_map.put(COMMON_KEYS[i].getBytes("ISO-8859-1"), COMMON_KEYS[i]);
                managedInterningSet.add(new WeakStringEntry(COMMON_KEYS[i]));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        new AEThread2("asyncify", true){

            public void run() {
                SimpleTimer.addPeriodicEvent("StringInterner:cleaner", 60000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        managedSetLock.writeLock().lock();
                        try {
                            StringInterner.sanitize(true);
                            Object var3_2 = null;
                            managedSetLock.writeLock().unlock();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            managedSetLock.writeLock().unlock();
                            throw throwable;
                        }
                        StringInterner.sanitizeLight();
                    }
                });
            }
        }.start();
        savingsComp = new Comparator(){

            public int compare(Object o1, Object o2) {
                WeakWeightedEntry w1 = (WeakWeightedEntry)o1;
                WeakWeightedEntry w2 = (WeakWeightedEntry)o2;
                return w1.hits * w1.size - w2.hits * w2.size;
            }
        };
    }

    private static class WeakByteArrayEntry
    extends WeakWeightedEntry {
        public WeakByteArrayEntry(byte[] array) {
            super((Object)array, HashCodeUtils.hashCode(array), array.length + 8);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WeakByteArrayEntry) {
                byte[] myArray = this.getArray();
                byte[] otherArray = ((WeakByteArrayEntry)obj).getArray();
                return myArray == null ? false : Arrays.equals(myArray, otherArray);
            }
            return false;
        }

        public byte[] getArray() {
            return (byte[])this.get();
        }

        public String toString() {
            return super.toString() + " " + (this.getArray() == null ? "null" : new String(this.getArray()));
        }
    }

    private static class WeakCharArrayEntry
    extends WeakWeightedEntry {
        public WeakCharArrayEntry(char[] array) {
            super((Object)array, HashCodeUtils.hashCode(array), array.length + 8);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WeakCharArrayEntry) {
                char[] myArray = this.getCharArray();
                char[] otherArray = ((WeakCharArrayEntry)obj).getCharArray();
                return myArray == null ? false : Arrays.equals(myArray, otherArray);
            }
            return false;
        }

        public char[] getCharArray() {
            return (char[])this.get();
        }

        public String toString() {
            return super.toString() + " " + (this.getCharArray() == null ? "null" : new String(this.getCharArray()));
        }
    }

    private static class WeakEntry
    extends WeakReference {
        private final int hash;

        protected WeakEntry(Object o, ReferenceQueue q, int hash) {
            super(o, q);
            this.hash = hash;
        }

        public WeakEntry(Object o, ReferenceQueue q) {
            super(o, q);
            this.hash = o.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WeakEntry) {
                Object myObj = this.get();
                Object otherObj = ((WeakEntry)obj).get();
                return myObj == null ? false : myObj.equals(otherObj);
            }
            return false;
        }

        public final int hashCode() {
            return this.hash;
        }
    }

    private static class WeakFileEntry
    extends WeakWeightedEntry {
        public WeakFileEntry(File entry) {
            super((Object)entry, entry.hashCode(), 40 + entry.getPath().length() * 2);
        }

        public File getFile() {
            return (File)this.get();
        }

        public String toString() {
            return super.toString() + " " + this.getFile();
        }
    }

    private static class WeakStringEntry
    extends WeakWeightedEntry {
        public WeakStringEntry(String entry) {
            super((Object)entry, entry.hashCode(), 24 + entry.length() * 2);
        }

        public String getString() {
            return (String)this.get();
        }

        public String toString() {
            return super.toString() + " " + this.getString();
        }
    }

    private static class WeakURLEntry
    extends WeakWeightedEntry {
        public WeakURLEntry(URL entry) {
            super((Object)entry, entry.toExternalForm().hashCode(), 176 + entry.toString().length() * 2);
        }

        public URL getURL() {
            return (URL)this.get();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WeakURLEntry) {
                URL other;
                URL my = this.getURL();
                if (my == (other = ((WeakURLEntry)obj).getURL())) {
                    return true;
                }
                if (my == null || other == null) {
                    return false;
                }
                return my.toExternalForm().equals(other.toExternalForm());
            }
            return false;
        }

        public String toString() {
            return super.toString() + " " + this.getURL();
        }
    }

    private static abstract class WeakWeightedEntry
    extends WeakEntry {
        final short size;
        short hits;

        public WeakWeightedEntry(Object o, int hash, int size) {
            super(o, managedRefQueue, hash);
            this.size = (short)(size & Short.MAX_VALUE);
        }

        public void incHits() {
            if (this.hits < Short.MAX_VALUE) {
                this.hits = (short)(this.hits + 1);
            }
        }

        public void decHits() {
            if (this.hits > 0) {
                this.hits = (short)(this.hits - 1);
            }
        }

        public String toString() {
            return this.getClass().getName().replaceAll("^.*\\..\\w+$", "") + " h=" + this.hits + ";s=" + this.size;
        }

        public void destroy() {
            this.hits = (short)-1;
        }

        public boolean isDestroyed() {
            return this.hits == -1;
        }
    }
}

