/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.ui.common.util.MenuItemManagerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItemManager {
    private static MenuItemManager instance;
    private static AEMonitor class_mon;
    private Map<String, Map<String, MenuItem>> items;
    private AEMonitor items_mon = new AEMonitor("MenuManager:items");
    private ArrayList<MenuItemManagerListener> listeners = new ArrayList(0);

    private MenuItemManager() {
        this.items = new HashMap<String, Map<String, MenuItem>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MenuItemManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new MenuItemManager();
            }
            MenuItemManager menuItemManager = instance;
            Object var2_1 = null;
            class_mon.exit();
            return menuItemManager;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMenuItem(MenuItem item) {
        try {
            String name = item.getResourceKey();
            String sMenuID = item.getMenuID();
            try {
                this.items_mon.enter();
                Map<String, MenuItem> mTypes = this.items.get(sMenuID);
                if (mTypes == null) {
                    mTypes = new LinkedHashMap<String, MenuItem>();
                    this.items.put(sMenuID, mTypes);
                }
                mTypes.put(name, item);
                Object var6_6 = null;
                this.items_mon.exit();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.items_mon.exit();
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Menu Item");
            Debug.printStackTrace(e);
        }
    }

    public void removeAllMenuItems(String sMenuID) {
        this.items.remove(sMenuID);
    }

    public void removeMenuItem(MenuItem item) {
        Map<String, MenuItem> menu_item_map = this.items.get(item.getMenuID());
        if (menu_item_map != null) {
            menu_item_map.remove(item.getResourceKey());
        }
    }

    public MenuItem[] getAllAsArray(String sMenuID) {
        if (sMenuID != null) {
            this.triggerMenuItemQuery(sMenuID);
        }
        Map<String, MenuItem> local_menu_item_map = this.items.get(sMenuID);
        Map<String, MenuItem> global_menu_item_map = this.items.get(null);
        if (local_menu_item_map == null && global_menu_item_map == null) {
            return new MenuItem[0];
        }
        if (sMenuID == null) {
            local_menu_item_map = null;
        }
        ArrayList<MenuItem> l = new ArrayList<MenuItem>();
        if (local_menu_item_map != null) {
            l.addAll(local_menu_item_map.values());
        }
        if (global_menu_item_map != null) {
            l.addAll(global_menu_item_map.values());
        }
        return l.toArray(new MenuItem[l.size()]);
    }

    public MenuItem[] getAllAsArray(String[] menu_ids) {
        ArrayList<MenuItem> l = new ArrayList<MenuItem>();
        for (int i = 0; i < menu_ids.length; ++i) {
            if (menu_ids[i] != null) {
                this.triggerMenuItemQuery(menu_ids[i]);
            }
            this.addMenuItems(menu_ids[i], l);
        }
        this.addMenuItems(null, l);
        return l.toArray(new MenuItem[l.size()]);
    }

    private void addMenuItems(String menu_id, ArrayList<MenuItem> l) {
        Map<String, MenuItem> menu_map = this.items.get(menu_id);
        if (menu_map != null) {
            l.addAll(menu_map.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MenuItemManagerListener l) {
        ArrayList<MenuItemManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MenuItemManagerListener l) {
        ArrayList<MenuItemManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerMenuItemQuery(String id) {
        MenuItemManagerListener[] listenersArray;
        ArrayList<MenuItemManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            listenersArray = this.listeners.toArray(new MenuItemManagerListener[0]);
        }
        for (MenuItemManagerListener l : listenersArray) {
            try {
                l.queryForMenuItem(id);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerMenuItemCleanup(String id) {
        MenuItemManagerListener[] listenersArray;
        ArrayList<MenuItemManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            listenersArray = this.listeners.toArray(new MenuItemManagerListener[0]);
        }
        for (MenuItemManagerListener l : listenersArray) {
            try {
                l.cleanupMenuItem(id);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    static {
        class_mon = new AEMonitor("MenuManager");
    }
}

