/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.BrowserWrapper;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class BrowserWrapperFake
extends BrowserWrapper {
    private Composite parent;
    private Composite browser;
    private Label link_label;
    private Label description_label;
    private String url;
    private String description;
    private List<LocationListener> location_listeners = new ArrayList<LocationListener>();
    private List<ProgressListener> progress_listeners = new ArrayList<ProgressListener>();
    private List<TitleListener> title_listeners = new ArrayList<TitleListener>();

    protected BrowserWrapperFake(Composite _parent, int style) {
        this.parent = _parent;
        this.browser = new Composite(this.parent, 0);
        this.browser.setBackground(Colors.white);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.browser.setLayout((Layout)layout);
        Label label = new Label(this.browser, 64);
        Messages.setLanguageText((Widget)label, "browser.internal.disabled.info");
        label.setLayoutData((Object)new GridData(768));
        label.setBackground(Colors.white);
        Composite details = new Composite(this.browser, 2048);
        layout = new GridLayout();
        layout.numColumns = 2;
        details.setLayout((Layout)layout);
        details.setLayoutData((Object)new GridData(1808));
        details.setBackground(Colors.white);
        label = new Label(details, 0);
        label.setText("URL");
        label.setLayoutData((Object)new GridData());
        label.setBackground(Colors.white);
        this.link_label = new Label(details, 0);
        this.link_label.setText(MessageText.getString("ConfigView.label.please.visit.here"));
        this.link_label.setCursor(this.link_label.getDisplay().getSystemCursor(21));
        this.link_label.setForeground(Colors.blue);
        this.link_label.setBackground(Colors.white);
        this.link_label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Utils.launch(BrowserWrapperFake.this.url);
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && e.stateMask != 262144) {
                    Utils.launch(BrowserWrapperFake.this.url);
                }
            }
        });
        GridData grid_data = new GridData(768);
        grid_data.horizontalIndent = 10;
        this.link_label.setLayoutData((Object)grid_data);
        ClipboardCopy.addCopyToClipMenu((Control)this.link_label, new ClipboardCopy.copyToClipProvider(){

            public String getText() {
                return BrowserWrapperFake.this.url;
            }
        });
        label = new Label(details, 0);
        Messages.setLanguageText((Widget)label, "columnChooser.columndescription");
        label.setLayoutData((Object)new GridData());
        label.setBackground(Colors.white);
        this.description_label = new Label(details, 0);
        this.description_label.setText("");
        grid_data = new GridData(768);
        grid_data.horizontalIndent = 10;
        this.description_label.setLayoutData((Object)grid_data);
        this.description_label.setBackground(Colors.white);
    }

    public boolean isFake() {
        return true;
    }

    public Composite getControl() {
        return this.browser;
    }

    public void setBrowser(WindowEvent event2) {
    }

    public void setVisible(boolean visible) {
        this.browser.setVisible(visible);
    }

    public boolean isVisible() {
        return this.browser.isVisible();
    }

    public boolean isDisposed() {
        return this.browser.isDisposed();
    }

    public void dispose() {
        this.browser.dispose();
    }

    public boolean execute(String str) {
        return false;
    }

    public boolean isBackEnabled() {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(final String _url) {
        this.url = _url;
        Utils.execSWTThread(new Runnable(){

            public void run() {
                LocationEvent event2;
                String url_str = _url;
                int pos = url_str.indexOf(63);
                if (pos != -1) {
                    url_str = url_str.substring(0, pos);
                }
                BrowserWrapperFake.this.link_label.setText(url_str);
                BrowserWrapperFake.this.browser.layout();
                for (LocationListener l : BrowserWrapperFake.this.location_listeners) {
                    try {
                        event2 = new LocationEvent((Widget)BrowserWrapperFake.this.browser);
                        event2.top = true;
                        event2.location = _url;
                        l.changed(event2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                for (LocationListener l : BrowserWrapperFake.this.progress_listeners) {
                    try {
                        event2 = new ProgressEvent((Widget)BrowserWrapperFake.this.browser);
                        l.completed((ProgressEvent)event2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                for (LocationListener l : BrowserWrapperFake.this.title_listeners) {
                    try {
                        event2 = new TitleEvent((Widget)BrowserWrapperFake.this.browser);
                        event2.title = "Browser Disabled";
                        l.changed((TitleEvent)event2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    public void setText(String text) {
        this.description = text;
        Utils.execSWTThread(new Runnable(){

            public void run() {
                BrowserWrapperFake.this.description_label.setText(BrowserWrapperFake.this.description);
                BrowserWrapperFake.this.browser.layout();
            }
        });
    }

    public void setData(String key, Object value) {
        this.browser.setData(key, value);
    }

    public Object getData(String key) {
        return this.browser.getData(key);
    }

    public void back() {
    }

    public void refresh() {
    }

    public void update() {
        this.browser.update();
    }

    public Shell getShell() {
        return this.browser.getShell();
    }

    public Display getDisplay() {
        return this.browser.getDisplay();
    }

    public Composite getParent() {
        return this.browser.getParent();
    }

    public Object getLayoutData() {
        return this.browser.getLayoutData();
    }

    public void setLayoutData(Object data) {
        this.browser.setLayoutData(data);
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void addListener(int type, Listener l) {
        this.browser.addListener(type, l);
    }

    public void addLocationListener(LocationListener l) {
        this.location_listeners.add(l);
    }

    public void removeLocationListener(LocationListener l) {
        this.location_listeners.remove(l);
    }

    public void addTitleListener(TitleListener l) {
        this.title_listeners.add(l);
    }

    public void addProgressListener(ProgressListener l) {
        this.progress_listeners.add(l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.progress_listeners.remove(l);
    }

    public void addOpenWindowListener(OpenWindowListener l) {
    }

    public void addCloseWindowListener(CloseWindowListener l) {
    }

    public void addDisposeListener(DisposeListener l) {
        this.browser.addDisposeListener(l);
    }

    public void removeDisposeListener(DisposeListener l) {
        this.browser.removeDisposeListener(l);
    }

    public void addStatusTextListener(StatusTextListener l) {
    }

    public void removeStatusTextListener(StatusTextListener l) {
    }

    public BrowserWrapper.BrowserFunction addBrowserFunction(String name, BrowserWrapper.BrowserFunction bf) {
        return new BrowserFunctionFake(bf);
    }

    public static class BrowserFunctionFake
    extends BrowserWrapper.BrowserFunction {
        private final BrowserWrapper.BrowserFunction bf;
        private boolean disposed;

        private BrowserFunctionFake(BrowserWrapper.BrowserFunction _bf) {
            this.bf = _bf;
            this.bf.bind(this);
        }

        public Object function(Object[] arguments) {
            return this.bf.function(arguments);
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public void dispose() {
            this.disposed = true;
        }
    }
}

