/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.progress.IProgressReport;
import org.gudy.azureus2.ui.swt.progress.IProgressReportConstants;
import org.gudy.azureus2.ui.swt.progress.IProgressReporter;
import org.gudy.azureus2.ui.swt.progress.IProgressReporterListener;
import org.gudy.azureus2.ui.swt.progress.ProgressReporterWindow;
import org.gudy.azureus2.ui.swt.progress.ProgressReportingManager;

public class FileDownloadWindow
implements TorrentDownloaderCallBackInterface,
IProgressReportConstants {
    TorrentDownloader downloader;
    TorrentDownloaderCallBackInterface listener;
    boolean force_dialog;
    IProgressReporter pReporter;
    Shell parent;
    String original_url;
    String decoded_url;
    String referrer;
    Map request_properties;
    String dirName = null;
    String shortURL = null;
    TorrentOpenOptions torrentOptions;
    private int lastState = -1;

    public FileDownloadWindow(Shell parent, String url, String referrer, Map request_properties) {
        this(parent, url, referrer, request_properties, null, null);
    }

    public FileDownloadWindow(Shell parent, String url, String referrer, Map request_properties, TorrentOpenOptions torrentOptions, TorrentDownloaderCallBackInterface listener) {
        this.parent = parent;
        this.original_url = url;
        this.referrer = referrer;
        this.torrentOptions = torrentOptions;
        this.listener = listener;
        this.request_properties = request_properties;
        this.decoded_url = UrlUtils.decodeIfNeeded(this.original_url);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                FileDownloadWindow.this.init();
            }
        });
    }

    public FileDownloadWindow(Shell parent, String url, String referrer, Map request_properties, boolean force_dialog) {
        this.parent = parent;
        this.original_url = url;
        this.referrer = referrer;
        this.force_dialog = force_dialog;
        this.request_properties = request_properties;
        this.decoded_url = UrlUtils.decodeIfNeeded(this.original_url);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                FileDownloadWindow.this.init();
            }
        });
    }

    private void init() {
        if (COConfigurationManager.getBooleanParameter("Save Torrent Files")) {
            try {
                File f;
                this.dirName = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                if (this.dirName != null && !(f = new File(this.dirName)).isDirectory()) {
                    if (f.exists()) {
                        this.dirName = null;
                    } else if (!f.mkdirs()) {
                        this.dirName = null;
                    }
                }
            }
            catch (Exception egnore) {
                // empty catch block
            }
        }
        if (this.dirName == null) {
            DirectoryDialog dd = new DirectoryDialog(this.parent == null ? Utils.findAnyShell() : this.parent, 0);
            dd.setText(MessageText.getString("fileDownloadWindow.saveTorrentIn"));
            this.dirName = dd.open();
        }
        if (this.dirName == null) {
            return;
        }
        this.pReporter = ProgressReportingManager.getInstance().addReporter();
        this.setupAndShowDialog();
        this.downloader = TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)this, this.original_url, this.referrer, this.request_properties, this.dirName);
        this.downloader.setIgnoreReponseCode(true);
        this.downloader.start();
    }

    private void setupAndShowDialog() {
        if (null != this.pReporter) {
            this.pReporter.setName(MessageText.getString("fileDownloadWindow.state_downloading") + ": " + this.getFileName(this.decoded_url));
            this.pReporter.appendDetailMessage(MessageText.getString("fileDownloadWindow.downloading") + this.getShortURL(this.decoded_url));
            this.pReporter.setTitle(MessageText.getString("fileDownloadWindow.title"));
            this.pReporter.setIndeterminate(true);
            this.pReporter.setCancelAllowed(true);
            this.pReporter.setRetryAllowed(true);
            this.pReporter.addListener(new IProgressReporterListener(){

                public int report(IProgressReport pReport) {
                    switch (pReport.getReportType()) {
                        case 1: {
                            if (null == FileDownloadWindow.this.downloader) break;
                            FileDownloadWindow.this.downloader.cancel();
                            Logger.log(new LogEvent(LogIDs.LOGGER, MessageText.getString("FileDownload.canceled", new String[]{FileDownloadWindow.this.getShortURL(FileDownloadWindow.this.decoded_url)})));
                            break;
                        }
                        case 2: {
                            return 1;
                        }
                        case 5: {
                            if (!pReport.isRetryAllowed()) break;
                            FileDownloadWindow.this.downloader.cancel();
                            FileDownloadWindow.this.downloader = TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)FileDownloadWindow.this, FileDownloadWindow.this.original_url, FileDownloadWindow.this.referrer, FileDownloadWindow.this.request_properties, FileDownloadWindow.this.dirName);
                            FileDownloadWindow.this.downloader.setIgnoreReponseCode(true);
                            FileDownloadWindow.this.downloader.start();
                            break;
                        }
                    }
                    return 0;
                }
            });
            ProgressReporterWindow.open(this.pReporter, 2);
        }
    }

    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        if (this.listener != null) {
            this.listener.TorrentDownloaderEvent(state, inf);
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        int state;
        int localLastState;
        FileDownloadWindow fileDownloadWindow = this;
        synchronized (fileDownloadWindow) {
            localLastState = this.lastState;
            this.lastState = state = this.downloader.getDownloadState();
        }
        int percentDone = this.downloader.getPercentDone();
        IProgressReport pReport = this.pReporter.getProgressReport();
        switch (state) {
            case 6: {
                if (localLastState == state) {
                    return;
                }
                if (!pReport.isCanceled()) {
                    this.pReporter.cancel();
                }
                return;
            }
            case 2: {
                this.pReporter.setPercentage(percentDone, this.downloader.getStatus());
                break;
            }
            case 4: {
                if (localLastState == state) {
                    return;
                }
                if (pReport.isCanceled()) {
                    return;
                }
                if (this.torrentOptions != null && this.torrentOptions.getHideErrors()) {
                    this.pReporter.setCancelCloses(true);
                    this.pReporter.cancel();
                } else {
                    this.pReporter.setErrorMessage(MessageText.getString("fileDownloadWindow.state_error") + this.downloader.getError());
                }
                return;
            }
            case 3: {
                if (localLastState == state) {
                    return;
                }
                this.pReporter.setDone();
                if (this.listener == null) {
                    if (this.torrentOptions == null) {
                        this.torrentOptions = new TorrentOpenOptions();
                    }
                    if (TorrentOpener.mergeFileIntoTorrentInfo(this.downloader.getFile().getAbsolutePath(), this.original_url, this.torrentOptions)) {
                        UIFunctionsManager.getUIFunctions().addTorrentWithOptions(this.force_dialog, this.torrentOptions);
                    }
                }
                return;
            }
        }
    }

    private String getShortURL(String url) {
        if (null == this.shortURL) {
            this.shortURL = url;
            int trunc_pos = this.shortURL.indexOf(38);
            if (trunc_pos == -1 && (trunc_pos = this.shortURL.indexOf(63)) > 0 && this.shortURL.charAt(trunc_pos - 1) == ':') {
                trunc_pos = -1;
            }
            if (trunc_pos != -1) {
                this.shortURL = this.shortURL.substring(0, trunc_pos + 1) + "...";
            }
            this.shortURL = this.shortURL.replaceAll("&", "&&");
        }
        return this.shortURL;
    }

    private String getFileName(String url) {
        try {
            String[] titles;
            for (String toMatch : titles = new String[]{"title", "dn"}) {
                Matcher matcher = Pattern.compile("[?&]" + toMatch + "=([^&]*)", 2).matcher(url);
                if (!matcher.find()) continue;
                String file_name = matcher.group(1);
                file_name = UrlUtils.decode(file_name);
                return file_name;
            }
            String lc_url = (url = this.getShortURL(url)).toLowerCase(MessageText.LOCALE_ENGLISH);
            if (lc_url.startsWith("magnet:") || lc_url.startsWith("maggot:") || lc_url.startsWith("dht:") || lc_url.startsWith("bc:") || lc_url.startsWith("bctp:")) {
                return url;
            }
            String tmp = url.substring(url.lastIndexOf(47) + 1);
            int pos = tmp.toLowerCase(MessageText.LOCALE_ENGLISH).lastIndexOf(".vuze");
            if (pos > 0) {
                return tmp.substring(0, pos + 5);
            }
            pos = tmp.toLowerCase(MessageText.LOCALE_ENGLISH).lastIndexOf(".torrent");
            if (pos > 0) {
                tmp = tmp.substring(0, pos);
            }
            return tmp + ".torrent";
        }
        catch (Exception exception) {
            return url;
        }
    }
}

