/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.speedmanager.SpeedLimitHandler;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.ISelectedVuzeFileContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.UIPluginView;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.ListenerDMTask;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.TrackerChangerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.maketorrent.WebSeedsEditor;
import org.gudy.azureus2.ui.swt.maketorrent.WebSeedsEditorListener;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;
import org.gudy.azureus2.ui.swt.shells.AdvRenameWindow;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.FilesViewMenuUtil;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentUtil {
    public static void fillTorrentMenu(final Menu menu, final DownloadManager[] dms, AzureusCore azureus_core, final Composite composite, boolean include_show_details, int selected_dl_types, final TableView tv) {
        boolean isSeedingView;
        switch (selected_dl_types) {
            case 1: {
                isSeedingView = false;
                break;
            }
            case 2: {
                isSeedingView = true;
                break;
            }
            case 0: {
                if (dms.length == 1) {
                    isSeedingView = dms[0].isDownloadComplete(false);
                    break;
                }
            }
            default: {
                isSeedingView = false;
            }
        }
        boolean hasSelection = dms.length > 0;
        boolean isTrackerOn = TRTrackerUtils.isTrackerEnabled();
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean bChangeDir = hasSelection;
        boolean fileRescan = true;
        boolean fileMove = true;
        boolean manualUpdate = true;
        boolean barsOpened = true;
        boolean changeUrl = true;
        boolean stop = false;
        boolean start = false;
        boolean recheck = false;
        boolean forceStartEnabled = false;
        boolean forceStart = false;
        boolean canSetSuperSeed = false;
        boolean superSeedAllYes = true;
        boolean superSeedAllNo = true;
        boolean upSpeedDisabled = false;
        long totalUpSpeed = 0L;
        boolean upSpeedUnlimited = false;
        long upSpeedSetMax = 0L;
        boolean downSpeedDisabled = false;
        long totalDownSpeed = 0L;
        boolean downSpeedUnlimited = false;
        long downSpeedSetMax = 0L;
        boolean allScanSelected = true;
        boolean allScanNotSelected = true;
        boolean allStopped = true;
        if (hasSelection) {
            for (int i = 0; i < dms.length; ++i) {
                int state;
                TRTrackerAnnouncer trackerClient;
                DownloadManager dm = dms[i];
                try {
                    int maxul = dm.getStats().getUploadRateLimitBytesPerSecond();
                    if (maxul == 0) {
                        upSpeedUnlimited = true;
                    } else if ((long)maxul > upSpeedSetMax) {
                        upSpeedSetMax = maxul;
                    }
                    if (maxul == -1) {
                        maxul = 0;
                        upSpeedDisabled = true;
                    }
                    totalUpSpeed += (long)maxul;
                    int maxdl = dm.getStats().getDownloadRateLimitBytesPerSecond();
                    if (maxdl == 0) {
                        downSpeedUnlimited = true;
                    } else if ((long)maxdl > downSpeedSetMax) {
                        downSpeedSetMax = maxdl;
                    }
                    if (maxdl == -1) {
                        maxdl = 0;
                        downSpeedDisabled = true;
                    }
                    totalDownSpeed += (long)maxdl;
                }
                catch (Exception ex) {
                    Debug.printStackTrace(ex);
                }
                if (barsOpened && !DownloadBar.getManager().isOpen(dm)) {
                    barsOpened = false;
                }
                stop = stop || ManagerUtils.isStopable(dm);
                start = start || ManagerUtils.isStartable(dm);
                recheck = recheck || dm.canForceRecheck();
                forceStartEnabled = forceStartEnabled || ManagerUtils.isForceStartable(dm);
                forceStart = forceStart || dm.isForceStart();
                boolean stopped = ManagerUtils.isStopped(dm);
                allStopped &= stopped;
                boolean bl = fileMove = fileMove && dm.canMoveDataFiles();
                if (userMode < 2 && (trackerClient = dm.getTrackerClient()) != null) {
                    boolean update_state = SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L;
                    manualUpdate &= update_state;
                }
                if ((bChangeDir &= (state = dm.getState()) == 100 || state == 70 || state == 75) && dms.length == 1) {
                    bChangeDir = dm.isDataAlreadyAllocated();
                    bChangeDir = bChangeDir && state == 100 ? !dm.filesExist(true) : false;
                }
                boolean scan = dm.getDownloadState().getFlag(2L);
                boolean incomplete = !dm.isDownloadComplete(true);
                allScanSelected = incomplete && allScanSelected && scan;
                allScanNotSelected = incomplete && allScanNotSelected && !scan;
                PEPeerManager pm = dm.getPeerManager();
                if (pm != null) {
                    if (pm.canToggleSuperSeedMode()) {
                        canSetSuperSeed = true;
                    }
                    if (pm.isSuperSeedMode()) {
                        superSeedAllYes = false;
                        continue;
                    }
                    superSeedAllNo = false;
                    continue;
                }
                superSeedAllYes = false;
                superSeedAllNo = false;
            }
            fileRescan = allScanSelected || allScanNotSelected;
        } else {
            barsOpened = false;
            forceStart = false;
            forceStartEnabled = false;
            start = false;
            stop = false;
            fileMove = false;
            fileRescan = false;
            upSpeedDisabled = true;
            downSpeedDisabled = true;
            changeUrl = false;
            recheck = false;
            manualUpdate = false;
        }
        if (bChangeDir) {
            MenuItem menuItemChangeDir = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)menuItemChangeDir, "MyTorrentsView.menu.changeDirectory");
            menuItemChangeDir.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentUtil.changeDirSelectedTorrents(dms, composite.getShell());
                }
            });
        }
        if (include_show_details) {
            MenuItem itemDetails = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDetails, "MyTorrentsView.menu.showdetails");
            menu.setDefaultItem(itemDetails);
            Utils.setMenuItemImage(itemDetails, "details");
            itemDetails.addListener(13, (Listener)new ListenerDMTask(dms){

                public void run(DownloadManager dm) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.getMDI().showEntryByID("DMDetails", dm);
                    }
                }
            });
            itemDetails.setEnabled(hasSelection);
        }
        MenuItem itemBar = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemBar, "MyTorrentsView.menu.showdownloadbar");
        Utils.setMenuItemImage(itemBar, "downloadBar");
        itemBar.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                if (DownloadBar.getManager().isOpen(dm)) {
                    DownloadBar.close(dm);
                } else {
                    DownloadBar.open(dm, menu.getShell());
                }
            }
        });
        itemBar.setEnabled(hasSelection);
        itemBar.setSelection(barsOpened);
        new MenuItem(menu, 2);
        MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOpen, "MyTorrentsView.menu.open");
        Utils.setMenuItemImage(itemOpen, "run");
        itemOpen.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager[] dms) {
                TorrentUtil.runDataSources(dms);
            }
        });
        itemOpen.setEnabled(hasSelection);
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, (Listener)new ListenerDMTask(dms, false){

            public void run(DownloadManager dm) {
                ManagerUtils.open(dm, use_open_containing_folder);
            }
        });
        itemExplore.setEnabled(hasSelection);
        Menu menuBrowse = new Menu((Decorations)menu.getShell(), 4);
        MenuItem itemBrowse = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemBrowse, "MyTorrentsView.menu.browse");
        itemBrowse.setMenu(menuBrowse);
        MenuItem itemBrowsePublic = new MenuItem(menuBrowse, 8);
        itemBrowsePublic.setText(MessageText.getString("label.public") + "...");
        itemBrowsePublic.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                ManagerUtils.browse(dm, false, true);
            }
        });
        MenuItem itemBrowseAnon = new MenuItem(menuBrowse, 8);
        itemBrowseAnon.setText(MessageText.getString("label.anon") + "...");
        itemBrowseAnon.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                ManagerUtils.browse(dm, true, true);
            }
        });
        new MenuItem(menuBrowse, 2);
        MenuItem itemBrowseURL = new MenuItem(menuBrowse, 8);
        Messages.setLanguageText((Widget)itemBrowseURL, "label.copy.url.to.clip");
        itemBrowseURL.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Utils.getOffOfSWTThread(new AERunnable(){

                    public void runSupport() {
                        String url = ManagerUtils.browse(dms[0], true, false);
                        if (url != null) {
                            ClipboardCopy.copyToClipBoard(url);
                        }
                    }
                });
            }
        });
        itemBrowseURL.setEnabled(dms.length == 1);
        new MenuItem(menuBrowse, 2);
        final MenuItem itemBrowseDir = new MenuItem(menuBrowse, 32);
        Messages.setLanguageText((Widget)itemBrowseDir, "library.launch.web.in.browser.dir.list");
        itemBrowseDir.setSelection(COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList"));
        itemBrowseDir.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                COConfigurationManager.setParameter("Library.LaunchWebsiteInBrowserDirList", itemBrowseDir.getSelection());
            }
        });
        itemBrowse.setEnabled(hasSelection);
        MenuItem itemAdvanced = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemAdvanced, "MyTorrentsView.menu.advancedmenu");
        itemAdvanced.setEnabled(hasSelection);
        Menu menuAdvanced = new Menu((Decorations)menu.getShell(), 4);
        itemAdvanced.setMenu(menuAdvanced);
        long maxDownload = (long)COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * 1024L;
        long maxUpload = (long)COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * 1024L;
        ViewUtils.addSpeedMenu(menu.getShell(), menuAdvanced, true, true, true, hasSelection, downSpeedDisabled, downSpeedUnlimited, totalDownSpeed, downSpeedSetMax, maxDownload, upSpeedDisabled, upSpeedUnlimited, totalUpSpeed, upSpeedSetMax, maxUpload, dms.length, null, new ViewUtils.SpeedAdapter(){

            public void setDownSpeed(final int speed) {
                ListenerDMTask task2 = new ListenerDMTask(dms){

                    public void run(DownloadManager dm) {
                        dm.getStats().setDownloadRateLimitBytesPerSecond(speed);
                    }
                };
                task2.go();
            }

            public void setUpSpeed(final int speed) {
                ListenerDMTask task2 = new ListenerDMTask(dms){

                    public void run(DownloadManager dm) {
                        dm.getStats().setUploadRateLimitBytesPerSecond(speed);
                    }
                };
                task2.go();
            }
        });
        final Menu speedLimitsMenu = new Menu((Decorations)menuAdvanced.getShell(), 4);
        MenuItem speedLimitsMenuItem = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)speedLimitsMenuItem, "MainWindow.menu.speed_limits");
        speedLimitsMenuItem.setMenu(speedLimitsMenu);
        MenuBuildUtils.addMaintenanceListenerForMenu(speedLimitsMenu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                TorrentUtil.addSpeedLimitsMenu(dms, speedLimitsMenu);
            }
        });
        Menu menuTracker = new Menu((Decorations)menu.getShell(), 4);
        MenuItem itemTracker = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemTracker, "MyTorrentsView.menu.tracker");
        itemTracker.setMenu(menuTracker);
        itemExplore.setEnabled(hasSelection);
        TorrentUtil.addTrackerTorrentMenu(menuTracker, dms, changeUrl, manualUpdate, allStopped, use_open_containing_folder);
        MenuItem itemFiles = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemFiles, "ConfigView.section.files");
        Menu menuFiles = new Menu((Decorations)composite.getShell(), 4);
        itemFiles.setMenu(menuFiles);
        MenuItem itemFileMoveData = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileMoveData, "MyTorrentsView.menu.movedata");
        itemFileMoveData.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager[] dms) {
                TorrentUtil.moveDataFiles(composite.getShell(), dms);
            }
        });
        itemFileMoveData.setEnabled(fileMove);
        MenuItem itemFileMoveTorrent = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileMoveTorrent, "MyTorrentsView.menu.movetorrent");
        itemFileMoveTorrent.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager[] dms) {
                TorrentUtil.moveTorrentFile(composite.getShell(), dms);
            }
        });
        itemFileMoveTorrent.setEnabled(fileMove);
        MenuItem itemCheckFilesExist = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemCheckFilesExist, "MyTorrentsView.menu.checkfilesexist");
        itemCheckFilesExist.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                dm.filesExist(true);
            }
        });
        final MenuItem itemFileRescan = new MenuItem(menuFiles, 32);
        Messages.setLanguageText((Widget)itemFileRescan, "MyTorrentsView.menu.rescanfile");
        itemFileRescan.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                dm.getDownloadState().setFlag(2L, itemFileRescan.getSelection());
            }
        });
        itemFileRescan.setSelection(allScanSelected);
        itemFileRescan.setEnabled(fileRescan);
        MenuItem itemFileClearAlloc = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileClearAlloc, "MyTorrentsView.menu.clear_alloc_data");
        itemFileClearAlloc.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                dm.setDataAlreadyAllocated(false);
            }
        });
        itemFileClearAlloc.setEnabled(allStopped);
        MenuItem itemFileClearResume = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileClearResume, "MyTorrentsView.menu.clear_resume_data");
        itemFileClearResume.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                dm.getDownloadState().clearResumeData();
            }
        });
        itemFileClearResume.setEnabled(allStopped);
        final ArrayList<Download> ar_dms = new ArrayList<Download>();
        for (DownloadManager dm : dms) {
            Download stub = PluginCoreUtils.wrap(dm);
            if (!stub.canStubbify()) continue;
            ar_dms.add(stub);
        }
        MenuItem itemArchive = new MenuItem(menuAdvanced, 8);
        Messages.setLanguageText((Widget)itemArchive, "MyTorrentsView.menu.archive");
        Utils.setMenuItemImage(itemArchive, "archive");
        itemArchive.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                ManagerUtils.moveToArchive(ar_dms, null);
            }
        });
        itemArchive.setEnabled(ar_dms.size() > 0);
        MenuItem itemRename = new MenuItem(menuAdvanced, 4);
        Messages.setLanguageText((Widget)itemRename, "MyTorrentsView.menu.rename");
        itemRename.setEnabled(hasSelection);
        itemRename.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (DownloadManager dm : dms) {
                    AdvRenameWindow window = new AdvRenameWindow();
                    window.open(dm);
                }
            }
        });
        Menu quickViewMenu = new Menu((Decorations)menuAdvanced.getShell(), 4);
        MenuItem quickViewMenuItem = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)quickViewMenuItem, "MainWindow.menu.quick_view");
        quickViewMenuItem.setMenu(quickViewMenu);
        MenuBuildUtils.addMaintenanceListenerForMenu(quickViewMenu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                DownloadManager dm = dms[0];
                DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                int added = 0;
                for (final DiskManagerFileInfo file : files) {
                    if (!Utils.isQuickViewSupported(file)) continue;
                    final MenuItem addItem = new MenuItem(menu, 32);
                    addItem.setSelection(Utils.isQuickViewActive(file));
                    addItem.setText(file.getTorrentFile().getRelativePath());
                    addItem.addListener(13, new Listener(){

                        public void handleEvent(Event arg) {
                            Utils.setQuickViewActive(file, addItem.getSelection());
                        }
                    });
                    ++added;
                }
                if (added == 0) {
                    MenuItem addItem = new MenuItem(menu, 8);
                    addItem.setText(MessageText.getString("quick.view.no.files"));
                    addItem.setEnabled(false);
                }
            }
        });
        quickViewMenuItem.setEnabled(dms.length == 1);
        MenuFactory.addAlertsMenu(menuAdvanced, true, dms);
        if (userMode > 0) {
            MenuItem itemExport = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemExport, "MyTorrentsView.menu.exportmenu");
            Utils.setMenuItemImage(itemExport, "export");
            itemExport.setEnabled(hasSelection);
            Menu menuExport = new Menu((Decorations)composite.getShell(), 4);
            itemExport.setMenu(menuExport);
            final MenuItem itemExportXML = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemExportXML, "MyTorrentsView.menu.export");
            itemExportXML.addListener(13, (Listener)new ListenerDMTask(dms){

                public void run(DownloadManager[] dms) {
                    DownloadManager dm = dms[0];
                    if (dm != null) {
                        new ExportTorrentWizard(itemExportXML.getDisplay(), dm);
                    }
                }
            });
            MenuItem itemExportTorrent = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemExportTorrent, "MyTorrentsView.menu.exporttorrent");
            itemExportTorrent.addListener(13, (Listener)new ListenerDMTask(dms){

                public void run(DownloadManager[] dms) {
                    TorrentUtil.exportTorrent(dms, composite.getShell());
                }
            });
            MenuItem itemWebSeed = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemWebSeed, "MyTorrentsView.menu.exporthttpseeds");
            itemWebSeed.addListener(13, (Listener)new ListenerDMTask(dms){

                public void run(DownloadManager[] dms) {
                    TorrentUtil.exportHTTPSeeds(dms);
                }
            });
        }
        if (userMode > 0) {
            MenuItem itemExportXML = new MenuItem(menuAdvanced, 8);
            Messages.setLanguageText((Widget)itemExportXML, "label.options.and.info");
            itemExportXML.addListener(13, (Listener)new ListenerDMTask(dms){

                public void run(DownloadManager[] dms) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.getMDI().showEntryByID("TorrentOptionsView", dms);
                    }
                }
            });
        }
        if (userMode > 0) {
            MenuItem itemPeerSource = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemPeerSource, "MyTorrentsView.menu.peersource");
            Menu menuPeerSource = new Menu((Decorations)composite.getShell(), 4);
            itemPeerSource.setMenu(menuPeerSource);
            TorrentUtil.addPeerSourceSubMenu(dms, menuPeerSource);
        }
        if (userMode > 0) {
            final MenuItem ipf_enable = new MenuItem(menuAdvanced, 32);
            Messages.setLanguageText((Widget)ipf_enable, "MyTorrentsView.menu.ipf_enable");
            ipf_enable.addListener(13, (Listener)new ListenerDMTask(dms){

                public void run(DownloadManager dm) {
                    dm.getDownloadState().setFlag(256L, !ipf_enable.getSelection());
                }
            });
            boolean bEnabled = IpFilterManagerFactory.getSingleton().getIPFilter().isEnabled();
            if (bEnabled) {
                boolean allChecked = true;
                boolean allUnchecked = true;
                for (int j = 0; j < dms.length; ++j) {
                    DownloadManager dm = dms[j];
                    boolean b = dm.getDownloadState().getFlag(256L);
                    if (b) {
                        allUnchecked = false;
                        continue;
                    }
                    allChecked = false;
                }
                boolean bChecked = allUnchecked ? true : (allChecked ? false : false);
                ipf_enable.setSelection(bChecked);
            }
            ipf_enable.setEnabled(bEnabled);
        }
        if (userMode > 1) {
            MenuItem itemNetworks = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemNetworks, "MyTorrentsView.menu.networks");
            Menu menuNetworks = new Menu((Decorations)composite.getShell(), 4);
            itemNetworks.setMenu(menuNetworks);
            TorrentUtil.addNetworksSubMenu(dms, menuNetworks);
        }
        if (userMode > 1 && isSeedingView) {
            MenuItem itemSuperSeed = new MenuItem(menuAdvanced, 32);
            Messages.setLanguageText((Widget)itemSuperSeed, "ManagerItem.superseeding");
            boolean enabled = canSetSuperSeed && (superSeedAllNo || superSeedAllYes);
            itemSuperSeed.setEnabled(enabled);
            final boolean selected = superSeedAllNo;
            if (enabled) {
                itemSuperSeed.setSelection(selected);
                itemSuperSeed.addListener(13, (Listener)new ListenerDMTask(dms){

                    public void run(DownloadManager dm) {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm != null && pm.isSuperSeedMode() == selected && pm.canToggleSuperSeedMode()) {
                            pm.setSuperSeedMode(!selected);
                        }
                    }
                });
            }
        }
        if (userMode > 0) {
            boolean can_pause = false;
            for (int i = 0; i < dms.length; ++i) {
                DownloadManager dm = dms[i];
                if (!ManagerUtils.isPauseable(dm)) continue;
                can_pause = true;
                break;
            }
            MenuItem itemPauseFor = new MenuItem(menuAdvanced, 8);
            itemPauseFor.setEnabled(can_pause);
            Messages.setLanguageText((Widget)itemPauseFor, "MainWindow.menu.transfers.pausetransfersfor");
            itemPauseFor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TorrentUtil.pauseDownloadsFor(dms);
                }
            });
        }
        MenuItem itemPositionManual = new MenuItem(menuAdvanced, 8);
        Messages.setLanguageText((Widget)itemPositionManual, "MyTorrentsView.menu.reposition.manual");
        itemPositionManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TorrentUtil.repositionManual(tv, dms, composite.getShell(), isSeedingView);
            }
        });
        if (userMode > 0 && isTrackerOn) {
            MenuItem itemHost = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemHost, "MyTorrentsView.menu.host");
            Utils.setMenuItemImage(itemHost, "host");
            itemHost.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.hostTorrents(dms);
                }
            });
            MenuItem itemPublish = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemPublish, "MyTorrentsView.menu.publish");
            Utils.setMenuItemImage(itemPublish, "publish");
            itemPublish.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.publishTorrents(dms);
                }
            });
            itemHost.setEnabled(hasSelection);
            itemPublish.setEnabled(hasSelection);
        }
        Menu menuCategory = new Menu((Decorations)composite.getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(menuCategory);
        itemCategory.setEnabled(hasSelection);
        TorrentUtil.addCategorySubMenu(dms, menuCategory, composite);
        Menu menuTags = new Menu((Decorations)composite.getShell(), 4);
        MenuItem itemTags = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemTags, "label.tags");
        itemTags.setMenu(menuTags);
        itemTags.setEnabled(hasSelection);
        TagUIUtils.addLibraryViewTagsSubMenu(dms, menuTags, composite);
        if (isSeedingView) {
            MenuItem itemPersonalShare = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemPersonalShare, "MyTorrentsView.menu.create_personal_share");
            itemPersonalShare.addListener(13, (Listener)new ListenerDMTask(dms, false){

                public void run(DownloadManager dm) {
                    File file = dm.getSaveLocation();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("personal", "true");
                    if (file.isFile()) {
                        ShareUtils.shareFile(file.getAbsolutePath(), properties);
                    } else if (file.isDirectory()) {
                        ShareUtils.shareDir(file.getAbsolutePath(), properties);
                    }
                }
            });
        }
        new MenuItem(menu, 2);
        MenuItem itemQueue = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemQueue, "MyTorrentsView.menu.queue");
        Utils.setMenuItemImage(itemQueue, "start");
        itemQueue.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Utils.getOffOfSWTThread(new AERunnable(){

                    public void runSupport() {
                        TorrentUtil.queueDataSources(dms, true);
                    }
                });
            }
        });
        itemQueue.setEnabled(start);
        if (userMode > 0) {
            final MenuItem itemForceStart = new MenuItem(menu, 32);
            Messages.setLanguageText((Widget)itemForceStart, "MyTorrentsView.menu.forceStart");
            Utils.setMenuItemImage(itemForceStart, "forcestart");
            itemForceStart.addListener(13, (Listener)new ListenerDMTask(dms){

                public void run(DownloadManager dm) {
                    if (ManagerUtils.isForceStartable(dm)) {
                        dm.setForceStart(itemForceStart.getSelection());
                    }
                }
            });
            itemForceStart.setSelection(forceStart);
            itemForceStart.setEnabled(forceStartEnabled);
        }
        if (userMode > 0) {
            MenuItem itemPause = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemPause, "v3.MainWindow.button.pause");
            Utils.setMenuItemImage(itemPause, "pause");
            itemPause.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    Utils.getOffOfSWTThread(new AERunnable(){

                        public void runSupport() {
                            TorrentUtil.pauseDataSources(dms);
                        }
                    });
                }
            });
            itemPause.setEnabled(stop);
        }
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Utils.getOffOfSWTThread(new AERunnable(){

                    public void runSupport() {
                        TorrentUtil.stopDataSources(dms);
                    }
                });
            }
        });
        itemStop.setEnabled(stop);
        MenuItem itemRecheck = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRecheck, "MyTorrentsView.menu.recheck");
        Utils.setMenuItemImage(itemRecheck, "recheck");
        itemRecheck.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                if (dm.canForceRecheck()) {
                    dm.forceRecheck();
                }
            }
        });
        itemRecheck.setEnabled(recheck);
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "menu.delete.options");
        Utils.setMenuItemImage(itemRemove, "delete");
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TorrentUtil.removeDownloads(dms, null, true);
            }
        });
        itemRemove.setEnabled(hasSelection);
    }

    protected static void addNetworksSubMenu(DownloadManager[] dms, Menu menuNetworks) {
        for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
            boolean bChecked;
            final String nn = AENetworkClassifier.AT_NETWORKS[i];
            String msg_text = "ConfigView.section.connection.networks." + nn;
            final MenuItem itemNetwork = new MenuItem(menuNetworks, 32);
            itemNetwork.setData("network", (Object)nn);
            Messages.setLanguageText((Widget)itemNetwork, msg_text);
            itemNetwork.addListener(13, (Listener)new ListenerDMTask(dms){

                public void run(DownloadManager dm) {
                    dm.getDownloadState().setNetworkEnabled(nn, itemNetwork.getSelection());
                }
            });
            boolean bl = bChecked = dms.length > 0;
            if (bChecked) {
                for (int j = 0; j < dms.length; ++j) {
                    DownloadManager dm = dms[j];
                    if (dm.getDownloadState().isNetworkEnabled(nn)) continue;
                    bChecked = false;
                    break;
                }
            }
            itemNetwork.setSelection(bChecked);
        }
    }

    protected static void addPeerSourceSubMenu(DownloadManager[] dms, Menu menuPeerSource) {
        boolean hasSelection = dms.length > 0;
        for (int i = 0; i < PEPeerSource.PS_SOURCES.length; ++i) {
            boolean bEnabled;
            final String p = PEPeerSource.PS_SOURCES[i];
            String msg_text = "ConfigView.section.connection.peersource." + p;
            final MenuItem itemPS = new MenuItem(menuPeerSource, 32);
            itemPS.setData("peerSource", (Object)p);
            Messages.setLanguageText((Widget)itemPS, msg_text);
            itemPS.addListener(13, (Listener)new ListenerDMTask(dms){

                public void run(DownloadManager dm) {
                    dm.getDownloadState().setPeerSourceEnabled(p, itemPS.getSelection());
                }
            });
            itemPS.setSelection(true);
            boolean bChecked = hasSelection;
            boolean bl = bEnabled = !hasSelection;
            if (bChecked) {
                bEnabled = true;
                for (int j = 0; j < dms.length; ++j) {
                    DownloadManager dm = dms[j];
                    if (!dm.getDownloadState().isPeerSourceEnabled(p)) {
                        bChecked = false;
                    }
                    if (dm.getDownloadState().isPeerSourcePermitted(p)) continue;
                    bEnabled = false;
                }
            }
            itemPS.setSelection(bChecked);
            itemPS.setEnabled(bEnabled);
        }
    }

    protected static void exportHTTPSeeds(DownloadManager[] dms) {
        String port;
        String NL = "\r\n";
        String data = "";
        boolean http_enable = COConfigurationManager.getBooleanParameter("HTTP.Data.Listen.Port.Enable");
        if (http_enable) {
            int p = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port");
            int o = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port.Override");
            port = o == 0 ? String.valueOf(p) : String.valueOf(o);
        } else {
            data = "You need to enable the HTTP port or modify the URL(s) appropriately\r\n\r\n";
            port = "<port>";
        }
        String ip = COConfigurationManager.getStringParameter("Tracker IP", "");
        if (ip.length() == 0) {
            data = data + "You might need to modify the host address in the URL(s)\r\n\r\n";
            try {
                InetAddress ia = NetworkAdmin.getSingleton().getDefaultPublicAddress();
                if (ia != null) {
                    ip = IPToHostNameResolver.syncResolve(ia.getHostAddress(), 10000);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (ip.length() == 0) {
                ip = "<host>";
            }
        }
        String base = "http://" + UrlUtils.convertIPV6Host(ip) + ":" + port + "/";
        for (int i = 0; i < dms.length; ++i) {
            TOTorrent torrent;
            DownloadManager dm = dms[i];
            if (dm == null || (torrent = dm.getTorrent()) == null) continue;
            data = data + base + "webseed" + "\r\n";
            try {
                data = data + base + "files/" + URLEncoder.encode(new String(torrent.getHash(), "ISO-8859-1"), "ISO-8859-1") + "/" + "\r\n" + "\r\n";
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (data.length() > 0) {
            ClipboardCopy.copyToClipBoard(data);
        }
    }

    protected static void exportTorrent(DownloadManager[] dms, Shell parentShell) {
        int i;
        String path;
        File[] destinations = new File[dms.length];
        if (dms.length == 1) {
            FileDialog fd = new FileDialog(parentShell, 8192);
            fd.setFileName(dms[0].getTorrentFileName());
            path = fd.open();
            if (path == null) {
                return;
            }
            destinations[0] = new File(path);
        } else {
            DirectoryDialog dd = new DirectoryDialog(parentShell, 8192);
            path = dd.open();
            if (path == null) {
                return;
            }
            for (int i2 = 0; i2 < dms.length; ++i2) {
                destinations[i2] = new File(path, new File(dms[i2].getTorrentFileName()).getName());
            }
        }
        try {
            for (i = 0; i < dms.length; ++i) {
                File target = destinations[i];
                if (target.exists()) {
                    MessageBox mb = new MessageBox(parentShell, 196);
                    mb.setText(MessageText.getString("exportTorrentWizard.process.outputfileexists.title"));
                    mb.setMessage(MessageText.getString("exportTorrentWizard.process.outputfileexists.message") + "\n" + destinations[i].getName());
                    int result = mb.open();
                    if (result == 128) {
                        return;
                    }
                    if (!target.delete()) {
                        throw new Exception("Failed to delete file");
                    }
                }
                TorrentUtils.copyToFile(dms[i].getDownloadState().getTorrent(), target);
                TOTorrent dest = TOTorrentFactory.deserialiseFromBEncodedFile(target);
                dest.removeAdditionalProperties();
                dest.serialiseToBEncodedFile(target);
            }
        }
        catch (Throwable e) {
            Logger.log(new LogAlert((Object)dms[i], false, "Torrent export failed", e));
        }
    }

    protected static void pauseDownloadsFor(DownloadManager[] dms) {
        final ArrayList<DownloadManager> dms_to_pause = new ArrayList<DownloadManager>();
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = dms[i];
            if (!ManagerUtils.isPauseable(dm)) continue;
            dms_to_pause.add(dm);
        }
        if (dms_to_pause.size() == 0) {
            return;
        }
        String text = MessageText.getString("dialog.pause.for.period.text");
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("dialog.pause.for.period.title", "!" + text + "!");
        int def = COConfigurationManager.getIntParameter("pause.for.period.default", 10);
        entryWindow.setPreenteredText(String.valueOf(def), false);
        entryWindow.prompt(new UIInputReceiverListener(){

            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                int mins = -1;
                try {
                    mins = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException er) {
                    // empty catch block
                }
                if (mins <= 0) {
                    MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    return;
                }
                COConfigurationManager.setParameter("pause.for.period.default", mins);
                ManagerUtils.asyncPauseForPeriod(dms_to_pause, mins * 60);
            }
        });
    }

    protected static void addSpeedLimitsMenu(DownloadManager[] dms, Menu menu) {
        AzureusCore azureus_core = AzureusCoreFactory.getSingleton();
        final SpeedLimitHandler slh = SpeedLimitHandler.getSingleton(azureus_core);
        boolean all_have_limit = true;
        HashSet<String> common_profiles = new HashSet<String>();
        final ArrayList<byte[]> dm_hashes = new ArrayList<byte[]>();
        for (int i = 0; i < dms.length; ++i) {
            TOTorrent t;
            DownloadManager dm = dms[i];
            int maxul = dm.getStats().getUploadRateLimitBytesPerSecond();
            int maxdl = dm.getStats().getDownloadRateLimitBytesPerSecond();
            if (maxul == 0 && maxdl == 0) {
                all_have_limit = false;
            }
            if ((t = dm.getTorrent()) == null) {
                common_profiles.clear();
                continue;
            }
            try {
                byte[] hash = t.getHash();
                dm_hashes.add(hash);
                List<String> profs = slh.getProfilesForDownload(hash);
                if (i == 0) {
                    common_profiles.addAll(profs);
                    continue;
                }
                common_profiles.retainAll(profs);
                continue;
            }
            catch (TOTorrentException e) {
                Debug.out(e);
                common_profiles.clear();
            }
        }
        List<String> profiles = slh.getProfileNames();
        Menu add_to_prof_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem add_to_prof_item = new MenuItem(menu, 64);
        add_to_prof_item.setMenu(add_to_prof_menu);
        Messages.setLanguageText((Widget)add_to_prof_item, "MyTorrentsView.menu.sl_add_to_prof");
        if (!all_have_limit) {
            add_to_prof_item.setEnabled(false);
        } else {
            for (final String p : profiles) {
                MenuItem addItem = new MenuItem(add_to_prof_menu, 8);
                addItem.setText(p);
                addItem.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        slh.addDownloadsToProfile(p, dm_hashes);
                        MenuFactory.showText("MainWindow.menu.speed_limits.info.title", MessageText.getString("MainWindow.menu.speed_limits.info.prof", new String[]{p}), slh.getProfile(p));
                    }
                });
            }
        }
        Menu remove_from_prof_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem remove_from_prof_item = new MenuItem(menu, 64);
        remove_from_prof_item.setMenu(remove_from_prof_menu);
        Messages.setLanguageText((Widget)remove_from_prof_item, "MyTorrentsView.menu.sl_remove_from_prof");
        if (common_profiles.isEmpty()) {
            remove_from_prof_item.setEnabled(false);
        } else {
            for (final String p : common_profiles) {
                MenuItem addItem = new MenuItem(remove_from_prof_menu, 8);
                addItem.setText(p);
                addItem.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        slh.removeDownloadsFromProfile(p, dm_hashes);
                        MenuFactory.showText("MainWindow.menu.speed_limits.info.title", MessageText.getString("MainWindow.menu.speed_limits.info.prof", new String[]{p}), slh.getProfile(p));
                    }
                });
            }
        }
    }

    protected static void addTrackerTorrentMenu(Menu menuTracker, DownloadManager[] dms, boolean changeUrl, boolean manualUpdate, boolean allStopped, final boolean use_open_containing_folder) {
        boolean hasSelection = dms.length > 0;
        MenuItem itemChangeTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemChangeTracker, "MyTorrentsView.menu.changeTracker");
        Utils.setMenuItemImage(itemChangeTracker, "add_tracker");
        itemChangeTracker.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager[] dms) {
                if (dms.length > 0) {
                    new TrackerChangerWindow(dms);
                }
            }
        });
        itemChangeTracker.setEnabled(changeUrl);
        MenuItem itemEditTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemEditTracker, "MyTorrentsView.menu.editTracker");
        Utils.setMenuItemImage(itemEditTracker, "edit_trackers");
        itemEditTracker.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager[] dms) {
                HashMap<String, ArrayList<DownloadManager>> same_map = new HashMap<String, ArrayList<DownloadManager>>();
                for (DownloadManager dm : dms) {
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent == null) continue;
                    List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                    String str = "";
                    for (List<String> l : group) {
                        str = str + "[[";
                        for (String s : l) {
                            str = str + s + ", ";
                        }
                    }
                    ArrayList<DownloadManager> dl = (ArrayList<DownloadManager>)same_map.get(str);
                    if (dl == null) {
                        dl = new ArrayList<DownloadManager>();
                        same_map.put(str, dl);
                    }
                    dl.add(dm);
                }
                for (final List set : same_map.values()) {
                    TOTorrent torrent = ((DownloadManager)set.get(0)).getTorrent();
                    List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                    new MultiTrackerEditor(null, null, group, new TrackerEditorListener(){

                        @Override
                        public void trackersChanged(String str, String str2, List<List<String>> group) {
                            for (DownloadManager dm : set) {
                                TOTorrent torrent = dm.getTorrent();
                                TorrentUtils.listToAnnounceGroups(group, torrent);
                                try {
                                    TorrentUtils.writeToFile(torrent);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                if (dm.getTrackerClient() == null) continue;
                                dm.getTrackerClient().resetTrackerUrl(true);
                            }
                        }
                    }, true, true);
                }
            }
        });
        itemEditTracker.setEnabled(hasSelection);
        MenuItem itemEditTrackerMerged = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemEditTrackerMerged, "MyTorrentsView.menu.editTrackerMerge");
        itemEditTrackerMerged.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(final DownloadManager[] dms) {
                ArrayList<List<String>> merged_trackers = new ArrayList<List<String>>();
                HashSet<String> added = new HashSet<String>();
                for (DownloadManager dm : dms) {
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent == null) continue;
                    List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                    for (List<String> set : group) {
                        ArrayList<String> rem = new ArrayList<String>();
                        for (String url_str : set) {
                            try {
                                URL url = new URL(url_str);
                                if (TorrentUtils.isDecentralised(url) || added.contains(url_str)) continue;
                                added.add(url_str);
                                rem.add(url_str);
                            }
                            catch (Throwable e) {}
                        }
                        if (rem.size() <= 0) continue;
                        merged_trackers.add(rem);
                    }
                }
                new MultiTrackerEditor(null, null, merged_trackers, new TrackerEditorListener(){

                    @Override
                    public void trackersChanged(String str, String str2, List<List<String>> group) {
                        for (DownloadManager dm : dms) {
                            TOTorrent torrent = dm.getTorrent();
                            TorrentUtils.listToAnnounceGroups(group, torrent);
                            try {
                                TorrentUtils.writeToFile(torrent);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            if (dm.getTrackerClient() == null) continue;
                            dm.getTrackerClient().resetTrackerUrl(true);
                        }
                    }
                }, true, true);
            }
        });
        itemEditTrackerMerged.setEnabled(dms.length > 1);
        MenuItem itemEditWebSeeds = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemEditWebSeeds, "MyTorrentsView.menu.editWebSeeds");
        itemEditWebSeeds.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(final DownloadManager[] dms) {
                final TOTorrent torrent = dms[0].getTorrent();
                if (torrent == null) {
                    return;
                }
                List getright = this.getURLList(torrent, "url-list");
                List webseeds = this.getURLList(torrent, "httpseeds");
                Map<String, List<Object>> ws = new HashMap<String, List>();
                ws.put("getright", getright);
                ws.put("webseeds", webseeds);
                ws = BDecoder.decodeStrings(ws);
                new WebSeedsEditor(null, ws, new WebSeedsEditorListener(){

                    public void webSeedsChanged(String oldName, String newName, Map ws) {
                        try {
                            ws = BDecoder.decode(BEncoder.encode(ws));
                            List getright = (List)ws.get("getright");
                            if (getright == null || getright.size() == 0) {
                                torrent.removeAdditionalProperty("url-list");
                            } else {
                                torrent.setAdditionalListProperty("url-list", getright);
                            }
                            List webseeds = (List)ws.get("webseeds");
                            if (webseeds == null || webseeds.size() == 0) {
                                torrent.removeAdditionalProperty("httpseeds");
                            } else {
                                torrent.setAdditionalListProperty("httpseeds", webseeds);
                            }
                            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(ExternalSeedPlugin.class);
                            if (pi != null) {
                                ExternalSeedPlugin ext_seed_plugin = (ExternalSeedPlugin)pi.getPlugin();
                                ext_seed_plugin.downloadChanged(PluginCoreUtils.wrap(dms[0]));
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }, true);
            }

            protected List getURLList(TOTorrent torrent, String key) {
                Object obj = torrent.getAdditionalProperty(key);
                if (obj instanceof byte[]) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(obj);
                    return l;
                }
                if (obj instanceof List) {
                    return (List)obj;
                }
                return new ArrayList();
            }
        });
        itemEditWebSeeds.setEnabled(dms.length == 1);
        MenuItem itemManualUpdate = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemManualUpdate, "GeneralView.label.trackerurlupdate");
        itemManualUpdate.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                dm.requestTrackerAnnounce(false);
            }
        });
        itemManualUpdate.setEnabled(manualUpdate);
        boolean scrape_enabled = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Enable");
        boolean scrape_stopped = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Stopped Enable");
        boolean manualScrape = !scrape_enabled || !scrape_stopped && allStopped;
        MenuItem itemManualScrape = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemManualScrape, "GeneralView.label.trackerscrapeupdate");
        itemManualScrape.addListener(13, (Listener)new ListenerDMTask(dms, true, true){

            public void run(DownloadManager dm) {
                dm.requestTrackerScrape(true);
            }
        });
        itemManualScrape.setEnabled(manualScrape);
        MenuItem itemTorrentDL = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemTorrentDL, "MyTorrentsView.menu.torrent.dl");
        itemTorrentDL.addListener(13, (Listener)new ListenerDMTask(dms, false){

            public void run(DownloadManager dm) {
                String content;
                TOTorrent torrent = dm.getTorrent();
                String link = null;
                if (torrent == null) {
                    content = "Torrent not available";
                } else {
                    link = TorrentUtils.getObtainedFrom(torrent);
                    if (link != null) {
                        try {
                            new URL(link);
                        }
                        catch (Throwable e) {
                            link = null;
                        }
                    }
                    if (link != null) {
                        if (link.toLowerCase().startsWith("magnet:")) {
                            link = UrlUtils.getMagnetURI(dm);
                            content = "Torrent's magnet link:\r\n\r\n\t" + link;
                        } else {
                            content = "Torrent was obtained from\r\n\r\n\t" + link;
                        }
                    } else if (TorrentUtils.isReallyPrivate(torrent)) {
                        content = "Origin of torrent unknown and it is private so a magnet URI can't be used - sorry!";
                    } else {
                        link = UrlUtils.getMagnetURI(dm);
                        content = "Origin unavailable but magnet URI may work:\r\n\r\n\t" + link;
                    }
                }
                if (link != null) {
                    ClipboardCopy.copyToClipBoard(link);
                    content = content + "\r\n\r\nLink copied to clipboard";
                }
                TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("MyTorrentsView.menu.torrent.dl") + ": " + dm.getDisplayName(), null, content, false);
            }
        });
        itemTorrentDL.setEnabled(dms.length == 1);
        MenuItem itemTorrentExplore = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemTorrentExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemTorrentExplore.addListener(13, (Listener)new ListenerDMTask(dms, false){

            public void run(DownloadManager dm) {
                ManagerUtils.open(new File(dm.getTorrentFileName()), use_open_containing_folder);
            }
        });
    }

    protected static void moveTorrentFile(Shell shell, DownloadManager[] dms) {
        if (dms != null && dms.length > 0) {
            DirectoryDialog dd = new DirectoryDialog(shell);
            String filter_path = TorrentOpener.getFilterPathTorrent();
            if (filter_path == null || filter_path.trim().length() == 0) {
                filter_path = new File(dms[0].getTorrentFileName()).getParent();
            }
            dd.setFilterPath(filter_path);
            dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
            String path = dd.open();
            if (path != null) {
                File target = new File(path);
                TorrentOpener.setFilterPathTorrent(target.toString());
                for (int i = 0; i < dms.length; ++i) {
                    try {
                        dms[i].moveTorrentFile(target);
                        continue;
                    }
                    catch (Throwable e) {
                        Logger.log(new LogAlert((Object)dms[i], true, "Download torrent move operation failed", e));
                    }
                }
            }
        }
    }

    protected static void moveDataFiles(Shell shell, DownloadManager[] dms) {
        if (dms != null && dms.length > 0) {
            DirectoryDialog dd = new DirectoryDialog(shell);
            dd.setFilterPath(TorrentOpener.getFilterPathData());
            dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
            String path = dd.open();
            if (path != null) {
                TorrentOpener.setFilterPathData(path);
                File target = new File(path);
                for (int i = 0; i < dms.length; ++i) {
                    try {
                        dms[i].moveDataFilesLive(target);
                        continue;
                    }
                    catch (Throwable e) {
                        Logger.log(new LogAlert((Object)dms[i], true, "Download data move operation failed", e));
                    }
                }
            }
        }
    }

    public static void repositionManual(final TableView tv, final DownloadManager[] dms, final Shell shell, final boolean isSeedingView) {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("MyTorrentsView.dialog.setPosition.title", "MyTorrentsView.dialog.setPosition.text");
        entryWindow.prompt(new UIInputReceiverListener(){

            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                int newPosition = -1;
                try {
                    newPosition = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException er) {
                    // empty catch block
                }
                AzureusCore azureus_core = AzureusCoreFactory.getSingleton();
                if (azureus_core == null) {
                    return;
                }
                int size = azureus_core.getGlobalManager().downloadManagerCount(isSeedingView);
                if (newPosition > size) {
                    newPosition = size;
                }
                if (newPosition <= 0) {
                    MessageBox mb = new MessageBox(shell, 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    return;
                }
                TorrentUtil.moveSelectedTorrentsTo(tv, dms, newPosition);
            }
        });
    }

    protected static void addCategorySubMenu(DownloadManager[] dms, Menu menuCategory, final Composite composite) {
        boolean allow_category_selection;
        int i;
        MenuItem[] items = menuCategory.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        boolean bl = allow_category_selection = categories.length > 0;
        if (allow_category_selection) {
            boolean user_category_found = false;
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                user_category_found = true;
                break;
            }
            allow_category_selection = user_category_found;
        }
        if (allow_category_selection) {
            final Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                MenuItem itemCategory = new MenuItem(menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.addListener(13, (Listener)new ListenerDMTask(dms){

                    public void run(DownloadManager dm) {
                        dm.getDownloadState().setCategory(catUncat);
                    }
                });
                new MenuItem(menuCategory, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                Object category = categories[i];
                if (category.getType() != 0) continue;
                MenuItem itemCategory = new MenuItem(menuCategory, 8);
                itemCategory.setText(category.getName());
                itemCategory.addListener(13, (Listener)new ListenerDMTask(dms, (Category)category){
                    final /* synthetic */ Category val$category;
                    {
                        this.val$category = category;
                        super(x0);
                    }

                    public void run(DownloadManager dm) {
                        dm.getDownloadState().setCategory(this.val$category);
                    }
                });
            }
            new MenuItem(menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, (Listener)new ListenerDMTask(dms){

            public void run(DownloadManager[] dms) {
                CategoryAdderWindow adderWindow = new CategoryAdderWindow(composite.getDisplay());
                Category newCategory = adderWindow.getNewCategory();
                if (newCategory != null) {
                    TorrentUtil.assignToCategory(dms, newCategory);
                }
            }
        });
    }

    private static void moveSelectedTorrentsTo(TableView tv, DownloadManager[] dms, int iNewPos) {
        if (dms == null || dms.length == 0) {
            return;
        }
        TableColumnCore sortColumn = tv == null ? null : tv.getSortColumn();
        boolean isSortAscending = sortColumn == null ? true : sortColumn.isSortAscending();
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = dms[i];
            int iOldPos = dm.getPosition();
            dm.getGlobalManager().moveTo(dm, iNewPos);
            if (isSortAscending) {
                if (iOldPos <= iNewPos) continue;
                ++iNewPos;
                continue;
            }
            if (iOldPos >= iNewPos) continue;
            --iNewPos;
        }
        if (tv != null) {
            boolean bForceSort = sortColumn.getName().equals("#");
            tv.columnInvalidate("#");
            tv.refreshTable(bForceSort);
        }
    }

    protected static void changeDirSelectedTorrents(DownloadManager[] dms, Shell shell) {
        File f;
        if (dms.length <= 0) {
            return;
        }
        String sDefPath = COConfigurationManager.getStringParameter("Default save path");
        if (sDefPath.length() > 0 && !(f = new File(sDefPath)).exists()) {
            FileUtil.mkdirs(f);
        }
        DirectoryDialog dDialog = new DirectoryDialog(shell, 131072);
        dDialog.setFilterPath(sDefPath);
        dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath"));
        String sSavePath = dDialog.open();
        if (sSavePath != null) {
            File fSavePath = new File(sSavePath);
            for (int i = 0; i < dms.length; ++i) {
                String parentPath;
                DownloadManager dm = dms[i];
                int state = dm.getState();
                if (state != 100 && !dm.filesExist(true)) {
                    state = 100;
                }
                if (state != 100) continue;
                dm.setTorrentSaveDir(sSavePath);
                boolean found = dm.filesExist(true);
                if (!found && dm.getTorrent() != null && !dm.getTorrent().isSimpleTorrent() && (parentPath = fSavePath.getParent()) != null) {
                    dm.setTorrentSaveDir(parentPath);
                    found = dm.filesExist(true);
                    if (!found) {
                        dm.setTorrentSaveDir(sSavePath);
                    }
                }
                if (!found) continue;
                dm.stopIt(70, false, false);
                ManagerUtils.queue(dm, (Composite)shell);
            }
        }
    }

    public static void runDataSources(Object[] datasources) {
        for (int i = datasources.length - 1; i >= 0; --i) {
            Object ds = PluginCoreUtils.convert(datasources[i], true);
            if (ds instanceof DownloadManager) {
                DownloadManager dm = (DownloadManager)ds;
                ManagerUtils.run(dm);
                continue;
            }
            if (!(ds instanceof DiskManagerFileInfo)) continue;
            DiskManagerFileInfo info = (DiskManagerFileInfo)ds;
            Utils.launch(info);
        }
    }

    public static void hostTorrents(Object[] download_managers) {
        ListenerDMTask task2 = new ListenerDMTask(TorrentUtil.toDMS(download_managers), true, true){

            public void run(DownloadManager dm) {
                ManagerUtils.host(AzureusCoreFactory.getSingleton(), dm);
            }
        };
        task2.go();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.getMDI().showEntryByID("MyTrackerView");
        }
    }

    public static void publishTorrents(Object[] download_managers) {
        ListenerDMTask task2 = new ListenerDMTask(TorrentUtil.toDMS(download_managers), true, true){

            public void run(DownloadManager dm) {
                ManagerUtils.publish(AzureusCoreFactory.getSingleton(), dm);
            }
        };
        task2.go();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.getMDI().showEntryByID("MyTrackerView");
        }
    }

    public static void removeDataSources(Object[] datasources) {
        DownloadStub.DownloadStubEx[] stubs;
        DownloadManager[] dms = TorrentUtil.toDMS(datasources);
        TorrentUtil.removeDownloads(dms, null);
        Object[] fileInfos = TorrentUtil.toDMFI(datasources);
        if (fileInfos.length > 0) {
            FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_DELETE, fileInfos);
        }
        if ((stubs = TorrentUtil.toDownloadStubs(datasources)).length > 0) {
            TorrentUtil.removeDownloadStubs(stubs, null, false);
        }
    }

    public static boolean shouldStopGroup(Object[] datasources) {
        DownloadManager[] dms = TorrentUtil.toDMS(datasources);
        DiskManagerFileInfo[] dmfi = TorrentUtil.toDMFI(datasources);
        if (dms.length == 0 && dmfi.length == 0) {
            return true;
        }
        for (DownloadManager dm : dms) {
            boolean stopped;
            int state = dm.getState();
            boolean bl = stopped = state == 70 || state == 65;
            if (stopped) continue;
            return true;
        }
        for (DiskManagerFileInfo fileInfo2 : dmfi) {
            if (fileInfo2.isSkipped()) continue;
            return true;
        }
        return false;
    }

    public static void stopOrStartDataSources(Object[] datasources) {
        DownloadManager[] dms = TorrentUtil.toDMS(datasources);
        DiskManagerFileInfo[] dmfi = TorrentUtil.toDMFI(datasources);
        if (dms.length == 0 && dmfi.length == 0) {
            return;
        }
        boolean doStop = TorrentUtil.shouldStopGroup(datasources);
        if (doStop) {
            TorrentUtil.stopDataSources(datasources);
        } else {
            TorrentUtil.queueDataSources(datasources, true);
        }
    }

    public static void stopDataSources(Object[] datasources) {
        DownloadManager[] dms;
        for (DownloadManager dm : dms = TorrentUtil.toDMS(datasources)) {
            ManagerUtils.stop(dm, null);
        }
        Object[] fileInfos = TorrentUtil.toDMFI(datasources);
        if (fileInfos.length > 0) {
            FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_SKIPPED, fileInfos);
        }
    }

    public static void pauseDataSources(Object[] datasources) {
        DownloadManager[] dms;
        for (DownloadManager dm : dms = TorrentUtil.toDMS(datasources)) {
            ManagerUtils.pause(dm, null);
        }
    }

    public static void queueDataSources(Object[] datasources, boolean startStoppedParents) {
        DownloadManager[] dms;
        for (DownloadManager dm : dms = TorrentUtil.toDMS(datasources)) {
            ManagerUtils.queue(dm, null);
        }
        Object[] fileInfos = TorrentUtil.toDMFI(datasources);
        if (fileInfos.length > 0) {
            FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_NORMAL, fileInfos);
            if (startStoppedParents) {
                for (Object fileInfo2 : fileInfos) {
                    if (fileInfo2.getDownloadManager().getState() != 70) continue;
                    ManagerUtils.queue(fileInfo2.getDownloadManager(), null);
                }
            }
        }
    }

    public static void resumeTorrents(Object[] download_managers) {
        ListenerDMTask task2 = new ListenerDMTask(TorrentUtil.toDMS(download_managers)){

            public void run(DownloadManager dm) {
                ManagerUtils.start(dm);
            }
        };
        task2.go();
    }

    public static void assignToCategory(Object[] download_managers, final Category category) {
        ListenerDMTask task2 = new ListenerDMTask(TorrentUtil.toDMS(download_managers)){

            public void run(DownloadManager dm) {
                dm.getDownloadState().setCategory(category);
            }
        };
        task2.go();
    }

    public static void promptUserForComment(final DownloadManager[] dms) {
        if (dms.length == 0) {
            return;
        }
        DownloadManager dm = dms[0];
        String suggested = dm.getDownloadState().getUserComment();
        String msg_key_prefix = "MyTorrentsView.menu.edit_comment.enter.";
        SimpleTextEntryWindow text_entry = new SimpleTextEntryWindow();
        text_entry.setTitle(msg_key_prefix + "title");
        text_entry.setMessage(msg_key_prefix + "message");
        text_entry.setPreenteredText(suggested, false);
        text_entry.setMultiLine(true);
        text_entry.prompt(new UIInputReceiverListener(){

            public void UIInputReceiverClosed(UIInputReceiver text_entry) {
                if (text_entry.hasSubmittedInput()) {
                    String value = text_entry.getSubmittedInput();
                    final String value_to_set = value.length() == 0 ? null : value;
                    ListenerDMTask task2 = new ListenerDMTask(dms){

                        public void run(DownloadManager dm) {
                            dm.getDownloadState().setUserComment(value_to_set);
                        }
                    };
                    task2.go();
                }
            }
        });
    }

    private static DownloadManager[] toDMS(Object[] objects) {
        int count = 0;
        DownloadManager[] result = new DownloadManager[objects.length];
        for (Object object : objects) {
            SelectedContent sc;
            if (object instanceof DownloadManager) {
                DownloadManager dm = (DownloadManager)object;
                result[count++] = dm;
                continue;
            }
            if (!(object instanceof SelectedContent) || (sc = (SelectedContent)object).getFileIndex() != -1 || sc.getDownloadManager() == null) continue;
            result[count++] = sc.getDownloadManager();
        }
        DownloadManager[] resultTrim = new DownloadManager[count];
        System.arraycopy(result, 0, resultTrim, 0, count);
        return resultTrim;
    }

    private static DownloadStub.DownloadStubEx[] toDownloadStubs(Object[] objects) {
        ArrayList<DownloadStub.DownloadStubEx> result = new ArrayList<DownloadStub.DownloadStubEx>(objects.length);
        for (Object o : objects) {
            if (!(o instanceof DownloadStub.DownloadStubEx)) continue;
            result.add((DownloadStub.DownloadStubEx)o);
        }
        return result.toArray(new DownloadStub.DownloadStubEx[result.size()]);
    }

    private static DiskManagerFileInfo[] toDMFI(Object[] objects) {
        int count = 0;
        DiskManagerFileInfo[] result = new DiskManagerFileInfo[objects.length];
        for (Object object : objects) {
            DiskManagerFileInfo[] infos;
            DownloadManager dm;
            SelectedContent sc;
            int fileIndex;
            if (object instanceof DiskManagerFileInfo) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)object;
                result[count++] = fileInfo2;
                continue;
            }
            if (!(object instanceof SelectedContent) || (fileIndex = (sc = (SelectedContent)object).getFileIndex()) < 0 || sc.getDownloadManager() == null || (dm = sc.getDownloadManager()) == null || fileIndex >= (infos = dm.getDiskManagerFileInfo()).length) continue;
            result[count++] = infos[fileIndex];
        }
        DiskManagerFileInfo[] resultTrim = new DiskManagerFileInfo[count];
        System.arraycopy(result, 0, resultTrim, 0, count);
        return resultTrim;
    }

    public static boolean isFileTorrent(File torrentFile, String torrentName, boolean warnOnError) {
        String sFirstChunk = null;
        try {
            sFirstChunk = FileUtil.readFileAsString(torrentFile, 16384).toLowerCase();
            try {
                if (!sFirstChunk.startsWith("d")) {
                    sFirstChunk = FileUtil.readGZippedFileAsString(torrentFile, 16384).toLowerCase();
                }
            }
            catch (Throwable e) {}
        }
        catch (IOException e) {
            Debug.out("warning", e);
        }
        if (sFirstChunk == null) {
            sFirstChunk = "";
        }
        if (!sFirstChunk.startsWith("d")) {
            boolean isHTML = sFirstChunk.indexOf("<html") >= 0;
            String retry_url = UrlUtils.parseTextForMagnets(torrentName);
            if (retry_url == null) {
                retry_url = UrlUtils.parseTextForMagnets(sFirstChunk);
            }
            if (retry_url != null) {
                TorrentOpener.openTorrent(retry_url);
                return false;
            }
            if (warnOnError) {
                String[] buttons = new String[]{MessageText.getString("Button.ok")};
                MessageBoxShell boxShell = new MessageBoxShell(MessageText.getString("OpenTorrentWindow.mb.notTorrent.title"), MessageText.getString("OpenTorrentWindow.mb.notTorrent.text", new String[]{torrentName, isHTML ? "" : MessageText.getString("OpenTorrentWindow.mb.notTorrent.cannot.display")}), buttons, 0);
                if (isHTML) {
                    boxShell.setHtml(sFirstChunk);
                }
                boxShell.open(null);
            }
            return false;
        }
        return true;
    }

    public static Map<String, Long> calculateToolbarStates(ISelectedContent[] currentContent, String viewID_unused) {
        TableColumn tc;
        int i;
        boolean canRun;
        MdiEntrySWT entry;
        MultipleDocumentInterfaceSWT mdi;
        boolean hasRealDM;
        HashMap<String, Long> mapNewToolbarStates = new HashMap<String, Long>();
        String[] itemsNeedingSelection = new String[]{};
        String[] itemsNeedingRealDMSelection = new String[]{"remove", "top", "bottom", "transcode", "startstop"};
        String[] itemsRequiring1DMwithHash = new String[]{"details", "comment", "up", "down"};
        String[] itemsRequiring1DMSelection = new String[]{};
        int numSelection = currentContent.length;
        boolean hasSelection = numSelection > 0;
        boolean has1Selection = numSelection == 1;
        for (int i2 = 0; i2 < itemsNeedingSelection.length; ++i2) {
            String itemID = itemsNeedingSelection[i2];
            mapNewToolbarStates.put(itemID, hasSelection ? 1L : 0L);
        }
        TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
        boolean bl = hasRealDM = tv != null;
        if (!hasRealDM && numSelection > 0) {
            hasRealDM = true;
            for (int i3 = 0; i3 < currentContent.length; ++i3) {
                ISelectedContent content = currentContent[i3];
                DownloadManager dm = content.getDownloadManager();
                if (dm != null) continue;
                hasRealDM = false;
                break;
            }
        }
        if (!hasRealDM && (mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT()) != null && (entry = mdi.getCurrentEntrySWT()) != null) {
            if (entry.getDatasource() instanceof DownloadManager) {
                hasRealDM = true;
            } else if (entry instanceof UIPluginView && entry.getDataSource() instanceof DownloadManager) {
                hasRealDM = true;
            }
        }
        boolean canStart = false;
        boolean canStop = false;
        boolean canRemoveFileInfo = false;
        boolean canRunFileInfo = false;
        boolean hasDM = false;
        if (currentContent.length > 0 && hasRealDM) {
            boolean canMoveUp = false;
            boolean canMoveDown = false;
            boolean canDownload = false;
            GlobalManager gm = null;
            for (int i4 = 0; i4 < currentContent.length; ++i4) {
                int storageType;
                int fileIndex;
                ISelectedContent content = currentContent[i4];
                DownloadManager dm = content.getDownloadManager();
                if (dm == null) {
                    if (canDownload || content.getDownloadInfo() == null) continue;
                    canDownload = true;
                    continue;
                }
                if (gm == null) {
                    gm = dm.getGlobalManager();
                }
                if ((fileIndex = content.getFileIndex()) == -1) {
                    if (!canMoveUp && gm.isMoveableUp(dm)) {
                        canMoveUp = true;
                    }
                    if (!canMoveDown && gm.isMoveableDown(dm)) {
                        canMoveDown = true;
                    }
                    hasDM = true;
                    if (!canStart && ManagerUtils.isStartable(dm)) {
                        canStart = true;
                    }
                    if (canStop || !ManagerUtils.isStopable(dm)) continue;
                    canStop = true;
                    continue;
                }
                DiskManagerFileInfoSet fileInfos = dm.getDiskManagerFileInfoSet();
                if (fileIndex >= fileInfos.nbFiles()) continue;
                DiskManagerFileInfo fileInfo2 = fileInfos.getFiles()[fileIndex];
                if (!canStart && fileInfo2.isSkipped()) {
                    canStart = true;
                }
                if (!canStop && !fileInfo2.isSkipped()) {
                    canStop = true;
                }
                if (!(canRemoveFileInfo || fileInfo2.isSkipped() || (storageType = fileInfo2.getStorageType()) != 1 && storageType != 2)) {
                    canRemoveFileInfo = true;
                }
                if (canRunFileInfo || fileInfo2.getAccessMode() != 1 || fileInfo2.getDownloaded() != fileInfo2.getLength() || !fileInfo2.getFile(true).exists()) continue;
                canRunFileInfo = true;
            }
            boolean canRemove = hasDM || canRemoveFileInfo;
            mapNewToolbarStates.put("remove", canRemove ? 1L : 0L);
            mapNewToolbarStates.put("download", canDownload ? 1L : 0L);
            if (currentContent.length == 1) {
                mapNewToolbarStates.put("up", canMoveUp ? 1L : 0L);
                mapNewToolbarStates.put("down", canMoveDown ? 1L : 0L);
            }
        }
        boolean bl2 = canRun = has1Selection && (hasDM && !canRunFileInfo || !hasDM && canRunFileInfo);
        if (canRun) {
            ISelectedContent content = currentContent[0];
            DownloadManager dm = content.getDownloadManager();
            if (dm == null) {
                canRun = false;
            } else {
                TOTorrent torrent = dm.getTorrent();
                if (torrent == null) {
                    canRun = false;
                } else if (!dm.getAssumedComplete() && torrent.isSimpleTorrent()) {
                    canRun = false;
                }
            }
        }
        mapNewToolbarStates.put("run", canRun ? 1L : 0L);
        mapNewToolbarStates.put("start", canStart ? 1L : 0L);
        mapNewToolbarStates.put("stop", canStop ? 1L : 0L);
        mapNewToolbarStates.put("startstop", canStart || canStop ? 1L : 0L);
        for (i = 0; i < itemsNeedingRealDMSelection.length; ++i) {
            String itemID = itemsNeedingRealDMSelection[i];
            if (mapNewToolbarStates.containsKey(itemID)) continue;
            mapNewToolbarStates.put(itemID, hasSelection && hasDM && hasRealDM ? 1L : 0L);
        }
        for (i = 0; i < itemsRequiring1DMSelection.length; ++i) {
            String itemID = itemsRequiring1DMSelection[i];
            if (mapNewToolbarStates.containsKey(itemID)) continue;
            mapNewToolbarStates.put(itemID, has1Selection && hasDM ? 1L : 0L);
        }
        for (i = 0; i < itemsRequiring1DMwithHash.length; ++i) {
            String itemID = itemsRequiring1DMwithHash[i];
            if (mapNewToolbarStates.containsKey(itemID)) continue;
            mapNewToolbarStates.put(itemID, hasDM ? 1L : 0L);
        }
        mapNewToolbarStates.put("download", has1Selection && !(currentContent[0] instanceof ISelectedVuzeFileContent) && currentContent[0].getDownloadManager() == null && (currentContent[0].getHash() != null || currentContent[0].getDownloadInfo() != null) ? 1L : 0L);
        if (tv != null && (tc = tv.getTableColumn("#")) != null && !tc.isVisible()) {
            mapNewToolbarStates.put("up", 0L);
            mapNewToolbarStates.put("down", 0L);
        }
        return mapNewToolbarStates;
    }

    public static void removeDownloads(DownloadManager[] dms, AERunnable deleteFailed) {
        TorrentUtil.removeDownloads(dms, deleteFailed, false);
    }

    public static void removeDownloads(final DownloadManager[] dms, final AERunnable deleteFailed, boolean forcePrompt) {
        DownloadManager dm;
        int i;
        if (dms == null) {
            return;
        }
        boolean can_archive = false;
        for (i = 0; i < dms.length; ++i) {
            dm = dms[i];
            if (dm == null || !PluginCoreUtils.wrap(dm).canStubbify()) continue;
            can_archive = true;
        }
        for (i = 0; i < dms.length; ++i) {
            dm = dms[i];
            if (dm == null) continue;
            boolean deleteTorrent = COConfigurationManager.getBooleanParameter("def.deletetorrent");
            int confirm = COConfigurationManager.getIntParameter("tb.confirm.delete.content");
            boolean doPrompt = confirm == 0 | forcePrompt;
            if (doPrompt) {
                String title = MessageText.getString("deletedata.title");
                String text = MessageText.getString("v3.deleteContent.message", new String[]{dm.getDisplayName()});
                if (can_archive) {
                    text = text + "\n\n" + MessageText.getString("v3.deleteContent.or.archive");
                }
                String[] buttons = new String[]{MessageText.getString("Button.cancel"), MessageText.getString("Button.deleteContent.fromComputer"), MessageText.getString("Button.deleteContent.fromLibrary")};
                int defaultButtonPos = 2;
                final MessageBoxShell mb = new MessageBoxShell(title, text, buttons, defaultButtonPos);
                int numLeft = dms.length - i;
                if (numLeft > 1) {
                    mb.setRemember("na", false, MessageText.getString("v3.deleteContent.applyToAll", new String[]{"" + numLeft}));
                    mb.setRememberOnlyIfButton(-3);
                }
                mb.setRelatedObject(dm);
                mb.setLeftImage("image.trash");
                mb.addCheckBox("deletecontent.also.deletetorrent", 2, deleteTorrent);
                final int index = i;
                mb.open(new UserPrompterResultListener(){

                    public void prompterClosed(int result) {
                        ImageLoader.getInstance().releaseImage("image.trash");
                        TorrentUtil.removeDownloadsPrompterClosed(dms, index, deleteFailed, result, mb.isRemembered(), mb.getCheckBoxEnabled());
                    }
                });
                return;
            }
            boolean deleteData = confirm == 1;
            TorrentUtil.removeDownloadsPrompterClosed(dms, i, deleteFailed, deleteData ? 1 : 2, true, deleteTorrent);
        }
    }

    private static void removeDownloadsPrompterClosed(DownloadManager[] dms, int index, AERunnable deleteFailed, int result, boolean doAll, boolean deleteTorrent) {
        if (result == -1) {
            return;
        }
        if (doAll) {
            if (result == 1 || result == 2) {
                for (int i = index; i < dms.length; ++i) {
                    DownloadManager dm = dms[i];
                    boolean deleteData = result == 2 ? false : !dm.getDownloadState().getFlag(64L);
                    ManagerUtils.asyncStopDelete(dm, 70, deleteTorrent, deleteData, deleteFailed);
                }
            }
        } else {
            if (result == 1 || result == 2) {
                DownloadManager dm = dms[index];
                boolean deleteData = result == 2 ? false : !dm.getDownloadState().getFlag(64L);
                ManagerUtils.asyncStopDelete(dm, 70, deleteTorrent, deleteData, null);
            }
            dms[index] = null;
            if (index != dms.length - 1) {
                TorrentUtil.removeDownloads(dms, deleteFailed, true);
            }
        }
    }

    public static void removeDownloadStubs(final DownloadStub.DownloadStubEx[] dms, final AERunnable deleteFailed, boolean forcePrompt) {
        if (dms == null) {
            return;
        }
        for (int i = 0; i < dms.length; ++i) {
            DownloadStub.DownloadStubEx dm = dms[i];
            boolean deleteTorrent = COConfigurationManager.getBooleanParameter("def.deletetorrent");
            int confirm = COConfigurationManager.getIntParameter("tb.confirm.delete.content");
            boolean doPrompt = confirm == 0 | forcePrompt;
            if (doPrompt) {
                String title = MessageText.getString("deletedata.title");
                String text = MessageText.getString("v3.deleteContent.message", new String[]{dm.getName()});
                String[] buttons = new String[]{MessageText.getString("Button.cancel"), MessageText.getString("Button.deleteContent.fromComputer"), MessageText.getString("Button.deleteContent.fromLibrary")};
                int defaultButtonPos = 2;
                final MessageBoxShell mb = new MessageBoxShell(title, text, buttons, defaultButtonPos);
                int numLeft = dms.length - i;
                if (numLeft > 1) {
                    mb.setRemember("na", false, MessageText.getString("v3.deleteContent.applyToAll", new String[]{"" + numLeft}));
                    mb.setRememberOnlyIfButton(-3);
                }
                mb.setRelatedObject(dm);
                mb.setLeftImage("image.trash");
                mb.addCheckBox("deletecontent.also.deletetorrent", 2, deleteTorrent);
                final int index = i;
                mb.open(new UserPrompterResultListener(){

                    public void prompterClosed(int result) {
                        ImageLoader.getInstance().releaseImage("image.trash");
                        TorrentUtil.removeDownloadStubsPrompterClosed(dms, index, deleteFailed, result, mb.isRemembered(), mb.getCheckBoxEnabled());
                    }
                });
                return;
            }
            boolean deleteData = confirm == 1;
            TorrentUtil.removeDownloadStubsPrompterClosed(dms, i, deleteFailed, deleteData ? 1 : 2, true, deleteTorrent);
        }
    }

    private static void removeDownloadStubsPrompterClosed(DownloadStub.DownloadStubEx[] dms, int index, AERunnable deleteFailed, int result, boolean doAll, boolean deleteTorrent) {
        if (result == -1) {
            return;
        }
        if (doAll) {
            if (result == 1 || result == 2) {
                for (int i = index; i < dms.length; ++i) {
                    DownloadStub.DownloadStubEx dm = dms[i];
                    boolean deleteData = result != 2;
                    try {
                        dm.remove(deleteTorrent, deleteData);
                        continue;
                    }
                    catch (Throwable e) {
                        if (deleteFailed == null) continue;
                        deleteFailed.runSupport();
                    }
                }
            }
        } else {
            if (result == 1 || result == 2) {
                DownloadStub.DownloadStubEx dm = dms[index];
                boolean deleteData = result != 2;
                try {
                    dm.remove(deleteTorrent, deleteData);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            dms[index] = null;
            if (index != dms.length - 1) {
                TorrentUtil.removeDownloadStubs(dms, deleteFailed, true);
            }
        }
    }
}

