/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.core.util.HTTPUtils;
import com.aelitis.azureus.core.util.LaunchManager;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.webplugin.WebPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerUtils {
    private static RunDownloadManager run;
    private static Map<DownloadManager, WebPlugin> browse_plugins;
    private static AsyncDispatcher async;

    public static void setRunRunnable(RunDownloadManager run) {
        ManagerUtils.run = run;
    }

    public static void run(final DownloadManager dm) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    AZ3Functions.provider prov = AZ3Functions.getProvider();
                    if (prov != null) {
                        prov.setOpened(dm, true);
                    }
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            if (run != null) {
                                run.run(dm);
                            } else {
                                Utils.launch(dm.getSaveLocation().toString());
                            }
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(DownloadManager dm) {
        ManagerUtils.open(dm, false);
    }

    public static void open(final DownloadManager dm, final boolean open_containing_folder_mode) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            ManagerUtils.open(dm.getSaveLocation(), open_containing_folder_mode);
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(final DiskManagerFileInfo file, final boolean open_containing_folder_mode) {
        if (file != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(file);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            File this_file = file.getFile(true);
                            File parent_file = open_containing_folder_mode ? this_file.getParentFile() : null;
                            ManagerUtils.open(parent_file == null ? this_file : parent_file);
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(File f, boolean open_containing_folder_mode) {
        if (open_containing_folder_mode) {
            Utils.launch(f.getParent());
        } else {
            ManagerUtils.open(f);
        }
    }

    public static void open(File f) {
        while (f != null && !f.exists()) {
            f = f.getParentFile();
        }
        if (f == null) {
            return;
        }
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            try {
                PlatformManagerFactory.getPlatformManager().showFile(f.toString());
                return;
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
        if (f.isDirectory()) {
            Utils.launch(f.toString());
        } else {
            Utils.launch(f.getParent().toString());
        }
    }

    private static boolean getBrowseAnon(DownloadManager dm) {
        boolean anon = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserAnon");
        if (!anon) {
            String[] nets;
            boolean found_pub = false;
            for (String net : nets = dm.getDownloadState().getNetworks()) {
                if (net != "Public") continue;
                found_pub = true;
                break;
            }
            if (nets.length > 0 && !found_pub) {
                anon = true;
            }
        }
        return anon;
    }

    private static DiskManagerFileInfo getBrowseHomePage(DownloadManager dm) {
        try {
            DiskManagerFileInfo[] files;
            for (DiskManagerFileInfo file : files = dm.getDiskManagerFileInfoSet().getFiles()) {
                String name;
                if (file.getTorrentFile().getPathComponents().length != 1 || !(name = file.getTorrentFile().getRelativePath().toLowerCase(Locale.US)).equals("index.html") && !name.equals("index.htm")) continue;
                return file;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return null;
    }

    public static boolean browseWebsite(DiskManagerFileInfo file) {
        try {
            String name = file.getTorrentFile().getRelativePath().toLowerCase(Locale.US);
            if (name.equals("index.html") || name.equals("index.htm")) {
                ManagerUtils.browse(file);
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    public static boolean browseWebsite(DownloadManager dm) {
        DiskManagerFileInfo file = ManagerUtils.getBrowseHomePage(dm);
        if (file != null) {
            ManagerUtils.browse(file);
            return true;
        }
        return false;
    }

    public static String browse(DiskManagerFileInfo file) {
        boolean anon = ManagerUtils.getBrowseAnon(file.getDownloadManager());
        return ManagerUtils.browse(file, anon, true);
    }

    public static String browse(DiskManagerFileInfo file, boolean anon, boolean launch) {
        return ManagerUtils.browse(file.getDownloadManager(), file, anon, launch);
    }

    public static String browse(DownloadManager dm) {
        boolean anon = ManagerUtils.getBrowseAnon(dm);
        return ManagerUtils.browse(dm, null, anon, true);
    }

    public static String browse(DownloadManager dm, boolean anon, boolean launch) {
        return ManagerUtils.browse(dm, null, anon, launch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String browse(final DownloadManager dm, DiskManagerFileInfo _file, final boolean anon, final boolean launch) {
        String url_suffix;
        DiskManagerFileInfo file;
        Properties props = new Properties();
        File save_location = dm.getSaveLocation();
        String root_dir = save_location.isFile() ? save_location.getParentFile().getAbsolutePath() : save_location.getAbsolutePath();
        boolean always_browse = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList");
        if (!always_browse && _file == null) {
            _file = ManagerUtils.getBrowseHomePage(dm);
        }
        if ((file = _file) == null) {
            url_suffix = "";
        } else {
            String relative_path = file.getTorrentFile().getRelativePath();
            String[] bits = relative_path.replace(File.separatorChar, '/').split("/");
            String _url_suffix = "";
            int bits_to_use = always_browse ? bits.length - 1 : bits.length;
            for (int i = 0; i < bits_to_use; ++i) {
                String bit = bits[i];
                if (bit.length() == 0) continue;
                _url_suffix = _url_suffix + (_url_suffix == "" ? "" : "/") + UrlUtils.encode(bit);
            }
            url_suffix = _url_suffix;
        }
        Map<DownloadManager, WebPlugin> map = browse_plugins;
        synchronized (map) {
            WebPlugin plugin = browse_plugins.get(dm);
            if (plugin == null) {
                props.put("Port", (Object)0);
                props.put("Bind IP", "127.0.0.1");
                props.put("Home Page", "");
                props.put("Root Dir", root_dir);
                props.put("Access", "local");
                props.put("DefaultHideResourceConfig", (Object)true);
                props.put("DefaultEnableKeepAlive", (Object)true);
                props.put("EnablePairing", (Object)false);
                props.put("EnableUPNP", (Object)false);
                props.put("EnableI2P", (Object)false);
                props.put("EnableTor", (Object)false);
                String plugin_id = "webserver:" + dm.getInternalName();
                final String plugin_name = "Web Server for " + dm.getDisplayName();
                Properties messages = new Properties();
                messages.put("plugins." + plugin_id, plugin_name);
                PluginInitializer.getDefaultInterface().getUtilities().getLocaleUtilities().integrateLocalisedMessageBundle(messages);
                final AESemaphore waiter = new AESemaphore("waiter");
                final String[] url_holder = new String[]{null};
                plugin = new UnloadableWebPlugin(props){
                    private Map<String, Object> file_map;
                    private String host;
                    {
                        super(x0);
                        this.file_map = new HashMap<String, Object>();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void initialize(PluginInterface plugin_interface) throws PluginException {
                        DiskManagerFileInfoSet file_set = dm.getDiskManagerFileInfoSet();
                        DiskManagerFileInfo[] files = file_set.getFiles();
                        HashSet<Object> root_dir = new HashSet<Object>();
                        this.file_map.put("", root_dir);
                        for (DiskManagerFileInfo dm_file : files) {
                            TOTorrentFile file2 = dm_file.getTorrentFile();
                            String path = file2.getRelativePath();
                            this.file_map.put(path, dm_file);
                            if (path.startsWith(File.separator)) {
                                path = path.substring(1);
                            }
                            Set<Object> dir = root_dir;
                            int pos = 0;
                            while (true) {
                                int next_pos;
                                if ((next_pos = path.indexOf(File.separatorChar, pos)) == -1) break;
                                String bit = path.substring(pos, next_pos);
                                dir.add(bit);
                                String sub_path = path.substring(0, next_pos);
                                dir = (Set)this.file_map.get(sub_path);
                                if (dir == null) {
                                    dir = new HashSet();
                                    this.file_map.put(sub_path, dir);
                                }
                                pos = next_pos + 1;
                            }
                            dir.add(dm_file);
                        }
                        Properties props = plugin_interface.getPluginProperties();
                        props.put("plugin.name", plugin_name);
                        super.initialize(plugin_interface);
                        InetAddress bind_ip = this.getServerBindIP();
                        this.host = bind_ip.isAnyLocalAddress() ? "127.0.0.1" : bind_ip.getHostAddress();
                        int port = this.getServerPort();
                        this.log("Assigned port: " + port);
                        String protocol = this.getProtocol();
                        String url = protocol + "://" + this.host + ":" + port + "/" + url_suffix;
                        if (launch) {
                            Utils.launch(url, false, true, anon);
                            return;
                        }
                        String[] stringArray = url_holder;
                        synchronized (url_holder) {
                            url_holder[0] = url;
                            // ** MonitorExit[var10_11] (shouldn't be in output)
                            waiter.release();
                            return;
                        }
                    }

                    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
                        try {
                            boolean res = super.generate(request2, response);
                            if (!res) {
                                response.setReplyStatus(404);
                            }
                        }
                        catch (Throwable e) {
                            response.setReplyStatus(404);
                        }
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    protected boolean useFile(TrackerWebPageRequest request2, final TrackerWebPageResponse response, String root, String relative_url) throws IOException {
                        String file_type;
                        long file_size;
                        DiskManagerFileInfo dm_file;
                        block42: {
                            block43: {
                                int len;
                                URL stream_url;
                                boolean done;
                                URL absolute_url = request2.getAbsoluteURL();
                                String path = absolute_url.getPath();
                                if (path.equals("/") && COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList")) {
                                    relative_url = "/";
                                }
                                String download_name = XUXmlWriter.escapeXML(dm.getDisplayName());
                                String relative_file = relative_url.replace('/', File.separatorChar);
                                String node_key = relative_file.substring(1);
                                Object file_node = this.file_map.get(node_key);
                                boolean file_node_is_parent = false;
                                if (file_node == null) {
                                    int pos = node_key.lastIndexOf(File.separator);
                                    node_key = pos == -1 ? "" : node_key.substring(0, pos);
                                    file_node = this.file_map.get(node_key);
                                    file_node_is_parent = true;
                                }
                                if (file_node == null) {
                                    return false;
                                }
                                if (file_node instanceof Set) {
                                    String file_name;
                                    Set kids = (Set)file_node;
                                    String request_url = request2.getURL();
                                    if (file_node_is_parent) {
                                        int pos = request_url.lastIndexOf("/");
                                        request_url = pos == -1 ? "" : request_url.substring(0, pos);
                                    }
                                    response.setContentType("text/html");
                                    OutputStream os = response.getOutputStream();
                                    String NL = "\r\n";
                                    String title = XUXmlWriter.escapeXML(UrlUtils.decode(request_url));
                                    if (title.length() == 0) {
                                        title = "/";
                                    }
                                    os.write(("<html>" + NL + " <head>" + NL + " <meta charset=\"UTF-8\">" + NL + "  <title>" + download_name + ": Index of " + title + "</title>" + NL + " </head>" + NL + " <body>" + NL + "  <p>" + download_name + "</p>" + NL + "  <h1>Index of " + title + "</h1>" + NL + "  <pre><hr>" + NL).getBytes("UTF-8"));
                                    String root_url = request_url;
                                    if (!root_url.endsWith("/")) {
                                        root_url = root_url + "/";
                                    }
                                    if (request_url.length() > 1) {
                                        int pos = request_url.lastIndexOf(47);
                                        if (pos == 0) {
                                            ++pos;
                                        }
                                        String parent = request_url.substring(0, pos);
                                        os.write(("<a href=\"" + parent + "\">..</a>" + NL).getBytes("UTF-8"));
                                    }
                                    ArrayList<String[]> filenames = new ArrayList<String[]>(kids.size());
                                    int max_filename = 0;
                                    int MAX_LEN = 120;
                                    for (Object entry : kids) {
                                        int len2;
                                        DiskManagerFileInfo file2;
                                        if (entry instanceof String) {
                                            file2 = null;
                                            file_name = (String)entry;
                                        } else {
                                            file2 = (DiskManagerFileInfo)entry;
                                            if (file2.isSkipped()) continue;
                                            file_name = file2.getTorrentFile().getRelativePath();
                                            int pos = file_name.lastIndexOf(File.separatorChar);
                                            if (pos != -1) {
                                                file_name = file_name.substring(pos + 1);
                                            }
                                        }
                                        String url = root_url + UrlUtils.encode(file_name);
                                        if (file2 == null) {
                                            file_name = file_name + "/";
                                        }
                                        if ((len2 = file_name.length()) > MAX_LEN) {
                                            file_name = file_name.substring(0, MAX_LEN - 3) + "...";
                                            len2 = file_name.length();
                                        }
                                        if (len2 > max_filename) {
                                            max_filename = len2;
                                        }
                                        filenames.add(new String[]{url, file_name, file2 == null ? "" : DisplayFormatters.formatByteCountToKiBEtc(file2.getLength())});
                                    }
                                    max_filename = (max_filename + 15) / 8 * 8;
                                    char[] padding = new char[max_filename];
                                    Arrays.fill(padding, ' ');
                                    Collections.sort(filenames, new Comparator<String[]>(){
                                        Comparator comp = new FormattersImpl().getAlphanumericComparator(true);

                                        @Override
                                        public int compare(String[] o1, String[] o2) {
                                            return this.comp.compare(o1[0], o2[0]);
                                        }
                                    });
                                    for (String[] entry : filenames) {
                                        file_name = entry[1];
                                        int len3 = file_name.length();
                                        StringBuffer line = new StringBuffer(max_filename + 64);
                                        line.append("<a href=\"" + entry[0] + "\">" + XUXmlWriter.escapeXML(file_name) + "</a>");
                                        line.append(padding, 0, max_filename - len3);
                                        line.append(entry[2]);
                                        line.append(NL);
                                        os.write(line.toString().getBytes("UTF-8"));
                                    }
                                    os.write(("  <hr></pre>" + NL + "  <address>Vuze Web Server at " + this.host + " Port " + this.getServerPort() + "</address>" + NL + " </body>" + NL + "</html>").getBytes("UTF-8"));
                                    return true;
                                }
                                dm_file = (DiskManagerFileInfo)file_node;
                                file_size = dm_file.getLength();
                                File target_file = dm_file.getFile(true);
                                boolean bl = done = dm_file.getDownloaded() == file_size && target_file.length() == file_size;
                                if (file_size >= 524288L && (stream_url = ManagerUtils.getMediaServerContentURL(dm_file)) != null) {
                                    OutputStream os = response.getRawOutputStream();
                                    os.write(("HTTP/1.1 302 Found\r\nLocation: " + stream_url.toExternalForm() + "\r\n" + "\r\n").getBytes("UTF-8"));
                                    return true;
                                }
                                String relative_path = dm_file.getTorrentFile().getRelativePath();
                                int pos = relative_path.lastIndexOf(".");
                                file_type = pos == -1 ? "" : relative_path.substring(pos + 1);
                                if (!done) break block42;
                                if (file_size < 524288L) {
                                    boolean padding;
                                    block39: {
                                        FileInputStream fis = null;
                                        try {
                                            fis = new FileInputStream(target_file);
                                            response.useStream(file_type, fis);
                                            padding = true;
                                            Object var28_57 = null;
                                            if (fis == null) break block39;
                                        }
                                        catch (Throwable throwable) {
                                            Object var28_58 = null;
                                            if (fis != null) {
                                                fis.close();
                                            }
                                            throw throwable;
                                        }
                                        fis.close();
                                    }
                                    return padding;
                                }
                                OutputStream os = null;
                                InputStream is = null;
                                os = response.getRawOutputStream();
                                byte[] buffer = new byte[131072];
                                is = new FileInputStream(target_file);
                                while ((len = is.read(buffer)) > 0) {
                                    os.write(buffer, 0, len);
                                }
                                Object var30_60 = null;
                                try {
                                    os.close();
                                }
                                catch (Throwable e2) {
                                    // empty catch block
                                }
                                try {
                                    is.close();
                                }
                                catch (Throwable e2) {}
                                break block43;
                                {
                                    catch (Throwable e) {
                                        Object var30_61 = null;
                                        try {
                                            os.close();
                                        }
                                        catch (Throwable e2) {
                                            // empty catch block
                                        }
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable e2) {}
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var30_62 = null;
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable e2) {
                                        // empty catch block
                                    }
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable e2) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                            return true;
                        }
                        dm_file.setPriority(10);
                        try {
                            final OutputStream os = response.getRawOutputStream();
                            os.write(("HTTP/1.1 200 OK\r\nContent-Type:" + HTTPUtils.guessContentTypeFromFileType(file_type) + "\r\n" + "Content-Length: " + file_size + "\r\n" + "Connection: close" + "\r\n" + "X-Vuze-Hack: X").getBytes("UTF-8"));
                            DiskManagerChannel chan = PluginCoreUtils.wrap(dm_file).createChannel();
                            final DiskManagerRequest req = chan.createRequest();
                            final boolean[] header_complete = new boolean[]{false};
                            final long[] last_write = new long[]{0L};
                            req.setOffset(0L);
                            req.setLength(file_size);
                            req.addListener(new DiskManagerListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void eventOccurred(DiskManagerEvent event2) {
                                    int type = event2.getType();
                                    if (type == 3) {
                                        return;
                                    }
                                    if (type == 2) {
                                        throw new RuntimeException(event2.getFailure());
                                    }
                                    PooledByteBuffer buffer = event2.getBuffer();
                                    if (buffer == null) {
                                        throw new RuntimeException("eh?");
                                    }
                                    try {
                                        try {
                                            boolean do_header = false;
                                            boolean[] blArray = header_complete;
                                            synchronized (header_complete) {
                                                if (!header_complete[0]) {
                                                    do_header = true;
                                                    header_complete[0] = true;
                                                }
                                                last_write[0] = SystemTime.getMonotonousTime();
                                                // ** MonitorExit[var5_6] (shouldn't be in output)
                                                if (do_header) {
                                                    os.write("\r\n\r\n".getBytes("UTF-8"));
                                                }
                                                byte[] data = buffer.toByteArray();
                                                os.write(data);
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new RuntimeException("Failed to write to " + file, e);
                                        }
                                        {
                                            Object var8_8 = null;
                                            buffer.returnToPool();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_9 = null;
                                        buffer.returnToPool();
                                        throw throwable;
                                    }
                                    {
                                        return;
                                    }
                                }
                            });
                            TimerEventPeriodic[] timer_event = new TimerEventPeriodic[]{null};
                            timer_event[0] = SimpleTimer.addPeriodicEvent("KeepAlive", 10000L, new TimerEventPerformer(){
                                boolean cancel_outstanding = false;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public void perform(TimerEvent event2) {
                                    if (this.cancel_outstanding) {
                                        req.cancel();
                                        return;
                                    }
                                    boolean[] blArray = header_complete;
                                    synchronized (header_complete) {
                                        if (header_complete[0]) {
                                            if (SystemTime.getMonotonousTime() - last_write[0] >= 300000L) {
                                                req.cancel();
                                            }
                                        } else {
                                            try {
                                                os.write("X".getBytes("UTF-8"));
                                                os.flush();
                                            }
                                            catch (Throwable e) {
                                                req.cancel();
                                            }
                                        }
                                        // ** MonitorExit[var2_2] (shouldn't be in output)
                                        if (response.isActive()) return;
                                        this.cancel_outstanding = true;
                                        return;
                                    }
                                }
                            });
                            try {
                                req.run();
                                Object var33_67 = null;
                                timer_event[0].cancel();
                            }
                            catch (Throwable throwable) {
                                Object var33_68 = null;
                                timer_event[0].cancel();
                                throw throwable;
                            }
                            return true;
                        }
                        catch (Throwable e) {
                            return false;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void unload() throws PluginException {
                        Map map = browse_plugins;
                        synchronized (map) {
                            browse_plugins.remove(dm);
                        }
                        super.unload();
                    }
                };
                PluginManager.registerPlugin(plugin, plugin_id, plugin_id);
                browse_plugins.put(dm, plugin);
                if (launch) {
                    return null;
                }
                waiter.reserve(10000L);
                String[] stringArray = url_holder;
                synchronized (url_holder) {
                    // ** MonitorExit[var17_21] (shouldn't be in output)
                    return url_holder[0];
                }
            }
            String protocol = plugin.getProtocol();
            InetAddress bind_ip = plugin.getServerBindIP();
            String host = bind_ip.isAnyLocalAddress() ? "127.0.0.1" : bind_ip.getHostAddress();
            String url = protocol + "://" + host + ":" + plugin.getServerPort() + "/" + url_suffix;
            if (launch) {
                Utils.launch(url, false, true, anon);
                return null;
            }
            return url;
        }
    }

    public static URL getMediaServerContentURL(DiskManagerFileInfo file) {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            return null;
        }
        try {
            Object url = pi.getIPC().invoke("getContentURL", new Object[]{PluginCoreUtils.wrap(file)});
            if (url instanceof String) {
                return new URL((String)url);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70;
    }

    public static boolean isStopable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65;
    }

    public static boolean isPauseable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65 && state != 100;
    }

    public static boolean isStopped(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 100;
    }

    public static boolean isForceStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 75 || state == 60 || state == 50;
    }

    public static void host(AzureusCore azureus_core, DownloadManager dm) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            azureus_core.getTrackerHost().hostTorrent(torrent, true, false);
        }
        catch (TRHostException e) {
            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("MyTorrentsView.menu.host.error.title"), MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
            mb.open(null);
        }
    }

    public static void publish(AzureusCore azureus_core, DownloadManager dm) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            azureus_core.getTrackerHost().publishTorrent(torrent);
        }
        catch (TRHostException e) {
            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("MyTorrentsView.menu.host.error.title"), MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
            mb.open(null);
        }
    }

    public static void start(DownloadManager dm) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateWaiting();
        }
    }

    public static void queue(DownloadManager dm, Composite panelNotUsed) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateQueued();
        }
    }

    public static void pause(DownloadManager dm, Shell shell) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65) {
            return;
        }
        ManagerUtils.asyncPause(dm);
    }

    public static void stop(DownloadManager dm, Shell shell) {
        ManagerUtils.stop(dm, shell, 70);
    }

    public static void stop(final DownloadManager dm, final Shell shell, final int stateAfterStopped) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65 || state == stateAfterStopped) {
            return;
        }
        boolean stopme = true;
        if (state == 60 && dm.getStats().getShareRatio() >= 0 && dm.getStats().getShareRatio() < 1000 && COConfigurationManager.getBooleanParameter("Alert on close", false)) {
            if (!Utils.isThisThreadSWT()) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        ManagerUtils.stop(dm, shell, stateAfterStopped);
                    }
                });
                return;
            }
            Shell aShell = shell == null ? Utils.findAnyShell() : shell;
            MessageBox mb = new MessageBox(aShell, 200);
            mb.setText(MessageText.getString("seedmore.title"));
            mb.setMessage(MessageText.getString("seedmore.shareratio") + dm.getStats().getShareRatio() / 10 + "%.\n" + MessageText.getString("seedmore.uploadmore"));
            int action = mb.open();
            boolean bl = stopme = action == 64;
        }
        if (stopme) {
            ManagerUtils.asyncStop(dm, stateAfterStopped);
        }
    }

    public static void remove(DownloadManager dm, Shell unused_shell, boolean bDeleteTorrent, boolean bDeleteData) {
        ManagerUtils.remove(dm, unused_shell, bDeleteTorrent, bDeleteData, null);
    }

    public static void remove(DownloadManager dm, Shell unused_shell, boolean bDeleteTorrent, boolean bDeleteData, AERunnable deleteFailed) {
        TorrentUtil.removeDownloads(new DownloadManager[]{dm}, null);
        Debug.out("ManagerUtils.remove is Deprecated.  Use TorrentUtil.removeDownloads");
    }

    public static void asyncStopDelete(final DownloadManager dm, int stateAfterStopped, final boolean bDeleteTorrent, final boolean bDeleteData, final AERunnable deleteFailed) {
        async.dispatch(new AERunnable(){

            public void runSupport() {
                block13: {
                    try {
                        boolean reallyDeleteData = bDeleteData && !dm.getDownloadState().getFlag(64L);
                        dm.getGlobalManager().removeDownloadManager(dm, bDeleteTorrent, reallyDeleteData);
                    }
                    catch (GlobalManagerDownloadRemovalVetoException f) {
                        try {
                            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
                            ShareManager sm = pi.getShareManager();
                            Tracker tracker = pi.getTracker();
                            ShareResource[] shares = sm.getShares();
                            TOTorrent torrent = dm.getTorrent();
                            byte[] target_hash = torrent.getHash();
                            for (ShareResource share : shares) {
                                int type = share.getType();
                                byte[] hash = type == 2 ? ((ShareResourceDir)share).getItem().getTorrent().getHash() : (type == 1 ? ((ShareResourceFile)share).getItem().getTorrent().getHash() : null);
                                if (hash == null || !Arrays.equals(target_hash, hash)) continue;
                                try {
                                    dm.stopIt(70, false, false);
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                try {
                                    TrackerTorrent tracker_torrent = tracker.getTorrent(PluginCoreUtils.wrap(torrent));
                                    if (tracker_torrent != null) {
                                        tracker_torrent.stop();
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                share.delete();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!f.isSilent()) {
                            UIFunctionsManager.getUIFunctions().forceNotify(1, MessageText.getString("globalmanager.download.remove.veto"), f.getMessage(), null, null, -1);
                        }
                        if (deleteFailed != null) {
                            deleteFailed.runSupport();
                        }
                    }
                    catch (Exception ex) {
                        Debug.printStackTrace(ex);
                        if (deleteFailed == null) break block13;
                        deleteFailed.runSupport();
                    }
                }
            }
        });
    }

    public static void asyncStop(final DownloadManager dm, final int stateAfterStopped) {
        async.dispatch(new AERunnable(){

            public void runSupport() {
                dm.stopIt(stateAfterStopped, false, false);
            }
        });
    }

    public static void asyncPause(final DownloadManager dm) {
        async.dispatch(new AERunnable(){

            public void runSupport() {
                dm.pause();
            }
        });
    }

    public static void asyncStartAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().startAllDownloads();
            }
        });
    }

    public static void asyncStopAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().stopAllDownloads();
            }
        });
    }

    public static void asyncPause() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().pauseDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().pauseDownloadsForPeriod(seconds);
            }
        });
    }

    public static void asyncResume() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().resumeDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final List<DownloadManager> dms, final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void azureusCoreRunning(AzureusCore core) {
                final ArrayList<DownloadManager> paused = new ArrayList<DownloadManager>();
                final DownloadManagerAdapter listener = new DownloadManagerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void stateChanged(DownloadManager manager, int state) {
                        List list = paused;
                        synchronized (list) {
                            if (!paused.remove(manager)) {
                                return;
                            }
                        }
                        manager.removeListener(this);
                    }
                };
                for (DownloadManager dm : dms) {
                    if (!ManagerUtils.isPauseable(dm) || !dm.pause()) continue;
                    ArrayList<DownloadManager> arrayList = paused;
                    synchronized (arrayList) {
                        paused.add(dm);
                    }
                    dm.addListener(listener, false);
                }
                if (paused.size() > 0) {
                    SimpleTimer.addEvent("ManagerUtils.resumer", SystemTime.getOffsetTime(seconds * 1000), new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            ArrayList to_resume = new ArrayList();
                            List list = paused;
                            synchronized (list) {
                                to_resume.addAll(paused);
                                paused.clear();
                            }
                            for (DownloadManager dm : to_resume) {
                                dm.removeListener(listener);
                                try {
                                    dm.resume();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public static void moveToArchive(final List<Download> downloads, ArchiveCallback _run_when_complete) {
        final ArchiveCallback run_when_complete = _run_when_complete == null ? new ArchiveCallback() : _run_when_complete;
        Utils.getOffOfSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    String title = MessageText.getString("archive.info.title");
                    String text = MessageText.getString("archive.info.text");
                    MessageBoxShell prompter = new MessageBoxShell(title, text, new String[]{MessageText.getString("Button.ok")}, 0);
                    String remember_id = "managerutils.archive.info";
                    prompter.setRemember(remember_id, true, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                    prompter.setAutoCloseInMS(0);
                    prompter.open(null);
                    prompter.waitUntilClosed();
                    for (Download dm : downloads) {
                        try {
                            DownloadStub stub = dm.stubbify();
                            run_when_complete.success(dm, stub);
                        }
                        catch (Throwable e) {
                            run_when_complete.failed(dm, e);
                            Debug.out(e);
                        }
                    }
                    Object var9_9 = null;
                    run_when_complete.completed();
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    run_when_complete.completed();
                    throw throwable;
                }
            }
        });
    }

    public static void restoreFromArchive(final List<DownloadStub> downloads, final boolean start, ArchiveCallback _run_when_complete) {
        final ArchiveCallback run_when_complete = _run_when_complete == null ? new ArchiveCallback() : _run_when_complete;
        Utils.getOffOfSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    Tag tag = null;
                    try {
                        TagManager tm = TagManagerFactory.getTagManager();
                        TagType tt = tm.getTagType(3);
                        String tag_name = MessageText.getString("label.restored");
                        tag = tt.getTag(tag_name, true);
                        if (tag == null) {
                            tag = tt.createTag(tag_name, true);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    for (DownloadStub dm : downloads) {
                        try {
                            Download dl = dm.destubbify();
                            if (dl != null) {
                                run_when_complete.success(dm, dl);
                                if (tag != null) {
                                    tag.addTaggable(PluginCoreUtils.unwrap(dl));
                                }
                                if (!start) continue;
                                ManagerUtils.start(PluginCoreUtils.unwrap(dl));
                                continue;
                            }
                            run_when_complete.failed(dm, new Exception("Unknown error"));
                        }
                        catch (Throwable e) {
                            run_when_complete.failed(dm, e);
                            Debug.out(e);
                        }
                    }
                    Object var6_7 = null;
                    run_when_complete.completed();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    run_when_complete.completed();
                    throw throwable;
                }
            }
        });
    }

    static {
        browse_plugins = new IdentityHashMap<DownloadManager, WebPlugin>();
        async = new AsyncDispatcher(2000);
    }

    public static class ArchiveCallback {
        public void success(DownloadStub source, DownloadStub target) {
        }

        public void failed(DownloadStub original, Throwable error) {
        }

        public void completed() {
        }
    }

    public static interface RunDownloadManager {
        public void run(DownloadManager var1);
    }

    private static class UnloadableWebPlugin
    extends WebPlugin
    implements UnloadablePlugin {
        private UnloadableWebPlugin(Properties props) {
            super(props);
        }

        public void unload() throws PluginException {
            super.unloadPlugin();
        }
    }
}

