/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.ui.swt.browser.CookiesListener;
import java.net.URLDecoder;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.gudy.azureus2.ui.swt.BrowserWrapper;

public class ExternalLoginCookieListener
implements StatusTextListener,
LocationListener,
ProgressListener {
    private static final String AZCOOKIEMSG = "AZCOOKIEMSG;";
    private CookiesListener listener;
    private BrowserWrapper browser;
    private static final String getCookiesCode = "try {var cookies = encodeURIComponent(document.cookie);window.status = 'AZCOOKIEMSG;' + cookies;//alert(window.status);\nwindow.status = '';} catch(e) {}";

    public ExternalLoginCookieListener(CookiesListener _listener, BrowserWrapper browser) {
        this.listener = _listener;
        this.browser = browser;
        browser.addStatusTextListener(this);
    }

    public void changed(StatusTextEvent event2) {
        if (event2.text.startsWith(AZCOOKIEMSG)) {
            String uriEncodedCookies = event2.text.substring(AZCOOKIEMSG.length());
            try {
                String cookies = URLDecoder.decode(uriEncodedCookies, "UTF-8");
                if (this.listener != null) {
                    this.listener.cookiesFound(cookies);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void getCookies() {
        if (this.browser != null) {
            this.browser.execute(getCookiesCode);
        }
    }

    public void stopListening() {
        this.browser.removeStatusTextListener(this);
    }

    public void hookOnPageLoaded() {
        this.browser.addProgressListener(this);
    }

    public void hookOnPageChanged() {
        this.browser.addLocationListener(this);
    }

    public void hook() {
        this.hookOnPageChanged();
        this.hookOnPageLoaded();
    }

    public void unHook() {
    }

    public void changed(ProgressEvent arg0) {
    }

    public void completed(ProgressEvent arg0) {
        this.getCookies();
    }

    public void changed(LocationEvent arg0) {
        this.getCookies();
    }

    public void changing(LocationEvent arg0) {
    }
}

