/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadStubImpl
implements DownloadStub.DownloadStubEx {
    private final DownloadManagerImpl manager;
    private final String name;
    private final byte[] hash;
    private final long size;
    private final long date_created;
    private final String save_path;
    private final DownloadStubFileImpl[] files;
    private final Map<String, Object> gm_map;
    private DownloadImpl temp_download;
    private Map<String, Object> attributes;

    protected DownloadStubImpl(DownloadManagerImpl _manager, DownloadImpl _download, Map<String, Object> _gm_map) {
        this.manager = _manager;
        this.temp_download = _download;
        this.date_created = SystemTime.getCurrentTime();
        this.name = this.temp_download.getName();
        Torrent torrent = this.temp_download.getTorrent();
        this.hash = torrent.getHash();
        this.size = torrent.getSize();
        this.save_path = this.temp_download.getSavePath();
        DownloadStub.DownloadStubFile[] _files = this.temp_download.getStubFiles();
        this.gm_map = _gm_map;
        this.files = new DownloadStubFileImpl[_files.length];
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i] = new DownloadStubFileImpl(this, _files[i]);
        }
    }

    protected DownloadStubImpl(DownloadManagerImpl _manager, Map<String, Object> _map) {
        this.manager = _manager;
        this.date_created = MapUtils.getMapLong(_map, "dt", 0L);
        this.hash = (byte[])_map.get("hash");
        this.name = MapUtils.getMapString(_map, "name", null);
        this.size = MapUtils.getMapLong(_map, "s", 0L);
        this.save_path = MapUtils.getMapString(_map, "l", null);
        this.gm_map = (Map)_map.get("gm");
        List file_list = (List)_map.get("files");
        if (file_list == null) {
            this.files = new DownloadStubFileImpl[0];
        } else {
            this.files = new DownloadStubFileImpl[file_list.size()];
            for (int i = 0; i < this.files.length; ++i) {
                this.files[i] = new DownloadStubFileImpl(this, (Map)file_list.get(i));
            }
        }
        this.attributes = (Map)_map.get("attr");
    }

    public Map<String, Object> exportToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dt", this.date_created);
        map.put("hash", this.hash);
        map.put("s", this.size);
        MapUtils.setMapString(map, "name", this.name);
        MapUtils.setMapString(map, "l", this.save_path);
        map.put("gm", this.gm_map);
        ArrayList<Map> file_list = new ArrayList<Map>();
        map.put("files", file_list);
        for (DownloadStubFileImpl file : this.files) {
            file_list.add(file.exportToMap());
        }
        if (this.attributes != null) {
            map.put("attr", this.attributes);
        }
        return map;
    }

    @Override
    public boolean isStub() {
        return true;
    }

    protected void setStubbified() {
        this.temp_download = null;
    }

    @Override
    public Download destubbify() throws DownloadException {
        if (this.temp_download != null) {
            return this.temp_download;
        }
        return this.manager.destubbify(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getTorrentHash() {
        return this.hash;
    }

    @Override
    public long getTorrentSize() {
        return this.size;
    }

    @Override
    public long getCreationDate() {
        return this.date_created;
    }

    @Override
    public String getSavePath() {
        return this.save_path;
    }

    @Override
    public DownloadStub.DownloadStubFile[] getStubFiles() {
        return this.files;
    }

    @Override
    public long getLongAttribute(TorrentAttribute attribute) {
        if (this.attributes == null) {
            return 0L;
        }
        Long l = (Long)this.attributes.get(attribute.getName());
        if (l == null) {
            return 0L;
        }
        return l;
    }

    @Override
    public void setLongAttribute(TorrentAttribute attribute, long value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(attribute.getName(), value);
        if (this.temp_download == null) {
            this.manager.updated(this);
        }
    }

    public Map getGMMap() {
        return this.gm_map;
    }

    @Override
    public void remove() {
        this.manager.remove(this);
    }

    @Override
    public void remove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        byte[] bytes;
        TOTorrent torrent;
        if (delete_data && (torrent = this.manager.getTorrent(this)) != null) {
            File save_location = new File(this.getSavePath());
            if (torrent.isSimpleTorrent()) {
                if (save_location.isFile()) {
                    FileUtil.deleteWithRecycle(save_location, false);
                }
            } else if (save_location.isDirectory()) {
                DownloadStub.DownloadStubFile[] files = this.getStubFiles();
                String save_path = save_location.getAbsolutePath();
                if (!save_path.endsWith(File.separator)) {
                    save_path = save_path + File.separator;
                }
                int found = 0;
                for (DownloadStub.DownloadStubFile file : files) {
                    File f = file.getFile();
                    String path = f.getAbsolutePath();
                    if (!path.startsWith(save_path) || !f.exists()) continue;
                    ++found;
                }
                int actual = this.countFiles(save_location);
                if (actual == found) {
                    FileUtil.deleteWithRecycle(save_location, false);
                } else {
                    for (DownloadStub.DownloadStubFile file : files) {
                        File f = file.getFile();
                        String path = f.getAbsolutePath();
                        if (!path.startsWith(save_path)) continue;
                        FileUtil.deleteWithRecycle(f, false);
                    }
                    TorrentUtils.recursiveEmptyDirDelete(save_location, false);
                }
            }
        }
        if (delete_torrent && (bytes = (byte[])this.gm_map.get("torrent")) != null) {
            try {
                String torrent_file = new String(bytes, "UTF-8");
                File file = new File(torrent_file);
                TorrentUtils.delete(file, false);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        this.manager.remove(this);
    }

    private int countFiles(File dir) {
        int result = 0;
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isFile()) {
                    ++result;
                    continue;
                }
                result += this.countFiles(f);
            }
        }
        return result;
    }

    protected static class DownloadStubFileImpl
    implements DownloadStub.DownloadStubFile {
        private final DownloadStubImpl stub;
        private final Object file;
        private final long length;

        protected DownloadStubFileImpl(DownloadStubImpl _stub, DownloadStub.DownloadStubFile stub_file) {
            this.stub = _stub;
            this.length = stub_file.getLength();
            File f = stub_file.getFile();
            String path = f.getAbsolutePath();
            String save_loc = this.stub.getSavePath();
            int save_loc_len = save_loc.length();
            this.file = path.startsWith(save_loc) && path.length() > save_loc_len && path.charAt(save_loc_len) == File.separatorChar ? path.substring(save_loc_len + 1) : f;
        }

        protected DownloadStubFileImpl(DownloadStubImpl _stub, Map map) {
            this.stub = _stub;
            String abs_file = MapUtils.getMapString(map, "file", null);
            this.file = abs_file != null ? new File(abs_file) : MapUtils.getMapString(map, "rel", null);
            this.length = (Long)map.get("len");
        }

        protected Map exportToMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.file instanceof File) {
                map.put("file", ((File)this.file).getAbsolutePath());
            } else {
                map.put("rel", (String)this.file);
            }
            map.put("len", this.length);
            return map;
        }

        public File getFile() {
            if (this.file instanceof File) {
                return (File)this.file;
            }
            return new File(this.stub.getSavePath(), (String)this.file);
        }

        public long getLength() {
            return this.length;
        }
    }
}

