/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class ImageViewerWindow {
    private Shell shell;
    private Button ok;
    private Image image;
    private List<TextViewerWindowListener> listeners = new ArrayList<TextViewerWindowListener>();

    public ImageViewerWindow(String sTitleID, String sMessageID, File image_file) {
        this(sTitleID, sMessageID, image_file, null);
    }

    public ImageViewerWindow(String sTitleID, String sMessageID, Image img) {
        this(sTitleID, sMessageID, null, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageViewerWindow(String sTitleID, String sMessageID, File image_file, Image img) {
        this.shell = ShellFactory.createMainShell(3184);
        if (sTitleID != null) {
            this.shell.setText(MessageText.keyExists(sTitleID) ? MessageText.getString(sTitleID) : sTitleID);
        }
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        if (sMessageID != null) {
            label.setText(MessageText.keyExists(sMessageID) ? MessageText.getString(sMessageID) : sMessageID);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        final ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        gridData = new GridData(1808);
        gridData.widthHint = 500;
        gridData.heightHint = 400;
        gridData.horizontalSpan = 2;
        sc.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sc.setLayout((Layout)layout);
        final Composite img_comp = new Composite((Composite)sc, 0);
        img_comp.setLayout((Layout)new GridLayout());
        Label img_label = new Label(img_comp, 2048);
        img_label.setAlignment(0x1000000);
        gridData = new GridData(1808);
        img_label.setLayoutData((Object)gridData);
        sc.setContent((Control)img_comp);
        sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                sc.setMinSize(img_comp.computeSize(-1, -1));
            }
        });
        if (img == null) {
            try {
                FileInputStream is = new FileInputStream(image_file);
                try {
                    this.image = new Image((Device)this.shell.getDisplay(), (InputStream)is);
                    Object var13_13 = null;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                {
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.image = img;
        }
        if (this.image != null) {
            img_label.setImage(this.image);
            img_label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ImageViewerWindow.this.image.dispose();
                }
            });
        }
        label = new Label((Composite)this.shell, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.ok = new Button((Composite)this.shell, 8);
        this.ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData();
        gridData.widthHint = 70;
        this.ok.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(this.ok);
        this.ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    ImageViewerWindow.this.shell.dispose();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b' && ImageViewerWindow.this.ok.isEnabled()) {
                    ImageViewerWindow.this.shell.dispose();
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                for (TextViewerWindowListener l : ImageViewerWindow.this.listeners) {
                    l.closed();
                }
            }
        });
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    public void setOKEnabled(boolean enabled) {
        this.ok.setEnabled(enabled);
    }

    public void addListener(TextViewerWindowListener l) {
        this.listeners.add(l);
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public static interface TextViewerWindowListener {
        public void closed();
    }
}

