/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.ui.swt.config.Parameter;

public class ColorParameter
extends Parameter
implements ParameterListener {
    private Button colorChooser;
    protected String sParamName;
    private Image img;
    private int r;
    private int g;
    private int b;

    public ColorParameter(final Composite composite, final String name, int _r, int _g, int _b) {
        super(name);
        this.sParamName = name;
        this.colorChooser = new Button(composite, 8);
        if (name == null) {
            this.r = _r;
            this.g = _g;
            this.b = _b;
        } else {
            this.r = COConfigurationManager.getIntParameter(name + ".red", _r);
            this.g = COConfigurationManager.getIntParameter(name + ".green", _g);
            this.b = COConfigurationManager.getIntParameter(name + ".blue", _b);
            COConfigurationManager.addParameterListener(this.sParamName, (ParameterListener)this);
        }
        this.updateButtonColor(composite.getDisplay(), this.r, this.g, this.b);
        this.colorChooser.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                if (ColorParameter.this.sParamName != null) {
                    COConfigurationManager.removeParameterListener(ColorParameter.this.sParamName, ColorParameter.this);
                }
                if (ColorParameter.this.img != null && !ColorParameter.this.img.isDisposed()) {
                    ColorParameter.this.img.dispose();
                }
            }
        });
        this.colorChooser.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ColorDialog cd = new ColorDialog(composite.getShell());
                cd.setRGB(new RGB(ColorParameter.this.r, ColorParameter.this.g, ColorParameter.this.b));
                RGB newColor = cd.open();
                if (newColor == null) {
                    return;
                }
                ColorParameter.this.newColorChosen(newColor);
                if (name != null) {
                    COConfigurationManager.setRGBParameter(name, newColor.red, newColor.green, newColor.blue);
                } else {
                    ColorParameter.this.r = newColor.red;
                    ColorParameter.this.g = newColor.green;
                    ColorParameter.this.b = newColor.blue;
                    ColorParameter.this.updateButtonColor(ColorParameter.this.colorChooser.getDisplay(), ColorParameter.this.r, ColorParameter.this.g, ColorParameter.this.b);
                }
                ColorParameter.this.newColorSet(newColor);
            }
        });
    }

    private void updateButtonColor(Display display, int rV, int gV, int bV) {
        Image oldImg = this.img;
        Color color = ColorCache.getColor((Device)display, rV, gV, bV);
        this.img = new Image((Device)display, 25, 10);
        GC gc = new GC((Drawable)this.img);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, 25, 10);
        gc.dispose();
        this.colorChooser.setImage(this.img);
        if (oldImg != null && !oldImg.isDisposed()) {
            oldImg.dispose();
        }
    }

    public Control getControl() {
        return this.colorChooser;
    }

    public void setLayoutData(Object layoutData) {
        this.colorChooser.setLayoutData(layoutData);
    }

    public void parameterChanged(String parameterName) {
        this.r = COConfigurationManager.getIntParameter(this.sParamName + ".red");
        this.g = COConfigurationManager.getIntParameter(this.sParamName + ".green");
        this.b = COConfigurationManager.getIntParameter(this.sParamName + ".blue");
        this.updateButtonColor(this.colorChooser.getDisplay(), this.r, this.g, this.b);
    }

    public void newColorChosen(RGB newColor) {
    }

    public void newColorSet(RGB newColor) {
    }

    public void setValue(Object value) {
    }

    public void setColor(int _r, int _g, int _b) {
        this.r = _r;
        this.g = _g;
        this.b = _b;
        if (this.sParamName == null) {
            this.updateButtonColor(this.colorChooser.getDisplay(), this.r, this.g, this.b);
        } else {
            COConfigurationManager.setRGBParameter(this.sParamName, this.r, this.g, this.b);
        }
    }
}

