/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeEvent;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeListener;
import org.gudy.azureus2.pluginsimpl.local.ui.config.UITextAreaImpl;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;

public class TextAreaParameter
extends Parameter
implements UIPropertyChangeListener {
    private UITextAreaImpl ui_text_area;
    private StyledText text_area;

    public TextAreaParameter(Composite composite, UITextAreaImpl _ui_text_area) {
        super("");
        this.ui_text_area = _ui_text_area;
        this.text_area = new StyledText(composite, 2824);
        ClipboardCopy.addCopyToClipMenu((Control)this.text_area, new ClipboardCopy.copyToClipProvider(){

            public String getText() {
                return TextAreaParameter.this.text_area.getText().trim();
            }
        });
        this.text_area.setText(this.ui_text_area.getText());
        this.ui_text_area.addPropertyChangeListener(this);
    }

    public void setLayoutData(Object layoutData) {
        if (layoutData instanceof GridData) {
            GridData gd = (GridData)layoutData;
            Integer hhint = (Integer)this.ui_text_area.getProperty("hhint");
            if (hhint != null) {
                gd.heightHint = hhint;
            }
        }
        this.text_area.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.text_area;
    }

    public void setValue(Object value) {
    }

    public void propertyChanged(final UIPropertyChangeEvent ev) {
        if (this.text_area.isDisposed() || !this.ui_text_area.isVisible()) {
            this.ui_text_area.removePropertyChangeListener(this);
            return;
        }
        this.text_area.getDisplay().asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (TextAreaParameter.this.text_area.isDisposed() || !TextAreaParameter.this.ui_text_area.isVisible()) {
                    TextAreaParameter.this.ui_text_area.removePropertyChangeListener(TextAreaParameter.this);
                    return;
                }
                String old_value = (String)ev.getOldPropertyValue();
                String new_value = (String)ev.getNewPropertyValue();
                ScrollBar bar = TextAreaParameter.this.text_area.getVerticalBar();
                boolean max = bar.getSelection() == bar.getMaximum() - bar.getThumb();
                int lineOffset = TextAreaParameter.this.text_area.getLineCount() - TextAreaParameter.this.text_area.getTopIndex();
                if (new_value.startsWith(old_value)) {
                    String toAppend = new_value.substring(old_value.length());
                    if (toAppend.length() == 0) {
                        return;
                    }
                    StringBuffer builder = new StringBuffer(toAppend.length());
                    String[] lines = toAppend.split("\n");
                    for (int i = 0; i < lines.length; ++i) {
                        String line = lines[i];
                        builder.append("\n");
                        builder.append(line);
                    }
                    TextAreaParameter.this.text_area.append(builder.toString());
                } else {
                    StringBuffer builder = new StringBuffer(new_value.length());
                    String[] lines = new_value.split("\n");
                    for (int i = 0; i < lines.length; ++i) {
                        String line = lines[i];
                        if (line != lines[0]) {
                            builder.append("\n");
                        }
                        builder.append(line);
                    }
                    TextAreaParameter.this.text_area.setText(builder.toString());
                }
                if (max) {
                    bar.setSelection(bar.getMaximum() - bar.getThumb());
                    TextAreaParameter.this.text_area.setTopIndex(TextAreaParameter.this.text_area.getLineCount() - lineOffset);
                    TextAreaParameter.this.text_area.redraw();
                }
            }
        });
    }
}

