/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.config.wizard.FinishPanel;
import org.gudy.azureus2.ui.swt.config.wizard.NatPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferPanel2
extends AbstractWizardPanel<ConfigureWizard> {
    private static final int kbit = 1000;
    private static final int mbit = 1000000;
    private static final int[] connection_rates = new int[]{0, 28800, 56000, 64000, 96000, 128000, 192000, 256000, 384000, 512000, 640000, 768000, 1000000, 2000000, 5000000, 10000000, 20000000, 50000000, 100000000};
    private volatile boolean test_in_progress;
    private boolean manual_mode;
    private Label uprate_label;

    public TransferPanel2(ConfigureWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((ConfigureWizard)this.wizard).setTitle(MessageText.getString("configureWizard.transfer.title"));
        ((ConfigureWizard)this.wizard).setCurrentInfo(MessageText.getString("configureWizard.transfer2.hint"));
        final Composite rootPanel = ((ConfigureWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer2.message");
        Group gRadio = new Group(panel, 0);
        Messages.setLanguageText((Widget)gRadio, "configureWizard.transfer2.group");
        gRadio.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gRadio.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gRadio.setLayoutData((Object)gridData);
        Button auto_button = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)auto_button, "auto.mode");
        auto_button.setSelection(true);
        new Label((Composite)gRadio, 0);
        label = new Label((Composite)gRadio, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer2.test.info");
        final Button speed_test = new Button((Composite)gRadio, 0);
        Messages.setLanguageText((Widget)speed_test, "configureWizard.transfer2.test");
        final SelectionAdapter speed_test_listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                speed_test.setEnabled(false);
                TransferPanel2.this.test_in_progress = true;
                TransferPanel2.this.updateNextEnabled();
                rootPanel.getShell().setEnabled(false);
                UIFunctionsManager.getUIFunctions().installPlugin("mlab", "dlg.install.mlab", new UIFunctions.actionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionComplete(Object result) {
                        if (result instanceof Boolean) {
                            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("mlab");
                            if (pi == null) {
                                Debug.out("mlab plugin not found");
                                this.enableTest();
                            } else {
                                IPCInterface callback = new IPCInterface(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public Object invoke(String methodName, Object[] params) {
                                        try {
                                            int u;
                                            Map results;
                                            Long up_rate;
                                            if (methodName.equals("results") && (up_rate = (Long)(results = (Map)params[0]).get("up")) != null && (u = up_rate.intValue()) > 0) {
                                                Utils.execSWTThread(new Runnable(){

                                                    public void run() {
                                                        TransferPanel2.this.updateUp(u, false);
                                                    }
                                                });
                                            }
                                            Object var3_3 = null;
                                            Object var7_6 = null;
                                            this.enableTest();
                                            return var3_3;
                                        }
                                        catch (Throwable throwable) {
                                            Object var7_7 = null;
                                            this.enableTest();
                                            throw throwable;
                                        }
                                    }

                                    public boolean canInvoke(String methodName, Object[] params) {
                                        return true;
                                    }
                                };
                                try {
                                    pi.getIPC().invoke("runTest", new Object[]{new HashMap(), callback, false});
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                    this.enableTest();
                                }
                            }
                        } else {
                            try {
                                Throwable error = (Throwable)result;
                                Debug.out(error);
                                Object var6_6 = null;
                                this.enableTest();
                            }
                            catch (Throwable throwable) {
                                Object var6_7 = null;
                                this.enableTest();
                                throw throwable;
                            }
                        }
                    }

                    protected void enableTest() {
                        Utils.execSWTThread(new Runnable(){

                            public void run() {
                                speed_test.setEnabled(true);
                                TransferPanel2.this.test_in_progress = false;
                                TransferPanel2.this.updateNextEnabled();
                                rootPanel.getShell().setEnabled(true);
                            }
                        });
                    }
                });
            }
        };
        speed_test.addSelectionListener((SelectionListener)speed_test_listener);
        final Button manual_button = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)manual_button, "manual.mode");
        new Label((Composite)gRadio, 0);
        final Label manual_label = new Label((Composite)gRadio, 0);
        Messages.setLanguageText((Widget)manual_label, "configureWizard.transfer2.mselect");
        String[] connection_labels = new String[connection_rates.length];
        connection_labels[0] = MessageText.getString("configureWizard.transfer2.current");
        String dial_up = MessageText.getString("dial.up");
        for (int i = 1; i < connection_rates.length; ++i) {
            connection_labels[i] = (i < 3 ? dial_up + " " : "xxx/") + DisplayFormatters.formatByteCountToBitsPerSec(connection_rates[i] / 8);
        }
        final Combo connection_speed = new Combo((Composite)gRadio, 12);
        for (int i = 0; i < connection_rates.length; ++i) {
            connection_speed.add(connection_labels[i]);
        }
        connection_speed.select(0);
        connection_speed.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                int index = connection_speed.getSelectionIndex();
                TransferPanel2.this.updateUp(connection_rates[index] / 8, true);
            }
        });
        final Label manual2_label = new Label((Composite)gRadio, 64);
        Messages.setLanguageText((Widget)manual2_label, "configureWizard.transfer2.mselect.info");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        manual2_label.setLayoutData((Object)gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event arg0) {
                boolean is_manual = manual_button.getSelection();
                speed_test.setEnabled(!is_manual);
                connection_speed.setEnabled(is_manual);
                manual_label.setEnabled(is_manual);
                manual2_label.setEnabled(is_manual);
                TransferPanel2.this.manual_mode = is_manual;
                TransferPanel2.this.updateNextEnabled();
            }
        };
        manual_button.addListener(13, listener);
        listener.handleEvent(null);
        this.uprate_label = new Label(panel, 64);
        gridData = new GridData(1808);
        gridData.verticalIndent = 10;
        this.uprate_label.setLayoutData((Object)gridData);
        this.updateUp(0, true);
        this.manual_mode = false;
        this.updateNextEnabled();
        if (((ConfigureWizard)this.wizard).getWizardMode() == 1) {
            Utils.execSWTThreadLater(0, new Runnable(){

                public void run() {
                    speed_test_listener.widgetSelected(null);
                }
            });
        }
    }

    private void updateUp(int rate, boolean manual) {
        ((ConfigureWizard)this.wizard).setConnectionUploadLimit(rate, manual);
        if (rate == 0) {
            this.uprate_label.setText(MessageText.getString("configureWizard.transfer2.rate.unchanged"));
        } else {
            this.uprate_label.setText(MessageText.getString("configureWizard.transfer2.rate.changed", new String[]{DisplayFormatters.formatByteCountToBitsPerSec(rate) + " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(rate) + ")", DisplayFormatters.formatByteCountToKiBEtcPerSec(((ConfigureWizard)this.wizard).getUploadLimit()), String.valueOf(((ConfigureWizard)this.wizard).maxActiveTorrents), String.valueOf(((ConfigureWizard)this.wizard).maxDownloads)}));
        }
    }

    private void updateNextEnabled() {
        ((ConfigureWizard)this.wizard).setPreviousEnabled(this.isPreviousEnabled());
        boolean enabled = this.isProgressEnabled();
        if (((ConfigureWizard)this.wizard).getWizardMode() != 0) {
            ((ConfigureWizard)this.wizard).setNextEnabled(false);
            ((ConfigureWizard)this.wizard).setFinishEnabled(enabled);
        } else {
            ((ConfigureWizard)this.wizard).setNextEnabled(enabled);
        }
    }

    public boolean isProgressEnabled() {
        if (this.test_in_progress) {
            return false;
        }
        return this.manual_mode || ((ConfigureWizard)this.wizard).getConnectionUploadLimit() > 0;
    }

    @Override
    public boolean isNextEnabled() {
        return this.isProgressEnabled() && ((ConfigureWizard)this.wizard).getWizardMode() == 0;
    }

    @Override
    public boolean isPreviousEnabled() {
        return !this.test_in_progress && ((ConfigureWizard)this.wizard).getWizardMode() == 0;
    }

    @Override
    public IWizardPanel getFinishPanel() {
        return new FinishPanel((ConfigureWizard)this.wizard, (IWizardPanel)this);
    }

    @Override
    public IWizardPanel getNextPanel() {
        return new NatPanel((ConfigureWizard)this.wizard, (IWizardPanel)this);
    }
}

