/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.ui.common.ToolBarItem;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarActivationListener;

public class UIToolBarItemImpl
implements ToolBarItem {
    private String id;
    private String imageID = "image.toolbar.run";
    private String textID;
    private boolean alwaysAvailable = false;
    private long state;
    private UIToolBarActivationListener defaultActivation;
    private String tooltipID;
    private String groupID = "main";
    private List<ToolBarItem.ToolBarItemListener> toolBarItemListeners = new ArrayList<ToolBarItem.ToolBarItemListener>();
    private String toolTip;

    public UIToolBarItemImpl(String id) {
        this.id = id;
    }

    public void addToolBarItemListener(ToolBarItem.ToolBarItemListener l) {
        if (!this.toolBarItemListeners.contains(l)) {
            this.toolBarItemListeners.add(l);
        }
    }

    public void removeToolBarItemListener(ToolBarItem.ToolBarItemListener l) {
        this.toolBarItemListeners.remove(l);
    }

    private void triggerFieldChange() {
        ToolBarItem.ToolBarItemListener[] array;
        for (ToolBarItem.ToolBarItemListener l : array = this.toolBarItemListeners.toArray(new ToolBarItem.ToolBarItemListener[0])) {
            l.uiFieldChanged(this);
        }
    }

    public String getID() {
        return this.id;
    }

    public String getTextID() {
        return this.textID;
    }

    public void setTextID(String id) {
        this.textID = id;
        this.triggerFieldChange();
    }

    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String id) {
        this.imageID = id;
        this.triggerFieldChange();
    }

    public boolean isAlwaysAvailable() {
        return this.alwaysAvailable;
    }

    public void setAlwaysAvailable(boolean alwaysAvailable) {
        this.alwaysAvailable = alwaysAvailable;
        this.triggerFieldChange();
    }

    public long getState() {
        return this.state;
    }

    public void setState(long state) {
        this.state = state;
        this.triggerFieldChange();
    }

    public boolean triggerToolBarItem(long activationType, Object datasource) {
        ToolBarItem.ToolBarItemListener[] array;
        for (ToolBarItem.ToolBarItemListener l : array = this.toolBarItemListeners.toArray(new ToolBarItem.ToolBarItemListener[0])) {
            if (!l.triggerToolBarItem(this, activationType, datasource)) continue;
            return true;
        }
        return false;
    }

    public void setDefaultActivationListener(UIToolBarActivationListener defaultActivation) {
        this.defaultActivation = defaultActivation;
    }

    public UIToolBarActivationListener getDefaultActivationListener() {
        return this.defaultActivation;
    }

    public String getTooltipID() {
        return this.tooltipID;
    }

    public void setTooltipID(String tooltipID) {
        this.tooltipID = tooltipID;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public void setToolTip(String text) {
        this.toolTip = text;
    }

    public String getToolTip() {
        return this.toolTip;
    }
}

