/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarItem;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarManager;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarItemImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarManagerCore;

public class UIToolBarManagerImpl
implements UIToolBarManagerCore {
    private static UIToolBarManagerImpl instance;
    private Map<String, UIToolBarItem> items = new LinkedHashMap<String, UIToolBarItem>();
    private Map<String, List<String>> mapGroupToItemIDs = new HashMap<String, List<String>>();
    public List<ToolBarManagerListener> listListeners = new ArrayList<ToolBarManagerListener>();

    public static UIToolBarManager getInstance() {
        if (instance == null) {
            instance = new UIToolBarManagerImpl();
        }
        return instance;
    }

    public UIToolBarManagerImpl() {
        SelectedContentManager.addCurrentlySelectedContentListener(new SelectedContentListener(){

            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
                if (viewID == null) {
                    ToolBarItem[] allSWTToolBarItems;
                    for (ToolBarItem item : allSWTToolBarItems = UIToolBarManagerImpl.this.getAllSWTToolBarItems()) {
                        item.setState(0L);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ToolBarManagerListener l) {
        List<ToolBarManagerListener> list = this.listListeners;
        synchronized (list) {
            this.listListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ToolBarManagerListener l) {
        List<ToolBarManagerListener> list = this.listListeners;
        synchronized (list) {
            this.listListeners.remove(l);
        }
    }

    public UIToolBarItem getToolBarItem(String itemID) {
        return this.items.get(itemID);
    }

    public UIToolBarItem[] getAllToolBarItems() {
        return this.items.values().toArray(new UIToolBarItem[0]);
    }

    public ToolBarItem[] getAllSWTToolBarItems() {
        return this.items.values().toArray(new ToolBarItem[0]);
    }

    public UIToolBarItem createToolBarItem(String id) {
        UIToolBarItemImpl base = new UIToolBarItemImpl(id);
        return base;
    }

    public void addToolBarItem(UIToolBarItem item) {
        this.addToolBarItem(item, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToolBarItem(UIToolBarItem item, boolean trigger) {
        if (item == null) {
            return;
        }
        if (this.items.containsKey(item.getID())) {
            return;
        }
        this.items.put(item.getID(), item);
        String groupID = item.getGroupID();
        Map<String, List<String>> map = this.mapGroupToItemIDs;
        synchronized (map) {
            List<String> list = this.mapGroupToItemIDs.get(groupID);
            if (list == null) {
                list = new ArrayList<String>();
                this.mapGroupToItemIDs.put(groupID, list);
            }
            list.add(item.getID());
        }
        if (trigger) {
            ToolBarManagerListener[] listeners;
            for (ToolBarManagerListener l : listeners = this.listListeners.toArray(new ToolBarManagerListener[0])) {
                l.toolbarItemAdded(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getToolBarIDsByGroup(String groupID) {
        Map<String, List<String>> map = this.mapGroupToItemIDs;
        synchronized (map) {
            List<String> list = this.mapGroupToItemIDs.get(groupID);
            if (list == null) {
                return new String[0];
            }
            return list.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIToolBarItem[] getToolBarItemsByGroup(String groupID) {
        Map<String, List<String>> map = this.mapGroupToItemIDs;
        synchronized (map) {
            List<String> list = this.mapGroupToItemIDs.get(groupID);
            if (list == null) {
                return new UIToolBarItem[0];
            }
            UIToolBarItem[] items = new UIToolBarItem[list.size()];
            int i = 0;
            for (String id : list) {
                items[i] = this.getToolBarItem(id);
                ++i;
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToolBarItem(String id) {
        UIToolBarItem toolBarItem = this.items.remove(id);
        if (toolBarItem != null) {
            ToolBarManagerListener[] listeners;
            Map<String, List<String>> map = this.mapGroupToItemIDs;
            synchronized (map) {
                List<String> list = this.mapGroupToItemIDs.get(toolBarItem.getGroupID());
                if (list != null) {
                    list.remove(toolBarItem.getID());
                }
            }
            for (ToolBarManagerListener l : listeners = this.listListeners.toArray(new ToolBarManagerListener[0])) {
                l.toolbarItemRemoved(toolBarItem);
            }
        }
    }

    public String[] getGroupIDs() {
        return this.mapGroupToItemIDs.keySet().toArray(new String[0]);
    }

    public static interface ToolBarManagerListener {
        public void toolbarItemRemoved(UIToolBarItem var1);

        public void toolbarItemAdded(UIToolBarItem var1);
    }
}

