/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.columnsetup;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.columnsetup.TableColumnSetupWindow;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.FakeTableCell;

public class ColumnTC_Sample
extends CoreTableColumnSWT
implements TableCellAddedListener {
    public static final String COLUMN_ID = "TableColumnSample";

    public ColumnTC_Sample(String tableID) {
        super(COLUMN_ID, tableID);
        this.setPosition(-1);
        this.setRefreshInterval(-2);
        this.setWidth(120);
    }

    public void cellAdded(final TableCell cell) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (cell.isDisposed()) {
                    return;
                }
                TableColumnCore column = (TableColumnCore)cell.getDataSource();
                TableViewSWT tv = (TableViewSWT)((TableCellCore)cell).getTableRowCore().getView();
                TableColumnSetupWindow tvs = (TableColumnSetupWindow)tv.getParentDataSource();
                TableRowCore sampleRow = (TableRowCore)tvs.getSampleRow();
                cell.addListeners(new Cell(cell, column, tv.getTableComposite(), sampleRow));
            }
        });
    }

    private static class Cell
    implements TableCellRefreshListener,
    TableCellSWTPaintListener,
    TableCellVisibilityListener,
    TableCellDisposeListener {
        private final TableColumnCore column;
        private FakeTableCell sampleCell;

        public Cell(TableCell parentCell, TableColumnCore column, Composite c, TableRowCore sampleRow) {
            this.column = column;
            if (sampleRow == null) {
                return;
            }
            Object ds = sampleRow.getDataSource(true);
            Object pds = sampleRow.getDataSource(false);
            if (column.handlesDataSourceType(pds.getClass())) {
                this.sampleCell = new FakeTableCell(column, ds);
                Rectangle bounds = ((TableCellSWT)parentCell).getBounds();
                this.sampleCell.setControl(c, bounds, false);
            }
        }

        public void dispose(TableCell cell) {
            this.sampleCell = null;
        }

        public void cellPaint(GC gc, TableCellSWT cell) {
            if (this.sampleCell == null) {
                return;
            }
            Rectangle bounds = cell.getBounds();
            this.sampleCell.setCellArea(bounds);
            try {
                this.sampleCell.refresh();
                this.sampleCell.doPaint(gc);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        public void cellVisibilityChanged(TableCell cell, int visibility) {
            if (this.sampleCell == null) {
                return;
            }
            try {
                this.column.invokeCellVisibilityListeners(this.sampleCell, visibility);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        public void refresh(TableCell cell) {
            if (this.sampleCell == null) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            this.sampleCell.refresh(true, true, true);
            cell.setSortValue(this.sampleCell.getSortValue());
            cell.invalidate();
            if (cell instanceof TableCellSWT) {
                ((TableCellSWT)cell).redraw();
            }
        }
    }
}

