/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.archivedfiles;

import java.io.File;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.ArchivedFilesView;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class NameItem
extends CoreTableColumnSWT
implements TableCellLightRefreshListener,
ObfusticateCellText {
    public NameItem(String tableID) {
        super("name", 1, -2, 400, tableID);
        this.setType(1);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        String name;
        DownloadStub.DownloadStubFile fileInfo2 = (DownloadStub.DownloadStubFile)cell.getDataSource();
        if (fileInfo2 == null) {
            name = "";
        } else {
            File f = fileInfo2.getFile();
            name = ArchivedFilesView.show_full_path ? f.getAbsolutePath() : f.getName();
        }
        cell.setText(name);
    }

    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    public String getObfusticatedText(TableCell cell) {
        DownloadStub.DownloadStubFile fileInfo2 = (DownloadStub.DownloadStubFile)cell.getDataSource();
        String name = fileInfo2 == null ? "" : Debug.secretFileName(fileInfo2.getFile().getName());
        return name;
    }
}

