/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class FirstPieceItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public FirstPieceItem() {
        super("firstpiece", 2, -2, 75, "Files");
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"protocol"});
        info.setProficiency((byte)2);
    }

    public void refresh(TableCell cell) {
        long sort_value;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        if (fileInfo2 == null) {
            sort_value = 0L;
        } else {
            sort_value = fileInfo2.getFirstPieceNumber();
            if (sort_value >= 0L) {
                sort_value = (sort_value << 32) + (long)fileInfo2.getIndex();
            }
        }
        if (!cell.setSortValue(sort_value) && cell.isValid()) {
            return;
        }
        cell.setText(sort_value < 0L || fileInfo2 == null ? "" : "" + fileInfo2.getFirstPieceNumber());
    }
}

